/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse;

public class DescribeAccountAttributesPublisher
implements SdkPublisher<DescribeAccountAttributesResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeAccountAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAccountAttributesPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeAccountAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAccountAttributesPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeAccountAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAccountAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAccountAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountAttribute> accountAttributes() {
        Function<DescribeAccountAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAttributes() != null) {
                return response.accountAttributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAccountAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAccountAttributesResponseFetcher
    implements AsyncPageFetcher<DescribeAccountAttributesResponse> {
        private DescribeAccountAttributesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccountAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAccountAttributesResponse> nextPage(DescribeAccountAttributesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccountAttributesPublisher.this.client.describeAccountAttributes(DescribeAccountAttributesPublisher.this.firstRequest);
            }
            return DescribeAccountAttributesPublisher.this.client.describeAccountAttributes((DescribeAccountAttributesRequest)((Object)DescribeAccountAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

