/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesPublisher;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsPublisher;

/**
 * Service client for accessing Amazon Pinpoint SMS Voice V2 asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Welcome to the <i>Amazon Pinpoint SMS and Voice, version 2 API Reference</i>. This guide provides information about
 * Amazon Pinpoint SMS and Voice, version 2 API resources, including supported HTTP methods, parameters, and schemas.
 * </p>
 * <p>
 * Amazon Pinpoint is an Amazon Web Services service that you can use to engage with your recipients across multiple
 * messaging channels. The Amazon Pinpoint SMS and Voice, version 2 API provides programmatic access to options that are
 * unique to the SMS and voice channels and supplements the resources provided by the Amazon Pinpoint API.
 * </p>
 * <p>
 * If you're new to Amazon Pinpoint, it's also helpful to review the <a
 * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html"> Amazon Pinpoint Developer Guide</a>.
 * The <i>Amazon Pinpoint Developer Guide</i> provides tutorials, code samples, and procedures that demonstrate how to
 * use Amazon Pinpoint features programmatically and how to integrate Amazon Pinpoint functionality into mobile apps and
 * other types of applications. The guide also provides key information, such as Amazon Pinpoint integration with other
 * Amazon Web Services services, and the quotas that apply to use of the service.
 * </p>
 * <p>
 * <b>Regional availability</b>
 * </p>
 * <p>
 * The <i>Amazon Pinpoint SMS and Voice, version 2 API Reference</i> is available in several Amazon Web Services Regions
 * and it provides an endpoint for each of these Regions. For a list of all the Regions and endpoints where the API is
 * currently available, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region">Amazon
 * Web Services Service Endpoints</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/pinpoint.html">Amazon
 * Pinpoint endpoints and quotas</a> in the Amazon Web Services General Reference. To learn more about Amazon Web
 * Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web
 * Services Regions</a> in the Amazon Web Services General Reference.
 * </p>
 * <p>
 * In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically
 * isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network
 * connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while
 * also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see
 * <a href="https://aws.amazon.com/about-aws/global-infrastructure/">Amazon Web Services Global Infrastructure.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PinpointSmsVoiceV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "sms-voice";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "sms-voice";

    /**
     * <p>
     * Associates the specified origination identity with a pool.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <p>
     * If the origination identity configuration doesn't match the pool's configuration, an error is returned.
     * </p>
     *
     * @param associateOriginationIdentityRequest
     * @return A Java Future containing the result of the AssociateOriginationIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.AssociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateOriginationIdentityResponse> associateOriginationIdentity(
            AssociateOriginationIdentityRequest associateOriginationIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified origination identity with a pool.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <p>
     * If the origination identity configuration doesn't match the pool's configuration, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateOriginationIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateOriginationIdentityRequest#builder()}
     * </p>
     *
     * @param associateOriginationIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateOriginationIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.AssociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateOriginationIdentityResponse> associateOriginationIdentity(
            Consumer<AssociateOriginationIdentityRequest.Builder> associateOriginationIdentityRequest) {
        return associateOriginationIdentity(AssociateOriginationIdentityRequest.builder()
                .applyMutation(associateOriginationIdentityRequest).build());
    }

    /**
     * <p>
     * Creates a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     * </p>
     * <p>
     * When you send a message, you can optionally specify a single configuration set.
     * </p>
     *
     * @param createConfigurationSetRequest
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            CreateConfigurationSetRequest createConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     * </p>
     * <p>
     * When you send a message, you can optionally specify a single configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new event destination in a configuration set.
     * </p>
     * <p>
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon
     * Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send
     * information about that event to an event destination, or send notifications to endpoints that are subscribed to
     * an Amazon SNS topic.
     * </p>
     * <p>
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a
     * reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.
     * </p>
     *
     * @param createEventDestinationRequest
     * @return A Java Future containing the result of the CreateEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventDestinationResponse> createEventDestination(
            CreateEventDestinationRequest createEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event destination in a configuration set.
     * </p>
     * <p>
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon
     * Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send
     * information about that event to an event destination, or send notifications to endpoints that are subscribed to
     * an Amazon SNS topic.
     * </p>
     * <p>
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a
     * reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventDestinationRequest#builder()}
     * </p>
     *
     * @param createEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventDestinationResponse> createEventDestination(
            Consumer<CreateEventDestinationRequest.Builder> createEventDestinationRequest) {
        return createEventDestination(CreateEventDestinationRequest.builder().applyMutation(createEventDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new opt-out list.
     * </p>
     * <p>
     * If the opt-out list name already exists, an error is returned.
     * </p>
     * <p>
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to
     * them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In
     * addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of
     * supported opt-out keywords, see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS
     * opt out </a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     *
     * @param createOptOutListRequest
     * @return A Java Future containing the result of the CreateOptOutList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOptOutListResponse> createOptOutList(CreateOptOutListRequest createOptOutListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new opt-out list.
     * </p>
     * <p>
     * If the opt-out list name already exists, an error is returned.
     * </p>
     * <p>
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to
     * them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In
     * addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of
     * supported opt-out keywords, see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS
     * opt out </a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOptOutListRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOptOutListRequest#builder()}
     * </p>
     *
     * @param createOptOutListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateOptOutList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOptOutListResponse> createOptOutList(
            Consumer<CreateOptOutListRequest.Builder> createOptOutListRequest) {
        return createOptOutList(CreateOptOutListRequest.builder().applyMutation(createOptOutListRequest).build());
    }

    /**
     * <p>
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more
     * phone numbers and SenderIds that are associated with your Amazon Web Services account.
     * </p>
     * <p>
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message
     * type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't
     * inherited from the origination identity and defaults to false.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     *
     * @param createPoolRequest
     * @return A Java Future containing the result of the CreatePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePoolResponse> createPool(CreatePoolRequest createPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more
     * phone numbers and SenderIds that are associated with your Amazon Web Services account.
     * </p>
     * <p>
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message
     * type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't
     * inherited from the origination identity and defaults to false.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePoolRequest#builder()}
     * </p>
     *
     * @param createPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePoolResponse> createPool(Consumer<CreatePoolRequest.Builder> createPoolRequest) {
        return createPool(CreatePoolRequest.builder().applyMutation(createPoolRequest).build());
    }

    /**
     * <p>
     * Creates a new registration based on the <b>RegistrationType</b> field.
     * </p>
     *
     * @param createRegistrationRequest
     * @return A Java Future containing the result of the CreateRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationResponse> createRegistration(CreateRegistrationRequest createRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new registration based on the <b>RegistrationType</b> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRegistrationRequest#builder()}
     * </p>
     *
     * @param createRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationResponse> createRegistration(
            Consumer<CreateRegistrationRequest.Builder> createRegistrationRequest) {
        return createRegistration(CreateRegistrationRequest.builder().applyMutation(createRegistrationRequest).build());
    }

    /**
     * <p>
     * Associate the registration with an origination identity such as a phone number or sender ID.
     * </p>
     *
     * @param createRegistrationAssociationRequest
     * @return A Java Future containing the result of the CreateRegistrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationAssociationResponse> createRegistrationAssociation(
            CreateRegistrationAssociationRequest createRegistrationAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate the registration with an origination identity such as a phone number or sender ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRegistrationAssociationRequest#builder()}
     * </p>
     *
     * @param createRegistrationAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateRegistrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationAssociationResponse> createRegistrationAssociation(
            Consumer<CreateRegistrationAssociationRequest.Builder> createRegistrationAssociationRequest) {
        return createRegistrationAssociation(CreateRegistrationAssociationRequest.builder()
                .applyMutation(createRegistrationAssociationRequest).build());
    }

    /**
     * <p>
     * Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is
     * 1MiB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed
     * “letter of authorization” (LOA) to be submitted.
     * </p>
     *
     * @param createRegistrationAttachmentRequest
     * @return A Java Future containing the result of the CreateRegistrationAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationAttachmentResponse> createRegistrationAttachment(
            CreateRegistrationAttachmentRequest createRegistrationAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is
     * 1MiB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed
     * “letter of authorization” (LOA) to be submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRegistrationAttachmentRequest#builder()}
     * </p>
     *
     * @param createRegistrationAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateRegistrationAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationAttachmentResponse> createRegistrationAttachment(
            Consumer<CreateRegistrationAttachmentRequest.Builder> createRegistrationAttachmentRequest) {
        return createRegistrationAttachment(CreateRegistrationAttachmentRequest.builder()
                .applyMutation(createRegistrationAttachmentRequest).build());
    }

    /**
     * <p>
     * Create a new version of the registration and increase the <b>VersionNumber</b>. The previous version of the
     * registration becomes read-only.
     * </p>
     *
     * @param createRegistrationVersionRequest
     * @return A Java Future containing the result of the CreateRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationVersionResponse> createRegistrationVersion(
            CreateRegistrationVersionRequest createRegistrationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new version of the registration and increase the <b>VersionNumber</b>. The previous version of the
     * registration becomes read-only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRegistrationVersionRequest#builder()}
     * </p>
     *
     * @param createRegistrationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRegistrationVersionResponse> createRegistrationVersion(
            Consumer<CreateRegistrationVersionRequest.Builder> createRegistrationVersionRequest) {
        return createRegistrationVersion(CreateRegistrationVersionRequest.builder()
                .applyMutation(createRegistrationVersionRequest).build());
    }

    /**
     * <p>
     * You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to
     * 10 verified destination numbers.
     * </p>
     *
     * @param createVerifiedDestinationNumberRequest
     * @return A Java Future containing the result of the CreateVerifiedDestinationNumber operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVerifiedDestinationNumberResponse> createVerifiedDestinationNumber(
            CreateVerifiedDestinationNumberRequest createVerifiedDestinationNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to
     * 10 verified destination numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVerifiedDestinationNumberRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVerifiedDestinationNumberRequest#builder()}
     * </p>
     *
     * @param createVerifiedDestinationNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateVerifiedDestinationNumber operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVerifiedDestinationNumberResponse> createVerifiedDestinationNumber(
            Consumer<CreateVerifiedDestinationNumberRequest.Builder> createVerifiedDestinationNumberRequest) {
        return createVerifiedDestinationNumber(CreateVerifiedDestinationNumberRequest.builder()
                .applyMutation(createVerifiedDestinationNumberRequest).build());
    }

    /**
     * <p>
     * Deletes an existing configuration set.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration
     * set, you can specify a destination for specific types of events related to voice and SMS messages.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing configuration set.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration
     * set, you can specify a destination for specific types of events related to voice and SMS messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing default message type on a configuration set.
     * </p>
     * <p>
     * A message type is a type of messages that you plan to send. If you send account-related messages or
     * time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param deleteDefaultMessageTypeRequest
     * @return A Java Future containing the result of the DeleteDefaultMessageType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDefaultMessageTypeResponse> deleteDefaultMessageType(
            DeleteDefaultMessageTypeRequest deleteDefaultMessageTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing default message type on a configuration set.
     * </p>
     * <p>
     * A message type is a type of messages that you plan to send. If you send account-related messages or
     * time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDefaultMessageTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDefaultMessageTypeRequest#builder()}
     * </p>
     *
     * @param deleteDefaultMessageTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteDefaultMessageType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDefaultMessageTypeResponse> deleteDefaultMessageType(
            Consumer<DeleteDefaultMessageTypeRequest.Builder> deleteDefaultMessageTypeRequest) {
        return deleteDefaultMessageType(DeleteDefaultMessageTypeRequest.builder().applyMutation(deleteDefaultMessageTypeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing default sender ID on a configuration set.
     * </p>
     * <p>
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support
     * for sender ID capabilities varies by country or region.
     * </p>
     *
     * @param deleteDefaultSenderIdRequest
     * @return A Java Future containing the result of the DeleteDefaultSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDefaultSenderIdResponse> deleteDefaultSenderId(
            DeleteDefaultSenderIdRequest deleteDefaultSenderIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing default sender ID on a configuration set.
     * </p>
     * <p>
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support
     * for sender ID capabilities varies by country or region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDefaultSenderIdRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDefaultSenderIdRequest#builder()}
     * </p>
     *
     * @param deleteDefaultSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDefaultSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDefaultSenderIdResponse> deleteDefaultSenderId(
            Consumer<DeleteDefaultSenderIdRequest.Builder> deleteDefaultSenderIdRequest) {
        return deleteDefaultSenderId(DeleteDefaultSenderIdRequest.builder().applyMutation(deleteDefaultSenderIdRequest).build());
    }

    /**
     * <p>
     * Deletes an existing event destination.
     * </p>
     * <p>
     * An event destination is a location where you send response information about the messages that you send. For
     * example, when a message is delivered successfully, you can send information about that event to an Amazon
     * CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     * </p>
     *
     * @param deleteEventDestinationRequest
     * @return A Java Future containing the result of the DeleteEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventDestinationResponse> deleteEventDestination(
            DeleteEventDestinationRequest deleteEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing event destination.
     * </p>
     * <p>
     * An event destination is a location where you send response information about the messages that you send. For
     * example, when a message is delivered successfully, you can send information about that event to an Amazon
     * CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventDestinationResponse> deleteEventDestination(
            Consumer<DeleteEventDestinationRequest.Builder> deleteEventDestinationRequest) {
        return deleteEventDestination(DeleteEventDestinationRequest.builder().applyMutation(deleteEventDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing keyword from an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     * </p>
     *
     * @param deleteKeywordRequest
     * @return A Java Future containing the result of the DeleteKeyword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteKeywordResponse> deleteKeyword(DeleteKeywordRequest deleteKeywordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing keyword from an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeywordRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeywordRequest#builder()}
     * </p>
     *
     * @param deleteKeywordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteKeyword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteKeywordResponse> deleteKeyword(Consumer<DeleteKeywordRequest.Builder> deleteKeywordRequest) {
        return deleteKeyword(DeleteKeywordRequest.builder().applyMutation(deleteKeywordRequest).build());
    }

    /**
     * <p>
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     * </p>
     * <p>
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an error is
     * returned.
     * </p>
     *
     * @param deleteOptOutListRequest
     * @return A Java Future containing the result of the DeleteOptOutList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOptOutListResponse> deleteOptOutList(DeleteOptOutListRequest deleteOptOutListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     * </p>
     * <p>
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptOutListRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOptOutListRequest#builder()}
     * </p>
     *
     * @param deleteOptOutListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteOptOutList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOptOutListResponse> deleteOptOutList(
            Consumer<DeleteOptOutListRequest.Builder> deleteOptOutListRequest) {
        return deleteOptOutList(DeleteOptOutListRequest.builder().applyMutation(deleteOptOutListRequest).build());
    }

    /**
     * <p>
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     * </p>
     * <p>
     * Each destination phone number can only be deleted once every 30 days.
     * </p>
     * <p>
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an error is
     * returned.
     * </p>
     *
     * @param deleteOptedOutNumberRequest
     * @return A Java Future containing the result of the DeleteOptedOutNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOptedOutNumberResponse> deleteOptedOutNumber(
            DeleteOptedOutNumberRequest deleteOptedOutNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     * </p>
     * <p>
     * Each destination phone number can only be deleted once every 30 days.
     * </p>
     * <p>
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptedOutNumberRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOptedOutNumberRequest#builder()}
     * </p>
     *
     * @param deleteOptedOutNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteOptedOutNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOptedOutNumberResponse> deleteOptedOutNumber(
            Consumer<DeleteOptedOutNumberRequest.Builder> deleteOptedOutNumberRequest) {
        return deleteOptedOutNumber(DeleteOptedOutNumberRequest.builder().applyMutation(deleteOptedOutNumberRequest).build());
    }

    /**
     * <p>
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     * </p>
     * <p>
     * If the pool status isn't active or if deletion protection is enabled, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param deletePoolRequest
     * @return A Java Future containing the result of the DeletePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeletePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePoolResponse> deletePool(DeletePoolRequest deletePoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     * </p>
     * <p>
     * If the pool status isn't active or if deletion protection is enabled, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePoolRequest#builder()}
     * </p>
     *
     * @param deletePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeletePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePoolResponse> deletePool(Consumer<DeletePoolRequest.Builder> deletePoolRequest) {
        return deletePool(DeletePoolRequest.builder().applyMutation(deletePoolRequest).build());
    }

    /**
     * <p>
     * Permanently delete an existing registration from your account.
     * </p>
     *
     * @param deleteRegistrationRequest
     * @return A Java Future containing the result of the DeleteRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRegistrationResponse> deleteRegistration(DeleteRegistrationRequest deleteRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently delete an existing registration from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegistrationRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRegistrationResponse> deleteRegistration(
            Consumer<DeleteRegistrationRequest.Builder> deleteRegistrationRequest) {
        return deleteRegistration(DeleteRegistrationRequest.builder().applyMutation(deleteRegistrationRequest).build());
    }

    /**
     * <p>
     * Permanently delete the specified registration attachment.
     * </p>
     *
     * @param deleteRegistrationAttachmentRequest
     * @return A Java Future containing the result of the DeleteRegistrationAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRegistrationAttachmentResponse> deleteRegistrationAttachment(
            DeleteRegistrationAttachmentRequest deleteRegistrationAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently delete the specified registration attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRegistrationAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteRegistrationAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRegistrationAttachmentResponse> deleteRegistrationAttachment(
            Consumer<DeleteRegistrationAttachmentRequest.Builder> deleteRegistrationAttachmentRequest) {
        return deleteRegistrationAttachment(DeleteRegistrationAttachmentRequest.builder()
                .applyMutation(deleteRegistrationAttachmentRequest).build());
    }

    /**
     * <p>
     * Delete the value in a registration form field.
     * </p>
     *
     * @param deleteRegistrationFieldValueRequest
     * @return A Java Future containing the result of the DeleteRegistrationFieldValue operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistrationFieldValue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRegistrationFieldValueResponse> deleteRegistrationFieldValue(
            DeleteRegistrationFieldValueRequest deleteRegistrationFieldValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the value in a registration form field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationFieldValueRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRegistrationFieldValueRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationFieldValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteRegistrationFieldValue operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistrationFieldValue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRegistrationFieldValueResponse> deleteRegistrationFieldValue(
            Consumer<DeleteRegistrationFieldValueRequest.Builder> deleteRegistrationFieldValueRequest) {
        return deleteRegistrationFieldValue(DeleteRegistrationFieldValueRequest.builder()
                .applyMutation(deleteRegistrationFieldValueRequest).build());
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit
     * override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas </a> in the
     * <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param deleteTextMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the DeleteTextMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTextMessageSpendLimitOverrideResponse> deleteTextMessageSpendLimitOverride(
            DeleteTextMessageSpendLimitOverrideRequest deleteTextMessageSpendLimitOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit
     * override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas </a> in the
     * <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTextMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTextMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param deleteTextMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteTextMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTextMessageSpendLimitOverrideResponse> deleteTextMessageSpendLimitOverride(
            Consumer<DeleteTextMessageSpendLimitOverrideRequest.Builder> deleteTextMessageSpendLimitOverrideRequest) {
        return deleteTextMessageSpendLimitOverride(DeleteTextMessageSpendLimitOverrideRequest.builder()
                .applyMutation(deleteTextMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Delete a verified destination phone number.
     * </p>
     *
     * @param deleteVerifiedDestinationNumberRequest
     * @return A Java Future containing the result of the DeleteVerifiedDestinationNumber operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVerifiedDestinationNumberResponse> deleteVerifiedDestinationNumber(
            DeleteVerifiedDestinationNumberRequest deleteVerifiedDestinationNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a verified destination phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedDestinationNumberRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVerifiedDestinationNumberRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedDestinationNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteVerifiedDestinationNumber operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVerifiedDestinationNumberResponse> deleteVerifiedDestinationNumber(
            Consumer<DeleteVerifiedDestinationNumberRequest.Builder> deleteVerifiedDestinationNumberRequest) {
        return deleteVerifiedDestinationNumber(DeleteVerifiedDestinationNumberRequest.builder()
                .applyMutation(deleteVerifiedDestinationNumberRequest).build());
    }

    /**
     * <p>
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override
     * sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web
     * Services. For more information on spending limits (quotas) see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas</a> in the
     * <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param deleteVoiceMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the DeleteVoiceMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceMessageSpendLimitOverrideResponse> deleteVoiceMessageSpendLimitOverride(
            DeleteVoiceMessageSpendLimitOverrideRequest deleteVoiceMessageSpendLimitOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override
     * sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web
     * Services. For more information on spending limits (quotas) see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas</a> in the
     * <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceMessageSpendLimitOverrideRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVoiceMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param deleteVoiceMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteVoiceMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceMessageSpendLimitOverrideResponse> deleteVoiceMessageSpendLimitOverride(
            Consumer<DeleteVoiceMessageSpendLimitOverrideRequest.Builder> deleteVoiceMessageSpendLimitOverrideRequest) {
        return deleteVoiceMessageSpendLimitOverride(DeleteVoiceMessageSpendLimitOverrideRequest.builder()
                .applyMutation(deleteVoiceMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web
     * Services end recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web
     * Services end recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesPublisher publisher = client.describeAccountAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesPublisher publisher = client.describeAccountAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesPublisher describeAccountAttributesPaginator(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        return new DescribeAccountAttributesPublisher(this, describeAccountAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesPublisher publisher = client.describeAccountAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesPublisher publisher = client.describeAccountAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesPublisher describeAccountAttributesPaginator(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributesPaginator(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota
     * includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint
     * quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota
     * includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint
     * quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        return new DescribeAccountLimitsPublisher(this, describeAccountLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return A Java Future containing the result of the DescribeConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationSetsResponse> describeConfigurationSets(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationSetsResponse> describeConfigurationSets(
            Consumer<DescribeConfigurationSetsRequest.Builder> describeConfigurationSetsRequest) {
        return describeConfigurationSets(DescribeConfigurationSetsRequest.builder()
                .applyMutation(describeConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsPublisher publisher = client.describeConfigurationSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsPublisher publisher = client.describeConfigurationSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSetsPublisher describeConfigurationSetsPaginator(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) {
        return new DescribeConfigurationSetsPublisher(this, describeConfigurationSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsPublisher publisher = client.describeConfigurationSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsPublisher publisher = client.describeConfigurationSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSetsPublisher describeConfigurationSetsPaginator(
            Consumer<DescribeConfigurationSetsRequest.Builder> describeConfigurationSetsRequest) {
        return describeConfigurationSetsPaginator(DescribeConfigurationSetsRequest.builder()
                .applyMutation(describeConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     *
     * @param describeKeywordsRequest
     * @return A Java Future containing the result of the DescribeKeywords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKeywordsResponse> describeKeywords(DescribeKeywordsRequest describeKeywordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeywordsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeKeywordsRequest#builder()}
     * </p>
     *
     * @param describeKeywordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeKeywords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKeywordsResponse> describeKeywords(
            Consumer<DescribeKeywordsRequest.Builder> describeKeywordsRequest) {
        return describeKeywords(DescribeKeywordsRequest.builder().applyMutation(describeKeywordsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsPublisher publisher = client.describeKeywordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsPublisher publisher = client.describeKeywordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeKeywordsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeywordsPublisher describeKeywordsPaginator(DescribeKeywordsRequest describeKeywordsRequest) {
        return new DescribeKeywordsPublisher(this, describeKeywordsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsPublisher publisher = client.describeKeywordsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsPublisher publisher = client.describeKeywordsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeywordsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeKeywordsRequest#builder()}
     * </p>
     *
     * @param describeKeywordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeywordsPublisher describeKeywordsPaginator(Consumer<DescribeKeywordsRequest.Builder> describeKeywordsRequest) {
        return describeKeywordsPaginator(DescribeKeywordsRequest.builder().applyMutation(describeKeywordsRequest).build());
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return A Java Future containing the result of the DescribeOptOutLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptOutListsResponse> describeOptOutLists(
            DescribeOptOutListsRequest describeOptOutListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptOutListsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptOutListsRequest#builder()}
     * </p>
     *
     * @param describeOptOutListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOptOutLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptOutListsResponse> describeOptOutLists(
            Consumer<DescribeOptOutListsRequest.Builder> describeOptOutListsRequest) {
        return describeOptOutLists(DescribeOptOutListsRequest.builder().applyMutation(describeOptOutListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsPublisher publisher = client.describeOptOutListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsPublisher publisher = client.describeOptOutListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptOutListsPublisher describeOptOutListsPaginator(DescribeOptOutListsRequest describeOptOutListsRequest) {
        return new DescribeOptOutListsPublisher(this, describeOptOutListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsPublisher publisher = client.describeOptOutListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsPublisher publisher = client.describeOptOutListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptOutListsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptOutListsRequest#builder()}
     * </p>
     *
     * @param describeOptOutListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptOutListsPublisher describeOptOutListsPaginator(
            Consumer<DescribeOptOutListsRequest.Builder> describeOptOutListsRequest) {
        return describeOptOutListsPaginator(DescribeOptOutListsRequest.builder().applyMutation(describeOptOutListsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an error is returned.
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return A Java Future containing the result of the DescribeOptedOutNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptedOutNumbersResponse> describeOptedOutNumbers(
            DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptedOutNumbersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptedOutNumbersRequest#builder()}
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOptedOutNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptedOutNumbersResponse> describeOptedOutNumbers(
            Consumer<DescribeOptedOutNumbersRequest.Builder> describeOptedOutNumbersRequest) {
        return describeOptedOutNumbers(DescribeOptedOutNumbersRequest.builder().applyMutation(describeOptedOutNumbersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersPublisher publisher = client.describeOptedOutNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersPublisher publisher = client.describeOptedOutNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptedOutNumbersPublisher describeOptedOutNumbersPaginator(
            DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest) {
        return new DescribeOptedOutNumbersPublisher(this, describeOptedOutNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersPublisher publisher = client.describeOptedOutNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersPublisher publisher = client.describeOptedOutNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptedOutNumbersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptedOutNumbersRequest#builder()}
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptedOutNumbersPublisher describeOptedOutNumbersPaginator(
            Consumer<DescribeOptedOutNumbersRequest.Builder> describeOptedOutNumbersRequest) {
        return describeOptedOutNumbersPaginator(DescribeOptedOutNumbersRequest.builder()
                .applyMutation(describeOptedOutNumbersRequest).build());
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an error is returned.
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return A Java Future containing the result of the DescribePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePhoneNumbersResponse> describePhoneNumbers(
            DescribePhoneNumbersRequest describePhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumbersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param describePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePhoneNumbersResponse> describePhoneNumbers(
            Consumer<DescribePhoneNumbersRequest.Builder> describePhoneNumbersRequest) {
        return describePhoneNumbers(DescribePhoneNumbersRequest.builder().applyMutation(describePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersPublisher publisher = client.describePhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersPublisher publisher = client.describePhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhoneNumbersPublisher describePhoneNumbersPaginator(DescribePhoneNumbersRequest describePhoneNumbersRequest) {
        return new DescribePhoneNumbersPublisher(this, describePhoneNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersPublisher publisher = client.describePhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersPublisher publisher = client.describePhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumbersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param describePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhoneNumbersPublisher describePhoneNumbersPaginator(
            Consumer<DescribePhoneNumbersRequest.Builder> describePhoneNumbersRequest) {
        return describePhoneNumbersPaginator(DescribePhoneNumbersRequest.builder().applyMutation(describePhoneNumbersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param describePoolsRequest
     * @return A Java Future containing the result of the DescribePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePoolsResponse> describePools(DescribePoolsRequest describePoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoolsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePoolsRequest#builder()}
     * </p>
     *
     * @param describePoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePoolsResponse> describePools(Consumer<DescribePoolsRequest.Builder> describePoolsRequest) {
        return describePools(DescribePoolsRequest.builder().applyMutation(describePoolsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsPublisher publisher = client.describePoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsPublisher publisher = client.describePoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePoolsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePoolsPublisher describePoolsPaginator(DescribePoolsRequest describePoolsRequest) {
        return new DescribePoolsPublisher(this, describePoolsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsPublisher publisher = client.describePoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsPublisher publisher = client.describePoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoolsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePoolsRequest#builder()}
     * </p>
     *
     * @param describePoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePoolsPublisher describePoolsPaginator(Consumer<DescribePoolsRequest.Builder> describePoolsRequest) {
        return describePoolsPaginator(DescribePoolsRequest.builder().applyMutation(describePoolsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web
     * Services account.
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     * @return A Java Future containing the result of the DescribeRegistrationAttachments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationAttachmentsResponse> describeRegistrationAttachments(
            DescribeRegistrationAttachmentsRequest describeRegistrationAttachmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web
     * Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationAttachmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationAttachmentsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRegistrationAttachments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationAttachmentsResponse> describeRegistrationAttachments(
            Consumer<DescribeRegistrationAttachmentsRequest.Builder> describeRegistrationAttachmentsRequest) {
        return describeRegistrationAttachments(DescribeRegistrationAttachmentsRequest.builder()
                .applyMutation(describeRegistrationAttachmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsPublisher publisher = client.describeRegistrationAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsPublisher publisher = client.describeRegistrationAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationAttachmentsPublisher describeRegistrationAttachmentsPaginator(
            DescribeRegistrationAttachmentsRequest describeRegistrationAttachmentsRequest) {
        return new DescribeRegistrationAttachmentsPublisher(this, describeRegistrationAttachmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsPublisher publisher = client.describeRegistrationAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsPublisher publisher = client.describeRegistrationAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationAttachmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationAttachmentsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationAttachmentsPublisher describeRegistrationAttachmentsPaginator(
            Consumer<DescribeRegistrationAttachmentsRequest.Builder> describeRegistrationAttachmentsRequest) {
        return describeRegistrationAttachmentsPaginator(DescribeRegistrationAttachmentsRequest.builder()
                .applyMutation(describeRegistrationAttachmentsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationFieldDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationFieldDefinitionsResponse> describeRegistrationFieldDefinitions(
            DescribeRegistrationFieldDefinitionsRequest describeRegistrationFieldDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationFieldDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationFieldDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRegistrationFieldDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationFieldDefinitionsResponse> describeRegistrationFieldDefinitions(
            Consumer<DescribeRegistrationFieldDefinitionsRequest.Builder> describeRegistrationFieldDefinitionsRequest) {
        return describeRegistrationFieldDefinitions(DescribeRegistrationFieldDefinitionsRequest.builder()
                .applyMutation(describeRegistrationFieldDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsPublisher publisher = client.describeRegistrationFieldDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsPublisher publisher = client.describeRegistrationFieldDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldDefinitionsPublisher describeRegistrationFieldDefinitionsPaginator(
            DescribeRegistrationFieldDefinitionsRequest describeRegistrationFieldDefinitionsRequest) {
        return new DescribeRegistrationFieldDefinitionsPublisher(this, describeRegistrationFieldDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsPublisher publisher = client.describeRegistrationFieldDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsPublisher publisher = client.describeRegistrationFieldDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationFieldDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationFieldDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldDefinitionsPublisher describeRegistrationFieldDefinitionsPaginator(
            Consumer<DescribeRegistrationFieldDefinitionsRequest.Builder> describeRegistrationFieldDefinitionsRequest) {
        return describeRegistrationFieldDefinitionsPaginator(DescribeRegistrationFieldDefinitionsRequest.builder()
                .applyMutation(describeRegistrationFieldDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration field values.
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     * @return A Java Future containing the result of the DescribeRegistrationFieldValues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationFieldValuesResponse> describeRegistrationFieldValues(
            DescribeRegistrationFieldValuesRequest describeRegistrationFieldValuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration field values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationFieldValuesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationFieldValuesRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRegistrationFieldValues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationFieldValuesResponse> describeRegistrationFieldValues(
            Consumer<DescribeRegistrationFieldValuesRequest.Builder> describeRegistrationFieldValuesRequest) {
        return describeRegistrationFieldValues(DescribeRegistrationFieldValuesRequest.builder()
                .applyMutation(describeRegistrationFieldValuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesPublisher publisher = client.describeRegistrationFieldValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesPublisher publisher = client.describeRegistrationFieldValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldValuesPublisher describeRegistrationFieldValuesPaginator(
            DescribeRegistrationFieldValuesRequest describeRegistrationFieldValuesRequest) {
        return new DescribeRegistrationFieldValuesPublisher(this, describeRegistrationFieldValuesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesPublisher publisher = client.describeRegistrationFieldValuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesPublisher publisher = client.describeRegistrationFieldValuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationFieldValuesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationFieldValuesRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldValuesPublisher describeRegistrationFieldValuesPaginator(
            Consumer<DescribeRegistrationFieldValuesRequest.Builder> describeRegistrationFieldValuesRequest) {
        return describeRegistrationFieldValuesPaginator(DescribeRegistrationFieldValuesRequest.builder()
                .applyMutation(describeRegistrationFieldValuesRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationSectionDefinitions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationSectionDefinitionsResponse> describeRegistrationSectionDefinitions(
            DescribeRegistrationSectionDefinitionsRequest describeRegistrationSectionDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationSectionDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationSectionDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRegistrationSectionDefinitions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationSectionDefinitionsResponse> describeRegistrationSectionDefinitions(
            Consumer<DescribeRegistrationSectionDefinitionsRequest.Builder> describeRegistrationSectionDefinitionsRequest) {
        return describeRegistrationSectionDefinitions(DescribeRegistrationSectionDefinitionsRequest.builder()
                .applyMutation(describeRegistrationSectionDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsPublisher publisher = client.describeRegistrationSectionDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsPublisher publisher = client.describeRegistrationSectionDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationSectionDefinitionsPublisher describeRegistrationSectionDefinitionsPaginator(
            DescribeRegistrationSectionDefinitionsRequest describeRegistrationSectionDefinitionsRequest) {
        return new DescribeRegistrationSectionDefinitionsPublisher(this, describeRegistrationSectionDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsPublisher publisher = client.describeRegistrationSectionDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsPublisher publisher = client.describeRegistrationSectionDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationSectionDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationSectionDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationSectionDefinitionsPublisher describeRegistrationSectionDefinitionsPaginator(
            Consumer<DescribeRegistrationSectionDefinitionsRequest.Builder> describeRegistrationSectionDefinitionsRequest) {
        return describeRegistrationSectionDefinitionsPaginator(DescribeRegistrationSectionDefinitionsRequest.builder()
                .applyMutation(describeRegistrationSectionDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view
     * the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationTypeDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationTypeDefinitionsResponse> describeRegistrationTypeDefinitions(
            DescribeRegistrationTypeDefinitionsRequest describeRegistrationTypeDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view
     * the requirements for creating, filling out, and submitting each registration type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationTypeDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationTypeDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRegistrationTypeDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationTypeDefinitionsResponse> describeRegistrationTypeDefinitions(
            Consumer<DescribeRegistrationTypeDefinitionsRequest.Builder> describeRegistrationTypeDefinitionsRequest) {
        return describeRegistrationTypeDefinitions(DescribeRegistrationTypeDefinitionsRequest.builder()
                .applyMutation(describeRegistrationTypeDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsPublisher publisher = client.describeRegistrationTypeDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsPublisher publisher = client.describeRegistrationTypeDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationTypeDefinitionsPublisher describeRegistrationTypeDefinitionsPaginator(
            DescribeRegistrationTypeDefinitionsRequest describeRegistrationTypeDefinitionsRequest) {
        return new DescribeRegistrationTypeDefinitionsPublisher(this, describeRegistrationTypeDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsPublisher publisher = client.describeRegistrationTypeDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsPublisher publisher = client.describeRegistrationTypeDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationTypeDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationTypeDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationTypeDefinitionsPublisher describeRegistrationTypeDefinitionsPaginator(
            Consumer<DescribeRegistrationTypeDefinitionsRequest.Builder> describeRegistrationTypeDefinitionsRequest) {
        return describeRegistrationTypeDefinitionsPaginator(DescribeRegistrationTypeDefinitionsRequest.builder()
                .applyMutation(describeRegistrationTypeDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration version.
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationVersionsResponse> describeRegistrationVersions(
            DescribeRegistrationVersionsRequest describeRegistrationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationVersionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRegistrationVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationVersionsResponse> describeRegistrationVersions(
            Consumer<DescribeRegistrationVersionsRequest.Builder> describeRegistrationVersionsRequest) {
        return describeRegistrationVersions(DescribeRegistrationVersionsRequest.builder()
                .applyMutation(describeRegistrationVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsPublisher publisher = client.describeRegistrationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsPublisher publisher = client.describeRegistrationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationVersionsPublisher describeRegistrationVersionsPaginator(
            DescribeRegistrationVersionsRequest describeRegistrationVersionsRequest) {
        return new DescribeRegistrationVersionsPublisher(this, describeRegistrationVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsPublisher publisher = client.describeRegistrationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsPublisher publisher = client.describeRegistrationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationVersionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationVersionsPublisher describeRegistrationVersionsPaginator(
            Consumer<DescribeRegistrationVersionsRequest.Builder> describeRegistrationVersionsRequest) {
        return describeRegistrationVersionsPaginator(DescribeRegistrationVersionsRequest.builder()
                .applyMutation(describeRegistrationVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registrations.
     * </p>
     *
     * @param describeRegistrationsRequest
     * @return A Java Future containing the result of the DescribeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationsResponse> describeRegistrations(
            DescribeRegistrationsRequest describeRegistrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistrationsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRegistrationsResponse> describeRegistrations(
            Consumer<DescribeRegistrationsRequest.Builder> describeRegistrationsRequest) {
        return describeRegistrations(DescribeRegistrationsRequest.builder().applyMutation(describeRegistrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsPublisher publisher = client.describeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsPublisher publisher = client.describeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationsPublisher describeRegistrationsPaginator(
            DescribeRegistrationsRequest describeRegistrationsRequest) {
        return new DescribeRegistrationsPublisher(this, describeRegistrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsPublisher publisher = client.describeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsPublisher publisher = client.describeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistrationsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationsPublisher describeRegistrationsPaginator(
            Consumer<DescribeRegistrationsRequest.Builder> describeRegistrationsRequest) {
        return describeRegistrationsPaginator(DescribeRegistrationsRequest.builder().applyMutation(describeRegistrationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an error is returned.
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return A Java Future containing the result of the DescribeSenderIds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSenderIdsResponse> describeSenderIds(DescribeSenderIdsRequest describeSenderIdsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSenderIdsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSenderIdsRequest#builder()}
     * </p>
     *
     * @param describeSenderIdsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSenderIds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSenderIdsResponse> describeSenderIds(
            Consumer<DescribeSenderIdsRequest.Builder> describeSenderIdsRequest) {
        return describeSenderIds(DescribeSenderIdsRequest.builder().applyMutation(describeSenderIdsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsPublisher publisher = client.describeSenderIdsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsPublisher publisher = client.describeSenderIdsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSenderIdsPublisher describeSenderIdsPaginator(DescribeSenderIdsRequest describeSenderIdsRequest) {
        return new DescribeSenderIdsPublisher(this, describeSenderIdsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsPublisher publisher = client.describeSenderIdsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsPublisher publisher = client.describeSenderIdsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSenderIdsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSenderIdsRequest#builder()}
     * </p>
     *
     * @param describeSenderIdsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSenderIdsPublisher describeSenderIdsPaginator(
            Consumer<DescribeSenderIdsRequest.Builder> describeSenderIdsRequest) {
        return describeSenderIdsPaginator(DescribeSenderIdsRequest.builder().applyMutation(describeSenderIdsRequest).build());
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html">
     * Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User
     * Guide</i>.
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return A Java Future containing the result of the DescribeSpendLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSpendLimitsResponse> describeSpendLimits(
            DescribeSpendLimitsRequest describeSpendLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html">
     * Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpendLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSpendLimitsRequest#builder()}
     * </p>
     *
     * @param describeSpendLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSpendLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSpendLimitsResponse> describeSpendLimits(
            Consumer<DescribeSpendLimitsRequest.Builder> describeSpendLimitsRequest) {
        return describeSpendLimits(DescribeSpendLimitsRequest.builder().applyMutation(describeSpendLimitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsPublisher publisher = client.describeSpendLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsPublisher publisher = client.describeSpendLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpendLimitsPublisher describeSpendLimitsPaginator(DescribeSpendLimitsRequest describeSpendLimitsRequest) {
        return new DescribeSpendLimitsPublisher(this, describeSpendLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsPublisher publisher = client.describeSpendLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsPublisher publisher = client.describeSpendLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpendLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSpendLimitsRequest#builder()}
     * </p>
     *
     * @param describeSpendLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpendLimitsPublisher describeSpendLimitsPaginator(
            Consumer<DescribeSpendLimitsRequest.Builder> describeSpendLimitsRequest) {
        return describeSpendLimitsPaginator(DescribeSpendLimitsRequest.builder().applyMutation(describeSpendLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified verified destiona numbers.
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     * @return A Java Future containing the result of the DescribeVerifiedDestinationNumbers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVerifiedDestinationNumbersResponse> describeVerifiedDestinationNumbers(
            DescribeVerifiedDestinationNumbersRequest describeVerifiedDestinationNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified verified destiona numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVerifiedDestinationNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVerifiedDestinationNumbersRequest#builder()}
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeVerifiedDestinationNumbers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVerifiedDestinationNumbersResponse> describeVerifiedDestinationNumbers(
            Consumer<DescribeVerifiedDestinationNumbersRequest.Builder> describeVerifiedDestinationNumbersRequest) {
        return describeVerifiedDestinationNumbers(DescribeVerifiedDestinationNumbersRequest.builder()
                .applyMutation(describeVerifiedDestinationNumbersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersPublisher publisher = client.describeVerifiedDestinationNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersPublisher publisher = client.describeVerifiedDestinationNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVerifiedDestinationNumbersPublisher describeVerifiedDestinationNumbersPaginator(
            DescribeVerifiedDestinationNumbersRequest describeVerifiedDestinationNumbersRequest) {
        return new DescribeVerifiedDestinationNumbersPublisher(this, describeVerifiedDestinationNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersPublisher publisher = client.describeVerifiedDestinationNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersPublisher publisher = client.describeVerifiedDestinationNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVerifiedDestinationNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVerifiedDestinationNumbersRequest#builder()}
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVerifiedDestinationNumbersPublisher describeVerifiedDestinationNumbersPaginator(
            Consumer<DescribeVerifiedDestinationNumbersRequest.Builder> describeVerifiedDestinationNumbersRequest) {
        return describeVerifiedDestinationNumbersPaginator(DescribeVerifiedDestinationNumbersRequest.builder()
                .applyMutation(describeVerifiedDestinationNumbersRequest).build());
    }

    /**
     * <p>
     * Removes the specified origination identity from an existing pool.
     * </p>
     * <p>
     * If the origination identity isn't associated with the specified pool, an error is returned.
     * </p>
     *
     * @param disassociateOriginationIdentityRequest
     * @return A Java Future containing the result of the DisassociateOriginationIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DisassociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateOriginationIdentityResponse> disassociateOriginationIdentity(
            DisassociateOriginationIdentityRequest disassociateOriginationIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified origination identity from an existing pool.
     * </p>
     * <p>
     * If the origination identity isn't associated with the specified pool, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateOriginationIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateOriginationIdentityRequest#builder()}
     * </p>
     *
     * @param disassociateOriginationIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateOriginationIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DisassociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateOriginationIdentityResponse> disassociateOriginationIdentity(
            Consumer<DisassociateOriginationIdentityRequest.Builder> disassociateOriginationIdentityRequest) {
        return disassociateOriginationIdentity(DisassociateOriginationIdentityRequest.builder()
                .applyMutation(disassociateOriginationIdentityRequest).build());
    }

    /**
     * <p>
     * Discard the current version of the registration.
     * </p>
     *
     * @param discardRegistrationVersionRequest
     * @return A Java Future containing the result of the DiscardRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DiscardRegistrationVersion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DiscardRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DiscardRegistrationVersionResponse> discardRegistrationVersion(
            DiscardRegistrationVersionRequest discardRegistrationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Discard the current version of the registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DiscardRegistrationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DiscardRegistrationVersionRequest#builder()}
     * </p>
     *
     * @param discardRegistrationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DiscardRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DiscardRegistrationVersion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DiscardRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DiscardRegistrationVersionResponse> discardRegistrationVersion(
            Consumer<DiscardRegistrationVersionRequest.Builder> discardRegistrationVersionRequest) {
        return discardRegistrationVersion(DiscardRegistrationVersionRequest.builder()
                .applyMutation(discardRegistrationVersionRequest).build());
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return A Java Future containing the result of the ListPoolOriginationIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPoolOriginationIdentitiesResponse> listPoolOriginationIdentities(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoolOriginationIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPoolOriginationIdentitiesRequest#builder()}
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListPoolOriginationIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPoolOriginationIdentitiesResponse> listPoolOriginationIdentities(
            Consumer<ListPoolOriginationIdentitiesRequest.Builder> listPoolOriginationIdentitiesRequest) {
        return listPoolOriginationIdentities(ListPoolOriginationIdentitiesRequest.builder()
                .applyMutation(listPoolOriginationIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesPublisher publisher = client.listPoolOriginationIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesPublisher publisher = client.listPoolOriginationIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoolOriginationIdentitiesPublisher listPoolOriginationIdentitiesPaginator(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) {
        return new ListPoolOriginationIdentitiesPublisher(this, listPoolOriginationIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesPublisher publisher = client.listPoolOriginationIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesPublisher publisher = client.listPoolOriginationIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoolOriginationIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPoolOriginationIdentitiesRequest#builder()}
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoolOriginationIdentitiesPublisher listPoolOriginationIdentitiesPaginator(
            Consumer<ListPoolOriginationIdentitiesRequest.Builder> listPoolOriginationIdentitiesRequest) {
        return listPoolOriginationIdentitiesPaginator(ListPoolOriginationIdentitiesRequest.builder()
                .applyMutation(listPoolOriginationIdentitiesRequest).build());
    }

    /**
     * <p>
     * Retreive all of the origination identies that are associated with a registration.
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     * @return A Java Future containing the result of the ListRegistrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRegistrationAssociationsResponse> listRegistrationAssociations(
            ListRegistrationAssociationsRequest listRegistrationAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retreive all of the origination identies that are associated with a registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRegistrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRegistrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRegistrationAssociationsResponse> listRegistrationAssociations(
            Consumer<ListRegistrationAssociationsRequest.Builder> listRegistrationAssociationsRequest) {
        return listRegistrationAssociations(ListRegistrationAssociationsRequest.builder()
                .applyMutation(listRegistrationAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsPublisher publisher = client.listRegistrationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsPublisher publisher = client.listRegistrationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegistrationAssociationsPublisher listRegistrationAssociationsPaginator(
            ListRegistrationAssociationsRequest listRegistrationAssociationsRequest) {
        return new ListRegistrationAssociationsPublisher(this, listRegistrationAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsPublisher publisher = client.listRegistrationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsPublisher publisher = client.listRegistrationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRegistrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegistrationAssociationsPublisher listRegistrationAssociationsPaginator(
            Consumer<ListRegistrationAssociationsRequest.Builder> listRegistrationAssociationsRequest) {
        return listRegistrationAssociationsPaginator(ListRegistrationAssociationsRequest.builder()
                .applyMutation(listRegistrationAssociationsRequest).build());
    }

    /**
     * <p>
     * List all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a keyword configuration on an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     *
     * @param putKeywordRequest
     * @return A Java Future containing the result of the PutKeyword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutKeywordResponse> putKeyword(PutKeywordRequest putKeywordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a keyword configuration on an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutKeywordRequest.Builder} avoiding the need to
     * create one manually via {@link PutKeywordRequest#builder()}
     * </p>
     *
     * @param putKeywordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutKeyword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutKeywordResponse> putKeyword(Consumer<PutKeywordRequest.Builder> putKeywordRequest) {
        return putKeyword(PutKeywordRequest.builder().applyMutation(putKeywordRequest).build());
    }

    /**
     * <p>
     * Creates an opted out destination phone number in the opt-out list.
     * </p>
     * <p>
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an error is returned.
     * </p>
     *
     * @param putOptedOutNumberRequest
     * @return A Java Future containing the result of the PutOptedOutNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOptedOutNumberResponse> putOptedOutNumber(PutOptedOutNumberRequest putOptedOutNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an opted out destination phone number in the opt-out list.
     * </p>
     * <p>
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOptedOutNumberRequest.Builder} avoiding the need
     * to create one manually via {@link PutOptedOutNumberRequest#builder()}
     * </p>
     *
     * @param putOptedOutNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutOptedOutNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutOptedOutNumberResponse> putOptedOutNumber(
            Consumer<PutOptedOutNumberRequest.Builder> putOptedOutNumberRequest) {
        return putOptedOutNumber(PutOptedOutNumberRequest.builder().applyMutation(putOptedOutNumberRequest).build());
    }

    /**
     * <p>
     * Creates or updates a field value for a registration.
     * </p>
     *
     * @param putRegistrationFieldValueRequest
     * @return A Java Future containing the result of the PutRegistrationFieldValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutRegistrationFieldValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRegistrationFieldValueResponse> putRegistrationFieldValue(
            PutRegistrationFieldValueRequest putRegistrationFieldValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a field value for a registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRegistrationFieldValueRequest.Builder} avoiding
     * the need to create one manually via {@link PutRegistrationFieldValueRequest#builder()}
     * </p>
     *
     * @param putRegistrationFieldValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutRegistrationFieldValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutRegistrationFieldValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRegistrationFieldValueResponse> putRegistrationFieldValue(
            Consumer<PutRegistrationFieldValueRequest.Builder> putRegistrationFieldValueRequest) {
        return putRegistrationFieldValue(PutRegistrationFieldValueRequest.builder()
                .applyMutation(putRegistrationFieldValueRequest).build());
    }

    /**
     * <p>
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer
     * available for sending messages.
     * </p>
     * <p>
     * If the origination phone number has deletion protection enabled or is associated with a pool, an error is
     * returned.
     * </p>
     *
     * @param releasePhoneNumberRequest
     * @return A Java Future containing the result of the ReleasePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReleasePhoneNumberResponse> releasePhoneNumber(ReleasePhoneNumberRequest releasePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer
     * available for sending messages.
     * </p>
     * <p>
     * If the origination phone number has deletion protection enabled or is associated with a pool, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleasePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link ReleasePhoneNumberRequest#builder()}
     * </p>
     *
     * @param releasePhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ReleasePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReleasePhoneNumberResponse> releasePhoneNumber(
            Consumer<ReleasePhoneNumberRequest.Builder> releasePhoneNumberRequest) {
        return releasePhoneNumber(ReleasePhoneNumberRequest.builder().applyMutation(releasePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Releases an existing sender ID in your account.
     * </p>
     *
     * @param releaseSenderIdRequest
     * @return A Java Future containing the result of the ReleaseSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ReleaseSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleaseSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReleaseSenderIdResponse> releaseSenderId(ReleaseSenderIdRequest releaseSenderIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases an existing sender ID in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleaseSenderIdRequest.Builder} avoiding the need
     * to create one manually via {@link ReleaseSenderIdRequest#builder()}
     * </p>
     *
     * @param releaseSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ReleaseSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ReleaseSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleaseSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ReleaseSenderIdResponse> releaseSenderId(
            Consumer<ReleaseSenderIdRequest.Builder> releaseSenderIdRequest) {
        return releaseSenderId(ReleaseSenderIdRequest.builder().applyMutation(releaseSenderIdRequest).build());
    }

    /**
     * <p>
     * Request an origination phone number for use in your account. For more information on phone number request see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html"> Requesting a
     * number </a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     *
     * @param requestPhoneNumberRequest
     * @return A Java Future containing the result of the RequestPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.RequestPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestPhoneNumberResponse> requestPhoneNumber(RequestPhoneNumberRequest requestPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request an origination phone number for use in your account. For more information on phone number request see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html"> Requesting a
     * number </a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestPhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link RequestPhoneNumberRequest#builder()}
     * </p>
     *
     * @param requestPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RequestPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.RequestPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestPhoneNumberResponse> requestPhoneNumber(
            Consumer<RequestPhoneNumberRequest.Builder> requestPhoneNumberRequest) {
        return requestPhoneNumber(RequestPhoneNumberRequest.builder().applyMutation(requestPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Request a new sender ID that doesn't require registration.
     * </p>
     *
     * @param requestSenderIdRequest
     * @return A Java Future containing the result of the RequestSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.RequestSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestSenderIdResponse> requestSenderId(RequestSenderIdRequest requestSenderIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a new sender ID that doesn't require registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestSenderIdRequest.Builder} avoiding the need
     * to create one manually via {@link RequestSenderIdRequest#builder()}
     * </p>
     *
     * @param requestSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RequestSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.RequestSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestSenderIdResponse> requestSenderId(
            Consumer<RequestSenderIdRequest.Builder> requestSenderIdRequest) {
        return requestSenderId(RequestSenderIdRequest.builder().applyMutation(requestSenderIdRequest).build());
    }

    /**
     * <p>
     * Before you can send test messages to a verified destination phone number you need to opt-in the verified
     * destination phone number. Creates a new text message with a verification code and send it to a verified
     * destination phone number. Once you have the verification code use <a>VerifyDestinationNumber</a> to opt-in the
     * verified destination phone number to receive messages.
     * </p>
     *
     * @param sendDestinationNumberVerificationCodeRequest
     * @return A Java Future containing the result of the SendDestinationNumberVerificationCode operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendDestinationNumberVerificationCode
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendDestinationNumberVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDestinationNumberVerificationCodeResponse> sendDestinationNumberVerificationCode(
            SendDestinationNumberVerificationCodeRequest sendDestinationNumberVerificationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Before you can send test messages to a verified destination phone number you need to opt-in the verified
     * destination phone number. Creates a new text message with a verification code and send it to a verified
     * destination phone number. Once you have the verification code use <a>VerifyDestinationNumber</a> to opt-in the
     * verified destination phone number to receive messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SendDestinationNumberVerificationCodeRequest.Builder} avoiding the need to create one manually via
     * {@link SendDestinationNumberVerificationCodeRequest#builder()}
     * </p>
     *
     * @param sendDestinationNumberVerificationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SendDestinationNumberVerificationCode operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendDestinationNumberVerificationCode
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendDestinationNumberVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendDestinationNumberVerificationCodeResponse> sendDestinationNumberVerificationCode(
            Consumer<SendDestinationNumberVerificationCodeRequest.Builder> sendDestinationNumberVerificationCodeRequest) {
        return sendDestinationNumberVerificationCode(SendDestinationNumberVerificationCodeRequest.builder()
                .applyMutation(sendDestinationNumberVerificationCodeRequest).build());
    }

    /**
     * <p>
     * Creates a new text message and sends it to a recipient's phone number.
     * </p>
     * <p>
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination
     * country of your messages, as well as the type of phone number (origination number) that you use to send the
     * message. For more information, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html">Message Parts per
     * Second (MPS) limits</a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     *
     * @param sendTextMessageRequest
     * @return A Java Future containing the result of the SendTextMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendTextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendTextMessageResponse> sendTextMessage(SendTextMessageRequest sendTextMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new text message and sends it to a recipient's phone number.
     * </p>
     * <p>
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination
     * country of your messages, as well as the type of phone number (origination number) that you use to send the
     * message. For more information, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html">Message Parts per
     * Second (MPS) limits</a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTextMessageRequest.Builder} avoiding the need
     * to create one manually via {@link SendTextMessageRequest#builder()}
     * </p>
     *
     * @param sendTextMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SendTextMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendTextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendTextMessageResponse> sendTextMessage(
            Consumer<SendTextMessageRequest.Builder> sendTextMessageRequest) {
        return sendTextMessage(SendTextMessageRequest.builder().applyMutation(sendTextMessageRequest).build());
    }

    /**
     * <p>
     * Allows you to send a request that sends a voice message through Amazon Pinpoint. This operation uses <a
     * href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.
     * </p>
     *
     * @param sendVoiceMessageRequest
     * @return A Java Future containing the result of the SendVoiceMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendVoiceMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendVoiceMessageResponse> sendVoiceMessage(SendVoiceMessageRequest sendVoiceMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to send a request that sends a voice message through Amazon Pinpoint. This operation uses <a
     * href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendVoiceMessageRequest.Builder} avoiding the need
     * to create one manually via {@link SendVoiceMessageRequest#builder()}
     * </p>
     *
     * @param sendVoiceMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SendVoiceMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendVoiceMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendVoiceMessageResponse> sendVoiceMessage(
            Consumer<SendVoiceMessageRequest.Builder> sendVoiceMessageRequest) {
        return sendVoiceMessage(SendVoiceMessageRequest.builder().applyMutation(sendVoiceMessageRequest).build());
    }

    /**
     * <p>
     * Sets the default message type on a configuration set.
     * </p>
     * <p>
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages
     * or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param setDefaultMessageTypeRequest
     * @return A Java Future containing the result of the SetDefaultMessageType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetDefaultMessageTypeResponse> setDefaultMessageType(
            SetDefaultMessageTypeRequest setDefaultMessageTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default message type on a configuration set.
     * </p>
     * <p>
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages
     * or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultMessageTypeRequest.Builder} avoiding the
     * need to create one manually via {@link SetDefaultMessageTypeRequest#builder()}
     * </p>
     *
     * @param setDefaultMessageTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetDefaultMessageType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetDefaultMessageTypeResponse> setDefaultMessageType(
            Consumer<SetDefaultMessageTypeRequest.Builder> setDefaultMessageTypeRequest) {
        return setDefaultMessageType(SetDefaultMessageTypeRequest.builder().applyMutation(setDefaultMessageTypeRequest).build());
    }

    /**
     * <p>
     * Sets default sender ID on a configuration set.
     * </p>
     * <p>
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the
     * configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are
     * available in your account.
     * </p>
     *
     * @param setDefaultSenderIdRequest
     * @return A Java Future containing the result of the SetDefaultSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetDefaultSenderIdResponse> setDefaultSenderId(SetDefaultSenderIdRequest setDefaultSenderIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets default sender ID on a configuration set.
     * </p>
     * <p>
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the
     * configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are
     * available in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultSenderIdRequest.Builder} avoiding the
     * need to create one manually via {@link SetDefaultSenderIdRequest#builder()}
     * </p>
     *
     * @param setDefaultSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetDefaultSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetDefaultSenderIdResponse> setDefaultSenderId(
            Consumer<SetDefaultSenderIdRequest.Builder> setDefaultSenderIdRequest) {
        return setDefaultSenderId(SetDefaultSenderIdRequest.builder().applyMutation(setDefaultSenderIdRequest).build());
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setTextMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the SetTextMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTextMessageSpendLimitOverrideResponse> setTextMessageSpendLimitOverride(
            SetTextMessageSpendLimitOverrideRequest setTextMessageSpendLimitOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTextMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link SetTextMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param setTextMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SetTextMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTextMessageSpendLimitOverrideResponse> setTextMessageSpendLimitOverride(
            Consumer<SetTextMessageSpendLimitOverrideRequest.Builder> setTextMessageSpendLimitOverrideRequest) {
        return setTextMessageSpendLimitOverride(SetTextMessageSpendLimitOverrideRequest.builder()
                .applyMutation(setTextMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setVoiceMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the SetVoiceMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetVoiceMessageSpendLimitOverrideResponse> setVoiceMessageSpendLimitOverride(
            SetVoiceMessageSpendLimitOverrideRequest setVoiceMessageSpendLimitOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetVoiceMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link SetVoiceMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param setVoiceMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SetVoiceMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetVoiceMessageSpendLimitOverrideResponse> setVoiceMessageSpendLimitOverride(
            Consumer<SetVoiceMessageSpendLimitOverrideRequest.Builder> setVoiceMessageSpendLimitOverrideRequest) {
        return setVoiceMessageSpendLimitOverride(SetVoiceMessageSpendLimitOverrideRequest.builder()
                .applyMutation(setVoiceMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Submit the specified registration for review and approval.
     * </p>
     *
     * @param submitRegistrationVersionRequest
     * @return A Java Future containing the result of the SubmitRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SubmitRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SubmitRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitRegistrationVersionResponse> submitRegistrationVersion(
            SubmitRegistrationVersionRequest submitRegistrationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submit the specified registration for review and approval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitRegistrationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link SubmitRegistrationVersionRequest#builder()}
     * </p>
     *
     * @param submitRegistrationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SubmitRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SubmitRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SubmitRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SubmitRegistrationVersionResponse> submitRegistrationVersion(
            Consumer<SubmitRegistrationVersionRequest.Builder> submitRegistrationVersionRequest) {
        return submitRegistrationVersion(SubmitRegistrationVersionRequest.builder()
                .applyMutation(submitRegistrationVersionRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When
     * you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of
     * 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more
     * information about tags, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint
     * resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When
     * you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of
     * 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more
     * information about tags, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint
     * resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information
     * on tags see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging
     * Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information
     * on tags see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging
     * Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs
     * and Kinesis Data Firehose. You can also enable or disable the event destination.
     * </p>
     * <p>
     * You may want to update an event destination to change its matching event types or updating the destination
     * resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and
     * Amazon SNS.
     * </p>
     *
     * @param updateEventDestinationRequest
     * @return A Java Future containing the result of the UpdateEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventDestinationResponse> updateEventDestination(
            UpdateEventDestinationRequest updateEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs
     * and Kinesis Data Firehose. You can also enable or disable the event destination.
     * </p>
     * <p>
     * You may want to update an event destination to change its matching event types or updating the destination
     * resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and
     * Amazon SNS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventDestinationResponse> updateEventDestination(
            Consumer<UpdateEventDestinationRequest.Builder> updateEventDestinationRequest) {
        return updateEventDestination(UpdateEventDestinationRequest.builder().applyMutation(updateEventDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or
     * disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
     * disable deletion protection.
     * </p>
     * <p>
     * If the origination phone number is associated with a pool, an error is returned.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or
     * disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
     * disable deletion protection.
     * </p>
     * <p>
     * If the origination phone number is associated with a pool, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(
            Consumer<UpdatePhoneNumberRequest.Builder> updatePhoneNumberRequest) {
        return updatePhoneNumber(UpdatePhoneNumberRequest.builder().applyMutation(updatePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way
     * messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable
     * deletion protection, and enable or disable shared routes.
     * </p>
     *
     * @param updatePoolRequest
     * @return A Java Future containing the result of the UpdatePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePoolResponse> updatePool(UpdatePoolRequest updatePoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way
     * messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable
     * deletion protection, and enable or disable shared routes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePoolRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePoolRequest#builder()}
     * </p>
     *
     * @param updatePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePoolResponse> updatePool(Consumer<UpdatePoolRequest.Builder> updatePoolRequest) {
        return updatePool(UpdatePoolRequest.builder().applyMutation(updatePoolRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing sender ID.
     * </p>
     *
     * @param updateSenderIdRequest
     * @return A Java Future containing the result of the UpdateSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSenderIdResponse> updateSenderId(UpdateSenderIdRequest updateSenderIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing sender ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSenderIdRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSenderIdRequest#builder()}
     * </p>
     *
     * @param updateSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSenderIdResponse> updateSenderId(Consumer<UpdateSenderIdRequest.Builder> updateSenderIdRequest) {
        return updateSenderId(UpdateSenderIdRequest.builder().applyMutation(updateSenderIdRequest).build());
    }

    /**
     * <p>
     * Use the verification code that was received by the verified destination phone number to opt-in the verified
     * destination phone number to receive more messages.
     * </p>
     *
     * @param verifyDestinationNumberRequest
     * @return A Java Future containing the result of the VerifyDestinationNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.VerifyDestinationNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/VerifyDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifyDestinationNumberResponse> verifyDestinationNumber(
            VerifyDestinationNumberRequest verifyDestinationNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the verification code that was received by the verified destination phone number to opt-in the verified
     * destination phone number to receive more messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyDestinationNumberRequest.Builder} avoiding
     * the need to create one manually via {@link VerifyDestinationNumberRequest#builder()}
     * </p>
     *
     * @param verifyDestinationNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the VerifyDestinationNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.VerifyDestinationNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/VerifyDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifyDestinationNumberResponse> verifyDestinationNumber(
            Consumer<VerifyDestinationNumberRequest.Builder> verifyDestinationNumberRequest) {
        return verifyDestinationNumber(VerifyDestinationNumberRequest.builder().applyMutation(verifyDestinationNumberRequest)
                .build());
    }

    @Override
    default PinpointSmsVoiceV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PinpointSmsVoiceV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PinpointSmsVoiceV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PinpointSmsVoiceV2AsyncClient}.
     */
    static PinpointSmsVoiceV2AsyncClientBuilder builder() {
        return new DefaultPinpointSmsVoiceV2AsyncClientBuilder();
    }
}
