/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutKeywordRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<PutKeywordRequest.Builder, PutKeywordRequest> {
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(PutKeywordRequest::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> KEYWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Keyword")
            .getter(getter(PutKeywordRequest::keyword)).setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()).build();

    private static final SdkField<String> KEYWORD_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeywordMessage").getter(getter(PutKeywordRequest::keywordMessage))
            .setter(setter(Builder::keywordMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeywordMessage").build()).build();

    private static final SdkField<String> KEYWORD_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeywordAction").getter(getter(PutKeywordRequest::keywordActionAsString))
            .setter(setter(Builder::keywordAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeywordAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINATION_IDENTITY_FIELD,
            KEYWORD_FIELD, KEYWORD_MESSAGE_FIELD, KEYWORD_ACTION_FIELD));

    private final String originationIdentity;

    private final String keyword;

    private final String keywordMessage;

    private final String keywordAction;

    private PutKeywordRequest(BuilderImpl builder) {
        super(builder);
        this.originationIdentity = builder.originationIdentity;
        this.keyword = builder.keyword;
        this.keywordMessage = builder.keywordMessage;
        this.keywordAction = builder.keywordAction;
    }

    /**
     * <p>
     * The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use
     * <a>DescribePhoneNumbers</a> get the values for PhoneNumberId and PhoneNumberArn while <a>DescribeSenderIds</a>
     * can be used to get the values for SenderId and SenderIdArn.
     * </p>
     * 
     * @return The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can
     *         use <a>DescribePhoneNumbers</a> get the values for PhoneNumberId and PhoneNumberArn while
     *         <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The new keyword to add.
     * </p>
     * 
     * @return The new keyword to add.
     */
    public final String keyword() {
        return keyword;
    }

    /**
     * <p>
     * The message associated with the keyword.
     * </p>
     * 
     * @return The message associated with the keyword.
     */
    public final String keywordMessage() {
        return keywordMessage;
    }

    /**
     * <p>
     * The action to perform for the new keyword when it is received.
     * </p>
     * <ul>
     * <li>
     * <p>
     * AUTOMATIC_RESPONSE: A message is sent to the recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPT_OUT: Keeps the recipient from receiving future messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPT_IN: The recipient wants to receive future messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keywordAction}
     * will return {@link KeywordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keywordActionAsString}.
     * </p>
     * 
     * @return The action to perform for the new keyword when it is received.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AUTOMATIC_RESPONSE: A message is sent to the recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPT_OUT: Keeps the recipient from receiving future messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPT_IN: The recipient wants to receive future messages.
     *         </p>
     *         </li>
     * @see KeywordAction
     */
    public final KeywordAction keywordAction() {
        return KeywordAction.fromValue(keywordAction);
    }

    /**
     * <p>
     * The action to perform for the new keyword when it is received.
     * </p>
     * <ul>
     * <li>
     * <p>
     * AUTOMATIC_RESPONSE: A message is sent to the recipient.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPT_OUT: Keeps the recipient from receiving future messages.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPT_IN: The recipient wants to receive future messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keywordAction}
     * will return {@link KeywordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keywordActionAsString}.
     * </p>
     * 
     * @return The action to perform for the new keyword when it is received.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AUTOMATIC_RESPONSE: A message is sent to the recipient.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPT_OUT: Keeps the recipient from receiving future messages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPT_IN: The recipient wants to receive future messages.
     *         </p>
     *         </li>
     * @see KeywordAction
     */
    public final String keywordActionAsString() {
        return keywordAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        hashCode = 31 * hashCode + Objects.hashCode(keywordMessage());
        hashCode = 31 * hashCode + Objects.hashCode(keywordActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutKeywordRequest)) {
            return false;
        }
        PutKeywordRequest other = (PutKeywordRequest) obj;
        return Objects.equals(originationIdentity(), other.originationIdentity()) && Objects.equals(keyword(), other.keyword())
                && Objects.equals(keywordMessage(), other.keywordMessage())
                && Objects.equals(keywordActionAsString(), other.keywordActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutKeywordRequest").add("OriginationIdentity", originationIdentity()).add("Keyword", keyword())
                .add("KeywordMessage", keywordMessage()).add("KeywordAction", keywordActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        case "KeywordMessage":
            return Optional.ofNullable(clazz.cast(keywordMessage()));
        case "KeywordAction":
            return Optional.ofNullable(clazz.cast(keywordActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutKeywordRequest, T> g) {
        return obj -> g.apply((PutKeywordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo, CopyableBuilder<Builder, PutKeywordRequest> {
        /**
         * <p>
         * The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You can use
         * <a>DescribePhoneNumbers</a> get the values for PhoneNumberId and PhoneNumberArn while
         * <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.
         * </p>
         * 
         * @param originationIdentity
         *        The origination identity to use such as a PhoneNumberId, PhoneNumberArn, SenderId or SenderIdArn. You
         *        can use <a>DescribePhoneNumbers</a> get the values for PhoneNumberId and PhoneNumberArn while
         *        <a>DescribeSenderIds</a> can be used to get the values for SenderId and SenderIdArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The new keyword to add.
         * </p>
         * 
         * @param keyword
         *        The new keyword to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);

        /**
         * <p>
         * The message associated with the keyword.
         * </p>
         * 
         * @param keywordMessage
         *        The message associated with the keyword.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywordMessage(String keywordMessage);

        /**
         * <p>
         * The action to perform for the new keyword when it is received.
         * </p>
         * <ul>
         * <li>
         * <p>
         * AUTOMATIC_RESPONSE: A message is sent to the recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPT_OUT: Keeps the recipient from receiving future messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPT_IN: The recipient wants to receive future messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keywordAction
         *        The action to perform for the new keyword when it is received.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AUTOMATIC_RESPONSE: A message is sent to the recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPT_OUT: Keeps the recipient from receiving future messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPT_IN: The recipient wants to receive future messages.
         *        </p>
         *        </li>
         * @see KeywordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeywordAction
         */
        Builder keywordAction(String keywordAction);

        /**
         * <p>
         * The action to perform for the new keyword when it is received.
         * </p>
         * <ul>
         * <li>
         * <p>
         * AUTOMATIC_RESPONSE: A message is sent to the recipient.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPT_OUT: Keeps the recipient from receiving future messages.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPT_IN: The recipient wants to receive future messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keywordAction
         *        The action to perform for the new keyword when it is received.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AUTOMATIC_RESPONSE: A message is sent to the recipient.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPT_OUT: Keeps the recipient from receiving future messages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPT_IN: The recipient wants to receive future messages.
         *        </p>
         *        </li>
         * @see KeywordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeywordAction
         */
        Builder keywordAction(KeywordAction keywordAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String originationIdentity;

        private String keyword;

        private String keywordMessage;

        private String keywordAction;

        private BuilderImpl() {
        }

        private BuilderImpl(PutKeywordRequest model) {
            super(model);
            originationIdentity(model.originationIdentity);
            keyword(model.keyword);
            keywordMessage(model.keywordMessage);
            keywordAction(model.keywordAction);
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getKeyword() {
            return keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final String getKeywordMessage() {
            return keywordMessage;
        }

        public final void setKeywordMessage(String keywordMessage) {
            this.keywordMessage = keywordMessage;
        }

        @Override
        public final Builder keywordMessage(String keywordMessage) {
            this.keywordMessage = keywordMessage;
            return this;
        }

        public final String getKeywordAction() {
            return keywordAction;
        }

        public final void setKeywordAction(String keywordAction) {
            this.keywordAction = keywordAction;
        }

        @Override
        public final Builder keywordAction(String keywordAction) {
            this.keywordAction = keywordAction;
            return this;
        }

        @Override
        public final Builder keywordAction(KeywordAction keywordAction) {
            this.keywordAction(keywordAction == null ? null : keywordAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutKeywordRequest build() {
            return new PutKeywordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
