/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Validation rules for a select field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectValidation implements SdkPojo, Serializable,
        ToCopyableBuilder<SelectValidation.Builder, SelectValidation> {
    private static final SdkField<Integer> MIN_CHOICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinChoices").getter(getter(SelectValidation::minChoices)).setter(setter(Builder::minChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinChoices").build()).build();

    private static final SdkField<Integer> MAX_CHOICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxChoices").getter(getter(SelectValidation::maxChoices)).setter(setter(Builder::maxChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxChoices").build()).build();

    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(SelectValidation::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CHOICES_FIELD,
            MAX_CHOICES_FIELD, OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minChoices;

    private final Integer maxChoices;

    private final List<String> options;

    private SelectValidation(BuilderImpl builder) {
        this.minChoices = builder.minChoices;
        this.maxChoices = builder.maxChoices;
        this.options = builder.options;
    }

    /**
     * <p>
     * The minimum number of choices for the select.
     * </p>
     * 
     * @return The minimum number of choices for the select.
     */
    public final Integer minChoices() {
        return minChoices;
    }

    /**
     * <p>
     * The maximum number of choices for the select.
     * </p>
     * 
     * @return The maximum number of choices for the select.
     */
    public final Integer maxChoices() {
        return maxChoices;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings for the possible selection options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return An array of strings for the possible selection options.
     */
    public final List<String> options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minChoices());
        hashCode = 31 * hashCode + Objects.hashCode(maxChoices());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectValidation)) {
            return false;
        }
        SelectValidation other = (SelectValidation) obj;
        return Objects.equals(minChoices(), other.minChoices()) && Objects.equals(maxChoices(), other.maxChoices())
                && hasOptions() == other.hasOptions() && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectValidation").add("MinChoices", minChoices()).add("MaxChoices", maxChoices())
                .add("Options", hasOptions() ? options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinChoices":
            return Optional.ofNullable(clazz.cast(minChoices()));
        case "MaxChoices":
            return Optional.ofNullable(clazz.cast(maxChoices()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelectValidation, T> g) {
        return obj -> g.apply((SelectValidation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectValidation> {
        /**
         * <p>
         * The minimum number of choices for the select.
         * </p>
         * 
         * @param minChoices
         *        The minimum number of choices for the select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minChoices(Integer minChoices);

        /**
         * <p>
         * The maximum number of choices for the select.
         * </p>
         * 
         * @param maxChoices
         *        The maximum number of choices for the select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxChoices(Integer maxChoices);

        /**
         * <p>
         * An array of strings for the possible selection options.
         * </p>
         * 
         * @param options
         *        An array of strings for the possible selection options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<String> options);

        /**
         * <p>
         * An array of strings for the possible selection options.
         * </p>
         * 
         * @param options
         *        An array of strings for the possible selection options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(String... options);
    }

    static final class BuilderImpl implements Builder {
        private Integer minChoices;

        private Integer maxChoices;

        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectValidation model) {
            minChoices(model.minChoices);
            maxChoices(model.maxChoices);
            options(model.options);
        }

        public final Integer getMinChoices() {
            return minChoices;
        }

        public final void setMinChoices(Integer minChoices) {
            this.minChoices = minChoices;
        }

        @Override
        public final Builder minChoices(Integer minChoices) {
            this.minChoices = minChoices;
            return this;
        }

        public final Integer getMaxChoices() {
            return maxChoices;
        }

        public final void setMaxChoices(Integer maxChoices) {
            this.maxChoices = maxChoices;
        }

        @Override
        public final Builder maxChoices(Integer maxChoices) {
            this.maxChoices = maxChoices;
            return this;
        }

        public final Collection<String> getOptions() {
            if (options instanceof SdkAutoConstructList) {
                return null;
            }
            return options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = StringListCopier.copy(options);
        }

        @Override
        public final Builder options(Collection<String> options) {
            this.options = StringListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(String... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        public SelectValidation build() {
            return new SelectValidation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
