/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePoolRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<UpdatePoolRequest.Builder, UpdatePoolRequest> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(UpdatePoolRequest::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TwoWayEnabled").getter(getter(UpdatePoolRequest::twoWayEnabled)).setter(setter(Builder::twoWayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelArn").getter(getter(UpdatePoolRequest::twoWayChannelArn))
            .setter(setter(Builder::twoWayChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelRole").getter(getter(UpdatePoolRequest::twoWayChannelRole))
            .setter(setter(Builder::twoWayChannelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()).build();

    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled")
            .getter(getter(UpdatePoolRequest::selfManagedOptOutsEnabled)).setter(setter(Builder::selfManagedOptOutsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build())
            .build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(UpdatePoolRequest::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Boolean> SHARED_ROUTES_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SharedRoutesEnabled").getter(getter(UpdatePoolRequest::sharedRoutesEnabled))
            .setter(setter(Builder::sharedRoutesEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedRoutesEnabled").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdatePoolRequest::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD,
            TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD,
            OPT_OUT_LIST_NAME_FIELD, SHARED_ROUTES_ENABLED_FIELD, DELETION_PROTECTION_ENABLED_FIELD));

    private final String poolId;

    private final Boolean twoWayEnabled;

    private final String twoWayChannelArn;

    private final String twoWayChannelRole;

    private final Boolean selfManagedOptOutsEnabled;

    private final String optOutListName;

    private final Boolean sharedRoutesEnabled;

    private final Boolean deletionProtectionEnabled;

    private UpdatePoolRequest(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.sharedRoutesEnabled = builder.sharedRoutesEnabled;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.
     * </p>
     * 
     * @return The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * By default this is set to false. When set to true you can receive incoming text messages from your end
     * recipients.
     * </p>
     * 
     * @return By default this is set to false. When set to true you can receive incoming text messages from your end
     *         recipients.
     */
    public final Boolean twoWayEnabled() {
        return twoWayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the two way channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the two way channel.
     */
    public final String twoWayChannelArn() {
        return twoWayChannelArn;
    }

    /**
     * <p>
     * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     * </p>
     * 
     * @return An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     */
    public final String twoWayChannelRole() {
        return twoWayChannelRole;
    }

    /**
     * <p>
     * By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one of
     * your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end
     * recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're
     * also responsible for tracking and honoring opt-out requests.
     * </p>
     * 
     * @return By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to
     *         one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds
     *         the end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP
     *         requests. You're also responsible for tracking and honoring opt-out requests.
     */
    public final Boolean selfManagedOptOutsEnabled() {
        return selfManagedOptOutsEnabled;
    }

    /**
     * <p>
     * The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.
     * </p>
     * 
     * @return The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * Indicates whether shared routes are enabled for the pool.
     * </p>
     * 
     * @return Indicates whether shared routes are enabled for the pool.
     */
    public final Boolean sharedRoutesEnabled() {
        return sharedRoutesEnabled;
    }

    /**
     * <p>
     * When set to true the pool can't be deleted.
     * </p>
     * 
     * @return When set to true the pool can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(sharedRoutesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePoolRequest)) {
            return false;
        }
        UpdatePoolRequest other = (UpdatePoolRequest) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(twoWayEnabled(), other.twoWayEnabled())
                && Objects.equals(twoWayChannelArn(), other.twoWayChannelArn())
                && Objects.equals(twoWayChannelRole(), other.twoWayChannelRole())
                && Objects.equals(selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled())
                && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(sharedRoutesEnabled(), other.sharedRoutesEnabled())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePoolRequest").add("PoolId", poolId()).add("TwoWayEnabled", twoWayEnabled())
                .add("TwoWayChannelArn", twoWayChannelArn()).add("TwoWayChannelRole", twoWayChannelRole())
                .add("SelfManagedOptOutsEnabled", selfManagedOptOutsEnabled()).add("OptOutListName", optOutListName())
                .add("SharedRoutesEnabled", sharedRoutesEnabled()).add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "TwoWayEnabled":
            return Optional.ofNullable(clazz.cast(twoWayEnabled()));
        case "TwoWayChannelArn":
            return Optional.ofNullable(clazz.cast(twoWayChannelArn()));
        case "TwoWayChannelRole":
            return Optional.ofNullable(clazz.cast(twoWayChannelRole()));
        case "SelfManagedOptOutsEnabled":
            return Optional.ofNullable(clazz.cast(selfManagedOptOutsEnabled()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "SharedRoutesEnabled":
            return Optional.ofNullable(clazz.cast(sharedRoutesEnabled()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePoolRequest, T> g) {
        return obj -> g.apply((UpdatePoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePoolRequest> {
        /**
         * <p>
         * The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.
         * </p>
         * 
         * @param poolId
         *        The unique identifier of the pool to update. Valid values are either the PoolId or PoolArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * By default this is set to false. When set to true you can receive incoming text messages from your end
         * recipients.
         * </p>
         * 
         * @param twoWayEnabled
         *        By default this is set to false. When set to true you can receive incoming text messages from your end
         *        recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayEnabled(Boolean twoWayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the two way channel.
         * </p>
         * 
         * @param twoWayChannelArn
         *        The Amazon Resource Name (ARN) of the two way channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelArn(String twoWayChannelArn);

        /**
         * <p>
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * </p>
         * 
         * @param twoWayChannelRole
         *        An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelRole(String twoWayChannelRole);

        /**
         * <p>
         * By default this is set to false. When an end recipient sends a message that begins with HELP or STOP to one
         * of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message and adds the end
         * recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests.
         * You're also responsible for tracking and honoring opt-out requests.
         * </p>
         * 
         * @param selfManagedOptOutsEnabled
         *        By default this is set to false. When an end recipient sends a message that begins with HELP or STOP
         *        to one of your dedicated numbers, Amazon Pinpoint automatically replies with a customizable message
         *        and adds the end recipient to the OptOutList. When set to true you're responsible for responding to
         *        HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled);

        /**
         * <p>
         * The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.
         * </p>
         * 
         * @param optOutListName
         *        The OptOutList to associate with the pool. Valid values are either OptOutListName or OptOutListArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * Indicates whether shared routes are enabled for the pool.
         * </p>
         * 
         * @param sharedRoutesEnabled
         *        Indicates whether shared routes are enabled for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled);

        /**
         * <p>
         * When set to true the pool can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        When set to true the pool can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String poolId;

        private Boolean twoWayEnabled;

        private String twoWayChannelArn;

        private String twoWayChannelRole;

        private Boolean selfManagedOptOutsEnabled;

        private String optOutListName;

        private Boolean sharedRoutesEnabled;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePoolRequest model) {
            super(model);
            poolId(model.poolId);
            twoWayEnabled(model.twoWayEnabled);
            twoWayChannelArn(model.twoWayChannelArn);
            twoWayChannelRole(model.twoWayChannelRole);
            selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            optOutListName(model.optOutListName);
            sharedRoutesEnabled(model.sharedRoutesEnabled);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getSharedRoutesEnabled() {
            return sharedRoutesEnabled;
        }

        public final void setSharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
        }

        @Override
        public final Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePoolRequest build() {
            return new UpdatePoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
