/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdAndCountry;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSenderIdsRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeSenderIdsRequest> {
    private static final SdkField<List<SenderIdAndCountry>> SENDER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SenderIds").getter(DescribeSenderIdsRequest.getter(DescribeSenderIdsRequest::senderIds)).setter(DescribeSenderIdsRequest.setter(Builder::senderIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SenderIdAndCountry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SenderIdFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeSenderIdsRequest.getter(DescribeSenderIdsRequest::filters)).setter(DescribeSenderIdsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SenderIdFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSenderIdsRequest.getter(DescribeSenderIdsRequest::nextToken)).setter(DescribeSenderIdsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeSenderIdsRequest.getter(DescribeSenderIdsRequest::maxResults)).setter(DescribeSenderIdsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<SenderIdAndCountry> senderIds;
    private final List<SenderIdFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeSenderIdsRequest(BuilderImpl builder) {
        super(builder);
        this.senderIds = builder.senderIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasSenderIds() {
        return this.senderIds != null && !(this.senderIds instanceof SdkAutoConstructList);
    }

    public final List<SenderIdAndCountry> senderIds() {
        return this.senderIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<SenderIdFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSenderIds() ? this.senderIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSenderIdsRequest)) {
            return false;
        }
        DescribeSenderIdsRequest other = (DescribeSenderIdsRequest)((Object)obj);
        return this.hasSenderIds() == other.hasSenderIds() && Objects.equals(this.senderIds(), other.senderIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSenderIdsRequest").add("SenderIds", this.hasSenderIds() ? this.senderIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SenderIds": {
                return Optional.ofNullable(clazz.cast(this.senderIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSenderIdsRequest, T> g) {
        return obj -> g.apply((DescribeSenderIdsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private List<SenderIdAndCountry> senderIds = DefaultSdkAutoConstructList.getInstance();
        private List<SenderIdFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSenderIdsRequest model) {
            super(model);
            this.senderIds(model.senderIds);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final List<SenderIdAndCountry.Builder> getSenderIds() {
            List<SenderIdAndCountry.Builder> result = SenderIdListCopier.copyToBuilder(this.senderIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSenderIds(Collection<SenderIdAndCountry.BuilderImpl> senderIds) {
            this.senderIds = SenderIdListCopier.copyFromBuilder(senderIds);
        }

        @Override
        public final Builder senderIds(Collection<SenderIdAndCountry> senderIds) {
            this.senderIds = SenderIdListCopier.copy(senderIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderIds(SenderIdAndCountry ... senderIds) {
            this.senderIds(Arrays.asList(senderIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderIds(Consumer<SenderIdAndCountry.Builder> ... senderIds) {
            this.senderIds(Stream.of(senderIds).map(c -> (SenderIdAndCountry)((SenderIdAndCountry.Builder)SenderIdAndCountry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SenderIdFilter.Builder> getFilters() {
            List<SenderIdFilter.Builder> result = SenderIdFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SenderIdFilter.BuilderImpl> filters) {
            this.filters = SenderIdFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SenderIdFilter> filters) {
            this.filters = SenderIdFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SenderIdFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SenderIdFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (SenderIdFilter)((SenderIdFilter.Builder)SenderIdFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSenderIdsRequest build() {
            return new DescribeSenderIdsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSenderIdsRequest> {
        public Builder senderIds(Collection<SenderIdAndCountry> var1);

        public Builder senderIds(SenderIdAndCountry ... var1);

        public Builder senderIds(Consumer<SenderIdAndCountry.Builder> ... var1);

        public Builder filters(Collection<SenderIdFilter> var1);

        public Builder filters(SenderIdFilter ... var1);

        public Builder filters(Consumer<SenderIdFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

