/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVerifiedDestinationNumbersResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeVerifiedDestinationNumbersResponse.Builder, DescribeVerifiedDestinationNumbersResponse> {
    private static final SdkField<List<VerifiedDestinationNumberInformation>> VERIFIED_DESTINATION_NUMBERS_FIELD = SdkField
            .<List<VerifiedDestinationNumberInformation>> builder(MarshallingType.LIST)
            .memberName("VerifiedDestinationNumbers")
            .getter(getter(DescribeVerifiedDestinationNumbersResponse::verifiedDestinationNumbers))
            .setter(setter(Builder::verifiedDestinationNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VerifiedDestinationNumberInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VerifiedDestinationNumberInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeVerifiedDestinationNumbersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_DESTINATION_NUMBERS_FIELD, NEXT_TOKEN_FIELD));

    private final List<VerifiedDestinationNumberInformation> verifiedDestinationNumbers;

    private final String nextToken;

    private DescribeVerifiedDestinationNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumbers = builder.verifiedDestinationNumbers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VerifiedDestinationNumbers property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVerifiedDestinationNumbers() {
        return verifiedDestinationNumbers != null && !(verifiedDestinationNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of VerifiedDestinationNumberInformation objects
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVerifiedDestinationNumbers} method.
     * </p>
     * 
     * @return An array of VerifiedDestinationNumberInformation objects
     */
    public final List<VerifiedDestinationNumberInformation> verifiedDestinationNumbers() {
        return verifiedDestinationNumbers;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVerifiedDestinationNumbers() ? verifiedDestinationNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedDestinationNumbersResponse)) {
            return false;
        }
        DescribeVerifiedDestinationNumbersResponse other = (DescribeVerifiedDestinationNumbersResponse) obj;
        return hasVerifiedDestinationNumbers() == other.hasVerifiedDestinationNumbers()
                && Objects.equals(verifiedDestinationNumbers(), other.verifiedDestinationNumbers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVerifiedDestinationNumbersResponse")
                .add("VerifiedDestinationNumbers", hasVerifiedDestinationNumbers() ? verifiedDestinationNumbers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedDestinationNumbers":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumbers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedDestinationNumbersResponse, T> g) {
        return obj -> g.apply((DescribeVerifiedDestinationNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVerifiedDestinationNumbersResponse> {
        /**
         * <p>
         * An array of VerifiedDestinationNumberInformation objects
         * </p>
         * 
         * @param verifiedDestinationNumbers
         *        An array of VerifiedDestinationNumberInformation objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumbers(Collection<VerifiedDestinationNumberInformation> verifiedDestinationNumbers);

        /**
         * <p>
         * An array of VerifiedDestinationNumberInformation objects
         * </p>
         * 
         * @param verifiedDestinationNumbers
         *        An array of VerifiedDestinationNumberInformation objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumbers(VerifiedDestinationNumberInformation... verifiedDestinationNumbers);

        /**
         * <p>
         * An array of VerifiedDestinationNumberInformation objects
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberInformation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberInformation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberInformation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #verifiedDestinationNumbers(List<VerifiedDestinationNumberInformation>)}.
         * 
         * @param verifiedDestinationNumbers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedDestinationNumbers(java.util.Collection<VerifiedDestinationNumberInformation>)
         */
        Builder verifiedDestinationNumbers(Consumer<VerifiedDestinationNumberInformation.Builder>... verifiedDestinationNumbers);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<VerifiedDestinationNumberInformation> verifiedDestinationNumbers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedDestinationNumbersResponse model) {
            super(model);
            verifiedDestinationNumbers(model.verifiedDestinationNumbers);
            nextToken(model.nextToken);
        }

        public final List<VerifiedDestinationNumberInformation.Builder> getVerifiedDestinationNumbers() {
            List<VerifiedDestinationNumberInformation.Builder> result = VerifiedDestinationNumberInformationListCopier
                    .copyToBuilder(this.verifiedDestinationNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedDestinationNumbers(
                Collection<VerifiedDestinationNumberInformation.BuilderImpl> verifiedDestinationNumbers) {
            this.verifiedDestinationNumbers = VerifiedDestinationNumberInformationListCopier
                    .copyFromBuilder(verifiedDestinationNumbers);
        }

        @Override
        public final Builder verifiedDestinationNumbers(
                Collection<VerifiedDestinationNumberInformation> verifiedDestinationNumbers) {
            this.verifiedDestinationNumbers = VerifiedDestinationNumberInformationListCopier.copy(verifiedDestinationNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedDestinationNumbers(VerifiedDestinationNumberInformation... verifiedDestinationNumbers) {
            verifiedDestinationNumbers(Arrays.asList(verifiedDestinationNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedDestinationNumbers(
                Consumer<VerifiedDestinationNumberInformation.Builder>... verifiedDestinationNumbers) {
            verifiedDestinationNumbers(Stream.of(verifiedDestinationNumbers)
                    .map(c -> VerifiedDestinationNumberInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVerifiedDestinationNumbersResponse build() {
            return new DescribeVerifiedDestinationNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
