/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of the specified field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationFieldDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationFieldDefinition.Builder, RegistrationFieldDefinition> {
    private static final SdkField<String> SECTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SectionPath").getter(getter(RegistrationFieldDefinition::sectionPath))
            .setter(setter(Builder::sectionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionPath").build()).build();

    private static final SdkField<String> FIELD_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldPath").getter(getter(RegistrationFieldDefinition::fieldPath)).setter(setter(Builder::fieldPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPath").build()).build();

    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldType").getter(getter(RegistrationFieldDefinition::fieldTypeAsString))
            .setter(setter(Builder::fieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldType").build()).build();

    private static final SdkField<String> FIELD_REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldRequirement").getter(getter(RegistrationFieldDefinition::fieldRequirementAsString))
            .setter(setter(Builder::fieldRequirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldRequirement").build()).build();

    private static final SdkField<SelectValidation> SELECT_VALIDATION_FIELD = SdkField
            .<SelectValidation> builder(MarshallingType.SDK_POJO).memberName("SelectValidation")
            .getter(getter(RegistrationFieldDefinition::selectValidation)).setter(setter(Builder::selectValidation))
            .constructor(SelectValidation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectValidation").build()).build();

    private static final SdkField<TextValidation> TEXT_VALIDATION_FIELD = SdkField
            .<TextValidation> builder(MarshallingType.SDK_POJO).memberName("TextValidation")
            .getter(getter(RegistrationFieldDefinition::textValidation)).setter(setter(Builder::textValidation))
            .constructor(TextValidation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextValidation").build()).build();

    private static final SdkField<RegistrationFieldDisplayHints> DISPLAY_HINTS_FIELD = SdkField
            .<RegistrationFieldDisplayHints> builder(MarshallingType.SDK_POJO).memberName("DisplayHints")
            .getter(getter(RegistrationFieldDefinition::displayHints)).setter(setter(Builder::displayHints))
            .constructor(RegistrationFieldDisplayHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayHints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_PATH_FIELD,
            FIELD_PATH_FIELD, FIELD_TYPE_FIELD, FIELD_REQUIREMENT_FIELD, SELECT_VALIDATION_FIELD, TEXT_VALIDATION_FIELD,
            DISPLAY_HINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sectionPath;

    private final String fieldPath;

    private final String fieldType;

    private final String fieldRequirement;

    private final SelectValidation selectValidation;

    private final TextValidation textValidation;

    private final RegistrationFieldDisplayHints displayHints;

    private RegistrationFieldDefinition(BuilderImpl builder) {
        this.sectionPath = builder.sectionPath;
        this.fieldPath = builder.fieldPath;
        this.fieldType = builder.fieldType;
        this.fieldRequirement = builder.fieldRequirement;
        this.selectValidation = builder.selectValidation;
        this.textValidation = builder.textValidation;
        this.displayHints = builder.displayHints;
    }

    /**
     * <p>
     * The section path of the field.
     * </p>
     * 
     * @return The section path of the field.
     */
    public final String sectionPath() {
        return sectionPath;
    }

    /**
     * <p>
     * The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list of
     * <b>FieldPaths</b>.
     * </p>
     * 
     * @return The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a
     *         list of <b>FieldPaths</b>.
     */
    public final String fieldPath() {
        return fieldPath;
    }

    /**
     * <p>
     * The type of field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldType} will
     * return {@link FieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldTypeAsString}.
     * </p>
     * 
     * @return The type of field.
     * @see FieldType
     */
    public final FieldType fieldType() {
        return FieldType.fromValue(fieldType);
    }

    /**
     * <p>
     * The type of field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldType} will
     * return {@link FieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldTypeAsString}.
     * </p>
     * 
     * @return The type of field.
     * @see FieldType
     */
    public final String fieldTypeAsString() {
        return fieldType;
    }

    /**
     * <p>
     * Specifies if the field for the registration form is required, conditional or optional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldRequirement}
     * will return {@link FieldRequirement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldRequirementAsString}.
     * </p>
     * 
     * @return Specifies if the field for the registration form is required, conditional or optional.
     * @see FieldRequirement
     */
    public final FieldRequirement fieldRequirement() {
        return FieldRequirement.fromValue(fieldRequirement);
    }

    /**
     * <p>
     * Specifies if the field for the registration form is required, conditional or optional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldRequirement}
     * will return {@link FieldRequirement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldRequirementAsString}.
     * </p>
     * 
     * @return Specifies if the field for the registration form is required, conditional or optional.
     * @see FieldRequirement
     */
    public final String fieldRequirementAsString() {
        return fieldRequirement;
    }

    /**
     * <p>
     * The validation rules for a select field.
     * </p>
     * 
     * @return The validation rules for a select field.
     */
    public final SelectValidation selectValidation() {
        return selectValidation;
    }

    /**
     * <p>
     * The validation rules for a text field.
     * </p>
     * 
     * @return The validation rules for a text field.
     */
    public final TextValidation textValidation() {
        return textValidation;
    }

    /**
     * <p>
     * An array of RegistrationFieldDisplayHints objects for the field.
     * </p>
     * 
     * @return An array of RegistrationFieldDisplayHints objects for the field.
     */
    public final RegistrationFieldDisplayHints displayHints() {
        return displayHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sectionPath());
        hashCode = 31 * hashCode + Objects.hashCode(fieldPath());
        hashCode = 31 * hashCode + Objects.hashCode(fieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldRequirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectValidation());
        hashCode = 31 * hashCode + Objects.hashCode(textValidation());
        hashCode = 31 * hashCode + Objects.hashCode(displayHints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationFieldDefinition)) {
            return false;
        }
        RegistrationFieldDefinition other = (RegistrationFieldDefinition) obj;
        return Objects.equals(sectionPath(), other.sectionPath()) && Objects.equals(fieldPath(), other.fieldPath())
                && Objects.equals(fieldTypeAsString(), other.fieldTypeAsString())
                && Objects.equals(fieldRequirementAsString(), other.fieldRequirementAsString())
                && Objects.equals(selectValidation(), other.selectValidation())
                && Objects.equals(textValidation(), other.textValidation())
                && Objects.equals(displayHints(), other.displayHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationFieldDefinition").add("SectionPath", sectionPath()).add("FieldPath", fieldPath())
                .add("FieldType", fieldTypeAsString()).add("FieldRequirement", fieldRequirementAsString())
                .add("SelectValidation", selectValidation()).add("TextValidation", textValidation())
                .add("DisplayHints", displayHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SectionPath":
            return Optional.ofNullable(clazz.cast(sectionPath()));
        case "FieldPath":
            return Optional.ofNullable(clazz.cast(fieldPath()));
        case "FieldType":
            return Optional.ofNullable(clazz.cast(fieldTypeAsString()));
        case "FieldRequirement":
            return Optional.ofNullable(clazz.cast(fieldRequirementAsString()));
        case "SelectValidation":
            return Optional.ofNullable(clazz.cast(selectValidation()));
        case "TextValidation":
            return Optional.ofNullable(clazz.cast(textValidation()));
        case "DisplayHints":
            return Optional.ofNullable(clazz.cast(displayHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrationFieldDefinition, T> g) {
        return obj -> g.apply((RegistrationFieldDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationFieldDefinition> {
        /**
         * <p>
         * The section path of the field.
         * </p>
         * 
         * @param sectionPath
         *        The section path of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionPath(String sectionPath);

        /**
         * <p>
         * The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a list
         * of <b>FieldPaths</b>.
         * </p>
         * 
         * @param fieldPath
         *        The path to the registration form field. You can use <a>DescribeRegistrationFieldDefinitions</a> for a
         *        list of <b>FieldPaths</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPath(String fieldPath);

        /**
         * <p>
         * The type of field.
         * </p>
         * 
         * @param fieldType
         *        The type of field.
         * @see FieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldType
         */
        Builder fieldType(String fieldType);

        /**
         * <p>
         * The type of field.
         * </p>
         * 
         * @param fieldType
         *        The type of field.
         * @see FieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldType
         */
        Builder fieldType(FieldType fieldType);

        /**
         * <p>
         * Specifies if the field for the registration form is required, conditional or optional.
         * </p>
         * 
         * @param fieldRequirement
         *        Specifies if the field for the registration form is required, conditional or optional.
         * @see FieldRequirement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldRequirement
         */
        Builder fieldRequirement(String fieldRequirement);

        /**
         * <p>
         * Specifies if the field for the registration form is required, conditional or optional.
         * </p>
         * 
         * @param fieldRequirement
         *        Specifies if the field for the registration form is required, conditional or optional.
         * @see FieldRequirement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldRequirement
         */
        Builder fieldRequirement(FieldRequirement fieldRequirement);

        /**
         * <p>
         * The validation rules for a select field.
         * </p>
         * 
         * @param selectValidation
         *        The validation rules for a select field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectValidation(SelectValidation selectValidation);

        /**
         * <p>
         * The validation rules for a select field.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelectValidation.Builder} avoiding the
         * need to create one manually via {@link SelectValidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectValidation.Builder#build()} is called immediately and its
         * result is passed to {@link #selectValidation(SelectValidation)}.
         * 
         * @param selectValidation
         *        a consumer that will call methods on {@link SelectValidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectValidation(SelectValidation)
         */
        default Builder selectValidation(Consumer<SelectValidation.Builder> selectValidation) {
            return selectValidation(SelectValidation.builder().applyMutation(selectValidation).build());
        }

        /**
         * <p>
         * The validation rules for a text field.
         * </p>
         * 
         * @param textValidation
         *        The validation rules for a text field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textValidation(TextValidation textValidation);

        /**
         * <p>
         * The validation rules for a text field.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextValidation.Builder} avoiding the need
         * to create one manually via {@link TextValidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextValidation.Builder#build()} is called immediately and its
         * result is passed to {@link #textValidation(TextValidation)}.
         * 
         * @param textValidation
         *        a consumer that will call methods on {@link TextValidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textValidation(TextValidation)
         */
        default Builder textValidation(Consumer<TextValidation.Builder> textValidation) {
            return textValidation(TextValidation.builder().applyMutation(textValidation).build());
        }

        /**
         * <p>
         * An array of RegistrationFieldDisplayHints objects for the field.
         * </p>
         * 
         * @param displayHints
         *        An array of RegistrationFieldDisplayHints objects for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayHints(RegistrationFieldDisplayHints displayHints);

        /**
         * <p>
         * An array of RegistrationFieldDisplayHints objects for the field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationFieldDisplayHints.Builder}
         * avoiding the need to create one manually via {@link RegistrationFieldDisplayHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationFieldDisplayHints.Builder#build()} is called
         * immediately and its result is passed to {@link #displayHints(RegistrationFieldDisplayHints)}.
         * 
         * @param displayHints
         *        a consumer that will call methods on {@link RegistrationFieldDisplayHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayHints(RegistrationFieldDisplayHints)
         */
        default Builder displayHints(Consumer<RegistrationFieldDisplayHints.Builder> displayHints) {
            return displayHints(RegistrationFieldDisplayHints.builder().applyMutation(displayHints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sectionPath;

        private String fieldPath;

        private String fieldType;

        private String fieldRequirement;

        private SelectValidation selectValidation;

        private TextValidation textValidation;

        private RegistrationFieldDisplayHints displayHints;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationFieldDefinition model) {
            sectionPath(model.sectionPath);
            fieldPath(model.fieldPath);
            fieldType(model.fieldType);
            fieldRequirement(model.fieldRequirement);
            selectValidation(model.selectValidation);
            textValidation(model.textValidation);
            displayHints(model.displayHints);
        }

        public final String getSectionPath() {
            return sectionPath;
        }

        public final void setSectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
        }

        @Override
        public final Builder sectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
            return this;
        }

        public final String getFieldPath() {
            return fieldPath;
        }

        public final void setFieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
        }

        @Override
        public final Builder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public final String getFieldType() {
            return fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public final Builder fieldType(FieldType fieldType) {
            this.fieldType(fieldType == null ? null : fieldType.toString());
            return this;
        }

        public final String getFieldRequirement() {
            return fieldRequirement;
        }

        public final void setFieldRequirement(String fieldRequirement) {
            this.fieldRequirement = fieldRequirement;
        }

        @Override
        public final Builder fieldRequirement(String fieldRequirement) {
            this.fieldRequirement = fieldRequirement;
            return this;
        }

        @Override
        public final Builder fieldRequirement(FieldRequirement fieldRequirement) {
            this.fieldRequirement(fieldRequirement == null ? null : fieldRequirement.toString());
            return this;
        }

        public final SelectValidation.Builder getSelectValidation() {
            return selectValidation != null ? selectValidation.toBuilder() : null;
        }

        public final void setSelectValidation(SelectValidation.BuilderImpl selectValidation) {
            this.selectValidation = selectValidation != null ? selectValidation.build() : null;
        }

        @Override
        public final Builder selectValidation(SelectValidation selectValidation) {
            this.selectValidation = selectValidation;
            return this;
        }

        public final TextValidation.Builder getTextValidation() {
            return textValidation != null ? textValidation.toBuilder() : null;
        }

        public final void setTextValidation(TextValidation.BuilderImpl textValidation) {
            this.textValidation = textValidation != null ? textValidation.build() : null;
        }

        @Override
        public final Builder textValidation(TextValidation textValidation) {
            this.textValidation = textValidation;
            return this;
        }

        public final RegistrationFieldDisplayHints.Builder getDisplayHints() {
            return displayHints != null ? displayHints.toBuilder() : null;
        }

        public final void setDisplayHints(RegistrationFieldDisplayHints.BuilderImpl displayHints) {
            this.displayHints = displayHints != null ? displayHints.build() : null;
        }

        @Override
        public final Builder displayHints(RegistrationFieldDisplayHints displayHints) {
            this.displayHints = displayHints;
            return this;
        }

        @Override
        public RegistrationFieldDefinition build() {
            return new RegistrationFieldDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
