/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapability;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProtectConfigurationCountryRuleSetRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, GetProtectConfigurationCountryRuleSetRequest> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(GetProtectConfigurationCountryRuleSetRequest.getter(GetProtectConfigurationCountryRuleSetRequest::protectConfigurationId)).setter(GetProtectConfigurationCountryRuleSetRequest.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final SdkField<String> NUMBER_CAPABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberCapability").getter(GetProtectConfigurationCountryRuleSetRequest.getter(GetProtectConfigurationCountryRuleSetRequest::numberCapabilityAsString)).setter(GetProtectConfigurationCountryRuleSetRequest.setter(Builder::numberCapability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATION_ID_FIELD, NUMBER_CAPABILITY_FIELD));
    private final String protectConfigurationId;
    private final String numberCapability;

    private GetProtectConfigurationCountryRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationId = builder.protectConfigurationId;
        this.numberCapability = builder.numberCapability;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public final NumberCapability numberCapability() {
        return NumberCapability.fromValue(this.numberCapability);
    }

    public final String numberCapabilityAsString() {
        return this.numberCapability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberCapabilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtectConfigurationCountryRuleSetRequest)) {
            return false;
        }
        GetProtectConfigurationCountryRuleSetRequest other = (GetProtectConfigurationCountryRuleSetRequest)((Object)obj);
        return Objects.equals(this.protectConfigurationId(), other.protectConfigurationId()) && Objects.equals(this.numberCapabilityAsString(), other.numberCapabilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetProtectConfigurationCountryRuleSetRequest").add("ProtectConfigurationId", (Object)this.protectConfigurationId()).add("NumberCapability", (Object)this.numberCapabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
            case "NumberCapability": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtectConfigurationCountryRuleSetRequest, T> g) {
        return obj -> g.apply((GetProtectConfigurationCountryRuleSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String protectConfigurationId;
        private String numberCapability;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtectConfigurationCountryRuleSetRequest model) {
            super(model);
            this.protectConfigurationId(model.protectConfigurationId);
            this.numberCapability(model.numberCapability);
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getNumberCapability() {
            return this.numberCapability;
        }

        public final void setNumberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
        }

        @Override
        public final Builder numberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
            return this;
        }

        @Override
        public final Builder numberCapability(NumberCapability numberCapability) {
            this.numberCapability(numberCapability == null ? null : numberCapability.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProtectConfigurationCountryRuleSetRequest build() {
            return new GetProtectConfigurationCountryRuleSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProtectConfigurationCountryRuleSetRequest> {
        public Builder protectConfigurationId(String var1);

        public Builder numberCapability(String var1);

        public Builder numberCapability(NumberCapability var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

