/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccessDeniedException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConflictException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteAccountDefaultProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteAccountDefaultProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteMediaMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteMediaMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetProtectConfigurationCountryRuleSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetProtectConfigurationCountryRuleSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.InternalServerException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendMediaMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendMediaMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetAccountDefaultProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetAccountDefaultProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetMediaMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetMediaMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ThrottlingException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationCountryRuleSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationCountryRuleSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ValidationException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable;

/**
 * Service client for accessing Amazon Pinpoint SMS Voice V2. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Welcome to the <i>AWS End User Messaging SMS and Voice, version 2 API Reference</i>. This guide provides information
 * about AWS End User Messaging SMS and Voice, version 2 API resources, including supported HTTP methods, parameters,
 * and schemas.
 * </p>
 * <p>
 * Amazon Pinpoint is an Amazon Web Services service that you can use to engage with your recipients across multiple
 * messaging channels. The AWS End User Messaging SMS and Voice, version 2 API provides programmatic access to options
 * that are unique to the SMS and voice channels. AWS End User Messaging SMS and Voice, version 2 resources such as
 * phone numbers, sender IDs, and opt-out lists can be used by the Amazon Pinpoint API.
 * </p>
 * <p>
 * If you're new to AWS End User Messaging SMS and Voice, it's also helpful to review the <a
 * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html"> AWS End User Messaging SMS User
 * Guide</a>. The <i>AWS End User Messaging SMS User Guide </i> provides tutorials, code samples, and procedures that
 * demonstrate how to use AWS End User Messaging SMS and Voice features programmatically and how to integrate
 * functionality into mobile apps and other types of applications. The guide also provides key information, such as AWS
 * End User Messaging SMS and Voice integration with other Amazon Web Services services, and the quotas that apply to
 * use of the service.
 * </p>
 * <p>
 * <b>Regional availability</b>
 * </p>
 * <p>
 * The <i>AWS End User Messaging SMS and Voice version 2 API Reference</i> is available in several Amazon Web Services
 * Regions and it provides an endpoint for each of these Regions. For a list of all the Regions and endpoints where the
 * API is currently available, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region">Amazon Web Services Service
 * Endpoints</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/pinpoint.html">Amazon Pinpoint endpoints and
 * quotas</a> in the Amazon Web Services General Reference. To learn more about Amazon Web Services Regions, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions</a> in
 * the Amazon Web Services General Reference.
 * </p>
 * <p>
 * In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically
 * isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network
 * connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while
 * also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see
 * <a href="https://aws.amazon.com/about-aws/global-infrastructure/">Amazon Web Services Global Infrastructure.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PinpointSmsVoiceV2Client extends AwsClient {
    String SERVICE_NAME = "sms-voice";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "sms-voice";

    /**
     * <p>
     * Associates the specified origination identity with a pool.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <p>
     * If the origination identity configuration doesn't match the pool's configuration, an error is returned.
     * </p>
     *
     * @param associateOriginationIdentityRequest
     * @return Result of the AssociateOriginationIdentity operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.AssociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateOriginationIdentityResponse associateOriginationIdentity(
            AssociateOriginationIdentityRequest associateOriginationIdentityRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified origination identity with a pool.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <p>
     * If the origination identity configuration doesn't match the pool's configuration, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateOriginationIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateOriginationIdentityRequest#builder()}
     * </p>
     *
     * @param associateOriginationIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateOriginationIdentity operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.AssociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateOriginationIdentityResponse associateOriginationIdentity(
            Consumer<AssociateOriginationIdentityRequest.Builder> associateOriginationIdentityRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return associateOriginationIdentity(AssociateOriginationIdentityRequest.builder()
                .applyMutation(associateOriginationIdentityRequest).build());
    }

    /**
     * <p>
     * Associate a protect configuration with a configuration set. This replaces the configuration sets current protect
     * configuration. A configuration set can only be associated with one protect configuration at a time. A protect
     * configuration can be associated with multiple configuration sets.
     * </p>
     *
     * @param associateProtectConfigurationRequest
     * @return Result of the AssociateProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.AssociateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateProtectConfigurationResponse associateProtectConfiguration(
            AssociateProtectConfigurationRequest associateProtectConfigurationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a protect configuration with a configuration set. This replaces the configuration sets current protect
     * configuration. A configuration set can only be associated with one protect configuration at a time. A protect
     * configuration can be associated with multiple configuration sets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateProtectConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param associateProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.AssociateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateProtectConfigurationResponse associateProtectConfiguration(
            Consumer<AssociateProtectConfigurationRequest.Builder> associateProtectConfigurationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return associateProtectConfiguration(AssociateProtectConfigurationRequest.builder()
                .applyMutation(associateProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     * </p>
     * <p>
     * When you send a message, you can optionally specify a single configuration set.
     * </p>
     *
     * @param createConfigurationSetRequest
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     * </p>
     * <p>
     * When you send a message, you can optionally specify a single configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest.Builder} to
     *        create a request.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new event destination in a configuration set.
     * </p>
     * <p>
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon
     * Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information
     * about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS
     * topic.
     * </p>
     * <p>
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a
     * reference to a single destination, such as a CloudWatch or Firehose destination.
     * </p>
     *
     * @param createEventDestinationRequest
     * @return Result of the CreateEventDestination operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventDestinationResponse createEventDestination(CreateEventDestinationRequest createEventDestinationRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event destination in a configuration set.
     * </p>
     * <p>
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon
     * Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information
     * about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS
     * topic.
     * </p>
     * <p>
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a
     * reference to a single destination, such as a CloudWatch or Firehose destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventDestinationRequest#builder()}
     * </p>
     *
     * @param createEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateEventDestination operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventDestinationResponse createEventDestination(
            Consumer<CreateEventDestinationRequest.Builder> createEventDestinationRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createEventDestination(CreateEventDestinationRequest.builder().applyMutation(createEventDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new opt-out list.
     * </p>
     * <p>
     * If the opt-out list name already exists, an error is returned.
     * </p>
     * <p>
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to
     * them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In
     * addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of
     * supported opt-out keywords, see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS
     * opt out </a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param createOptOutListRequest
     * @return Result of the CreateOptOutList operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOptOutListResponse createOptOutList(CreateOptOutListRequest createOptOutListRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new opt-out list.
     * </p>
     * <p>
     * If the opt-out list name already exists, an error is returned.
     * </p>
     * <p>
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to
     * them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In
     * addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of
     * supported opt-out keywords, see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS
     * opt out </a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOptOutListRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOptOutListRequest#builder()}
     * </p>
     *
     * @param createOptOutListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest.Builder} to create
     *        a request.
     * @return Result of the CreateOptOutList operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOptOutListResponse createOptOutList(Consumer<CreateOptOutListRequest.Builder> createOptOutListRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createOptOutList(CreateOptOutListRequest.builder().applyMutation(createOptOutListRequest).build());
    }

    /**
     * <p>
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more
     * phone numbers and SenderIds that are associated with your Amazon Web Services account.
     * </p>
     * <p>
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message
     * type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't
     * inherited from the origination identity and defaults to false.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     *
     * @param createPoolRequest
     * @return Result of the CreatePool operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePoolResponse createPool(CreatePoolRequest createPoolRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more
     * phone numbers and SenderIds that are associated with your Amazon Web Services account.
     * </p>
     * <p>
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message
     * type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't
     * inherited from the origination identity and defaults to false.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePoolRequest#builder()}
     * </p>
     *
     * @param createPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePool operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePoolResponse createPool(Consumer<CreatePoolRequest.Builder> createPoolRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return createPool(CreatePoolRequest.builder().applyMutation(createPoolRequest).build());
    }

    /**
     * <p>
     * Create a new protect configuration. By default all country rule sets for each capability are set to
     * <code>ALLOW</code>. Update the country rule sets using <code>UpdateProtectConfigurationCountryRuleSet</code>. A
     * protect configurations name is stored as a Tag with the key set to <code>Name</code> and value as the name of the
     * protect configuration.
     * </p>
     *
     * @param createProtectConfigurationRequest
     * @return Result of the CreateProtectConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProtectConfigurationResponse createProtectConfiguration(
            CreateProtectConfigurationRequest createProtectConfigurationRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new protect configuration. By default all country rule sets for each capability are set to
     * <code>ALLOW</code>. Update the country rule sets using <code>UpdateProtectConfigurationCountryRuleSet</code>. A
     * protect configurations name is stored as a Tag with the key set to <code>Name</code> and value as the name of the
     * protect configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param createProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateProtectConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProtectConfigurationResponse createProtectConfiguration(
            Consumer<CreateProtectConfigurationRequest.Builder> createProtectConfigurationRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createProtectConfiguration(CreateProtectConfigurationRequest.builder()
                .applyMutation(createProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new registration based on the <b>RegistrationType</b> field.
     * </p>
     *
     * @param createRegistrationRequest
     * @return Result of the CreateRegistration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationResponse createRegistration(CreateRegistrationRequest createRegistrationRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new registration based on the <b>RegistrationType</b> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRegistrationRequest#builder()}
     * </p>
     *
     * @param createRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateRegistration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationResponse createRegistration(Consumer<CreateRegistrationRequest.Builder> createRegistrationRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createRegistration(CreateRegistrationRequest.builder().applyMutation(createRegistrationRequest).build());
    }

    /**
     * <p>
     * Associate the registration with an origination identity such as a phone number or sender ID.
     * </p>
     *
     * @param createRegistrationAssociationRequest
     * @return Result of the CreateRegistrationAssociation operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistrationAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationAssociationResponse createRegistrationAssociation(
            CreateRegistrationAssociationRequest createRegistrationAssociationRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate the registration with an origination identity such as a phone number or sender ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRegistrationAssociationRequest#builder()}
     * </p>
     *
     * @param createRegistrationAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateRegistrationAssociation operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistrationAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationAssociationResponse createRegistrationAssociation(
            Consumer<CreateRegistrationAssociationRequest.Builder> createRegistrationAssociationRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return createRegistrationAssociation(CreateRegistrationAssociationRequest.builder()
                .applyMutation(createRegistrationAssociationRequest).build());
    }

    /**
     * <p>
     * Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is
     * 1MiB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed
     * “letter of authorization” (LOA) to be submitted.
     * </p>
     *
     * @param createRegistrationAttachmentRequest
     * @return Result of the CreateRegistrationAttachment operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationAttachmentResponse createRegistrationAttachment(
            CreateRegistrationAttachmentRequest createRegistrationAttachmentRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is
     * 1MiB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed
     * “letter of authorization” (LOA) to be submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRegistrationAttachmentRequest#builder()}
     * </p>
     *
     * @param createRegistrationAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentRequest.Builder}
     *        to create a request.
     * @return Result of the CreateRegistrationAttachment operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationAttachmentResponse createRegistrationAttachment(
            Consumer<CreateRegistrationAttachmentRequest.Builder> createRegistrationAttachmentRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createRegistrationAttachment(CreateRegistrationAttachmentRequest.builder()
                .applyMutation(createRegistrationAttachmentRequest).build());
    }

    /**
     * <p>
     * Create a new version of the registration and increase the <b>VersionNumber</b>. The previous version of the
     * registration becomes read-only.
     * </p>
     *
     * @param createRegistrationVersionRequest
     * @return Result of the CreateRegistrationVersion operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationVersionResponse createRegistrationVersion(
            CreateRegistrationVersionRequest createRegistrationVersionRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new version of the registration and increase the <b>VersionNumber</b>. The previous version of the
     * registration becomes read-only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistrationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRegistrationVersionRequest#builder()}
     * </p>
     *
     * @param createRegistrationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionRequest.Builder}
     *        to create a request.
     * @return Result of the CreateRegistrationVersion operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRegistrationVersionResponse createRegistrationVersion(
            Consumer<CreateRegistrationVersionRequest.Builder> createRegistrationVersionRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return createRegistrationVersion(CreateRegistrationVersionRequest.builder()
                .applyMutation(createRegistrationVersionRequest).build());
    }

    /**
     * <p>
     * You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to
     * 10 verified destination numbers.
     * </p>
     *
     * @param createVerifiedDestinationNumberRequest
     * @return Result of the CreateVerifiedDestinationNumber operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedDestinationNumberResponse createVerifiedDestinationNumber(
            CreateVerifiedDestinationNumberRequest createVerifiedDestinationNumberRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to
     * 10 verified destination numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVerifiedDestinationNumberRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVerifiedDestinationNumberRequest#builder()}
     * </p>
     *
     * @param createVerifiedDestinationNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberRequest.Builder}
     *        to create a request.
     * @return Result of the CreateVerifiedDestinationNumber operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedDestinationNumberResponse createVerifiedDestinationNumber(
            Consumer<CreateVerifiedDestinationNumberRequest.Builder> createVerifiedDestinationNumberRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return createVerifiedDestinationNumber(CreateVerifiedDestinationNumberRequest.builder()
                .applyMutation(createVerifiedDestinationNumberRequest).build());
    }

    /**
     * <p>
     * Removes the current account default protect configuration.
     * </p>
     *
     * @param deleteAccountDefaultProtectConfigurationRequest
     * @return Result of the DeleteAccountDefaultProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteAccountDefaultProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteAccountDefaultProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountDefaultProtectConfigurationResponse deleteAccountDefaultProtectConfiguration(
            DeleteAccountDefaultProtectConfigurationRequest deleteAccountDefaultProtectConfigurationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the current account default protect configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteAccountDefaultProtectConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteAccountDefaultProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAccountDefaultProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteAccountDefaultProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteAccountDefaultProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteAccountDefaultProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteAccountDefaultProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountDefaultProtectConfigurationResponse deleteAccountDefaultProtectConfiguration(
            Consumer<DeleteAccountDefaultProtectConfigurationRequest.Builder> deleteAccountDefaultProtectConfigurationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteAccountDefaultProtectConfiguration(DeleteAccountDefaultProtectConfigurationRequest.builder()
                .applyMutation(deleteAccountDefaultProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an existing configuration set.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration
     * set, you can specify a destination for specific types of events related to voice and SMS messages.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing configuration set.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration
     * set, you can specify a destination for specific types of events related to voice and SMS messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing default message type on a configuration set.
     * </p>
     * <p>
     * A message type is a type of messages that you plan to send. If you send account-related messages or
     * time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param deleteDefaultMessageTypeRequest
     * @return Result of the DeleteDefaultMessageType operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDefaultMessageTypeResponse deleteDefaultMessageType(
            DeleteDefaultMessageTypeRequest deleteDefaultMessageTypeRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing default message type on a configuration set.
     * </p>
     * <p>
     * A message type is a type of messages that you plan to send. If you send account-related messages or
     * time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDefaultMessageTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDefaultMessageTypeRequest#builder()}
     * </p>
     *
     * @param deleteDefaultMessageTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteDefaultMessageType operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDefaultMessageTypeResponse deleteDefaultMessageType(
            Consumer<DeleteDefaultMessageTypeRequest.Builder> deleteDefaultMessageTypeRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteDefaultMessageType(DeleteDefaultMessageTypeRequest.builder().applyMutation(deleteDefaultMessageTypeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing default sender ID on a configuration set.
     * </p>
     * <p>
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support
     * for sender ID capabilities varies by country or region.
     * </p>
     *
     * @param deleteDefaultSenderIdRequest
     * @return Result of the DeleteDefaultSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDefaultSenderIdResponse deleteDefaultSenderId(DeleteDefaultSenderIdRequest deleteDefaultSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing default sender ID on a configuration set.
     * </p>
     * <p>
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support
     * for sender ID capabilities varies by country or region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDefaultSenderIdRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDefaultSenderIdRequest#builder()}
     * </p>
     *
     * @param deleteDefaultSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDefaultSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDefaultSenderIdResponse deleteDefaultSenderId(
            Consumer<DeleteDefaultSenderIdRequest.Builder> deleteDefaultSenderIdRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteDefaultSenderId(DeleteDefaultSenderIdRequest.builder().applyMutation(deleteDefaultSenderIdRequest).build());
    }

    /**
     * <p>
     * Deletes an existing event destination.
     * </p>
     * <p>
     * An event destination is a location where you send response information about the messages that you send. For
     * example, when a message is delivered successfully, you can send information about that event to an Amazon
     * CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     * </p>
     *
     * @param deleteEventDestinationRequest
     * @return Result of the DeleteEventDestination operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventDestinationResponse deleteEventDestination(DeleteEventDestinationRequest deleteEventDestinationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing event destination.
     * </p>
     * <p>
     * An event destination is a location where you send response information about the messages that you send. For
     * example, when a message is delivered successfully, you can send information about that event to an Amazon
     * CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteEventDestination operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventDestinationResponse deleteEventDestination(
            Consumer<DeleteEventDestinationRequest.Builder> deleteEventDestinationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteEventDestination(DeleteEventDestinationRequest.builder().applyMutation(deleteEventDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing keyword from an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     * </p>
     *
     * @param deleteKeywordRequest
     * @return Result of the DeleteKeyword operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteKeywordResponse deleteKeyword(DeleteKeywordRequest deleteKeywordRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing keyword from an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeywordRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeywordRequest#builder()}
     * </p>
     *
     * @param deleteKeywordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKeyword operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteKeywordResponse deleteKeyword(Consumer<DeleteKeywordRequest.Builder> deleteKeywordRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteKeyword(DeleteKeywordRequest.builder().applyMutation(deleteKeywordRequest).build());
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending multimedia messages (MMS). Deleting a spend
     * limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas for Server Migration Service</a>
     * in the <i>Server Migration Service User Guide</i>.
     * </p>
     *
     * @param deleteMediaMessageSpendLimitOverrideRequest
     * @return Result of the DeleteMediaMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteMediaMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteMediaMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMediaMessageSpendLimitOverrideResponse deleteMediaMessageSpendLimitOverride(
            DeleteMediaMessageSpendLimitOverrideRequest deleteMediaMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending multimedia messages (MMS). Deleting a spend
     * limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas for Server Migration Service</a>
     * in the <i>Server Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteMediaMessageSpendLimitOverrideRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteMediaMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param deleteMediaMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteMediaMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteMediaMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteMediaMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteMediaMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMediaMessageSpendLimitOverrideResponse deleteMediaMessageSpendLimitOverride(
            Consumer<DeleteMediaMessageSpendLimitOverrideRequest.Builder> deleteMediaMessageSpendLimitOverrideRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteMediaMessageSpendLimitOverride(DeleteMediaMessageSpendLimitOverrideRequest.builder()
                .applyMutation(deleteMediaMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     * </p>
     * <p>
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an error is
     * returned.
     * </p>
     *
     * @param deleteOptOutListRequest
     * @return Result of the DeleteOptOutList operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOptOutListResponse deleteOptOutList(DeleteOptOutListRequest deleteOptOutListRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     * </p>
     * <p>
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptOutListRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOptOutListRequest#builder()}
     * </p>
     *
     * @param deleteOptOutListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteOptOutList operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOptOutListResponse deleteOptOutList(Consumer<DeleteOptOutListRequest.Builder> deleteOptOutListRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteOptOutList(DeleteOptOutListRequest.builder().applyMutation(deleteOptOutListRequest).build());
    }

    /**
     * <p>
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     * </p>
     * <p>
     * Each destination phone number can only be deleted once every 30 days.
     * </p>
     * <p>
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an error is
     * returned.
     * </p>
     *
     * @param deleteOptedOutNumberRequest
     * @return Result of the DeleteOptedOutNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOptedOutNumberResponse deleteOptedOutNumber(DeleteOptedOutNumberRequest deleteOptedOutNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     * </p>
     * <p>
     * Each destination phone number can only be deleted once every 30 days.
     * </p>
     * <p>
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptedOutNumberRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOptedOutNumberRequest#builder()}
     * </p>
     *
     * @param deleteOptedOutNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteOptedOutNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOptedOutNumberResponse deleteOptedOutNumber(
            Consumer<DeleteOptedOutNumberRequest.Builder> deleteOptedOutNumberRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteOptedOutNumber(DeleteOptedOutNumberRequest.builder().applyMutation(deleteOptedOutNumberRequest).build());
    }

    /**
     * <p>
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     * </p>
     * <p>
     * If the pool status isn't active or if deletion protection is enabled, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param deletePoolRequest
     * @return Result of the DeletePool operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeletePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePoolResponse deletePool(DeletePoolRequest deletePoolRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     * </p>
     * <p>
     * If the pool status isn't active or if deletion protection is enabled, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePoolRequest#builder()}
     * </p>
     *
     * @param deletePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePool operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeletePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePoolResponse deletePool(Consumer<DeletePoolRequest.Builder> deletePoolRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deletePool(DeletePoolRequest.builder().applyMutation(deletePoolRequest).build());
    }

    /**
     * <p>
     * Permanently delete the protect configuration. The protect configuration must have deletion protection disabled
     * and must not be associated as the account default protect configuration or associated with a configuration set.
     * </p>
     *
     * @param deleteProtectConfigurationRequest
     * @return Result of the DeleteProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProtectConfigurationResponse deleteProtectConfiguration(
            DeleteProtectConfigurationRequest deleteProtectConfigurationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently delete the protect configuration. The protect configuration must have deletion protection disabled
     * and must not be associated as the account default protect configuration or associated with a configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProtectConfigurationResponse deleteProtectConfiguration(
            Consumer<DeleteProtectConfigurationRequest.Builder> deleteProtectConfigurationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteProtectConfiguration(DeleteProtectConfigurationRequest.builder()
                .applyMutation(deleteProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Permanently delete an existing registration from your account.
     * </p>
     *
     * @param deleteRegistrationRequest
     * @return Result of the DeleteRegistration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRegistrationResponse deleteRegistration(DeleteRegistrationRequest deleteRegistrationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently delete an existing registration from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegistrationRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRegistration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRegistrationResponse deleteRegistration(Consumer<DeleteRegistrationRequest.Builder> deleteRegistrationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteRegistration(DeleteRegistrationRequest.builder().applyMutation(deleteRegistrationRequest).build());
    }

    /**
     * <p>
     * Permanently delete the specified registration attachment.
     * </p>
     *
     * @param deleteRegistrationAttachmentRequest
     * @return Result of the DeleteRegistrationAttachment operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRegistrationAttachmentResponse deleteRegistrationAttachment(
            DeleteRegistrationAttachmentRequest deleteRegistrationAttachmentRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently delete the specified registration attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRegistrationAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteRegistrationAttachment operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRegistrationAttachmentResponse deleteRegistrationAttachment(
            Consumer<DeleteRegistrationAttachmentRequest.Builder> deleteRegistrationAttachmentRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteRegistrationAttachment(DeleteRegistrationAttachmentRequest.builder()
                .applyMutation(deleteRegistrationAttachmentRequest).build());
    }

    /**
     * <p>
     * Delete the value in a registration form field.
     * </p>
     *
     * @param deleteRegistrationFieldValueRequest
     * @return Result of the DeleteRegistrationFieldValue operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteRegistrationFieldValue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRegistrationFieldValueResponse deleteRegistrationFieldValue(
            DeleteRegistrationFieldValueRequest deleteRegistrationFieldValueRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the value in a registration form field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationFieldValueRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRegistrationFieldValueRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationFieldValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteRegistrationFieldValue operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteRegistrationFieldValue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRegistrationFieldValueResponse deleteRegistrationFieldValue(
            Consumer<DeleteRegistrationFieldValueRequest.Builder> deleteRegistrationFieldValueRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteRegistrationFieldValue(DeleteRegistrationFieldValueRequest.builder()
                .applyMutation(deleteRegistrationFieldValueRequest).build());
    }

    /**
     * <p>
     * Deletes the resource-based policy document attached to the AWS End User Messaging SMS and Voice resource. A
     * shared resource can be a Pool, Opt-out list, Sender Id, or Phone number.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource-based policy document attached to the AWS End User Messaging SMS and Voice resource. A
     * shared resource can be a Pool, Opt-out list, Sender Id, or Phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit
     * override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the <i>AWS End User
     * Messaging SMS User Guide</i>.
     * </p>
     *
     * @param deleteTextMessageSpendLimitOverrideRequest
     * @return Result of the DeleteTextMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTextMessageSpendLimitOverrideResponse deleteTextMessageSpendLimitOverride(
            DeleteTextMessageSpendLimitOverrideRequest deleteTextMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit
     * override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the <i>AWS End User
     * Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTextMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTextMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param deleteTextMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteTextMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTextMessageSpendLimitOverrideResponse deleteTextMessageSpendLimitOverride(
            Consumer<DeleteTextMessageSpendLimitOverrideRequest.Builder> deleteTextMessageSpendLimitOverrideRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteTextMessageSpendLimitOverride(DeleteTextMessageSpendLimitOverrideRequest.builder()
                .applyMutation(deleteTextMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Delete a verified destination phone number.
     * </p>
     *
     * @param deleteVerifiedDestinationNumberRequest
     * @return Result of the DeleteVerifiedDestinationNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedDestinationNumberResponse deleteVerifiedDestinationNumber(
            DeleteVerifiedDestinationNumberRequest deleteVerifiedDestinationNumberRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a verified destination phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedDestinationNumberRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVerifiedDestinationNumberRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedDestinationNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteVerifiedDestinationNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedDestinationNumberResponse deleteVerifiedDestinationNumber(
            Consumer<DeleteVerifiedDestinationNumberRequest.Builder> deleteVerifiedDestinationNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteVerifiedDestinationNumber(DeleteVerifiedDestinationNumberRequest.builder()
                .applyMutation(deleteVerifiedDestinationNumberRequest).build());
    }

    /**
     * <p>
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override
     * sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web
     * Services. For more information on spending limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the <i>AWS End User
     * Messaging SMS User Guide</i>.
     * </p>
     *
     * @param deleteVoiceMessageSpendLimitOverrideRequest
     * @return Result of the DeleteVoiceMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVoiceMessageSpendLimitOverrideResponse deleteVoiceMessageSpendLimitOverride(
            DeleteVoiceMessageSpendLimitOverrideRequest deleteVoiceMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override
     * sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web
     * Services. For more information on spending limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the <i>AWS End User
     * Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceMessageSpendLimitOverrideRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVoiceMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param deleteVoiceMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteVoiceMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVoiceMessageSpendLimitOverrideResponse deleteVoiceMessageSpendLimitOverride(
            Consumer<DeleteVoiceMessageSpendLimitOverrideRequest.Builder> deleteVoiceMessageSpendLimitOverrideRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return deleteVoiceMessageSpendLimitOverride(DeleteVoiceMessageSpendLimitOverrideRequest.builder()
                .applyMutation(deleteVoiceMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end
     * recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end
     * recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client.describeAccountAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client
     *             .describeAccountAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client.describeAccountAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesIterable describeAccountAttributesPaginator(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeAccountAttributesIterable(this, describeAccountAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client.describeAccountAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client
     *             .describeAccountAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client.describeAccountAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesIterable describeAccountAttributesPaginator(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return describeAccountAttributesPaginator(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the current AWS End User Messaging SMS and Voice SMS Voice V2 resource quotas for your account. The
     * description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the
     * <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current AWS End User Messaging SMS and Voice SMS Voice V2 resource quotas for your account. The
     * description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the
     * <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client
     *             .describeAccountLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsIterable describeAccountLimitsPaginator(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeAccountLimitsIterable(this, describeAccountLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client
     *             .describeAccountLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsIterable describeAccountLimitsPaginator(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return Result of the DescribeConfigurationSets operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSetsResponse describeConfigurationSets(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeConfigurationSets operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSetsResponse describeConfigurationSets(
            Consumer<DescribeConfigurationSetsRequest.Builder> describeConfigurationSetsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeConfigurationSets(DescribeConfigurationSetsRequest.builder()
                .applyMutation(describeConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client.describeConfigurationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client
     *             .describeConfigurationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client.describeConfigurationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSetsIterable describeConfigurationSetsPaginator(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return new DescribeConfigurationSetsIterable(this, describeConfigurationSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client.describeConfigurationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client
     *             .describeConfigurationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client.describeConfigurationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationSetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationSetsIterable describeConfigurationSetsPaginator(
            Consumer<DescribeConfigurationSetsRequest.Builder> describeConfigurationSetsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeConfigurationSetsPaginator(DescribeConfigurationSetsRequest.builder()
                .applyMutation(describeConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     *
     * @param describeKeywordsRequest
     * @return Result of the DescribeKeywords operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeywordsResponse describeKeywords(DescribeKeywordsRequest describeKeywordsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeywordsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeKeywordsRequest#builder()}
     * </p>
     *
     * @param describeKeywordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeKeywords operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeywordsResponse describeKeywords(Consumer<DescribeKeywordsRequest.Builder> describeKeywordsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeKeywords(DescribeKeywordsRequest.builder().applyMutation(describeKeywordsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client.describeKeywordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client
     *             .describeKeywordsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client.describeKeywordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeKeywordsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeywordsIterable describeKeywordsPaginator(DescribeKeywordsRequest describeKeywordsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeKeywordsIterable(this, describeKeywordsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client.describeKeywordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client
     *             .describeKeywordsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client.describeKeywordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeywordsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeKeywordsRequest#builder()}
     * </p>
     *
     * @param describeKeywordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeKeywordsIterable describeKeywordsPaginator(Consumer<DescribeKeywordsRequest.Builder> describeKeywordsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeKeywordsPaginator(DescribeKeywordsRequest.builder().applyMutation(describeKeywordsRequest).build());
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return Result of the DescribeOptOutLists operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptOutListsResponse describeOptOutLists(DescribeOptOutListsRequest describeOptOutListsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptOutListsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptOutListsRequest#builder()}
     * </p>
     *
     * @param describeOptOutListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOptOutLists operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptOutListsResponse describeOptOutLists(
            Consumer<DescribeOptOutListsRequest.Builder> describeOptOutListsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeOptOutLists(DescribeOptOutListsRequest.builder().applyMutation(describeOptOutListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client.describeOptOutListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client
     *             .describeOptOutListsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client.describeOptOutListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptOutListsIterable describeOptOutListsPaginator(DescribeOptOutListsRequest describeOptOutListsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeOptOutListsIterable(this, describeOptOutListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client.describeOptOutListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client
     *             .describeOptOutListsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client.describeOptOutListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptOutListsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptOutListsRequest#builder()}
     * </p>
     *
     * @param describeOptOutListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptOutListsIterable describeOptOutListsPaginator(
            Consumer<DescribeOptOutListsRequest.Builder> describeOptOutListsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeOptOutListsPaginator(DescribeOptOutListsRequest.builder().applyMutation(describeOptOutListsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an error is returned.
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return Result of the DescribeOptedOutNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptedOutNumbersResponse describeOptedOutNumbers(DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptedOutNumbersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptedOutNumbersRequest#builder()}
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOptedOutNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptedOutNumbersResponse describeOptedOutNumbers(
            Consumer<DescribeOptedOutNumbersRequest.Builder> describeOptedOutNumbersRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeOptedOutNumbers(DescribeOptedOutNumbersRequest.builder().applyMutation(describeOptedOutNumbersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client.describeOptedOutNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client
     *             .describeOptedOutNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client.describeOptedOutNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptedOutNumbersIterable describeOptedOutNumbersPaginator(
            DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return new DescribeOptedOutNumbersIterable(this, describeOptedOutNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client.describeOptedOutNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client
     *             .describeOptedOutNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client.describeOptedOutNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptedOutNumbersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptedOutNumbersRequest#builder()}
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptedOutNumbersIterable describeOptedOutNumbersPaginator(
            Consumer<DescribeOptedOutNumbersRequest.Builder> describeOptedOutNumbersRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeOptedOutNumbersPaginator(DescribeOptedOutNumbersRequest.builder()
                .applyMutation(describeOptedOutNumbersRequest).build());
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an error is returned.
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return Result of the DescribePhoneNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhoneNumbersResponse describePhoneNumbers(DescribePhoneNumbersRequest describePhoneNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumbersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param describePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePhoneNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhoneNumbersResponse describePhoneNumbers(
            Consumer<DescribePhoneNumbersRequest.Builder> describePhoneNumbersRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describePhoneNumbers(DescribePhoneNumbersRequest.builder().applyMutation(describePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client.describePhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client
     *             .describePhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client.describePhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhoneNumbersIterable describePhoneNumbersPaginator(DescribePhoneNumbersRequest describePhoneNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribePhoneNumbersIterable(this, describePhoneNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client.describePhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client
     *             .describePhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client.describePhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumbersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param describePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhoneNumbersIterable describePhoneNumbersPaginator(
            Consumer<DescribePhoneNumbersRequest.Builder> describePhoneNumbersRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describePhoneNumbersPaginator(DescribePhoneNumbersRequest.builder().applyMutation(describePhoneNumbersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param describePoolsRequest
     * @return Result of the DescribePools operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePoolsResponse describePools(DescribePoolsRequest describePoolsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoolsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePoolsRequest#builder()}
     * </p>
     *
     * @param describePoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePools operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePoolsResponse describePools(Consumer<DescribePoolsRequest.Builder> describePoolsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describePools(DescribePoolsRequest.builder().applyMutation(describePoolsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client.describePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client
     *             .describePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client.describePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePoolsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePoolsIterable describePoolsPaginator(DescribePoolsRequest describePoolsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribePoolsIterable(this, describePoolsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client.describePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client
     *             .describePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client.describePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePoolsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePoolsRequest#builder()}
     * </p>
     *
     * @param describePoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePoolsIterable describePoolsPaginator(Consumer<DescribePoolsRequest.Builder> describePoolsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describePoolsPaginator(DescribePoolsRequest.builder().applyMutation(describePoolsRequest).build());
    }

    /**
     * <p>
     * Retrieves the protect configurations that match any of filters. If a filter isn’t provided then all protect
     * configurations are returned.
     * </p>
     *
     * @param describeProtectConfigurationsRequest
     * @return Result of the DescribeProtectConfigurations operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeProtectConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeProtectConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectConfigurationsResponse describeProtectConfigurations(
            DescribeProtectConfigurationsRequest describeProtectConfigurationsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the protect configurations that match any of filters. If a filter isn’t provided then all protect
     * configurations are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProtectConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeProtectConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeProtectConfigurations operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeProtectConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeProtectConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectConfigurationsResponse describeProtectConfigurations(
            Consumer<DescribeProtectConfigurationsRequest.Builder> describeProtectConfigurationsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeProtectConfigurations(DescribeProtectConfigurationsRequest.builder()
                .applyMutation(describeProtectConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeProtectConfigurations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable responses = client.describeProtectConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable responses = client
     *             .describeProtectConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable responses = client.describeProtectConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProtectConfigurations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeProtectConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeProtectConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeProtectConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectConfigurationsIterable describeProtectConfigurationsPaginator(
            DescribeProtectConfigurationsRequest describeProtectConfigurationsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeProtectConfigurationsIterable(this, describeProtectConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeProtectConfigurations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable responses = client.describeProtectConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable responses = client
     *             .describeProtectConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeProtectConfigurationsIterable responses = client.describeProtectConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProtectConfigurations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProtectConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeProtectConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeProtectConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeProtectConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectConfigurationsIterable describeProtectConfigurationsPaginator(
            Consumer<DescribeProtectConfigurationsRequest.Builder> describeProtectConfigurationsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeProtectConfigurationsPaginator(DescribeProtectConfigurationsRequest.builder()
                .applyMutation(describeProtectConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web
     * Services account.
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     * @return Result of the DescribeRegistrationAttachments operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationAttachmentsResponse describeRegistrationAttachments(
            DescribeRegistrationAttachmentsRequest describeRegistrationAttachmentsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web
     * Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationAttachmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationAttachmentsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRegistrationAttachments operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationAttachmentsResponse describeRegistrationAttachments(
            Consumer<DescribeRegistrationAttachmentsRequest.Builder> describeRegistrationAttachmentsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationAttachments(DescribeRegistrationAttachmentsRequest.builder()
                .applyMutation(describeRegistrationAttachmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable responses = client.describeRegistrationAttachmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable responses = client
     *             .describeRegistrationAttachmentsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable responses = client.describeRegistrationAttachmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationAttachmentsIterable describeRegistrationAttachmentsPaginator(
            DescribeRegistrationAttachmentsRequest describeRegistrationAttachmentsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationAttachmentsIterable(this, describeRegistrationAttachmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable responses = client.describeRegistrationAttachmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable responses = client
     *             .describeRegistrationAttachmentsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationAttachmentsIterable responses = client.describeRegistrationAttachmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationAttachments(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationAttachmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationAttachmentsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationAttachmentsIterable describeRegistrationAttachmentsPaginator(
            Consumer<DescribeRegistrationAttachmentsRequest.Builder> describeRegistrationAttachmentsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationAttachmentsPaginator(DescribeRegistrationAttachmentsRequest.builder()
                .applyMutation(describeRegistrationAttachmentsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     * @return Result of the DescribeRegistrationFieldDefinitions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldDefinitionsResponse describeRegistrationFieldDefinitions(
            DescribeRegistrationFieldDefinitionsRequest describeRegistrationFieldDefinitionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationFieldDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationFieldDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRegistrationFieldDefinitions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldDefinitionsResponse describeRegistrationFieldDefinitions(
            Consumer<DescribeRegistrationFieldDefinitionsRequest.Builder> describeRegistrationFieldDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationFieldDefinitions(DescribeRegistrationFieldDefinitionsRequest.builder()
                .applyMutation(describeRegistrationFieldDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable responses = client.describeRegistrationFieldDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable responses = client
     *             .describeRegistrationFieldDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable responses = client.describeRegistrationFieldDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldDefinitionsIterable describeRegistrationFieldDefinitionsPaginator(
            DescribeRegistrationFieldDefinitionsRequest describeRegistrationFieldDefinitionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationFieldDefinitionsIterable(this, describeRegistrationFieldDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable responses = client.describeRegistrationFieldDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable responses = client
     *             .describeRegistrationFieldDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldDefinitionsIterable responses = client.describeRegistrationFieldDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationFieldDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationFieldDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldDefinitionsIterable describeRegistrationFieldDefinitionsPaginator(
            Consumer<DescribeRegistrationFieldDefinitionsRequest.Builder> describeRegistrationFieldDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationFieldDefinitionsPaginator(DescribeRegistrationFieldDefinitionsRequest.builder()
                .applyMutation(describeRegistrationFieldDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration field values.
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     * @return Result of the DescribeRegistrationFieldValues operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldValuesResponse describeRegistrationFieldValues(
            DescribeRegistrationFieldValuesRequest describeRegistrationFieldValuesRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration field values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationFieldValuesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationFieldValuesRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRegistrationFieldValues operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldValuesResponse describeRegistrationFieldValues(
            Consumer<DescribeRegistrationFieldValuesRequest.Builder> describeRegistrationFieldValuesRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationFieldValues(DescribeRegistrationFieldValuesRequest.builder()
                .applyMutation(describeRegistrationFieldValuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable responses = client.describeRegistrationFieldValuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable responses = client
     *             .describeRegistrationFieldValuesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable responses = client.describeRegistrationFieldValuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldValuesIterable describeRegistrationFieldValuesPaginator(
            DescribeRegistrationFieldValuesRequest describeRegistrationFieldValuesRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationFieldValuesIterable(this, describeRegistrationFieldValuesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable responses = client.describeRegistrationFieldValuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable responses = client
     *             .describeRegistrationFieldValuesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationFieldValuesIterable responses = client.describeRegistrationFieldValuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationFieldValues(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationFieldValuesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationFieldValuesRequest#builder()}
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationFieldValuesIterable describeRegistrationFieldValuesPaginator(
            Consumer<DescribeRegistrationFieldValuesRequest.Builder> describeRegistrationFieldValuesRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationFieldValuesPaginator(DescribeRegistrationFieldValuesRequest.builder()
                .applyMutation(describeRegistrationFieldValuesRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     * @return Result of the DescribeRegistrationSectionDefinitions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationSectionDefinitionsResponse describeRegistrationSectionDefinitions(
            DescribeRegistrationSectionDefinitionsRequest describeRegistrationSectionDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationSectionDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationSectionDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRegistrationSectionDefinitions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationSectionDefinitionsResponse describeRegistrationSectionDefinitions(
            Consumer<DescribeRegistrationSectionDefinitionsRequest.Builder> describeRegistrationSectionDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationSectionDefinitions(DescribeRegistrationSectionDefinitionsRequest.builder()
                .applyMutation(describeRegistrationSectionDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable responses = client.describeRegistrationSectionDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable responses = client
     *             .describeRegistrationSectionDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable responses = client.describeRegistrationSectionDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationSectionDefinitionsIterable describeRegistrationSectionDefinitionsPaginator(
            DescribeRegistrationSectionDefinitionsRequest describeRegistrationSectionDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationSectionDefinitionsIterable(this, describeRegistrationSectionDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable responses = client.describeRegistrationSectionDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable responses = client
     *             .describeRegistrationSectionDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationSectionDefinitionsIterable responses = client.describeRegistrationSectionDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationSectionDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeRegistrationSectionDefinitionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeRegistrationSectionDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationSectionDefinitionsIterable describeRegistrationSectionDefinitionsPaginator(
            Consumer<DescribeRegistrationSectionDefinitionsRequest.Builder> describeRegistrationSectionDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationSectionDefinitionsPaginator(DescribeRegistrationSectionDefinitionsRequest.builder()
                .applyMutation(describeRegistrationSectionDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view
     * the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     * @return Result of the DescribeRegistrationTypeDefinitions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationTypeDefinitionsResponse describeRegistrationTypeDefinitions(
            DescribeRegistrationTypeDefinitionsRequest describeRegistrationTypeDefinitionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view
     * the requirements for creating, filling out, and submitting each registration type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationTypeDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationTypeDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRegistrationTypeDefinitions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationTypeDefinitionsResponse describeRegistrationTypeDefinitions(
            Consumer<DescribeRegistrationTypeDefinitionsRequest.Builder> describeRegistrationTypeDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationTypeDefinitions(DescribeRegistrationTypeDefinitionsRequest.builder()
                .applyMutation(describeRegistrationTypeDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable responses = client.describeRegistrationTypeDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable responses = client
     *             .describeRegistrationTypeDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable responses = client.describeRegistrationTypeDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationTypeDefinitionsIterable describeRegistrationTypeDefinitionsPaginator(
            DescribeRegistrationTypeDefinitionsRequest describeRegistrationTypeDefinitionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationTypeDefinitionsIterable(this, describeRegistrationTypeDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable responses = client.describeRegistrationTypeDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable responses = client
     *             .describeRegistrationTypeDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationTypeDefinitionsIterable responses = client.describeRegistrationTypeDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationTypeDefinitions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationTypeDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationTypeDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationTypeDefinitionsIterable describeRegistrationTypeDefinitionsPaginator(
            Consumer<DescribeRegistrationTypeDefinitionsRequest.Builder> describeRegistrationTypeDefinitionsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationTypeDefinitionsPaginator(DescribeRegistrationTypeDefinitionsRequest.builder()
                .applyMutation(describeRegistrationTypeDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registration version.
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     * @return Result of the DescribeRegistrationVersions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationVersionsResponse describeRegistrationVersions(
            DescribeRegistrationVersionsRequest describeRegistrationVersionsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registration version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationVersionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRegistrationVersions operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationVersionsResponse describeRegistrationVersions(
            Consumer<DescribeRegistrationVersionsRequest.Builder> describeRegistrationVersionsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationVersions(DescribeRegistrationVersionsRequest.builder()
                .applyMutation(describeRegistrationVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable responses = client.describeRegistrationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable responses = client
     *             .describeRegistrationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable responses = client.describeRegistrationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationVersionsIterable describeRegistrationVersionsPaginator(
            DescribeRegistrationVersionsRequest describeRegistrationVersionsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationVersionsIterable(this, describeRegistrationVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable responses = client.describeRegistrationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable responses = client
     *             .describeRegistrationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationVersionsIterable responses = client.describeRegistrationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrationVersions(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRegistrationVersionsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationVersionsIterable describeRegistrationVersionsPaginator(
            Consumer<DescribeRegistrationVersionsRequest.Builder> describeRegistrationVersionsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationVersionsPaginator(DescribeRegistrationVersionsRequest.builder()
                .applyMutation(describeRegistrationVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified registrations.
     * </p>
     *
     * @param describeRegistrationsRequest
     * @return Result of the DescribeRegistrations operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationsResponse describeRegistrations(DescribeRegistrationsRequest describeRegistrationsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified registrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistrationsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRegistrations operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationsResponse describeRegistrations(
            Consumer<DescribeRegistrationsRequest.Builder> describeRegistrationsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrations(DescribeRegistrationsRequest.builder().applyMutation(describeRegistrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable responses = client.describeRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable responses = client
     *             .describeRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable responses = client.describeRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRegistrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationsIterable describeRegistrationsPaginator(DescribeRegistrationsRequest describeRegistrationsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeRegistrationsIterable(this, describeRegistrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable responses = client.describeRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable responses = client
     *             .describeRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeRegistrationsIterable responses = client.describeRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRegistrations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegistrationsRequest#builder()}
     * </p>
     *
     * @param describeRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRegistrationsIterable describeRegistrationsPaginator(
            Consumer<DescribeRegistrationsRequest.Builder> describeRegistrationsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeRegistrationsPaginator(DescribeRegistrationsRequest.builder().applyMutation(describeRegistrationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an error is returned.
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return Result of the DescribeSenderIds operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSenderIdsResponse describeSenderIds(DescribeSenderIdsRequest describeSenderIdsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSenderIdsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSenderIdsRequest#builder()}
     * </p>
     *
     * @param describeSenderIdsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSenderIds operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSenderIdsResponse describeSenderIds(Consumer<DescribeSenderIdsRequest.Builder> describeSenderIdsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeSenderIds(DescribeSenderIdsRequest.builder().applyMutation(describeSenderIdsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client.describeSenderIdsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client
     *             .describeSenderIdsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client.describeSenderIdsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSenderIdsIterable describeSenderIdsPaginator(DescribeSenderIdsRequest describeSenderIdsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeSenderIdsIterable(this, describeSenderIdsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client.describeSenderIdsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client
     *             .describeSenderIdsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client.describeSenderIdsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSenderIdsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSenderIdsRequest#builder()}
     * </p>
     *
     * @param describeSenderIdsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSenderIdsIterable describeSenderIdsPaginator(
            Consumer<DescribeSenderIdsRequest.Builder> describeSenderIdsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return describeSenderIdsPaginator(DescribeSenderIdsRequest.builder().applyMutation(describeSenderIdsRequest).build());
    }

    /**
     * <p>
     * Describes the current monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/awssupport-spend-threshold.html"> Requesting
     * increases to your monthly SMS, MMS, or Voice spending quota </a> in the <i>AWS End User Messaging SMS User
     * Guide</i>.
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return Result of the DescribeSpendLimits operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpendLimitsResponse describeSpendLimits(DescribeSpendLimitsRequest describeSpendLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/awssupport-spend-threshold.html"> Requesting
     * increases to your monthly SMS, MMS, or Voice spending quota </a> in the <i>AWS End User Messaging SMS User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpendLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSpendLimitsRequest#builder()}
     * </p>
     *
     * @param describeSpendLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSpendLimits operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpendLimitsResponse describeSpendLimits(
            Consumer<DescribeSpendLimitsRequest.Builder> describeSpendLimitsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return describeSpendLimits(DescribeSpendLimitsRequest.builder().applyMutation(describeSpendLimitsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client.describeSpendLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client
     *             .describeSpendLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client.describeSpendLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpendLimitsIterable describeSpendLimitsPaginator(DescribeSpendLimitsRequest describeSpendLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeSpendLimitsIterable(this, describeSpendLimitsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client.describeSpendLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client
     *             .describeSpendLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client.describeSpendLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpendLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSpendLimitsRequest#builder()}
     * </p>
     *
     * @param describeSpendLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSpendLimitsIterable describeSpendLimitsPaginator(
            Consumer<DescribeSpendLimitsRequest.Builder> describeSpendLimitsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return describeSpendLimitsPaginator(DescribeSpendLimitsRequest.builder().applyMutation(describeSpendLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified verified destiona numbers.
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     * @return Result of the DescribeVerifiedDestinationNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVerifiedDestinationNumbersResponse describeVerifiedDestinationNumbers(
            DescribeVerifiedDestinationNumbersRequest describeVerifiedDestinationNumbersRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified verified destiona numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVerifiedDestinationNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVerifiedDestinationNumbersRequest#builder()}
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeVerifiedDestinationNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVerifiedDestinationNumbersResponse describeVerifiedDestinationNumbers(
            Consumer<DescribeVerifiedDestinationNumbersRequest.Builder> describeVerifiedDestinationNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeVerifiedDestinationNumbers(DescribeVerifiedDestinationNumbersRequest.builder()
                .applyMutation(describeVerifiedDestinationNumbersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable responses = client.describeVerifiedDestinationNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable responses = client
     *             .describeVerifiedDestinationNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable responses = client.describeVerifiedDestinationNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVerifiedDestinationNumbersIterable describeVerifiedDestinationNumbersPaginator(
            DescribeVerifiedDestinationNumbersRequest describeVerifiedDestinationNumbersRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeVerifiedDestinationNumbersIterable(this, describeVerifiedDestinationNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable responses = client.describeVerifiedDestinationNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable responses = client
     *             .describeVerifiedDestinationNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeVerifiedDestinationNumbersIterable responses = client.describeVerifiedDestinationNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVerifiedDestinationNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVerifiedDestinationNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVerifiedDestinationNumbersRequest#builder()}
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVerifiedDestinationNumbersIterable describeVerifiedDestinationNumbersPaginator(
            Consumer<DescribeVerifiedDestinationNumbersRequest.Builder> describeVerifiedDestinationNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return describeVerifiedDestinationNumbersPaginator(DescribeVerifiedDestinationNumbersRequest.builder()
                .applyMutation(describeVerifiedDestinationNumbersRequest).build());
    }

    /**
     * <p>
     * Removes the specified origination identity from an existing pool.
     * </p>
     * <p>
     * If the origination identity isn't associated with the specified pool, an error is returned.
     * </p>
     *
     * @param disassociateOriginationIdentityRequest
     * @return Result of the DisassociateOriginationIdentity operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DisassociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateOriginationIdentityResponse disassociateOriginationIdentity(
            DisassociateOriginationIdentityRequest disassociateOriginationIdentityRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified origination identity from an existing pool.
     * </p>
     * <p>
     * If the origination identity isn't associated with the specified pool, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateOriginationIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateOriginationIdentityRequest#builder()}
     * </p>
     *
     * @param disassociateOriginationIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateOriginationIdentity operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DisassociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateOriginationIdentityResponse disassociateOriginationIdentity(
            Consumer<DisassociateOriginationIdentityRequest.Builder> disassociateOriginationIdentityRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return disassociateOriginationIdentity(DisassociateOriginationIdentityRequest.builder()
                .applyMutation(disassociateOriginationIdentityRequest).build());
    }

    /**
     * <p>
     * Disassociate a protect configuration from a configuration set.
     * </p>
     *
     * @param disassociateProtectConfigurationRequest
     * @return Result of the DisassociateProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DisassociateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateProtectConfigurationResponse disassociateProtectConfiguration(
            DisassociateProtectConfigurationRequest disassociateProtectConfigurationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate a protect configuration from a configuration set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateProtectConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param disassociateProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DisassociateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateProtectConfigurationResponse disassociateProtectConfiguration(
            Consumer<DisassociateProtectConfigurationRequest.Builder> disassociateProtectConfigurationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return disassociateProtectConfiguration(DisassociateProtectConfigurationRequest.builder()
                .applyMutation(disassociateProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Discard the current version of the registration.
     * </p>
     *
     * @param discardRegistrationVersionRequest
     * @return Result of the DiscardRegistrationVersion operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DiscardRegistrationVersion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DiscardRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DiscardRegistrationVersionResponse discardRegistrationVersion(
            DiscardRegistrationVersionRequest discardRegistrationVersionRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Discard the current version of the registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DiscardRegistrationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DiscardRegistrationVersionRequest#builder()}
     * </p>
     *
     * @param discardRegistrationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionRequest.Builder}
     *        to create a request.
     * @return Result of the DiscardRegistrationVersion operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DiscardRegistrationVersion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DiscardRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DiscardRegistrationVersionResponse discardRegistrationVersion(
            Consumer<DiscardRegistrationVersionRequest.Builder> discardRegistrationVersionRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return discardRegistrationVersion(DiscardRegistrationVersionRequest.builder()
                .applyMutation(discardRegistrationVersionRequest).build());
    }

    /**
     * <p>
     * Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration.
     * </p>
     *
     * @param getProtectConfigurationCountryRuleSetRequest
     * @return Result of the GetProtectConfigurationCountryRuleSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.GetProtectConfigurationCountryRuleSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/GetProtectConfigurationCountryRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProtectConfigurationCountryRuleSetResponse getProtectConfigurationCountryRuleSet(
            GetProtectConfigurationCountryRuleSetRequest getProtectConfigurationCountryRuleSetRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetProtectConfigurationCountryRuleSetRequest.Builder} avoiding the need to create one manually via
     * {@link GetProtectConfigurationCountryRuleSetRequest#builder()}
     * </p>
     *
     * @param getProtectConfigurationCountryRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetProtectConfigurationCountryRuleSetRequest.Builder}
     *        to create a request.
     * @return Result of the GetProtectConfigurationCountryRuleSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.GetProtectConfigurationCountryRuleSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/GetProtectConfigurationCountryRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProtectConfigurationCountryRuleSetResponse getProtectConfigurationCountryRuleSet(
            Consumer<GetProtectConfigurationCountryRuleSetRequest.Builder> getProtectConfigurationCountryRuleSetRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return getProtectConfigurationCountryRuleSet(GetProtectConfigurationCountryRuleSetRequest.builder()
                .applyMutation(getProtectConfigurationCountryRuleSetRequest).build());
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the AWS End User Messaging SMS and
     * Voice resource. A shared resource can be a Pool, Opt-out list, Sender Id, or Phone number.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the AWS End User Messaging SMS and
     * Voice resource. A shared resource can be a Pool, Opt-out list, Sender Id, or Phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return Result of the ListPoolOriginationIdentities operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoolOriginationIdentitiesResponse listPoolOriginationIdentities(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoolOriginationIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPoolOriginationIdentitiesRequest#builder()}
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.Builder}
     *        to create a request.
     * @return Result of the ListPoolOriginationIdentities operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoolOriginationIdentitiesResponse listPoolOriginationIdentities(
            Consumer<ListPoolOriginationIdentitiesRequest.Builder> listPoolOriginationIdentitiesRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return listPoolOriginationIdentities(ListPoolOriginationIdentitiesRequest.builder()
                .applyMutation(listPoolOriginationIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client.listPoolOriginationIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client
     *             .listPoolOriginationIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client.listPoolOriginationIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoolOriginationIdentitiesIterable listPoolOriginationIdentitiesPaginator(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new ListPoolOriginationIdentitiesIterable(this, listPoolOriginationIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client.listPoolOriginationIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client
     *             .listPoolOriginationIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client.listPoolOriginationIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoolOriginationIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPoolOriginationIdentitiesRequest#builder()}
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPoolOriginationIdentitiesIterable listPoolOriginationIdentitiesPaginator(
            Consumer<ListPoolOriginationIdentitiesRequest.Builder> listPoolOriginationIdentitiesRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return listPoolOriginationIdentitiesPaginator(ListPoolOriginationIdentitiesRequest.builder()
                .applyMutation(listPoolOriginationIdentitiesRequest).build());
    }

    /**
     * <p>
     * Retreive all of the origination identies that are associated with a registration.
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     * @return Result of the ListRegistrationAssociations operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegistrationAssociationsResponse listRegistrationAssociations(
            ListRegistrationAssociationsRequest listRegistrationAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retreive all of the origination identies that are associated with a registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRegistrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListRegistrationAssociations operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegistrationAssociationsResponse listRegistrationAssociations(
            Consumer<ListRegistrationAssociationsRequest.Builder> listRegistrationAssociationsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return listRegistrationAssociations(ListRegistrationAssociationsRequest.builder()
                .applyMutation(listRegistrationAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable responses = client.listRegistrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable responses = client
     *             .listRegistrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable responses = client.listRegistrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegistrationAssociationsIterable listRegistrationAssociationsPaginator(
            ListRegistrationAssociationsRequest listRegistrationAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new ListRegistrationAssociationsIterable(this, listRegistrationAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable responses = client.listRegistrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable responses = client
     *             .listRegistrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListRegistrationAssociationsIterable responses = client.listRegistrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistrationAssociations(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRegistrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegistrationAssociationsIterable listRegistrationAssociationsPaginator(
            Consumer<ListRegistrationAssociationsRequest.Builder> listRegistrationAssociationsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return listRegistrationAssociationsPaginator(ListRegistrationAssociationsRequest.builder()
                .applyMutation(listRegistrationAssociationsRequest).build());
    }

    /**
     * <p>
     * List all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a keyword configuration on an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     *
     * @param putKeywordRequest
     * @return Result of the PutKeyword operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default PutKeywordResponse putKeyword(PutKeywordRequest putKeywordRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a keyword configuration on an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutKeywordRequest.Builder} avoiding the need to
     * create one manually via {@link PutKeywordRequest#builder()}
     * </p>
     *
     * @param putKeywordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest.Builder} to create a
     *        request.
     * @return Result of the PutKeyword operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    default PutKeywordResponse putKeyword(Consumer<PutKeywordRequest.Builder> putKeywordRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return putKeyword(PutKeywordRequest.builder().applyMutation(putKeywordRequest).build());
    }

    /**
     * <p>
     * Creates an opted out destination phone number in the opt-out list.
     * </p>
     * <p>
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an error is returned.
     * </p>
     *
     * @param putOptedOutNumberRequest
     * @return Result of the PutOptedOutNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default PutOptedOutNumberResponse putOptedOutNumber(PutOptedOutNumberRequest putOptedOutNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an opted out destination phone number in the opt-out list.
     * </p>
     * <p>
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOptedOutNumberRequest.Builder} avoiding the need
     * to create one manually via {@link PutOptedOutNumberRequest#builder()}
     * </p>
     *
     * @param putOptedOutNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest.Builder} to
     *        create a request.
     * @return Result of the PutOptedOutNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default PutOptedOutNumberResponse putOptedOutNumber(Consumer<PutOptedOutNumberRequest.Builder> putOptedOutNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return putOptedOutNumber(PutOptedOutNumberRequest.builder().applyMutation(putOptedOutNumberRequest).build());
    }

    /**
     * <p>
     * Creates or updates a field value for a registration.
     * </p>
     *
     * @param putRegistrationFieldValueRequest
     * @return Result of the PutRegistrationFieldValue operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutRegistrationFieldValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRegistrationFieldValueResponse putRegistrationFieldValue(
            PutRegistrationFieldValueRequest putRegistrationFieldValueRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a field value for a registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRegistrationFieldValueRequest.Builder} avoiding
     * the need to create one manually via {@link PutRegistrationFieldValueRequest#builder()}
     * </p>
     *
     * @param putRegistrationFieldValueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueRequest.Builder}
     *        to create a request.
     * @return Result of the PutRegistrationFieldValue operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutRegistrationFieldValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRegistrationFieldValueResponse putRegistrationFieldValue(
            Consumer<PutRegistrationFieldValueRequest.Builder> putRegistrationFieldValueRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return putRegistrationFieldValue(PutRegistrationFieldValueRequest.builder()
                .applyMutation(putRegistrationFieldValueRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based policy to a AWS End User Messaging SMS and Voice resource(phone number, sender Id,
     * phone poll, or opt-out list) that is used for sharing the resource. A shared resource can be a Pool, Opt-out
     * list, Sender Id, or Phone number. For more information about resource-based policies, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/shared-resources.html">Working with shared
     * resources</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based policy to a AWS End User Messaging SMS and Voice resource(phone number, sender Id,
     * phone poll, or opt-out list) that is used for sharing the resource. A shared resource can be a Pool, Opt-out
     * list, Sender Id, or Phone number. For more information about resource-based policies, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/shared-resources.html">Working with shared
     * resources</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutResourcePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer
     * available for sending messages.
     * </p>
     * <p>
     * If the origination phone number has deletion protection enabled or is associated with a pool, an error is
     * returned.
     * </p>
     *
     * @param releasePhoneNumberRequest
     * @return Result of the ReleasePhoneNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default ReleasePhoneNumberResponse releasePhoneNumber(ReleasePhoneNumberRequest releasePhoneNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer
     * available for sending messages.
     * </p>
     * <p>
     * If the origination phone number has deletion protection enabled or is associated with a pool, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleasePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link ReleasePhoneNumberRequest#builder()}
     * </p>
     *
     * @param releasePhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest.Builder} to
     *        create a request.
     * @return Result of the ReleasePhoneNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default ReleasePhoneNumberResponse releasePhoneNumber(Consumer<ReleasePhoneNumberRequest.Builder> releasePhoneNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return releasePhoneNumber(ReleasePhoneNumberRequest.builder().applyMutation(releasePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Releases an existing sender ID in your account.
     * </p>
     *
     * @param releaseSenderIdRequest
     * @return Result of the ReleaseSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ReleaseSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleaseSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default ReleaseSenderIdResponse releaseSenderId(ReleaseSenderIdRequest releaseSenderIdRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases an existing sender ID in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReleaseSenderIdRequest.Builder} avoiding the need
     * to create one manually via {@link ReleaseSenderIdRequest#builder()}
     * </p>
     *
     * @param releaseSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdRequest.Builder} to create
     *        a request.
     * @return Result of the ReleaseSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ReleaseSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleaseSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default ReleaseSenderIdResponse releaseSenderId(Consumer<ReleaseSenderIdRequest.Builder> releaseSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return releaseSenderId(ReleaseSenderIdRequest.builder().applyMutation(releaseSenderIdRequest).build());
    }

    /**
     * <p>
     * Request an origination phone number for use in your account. For more information on phone number request see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-request.html">Request a phone
     * number</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param requestPhoneNumberRequest
     * @return Result of the RequestPhoneNumber operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.RequestPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestPhoneNumberResponse requestPhoneNumber(RequestPhoneNumberRequest requestPhoneNumberRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request an origination phone number for use in your account. For more information on phone number request see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-request.html">Request a phone
     * number</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestPhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link RequestPhoneNumberRequest#builder()}
     * </p>
     *
     * @param requestPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest.Builder} to
     *        create a request.
     * @return Result of the RequestPhoneNumber operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.RequestPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestPhoneNumberResponse requestPhoneNumber(Consumer<RequestPhoneNumberRequest.Builder> requestPhoneNumberRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return requestPhoneNumber(RequestPhoneNumberRequest.builder().applyMutation(requestPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Request a new sender ID that doesn't require registration.
     * </p>
     *
     * @param requestSenderIdRequest
     * @return Result of the RequestSenderId operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.RequestSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestSenderIdResponse requestSenderId(RequestSenderIdRequest requestSenderIdRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a new sender ID that doesn't require registration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestSenderIdRequest.Builder} avoiding the need
     * to create one manually via {@link RequestSenderIdRequest#builder()}
     * </p>
     *
     * @param requestSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdRequest.Builder} to create
     *        a request.
     * @return Result of the RequestSenderId operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.RequestSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestSenderIdResponse requestSenderId(Consumer<RequestSenderIdRequest.Builder> requestSenderIdRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return requestSenderId(RequestSenderIdRequest.builder().applyMutation(requestSenderIdRequest).build());
    }

    /**
     * <p>
     * Before you can send test messages to a verified destination phone number you need to opt-in the verified
     * destination phone number. Creates a new text message with a verification code and send it to a verified
     * destination phone number. Once you have the verification code use <a>VerifyDestinationNumber</a> to opt-in the
     * verified destination phone number to receive messages.
     * </p>
     *
     * @param sendDestinationNumberVerificationCodeRequest
     * @return Result of the SendDestinationNumberVerificationCode operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendDestinationNumberVerificationCode
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendDestinationNumberVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDestinationNumberVerificationCodeResponse sendDestinationNumberVerificationCode(
            SendDestinationNumberVerificationCodeRequest sendDestinationNumberVerificationCodeRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Before you can send test messages to a verified destination phone number you need to opt-in the verified
     * destination phone number. Creates a new text message with a verification code and send it to a verified
     * destination phone number. Once you have the verification code use <a>VerifyDestinationNumber</a> to opt-in the
     * verified destination phone number to receive messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SendDestinationNumberVerificationCodeRequest.Builder} avoiding the need to create one manually via
     * {@link SendDestinationNumberVerificationCodeRequest#builder()}
     * </p>
     *
     * @param sendDestinationNumberVerificationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeRequest.Builder}
     *        to create a request.
     * @return Result of the SendDestinationNumberVerificationCode operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendDestinationNumberVerificationCode
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendDestinationNumberVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default SendDestinationNumberVerificationCodeResponse sendDestinationNumberVerificationCode(
            Consumer<SendDestinationNumberVerificationCodeRequest.Builder> sendDestinationNumberVerificationCodeRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return sendDestinationNumberVerificationCode(SendDestinationNumberVerificationCodeRequest.builder()
                .applyMutation(sendDestinationNumberVerificationCodeRequest).build());
    }

    /**
     * <p>
     * Creates a new multimedia message (MMS) and sends it to a recipient's phone number.
     * </p>
     *
     * @param sendMediaMessageRequest
     * @return Result of the SendMediaMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendMediaMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendMediaMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendMediaMessageResponse sendMediaMessage(SendMediaMessageRequest sendMediaMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new multimedia message (MMS) and sends it to a recipient's phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendMediaMessageRequest.Builder} avoiding the need
     * to create one manually via {@link SendMediaMessageRequest#builder()}
     * </p>
     *
     * @param sendMediaMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendMediaMessageRequest.Builder} to create
     *        a request.
     * @return Result of the SendMediaMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendMediaMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendMediaMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendMediaMessageResponse sendMediaMessage(Consumer<SendMediaMessageRequest.Builder> sendMediaMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return sendMediaMessage(SendMediaMessageRequest.builder().applyMutation(sendMediaMessageRequest).build());
    }

    /**
     * <p>
     * Creates a new text message and sends it to a recipient's phone number. SendTextMessage only sends an SMS message
     * to one recipient each time it is invoked.
     * </p>
     * <p>
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination
     * country of your messages, as well as the type of phone number (origination number) that you use to send the
     * message. For more information about MPS, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message Parts per Second
     * (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param sendTextMessageRequest
     * @return Result of the SendTextMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendTextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendTextMessageResponse sendTextMessage(SendTextMessageRequest sendTextMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new text message and sends it to a recipient's phone number. SendTextMessage only sends an SMS message
     * to one recipient each time it is invoked.
     * </p>
     * <p>
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination
     * country of your messages, as well as the type of phone number (origination number) that you use to send the
     * message. For more information about MPS, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message Parts per Second
     * (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendTextMessageRequest.Builder} avoiding the need
     * to create one manually via {@link SendTextMessageRequest#builder()}
     * </p>
     *
     * @param sendTextMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest.Builder} to create
     *        a request.
     * @return Result of the SendTextMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendTextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendTextMessageResponse sendTextMessage(Consumer<SendTextMessageRequest.Builder> sendTextMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return sendTextMessage(SendTextMessageRequest.builder().applyMutation(sendTextMessageRequest).build());
    }

    /**
     * <p>
     * Allows you to send a request that sends a voice message. This operation uses <a
     * href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.
     * </p>
     *
     * @param sendVoiceMessageRequest
     * @return Result of the SendVoiceMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendVoiceMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendVoiceMessageResponse sendVoiceMessage(SendVoiceMessageRequest sendVoiceMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to send a request that sends a voice message. This operation uses <a
     * href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendVoiceMessageRequest.Builder} avoiding the need
     * to create one manually via {@link SendVoiceMessageRequest#builder()}
     * </p>
     *
     * @param sendVoiceMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest.Builder} to create
     *        a request.
     * @return Result of the SendVoiceMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendVoiceMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendVoiceMessageResponse sendVoiceMessage(Consumer<SendVoiceMessageRequest.Builder> sendVoiceMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return sendVoiceMessage(SendVoiceMessageRequest.builder().applyMutation(sendVoiceMessageRequest).build());
    }

    /**
     * <p>
     * Set a protect configuration as your account default. You can only have one account default protect configuration
     * at a time. The current account default protect configuration is replaced with the provided protect configuration.
     * </p>
     *
     * @param setAccountDefaultProtectConfigurationRequest
     * @return Result of the SetAccountDefaultProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetAccountDefaultProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetAccountDefaultProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default SetAccountDefaultProtectConfigurationResponse setAccountDefaultProtectConfiguration(
            SetAccountDefaultProtectConfigurationRequest setAccountDefaultProtectConfigurationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set a protect configuration as your account default. You can only have one account default protect configuration
     * at a time. The current account default protect configuration is replaced with the provided protect configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link SetAccountDefaultProtectConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link SetAccountDefaultProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param setAccountDefaultProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetAccountDefaultProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the SetAccountDefaultProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetAccountDefaultProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetAccountDefaultProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default SetAccountDefaultProtectConfigurationResponse setAccountDefaultProtectConfiguration(
            Consumer<SetAccountDefaultProtectConfigurationRequest.Builder> setAccountDefaultProtectConfigurationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return setAccountDefaultProtectConfiguration(SetAccountDefaultProtectConfigurationRequest.builder()
                .applyMutation(setAccountDefaultProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets the default message type on a configuration set.
     * </p>
     * <p>
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages
     * or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param setDefaultMessageTypeRequest
     * @return Result of the SetDefaultMessageType operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDefaultMessageTypeResponse setDefaultMessageType(SetDefaultMessageTypeRequest setDefaultMessageTypeRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default message type on a configuration set.
     * </p>
     * <p>
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages
     * or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultMessageTypeRequest.Builder} avoiding the
     * need to create one manually via {@link SetDefaultMessageTypeRequest#builder()}
     * </p>
     *
     * @param setDefaultMessageTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest.Builder} to
     *        create a request.
     * @return Result of the SetDefaultMessageType operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDefaultMessageTypeResponse setDefaultMessageType(
            Consumer<SetDefaultMessageTypeRequest.Builder> setDefaultMessageTypeRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return setDefaultMessageType(SetDefaultMessageTypeRequest.builder().applyMutation(setDefaultMessageTypeRequest).build());
    }

    /**
     * <p>
     * Sets default sender ID on a configuration set.
     * </p>
     * <p>
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the
     * configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are
     * available in your account.
     * </p>
     *
     * @param setDefaultSenderIdRequest
     * @return Result of the SetDefaultSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDefaultSenderIdResponse setDefaultSenderId(SetDefaultSenderIdRequest setDefaultSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets default sender ID on a configuration set.
     * </p>
     * <p>
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the
     * configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are
     * available in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultSenderIdRequest.Builder} avoiding the
     * need to create one manually via {@link SetDefaultSenderIdRequest#builder()}
     * </p>
     *
     * @param setDefaultSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest.Builder} to
     *        create a request.
     * @return Result of the SetDefaultSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default SetDefaultSenderIdResponse setDefaultSenderId(Consumer<SetDefaultSenderIdRequest.Builder> setDefaultSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return setDefaultSenderId(SetDefaultSenderIdRequest.builder().applyMutation(setDefaultSenderIdRequest).build());
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending MMS messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setMediaMessageSpendLimitOverrideRequest
     * @return Result of the SetMediaMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetMediaMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetMediaMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default SetMediaMessageSpendLimitOverrideResponse setMediaMessageSpendLimitOverride(
            SetMediaMessageSpendLimitOverrideRequest setMediaMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending MMS messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetMediaMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link SetMediaMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param setMediaMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetMediaMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return Result of the SetMediaMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetMediaMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetMediaMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default SetMediaMessageSpendLimitOverrideResponse setMediaMessageSpendLimitOverride(
            Consumer<SetMediaMessageSpendLimitOverrideRequest.Builder> setMediaMessageSpendLimitOverrideRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return setMediaMessageSpendLimitOverride(SetMediaMessageSpendLimitOverrideRequest.builder()
                .applyMutation(setMediaMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setTextMessageSpendLimitOverrideRequest
     * @return Result of the SetTextMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTextMessageSpendLimitOverrideResponse setTextMessageSpendLimitOverride(
            SetTextMessageSpendLimitOverrideRequest setTextMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTextMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link SetTextMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param setTextMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return Result of the SetTextMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTextMessageSpendLimitOverrideResponse setTextMessageSpendLimitOverride(
            Consumer<SetTextMessageSpendLimitOverrideRequest.Builder> setTextMessageSpendLimitOverrideRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return setTextMessageSpendLimitOverride(SetTextMessageSpendLimitOverrideRequest.builder()
                .applyMutation(setTextMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setVoiceMessageSpendLimitOverrideRequest
     * @return Result of the SetVoiceMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default SetVoiceMessageSpendLimitOverrideResponse setVoiceMessageSpendLimitOverride(
            SetVoiceMessageSpendLimitOverrideRequest setVoiceMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetVoiceMessageSpendLimitOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link SetVoiceMessageSpendLimitOverrideRequest#builder()}
     * </p>
     *
     * @param setVoiceMessageSpendLimitOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest.Builder}
     *        to create a request.
     * @return Result of the SetVoiceMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default SetVoiceMessageSpendLimitOverrideResponse setVoiceMessageSpendLimitOverride(
            Consumer<SetVoiceMessageSpendLimitOverrideRequest.Builder> setVoiceMessageSpendLimitOverrideRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return setVoiceMessageSpendLimitOverride(SetVoiceMessageSpendLimitOverrideRequest.builder()
                .applyMutation(setVoiceMessageSpendLimitOverrideRequest).build());
    }

    /**
     * <p>
     * Submit the specified registration for review and approval.
     * </p>
     *
     * @param submitRegistrationVersionRequest
     * @return Result of the SubmitRegistrationVersion operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SubmitRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SubmitRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitRegistrationVersionResponse submitRegistrationVersion(
            SubmitRegistrationVersionRequest submitRegistrationVersionRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submit the specified registration for review and approval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitRegistrationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link SubmitRegistrationVersionRequest#builder()}
     * </p>
     *
     * @param submitRegistrationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionRequest.Builder}
     *        to create a request.
     * @return Result of the SubmitRegistrationVersion operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SubmitRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SubmitRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitRegistrationVersionResponse submitRegistrationVersion(
            Consumer<SubmitRegistrationVersionRequest.Builder> submitRegistrationVersionRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return submitRegistrationVersion(SubmitRegistrationVersionRequest.builder()
                .applyMutation(submitRegistrationVersionRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key
     * and an optional value. Tag keys must be unique per resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html">Tags </a> in the <i>AWS End
     * User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key
     * and an optional value. Tag keys must be unique per resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html">Tags </a> in the <i>AWS End
     * User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the association of the specified tags from a resource. For more information on tags see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html">Tags </a> in the <i>AWS End
     * User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association of the specified tags from a resource. For more information on tags see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html">Tags </a> in the <i>AWS End
     * User Messaging SMS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs
     * and Firehose. You can also enable or disable the event destination.
     * </p>
     * <p>
     * You may want to update an event destination to change its matching event types or updating the destination
     * resource ARN. You can't change an event destination's type between CloudWatch Logs, Firehose, and Amazon SNS.
     * </p>
     *
     * @param updateEventDestinationRequest
     * @return Result of the UpdateEventDestination operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventDestinationResponse updateEventDestination(UpdateEventDestinationRequest updateEventDestinationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs
     * and Firehose. You can also enable or disable the event destination.
     * </p>
     * <p>
     * You may want to update an event destination to change its matching event types or updating the destination
     * resource ARN. You can't change an event destination's type between CloudWatch Logs, Firehose, and Amazon SNS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventDestinationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateEventDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateEventDestination operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventDestinationResponse updateEventDestination(
            Consumer<UpdateEventDestinationRequest.Builder> updateEventDestinationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return updateEventDestination(UpdateEventDestinationRequest.builder().applyMutation(updateEventDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or
     * disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
     * disable deletion protection.
     * </p>
     * <p>
     * If the origination phone number is associated with a pool, an error is returned.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return Result of the UpdatePhoneNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePhoneNumberResponse updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or
     * disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
     * disable deletion protection.
     * </p>
     * <p>
     * If the origination phone number is associated with a pool, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest.Builder} to
     *        create a request.
     * @return Result of the UpdatePhoneNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePhoneNumberResponse updatePhoneNumber(Consumer<UpdatePhoneNumberRequest.Builder> updatePhoneNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return updatePhoneNumber(UpdatePhoneNumberRequest.builder().applyMutation(updatePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way
     * messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable
     * deletion protection, and enable or disable shared routes.
     * </p>
     *
     * @param updatePoolRequest
     * @return Result of the UpdatePool operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePoolResponse updatePool(UpdatePoolRequest updatePoolRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way
     * messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable
     * deletion protection, and enable or disable shared routes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePoolRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePoolRequest#builder()}
     * </p>
     *
     * @param updatePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest.Builder} to create a
     *        request.
     * @return Result of the UpdatePool operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePoolResponse updatePool(Consumer<UpdatePoolRequest.Builder> updatePoolRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return updatePool(UpdatePoolRequest.builder().applyMutation(updatePoolRequest).build());
    }

    /**
     * <p>
     * Update the setting for an existing protect configuration.
     * </p>
     *
     * @param updateProtectConfigurationRequest
     * @return Result of the UpdateProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProtectConfigurationResponse updateProtectConfiguration(
            UpdateProtectConfigurationRequest updateProtectConfigurationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the setting for an existing protect configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProtectConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProtectConfigurationRequest#builder()}
     * </p>
     *
     * @param updateProtectConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateProtectConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProtectConfigurationResponse updateProtectConfiguration(
            Consumer<UpdateProtectConfigurationRequest.Builder> updateProtectConfigurationRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return updateProtectConfiguration(UpdateProtectConfigurationRequest.builder()
                .applyMutation(updateProtectConfigurationRequest).build());
    }

    /**
     * <p>
     * Update a country rule set to <code>ALLOW</code> or <code>BLOCK</code> messages to be sent to the specified
     * destination counties. You can update one or multiple countries at a time. The updates are only applied to the
     * specified NumberCapability type.
     * </p>
     *
     * @param updateProtectConfigurationCountryRuleSetRequest
     * @return Result of the UpdateProtectConfigurationCountryRuleSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateProtectConfigurationCountryRuleSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateProtectConfigurationCountryRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProtectConfigurationCountryRuleSetResponse updateProtectConfigurationCountryRuleSet(
            UpdateProtectConfigurationCountryRuleSetRequest updateProtectConfigurationCountryRuleSetRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a country rule set to <code>ALLOW</code> or <code>BLOCK</code> messages to be sent to the specified
     * destination counties. You can update one or multiple countries at a time. The updates are only applied to the
     * specified NumberCapability type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateProtectConfigurationCountryRuleSetRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateProtectConfigurationCountryRuleSetRequest#builder()}
     * </p>
     *
     * @param updateProtectConfigurationCountryRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationCountryRuleSetRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateProtectConfigurationCountryRuleSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateProtectConfigurationCountryRuleSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateProtectConfigurationCountryRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProtectConfigurationCountryRuleSetResponse updateProtectConfigurationCountryRuleSet(
            Consumer<UpdateProtectConfigurationCountryRuleSetRequest.Builder> updateProtectConfigurationCountryRuleSetRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return updateProtectConfigurationCountryRuleSet(UpdateProtectConfigurationCountryRuleSetRequest.builder()
                .applyMutation(updateProtectConfigurationCountryRuleSetRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing sender ID.
     * </p>
     *
     * @param updateSenderIdRequest
     * @return Result of the UpdateSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSenderIdResponse updateSenderId(UpdateSenderIdRequest updateSenderIdRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing sender ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSenderIdRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSenderIdRequest#builder()}
     * </p>
     *
     * @param updateSenderIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSenderIdResponse updateSenderId(Consumer<UpdateSenderIdRequest.Builder> updateSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return updateSenderId(UpdateSenderIdRequest.builder().applyMutation(updateSenderIdRequest).build());
    }

    /**
     * <p>
     * Use the verification code that was received by the verified destination phone number to opt-in the verified
     * destination phone number to receive more messages.
     * </p>
     *
     * @param verifyDestinationNumberRequest
     * @return Result of the VerifyDestinationNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.VerifyDestinationNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/VerifyDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default VerifyDestinationNumberResponse verifyDestinationNumber(VerifyDestinationNumberRequest verifyDestinationNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the verification code that was received by the verified destination phone number to opt-in the verified
     * destination phone number to receive more messages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyDestinationNumberRequest.Builder} avoiding
     * the need to create one manually via {@link VerifyDestinationNumberRequest#builder()}
     * </p>
     *
     * @param verifyDestinationNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberRequest.Builder} to
     *        create a request.
     * @return Result of the VerifyDestinationNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.VerifyDestinationNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/VerifyDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default VerifyDestinationNumberResponse verifyDestinationNumber(
            Consumer<VerifyDestinationNumberRequest.Builder> verifyDestinationNumberRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return verifyDestinationNumber(VerifyDestinationNumberRequest.builder().applyMutation(verifyDestinationNumberRequest)
                .build());
    }

    /**
     * Create a {@link PinpointSmsVoiceV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PinpointSmsVoiceV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PinpointSmsVoiceV2Client}.
     */
    static PinpointSmsVoiceV2ClientBuilder builder() {
        return new DefaultPinpointSmsVoiceV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PinpointSmsVoiceV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
