/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOptOutListsRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<DescribeOptOutListsRequest.Builder, DescribeOptOutListsRequest> {
    private static final SdkField<List<String>> OPT_OUT_LIST_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptOutListNames")
            .getter(getter(DescribeOptOutListsRequest::optOutListNames))
            .setter(setter(Builder::optOutListNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOptOutListsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeOptOutListsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(DescribeOptOutListsRequest::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_NAMES_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, OWNER_FIELD));

    private final List<String> optOutListNames;

    private final String nextToken;

    private final Integer maxResults;

    private final String owner;

    private DescribeOptOutListsRequest(BuilderImpl builder) {
        super(builder);
        this.optOutListNames = builder.optOutListNames;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.owner = builder.owner;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptOutListNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptOutListNames() {
        return optOutListNames != null && !(optOutListNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or
     * OptOutListArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptOutListNames} method.
     * </p>
     * 
     * @return The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName
     *         or OptOutListArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final List<String> optOutListNames() {
        return optOutListNames;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per each request.
     * </p>
     * 
     * @return The maximum number of results to return per each request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use <code>SHARED</code> to
     * filter on Opt-Out List shared with your account. The <code>Owner</code> and <code>OptOutListNames</code>
     * parameters can't be used at the same time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use
     *         <code>SHARED</code> to filter on Opt-Out List shared with your account. The <code>Owner</code> and
     *         <code>OptOutListNames</code> parameters can't be used at the same time.
     * @see Owner
     */
    public final Owner owner() {
        return Owner.fromValue(owner);
    }

    /**
     * <p>
     * Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use <code>SHARED</code> to
     * filter on Opt-Out List shared with your account. The <code>Owner</code> and <code>OptOutListNames</code>
     * parameters can't be used at the same time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use
     *         <code>SHARED</code> to filter on Opt-Out List shared with your account. The <code>Owner</code> and
     *         <code>OptOutListNames</code> parameters can't be used at the same time.
     * @see Owner
     */
    public final String ownerAsString() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOptOutListNames() ? optOutListNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptOutListsRequest)) {
            return false;
        }
        DescribeOptOutListsRequest other = (DescribeOptOutListsRequest) obj;
        return hasOptOutListNames() == other.hasOptOutListNames() && Objects.equals(optOutListNames(), other.optOutListNames())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(ownerAsString(), other.ownerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOptOutListsRequest")
                .add("OptOutListNames", hasOptOutListNames() ? optOutListNames() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Owner", ownerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptOutListNames":
            return Optional.ofNullable(clazz.cast(optOutListNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptOutListsRequest, T> g) {
        return obj -> g.apply((DescribeOptOutListsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOptOutListsRequest> {
        /**
         * <p>
         * The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or
         * OptOutListArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param optOutListNames
         *        The OptOutLists to show the details of. This is an array of strings that can be either the
         *        OptOutListName or OptOutListArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListNames(Collection<String> optOutListNames);

        /**
         * <p>
         * The OptOutLists to show the details of. This is an array of strings that can be either the OptOutListName or
         * OptOutListArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param optOutListNames
         *        The OptOutLists to show the details of. This is an array of strings that can be either the
         *        OptOutListName or OptOutListArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListNames(String... optOutListNames);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per each request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use <code>SHARED</code>
         * to filter on Opt-Out List shared with your account. The <code>Owner</code> and <code>OptOutListNames</code>
         * parameters can't be used at the same time.
         * </p>
         * 
         * @param owner
         *        Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use
         *        <code>SHARED</code> to filter on Opt-Out List shared with your account. The <code>Owner</code> and
         *        <code>OptOutListNames</code> parameters can't be used at the same time.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(String owner);

        /**
         * <p>
         * Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use <code>SHARED</code>
         * to filter on Opt-Out List shared with your account. The <code>Owner</code> and <code>OptOutListNames</code>
         * parameters can't be used at the same time.
         * </p>
         * 
         * @param owner
         *        Use <code>SELF</code> to filter the list of Opt-Out List to ones your account owns or use
         *        <code>SHARED</code> to filter on Opt-Out List shared with your account. The <code>Owner</code> and
         *        <code>OptOutListNames</code> parameters can't be used at the same time.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(Owner owner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private List<String> optOutListNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptOutListsRequest model) {
            super(model);
            optOutListNames(model.optOutListNames);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            owner(model.owner);
        }

        public final Collection<String> getOptOutListNames() {
            if (optOutListNames instanceof SdkAutoConstructList) {
                return null;
            }
            return optOutListNames;
        }

        public final void setOptOutListNames(Collection<String> optOutListNames) {
            this.optOutListNames = OptOutListNameListCopier.copy(optOutListNames);
        }

        @Override
        public final Builder optOutListNames(Collection<String> optOutListNames) {
            this.optOutListNames = OptOutListNameListCopier.copy(optOutListNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optOutListNames(String... optOutListNames) {
            optOutListNames(Arrays.asList(optOutListNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOptOutListsRequest build() {
            return new DescribeOptOutListsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
