/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOptedOutNumbersRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<DescribeOptedOutNumbersRequest.Builder, DescribeOptedOutNumbersRequest> {
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(DescribeOptedOutNumbersRequest::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<List<String>> OPTED_OUT_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptedOutNumbers")
            .getter(getter(DescribeOptedOutNumbersRequest::optedOutNumbers))
            .setter(setter(Builder::optedOutNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptedOutNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OptedOutFilter>> FILTERS_FIELD = SdkField
            .<List<OptedOutFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeOptedOutNumbersRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptedOutFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptedOutFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOptedOutNumbersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeOptedOutNumbersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_NAME_FIELD,
            OPTED_OUT_NUMBERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String optOutListName;

    private final List<String> optedOutNumbers;

    private final List<OptedOutFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeOptedOutNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.optOutListName = builder.optOutListName;
        this.optedOutNumbers = builder.optedOutNumbers;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The OptOutListName or OptOutListArn of the OptOutList. You can use <a>DescribeOptOutLists</a> to find the values
     * for OptOutListName and OptOutListArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The OptOutListName or OptOutListArn of the OptOutList. You can use <a>DescribeOptOutLists</a> to find the
     *         values for OptOutListName and OptOutListArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptedOutNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptedOutNumbers() {
        return optedOutNumbers != null && !(optedOutNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of phone numbers to search for in the OptOutList.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptedOutNumbers} method.
     * </p>
     * 
     * @return An array of phone numbers to search for in the OptOutList.
     */
    public final List<String> optedOutNumbers() {
        return optedOutNumbers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of OptedOutFilter objects to filter the results on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of OptedOutFilter objects to filter the results on.
     */
    public final List<OptedOutFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per each request.
     * </p>
     * 
     * @return The maximum number of results to return per each request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptedOutNumbers() ? optedOutNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptedOutNumbersRequest)) {
            return false;
        }
        DescribeOptedOutNumbersRequest other = (DescribeOptedOutNumbersRequest) obj;
        return Objects.equals(optOutListName(), other.optOutListName()) && hasOptedOutNumbers() == other.hasOptedOutNumbers()
                && Objects.equals(optedOutNumbers(), other.optedOutNumbers()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOptedOutNumbersRequest").add("OptOutListName", optOutListName())
                .add("OptedOutNumbers", hasOptedOutNumbers() ? optedOutNumbers() : null)
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "OptedOutNumbers":
            return Optional.ofNullable(clazz.cast(optedOutNumbers()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptedOutNumbersRequest, T> g) {
        return obj -> g.apply((DescribeOptedOutNumbersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOptedOutNumbersRequest> {
        /**
         * <p>
         * The OptOutListName or OptOutListArn of the OptOutList. You can use <a>DescribeOptOutLists</a> to find the
         * values for OptOutListName and OptOutListArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param optOutListName
         *        The OptOutListName or OptOutListArn of the OptOutList. You can use <a>DescribeOptOutLists</a> to find
         *        the values for OptOutListName and OptOutListArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * An array of phone numbers to search for in the OptOutList.
         * </p>
         * 
         * @param optedOutNumbers
         *        An array of phone numbers to search for in the OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optedOutNumbers(Collection<String> optedOutNumbers);

        /**
         * <p>
         * An array of phone numbers to search for in the OptOutList.
         * </p>
         * 
         * @param optedOutNumbers
         *        An array of phone numbers to search for in the OptOutList.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optedOutNumbers(String... optedOutNumbers);

        /**
         * <p>
         * An array of OptedOutFilter objects to filter the results on.
         * </p>
         * 
         * @param filters
         *        An array of OptedOutFilter objects to filter the results on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OptedOutFilter> filters);

        /**
         * <p>
         * An array of OptedOutFilter objects to filter the results on.
         * </p>
         * 
         * @param filters
         *        An array of OptedOutFilter objects to filter the results on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OptedOutFilter... filters);

        /**
         * <p>
         * An array of OptedOutFilter objects to filter the results on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<OptedOutFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<OptedOutFilter>)
         */
        Builder filters(Consumer<OptedOutFilter.Builder>... filters);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per each request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String optOutListName;

        private List<String> optedOutNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<OptedOutFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptedOutNumbersRequest model) {
            super(model);
            optOutListName(model.optOutListName);
            optedOutNumbers(model.optedOutNumbers);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Collection<String> getOptedOutNumbers() {
            if (optedOutNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return optedOutNumbers;
        }

        public final void setOptedOutNumbers(Collection<String> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberListCopier.copy(optedOutNumbers);
        }

        @Override
        public final Builder optedOutNumbers(Collection<String> optedOutNumbers) {
            this.optedOutNumbers = OptedOutNumberListCopier.copy(optedOutNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optedOutNumbers(String... optedOutNumbers) {
            optedOutNumbers(Arrays.asList(optedOutNumbers));
            return this;
        }

        public final List<OptedOutFilter.Builder> getFilters() {
            List<OptedOutFilter.Builder> result = OptedOutFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OptedOutFilter.BuilderImpl> filters) {
            this.filters = OptedOutFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<OptedOutFilter> filters) {
            this.filters = OptedOutFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OptedOutFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OptedOutFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OptedOutFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOptedOutNumbersRequest build() {
            return new DescribeOptedOutNumbersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
