/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the reason a registration was rejected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationDeniedReasonInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationDeniedReasonInformation.Builder, RegistrationDeniedReasonInformation> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(RegistrationDeniedReasonInformation::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortDescription").getter(getter(RegistrationDeniedReasonInformation::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()).build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LongDescription").getter(getter(RegistrationDeniedReasonInformation::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongDescription").build()).build();

    private static final SdkField<String> DOCUMENTATION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationTitle").getter(getter(RegistrationDeniedReasonInformation::documentationTitle))
            .setter(setter(Builder::documentationTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationTitle").build())
            .build();

    private static final SdkField<String> DOCUMENTATION_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationLink").getter(getter(RegistrationDeniedReasonInformation::documentationLink))
            .setter(setter(Builder::documentationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationLink").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            SHORT_DESCRIPTION_FIELD, LONG_DESCRIPTION_FIELD, DOCUMENTATION_TITLE_FIELD, DOCUMENTATION_LINK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final String shortDescription;

    private final String longDescription;

    private final String documentationTitle;

    private final String documentationLink;

    private RegistrationDeniedReasonInformation(BuilderImpl builder) {
        this.reason = builder.reason;
        this.shortDescription = builder.shortDescription;
        this.longDescription = builder.longDescription;
        this.documentationTitle = builder.documentationTitle;
        this.documentationLink = builder.documentationLink;
    }

    /**
     * <p>
     * The reason a registration was rejected.
     * </p>
     * 
     * @return The reason a registration was rejected.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * A short description of the rejection reason.
     * </p>
     * 
     * @return A short description of the rejection reason.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * A long description of the rejection reason.
     * </p>
     * 
     * @return A long description of the rejection reason.
     */
    public final String longDescription() {
        return longDescription;
    }

    /**
     * <p>
     * The title of the document.
     * </p>
     * 
     * @return The title of the document.
     */
    public final String documentationTitle() {
        return documentationTitle;
    }

    /**
     * <p>
     * The link to the document.
     * </p>
     * 
     * @return The link to the document.
     */
    public final String documentationLink() {
        return documentationLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(documentationTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentationLink());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationDeniedReasonInformation)) {
            return false;
        }
        RegistrationDeniedReasonInformation other = (RegistrationDeniedReasonInformation) obj;
        return Objects.equals(reason(), other.reason()) && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(longDescription(), other.longDescription())
                && Objects.equals(documentationTitle(), other.documentationTitle())
                && Objects.equals(documentationLink(), other.documentationLink());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationDeniedReasonInformation").add("Reason", reason())
                .add("ShortDescription", shortDescription()).add("LongDescription", longDescription())
                .add("DocumentationTitle", documentationTitle()).add("DocumentationLink", documentationLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "ShortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "LongDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        case "DocumentationTitle":
            return Optional.ofNullable(clazz.cast(documentationTitle()));
        case "DocumentationLink":
            return Optional.ofNullable(clazz.cast(documentationLink()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrationDeniedReasonInformation, T> g) {
        return obj -> g.apply((RegistrationDeniedReasonInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationDeniedReasonInformation> {
        /**
         * <p>
         * The reason a registration was rejected.
         * </p>
         * 
         * @param reason
         *        The reason a registration was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * A short description of the rejection reason.
         * </p>
         * 
         * @param shortDescription
         *        A short description of the rejection reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * A long description of the rejection reason.
         * </p>
         * 
         * @param longDescription
         *        A long description of the rejection reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);

        /**
         * <p>
         * The title of the document.
         * </p>
         * 
         * @param documentationTitle
         *        The title of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationTitle(String documentationTitle);

        /**
         * <p>
         * The link to the document.
         * </p>
         * 
         * @param documentationLink
         *        The link to the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationLink(String documentationLink);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private String shortDescription;

        private String longDescription;

        private String documentationTitle;

        private String documentationLink;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationDeniedReasonInformation model) {
            reason(model.reason);
            shortDescription(model.shortDescription);
            longDescription(model.longDescription);
            documentationTitle(model.documentationTitle);
            documentationLink(model.documentationLink);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getDocumentationTitle() {
            return documentationTitle;
        }

        public final void setDocumentationTitle(String documentationTitle) {
            this.documentationTitle = documentationTitle;
        }

        @Override
        public final Builder documentationTitle(String documentationTitle) {
            this.documentationTitle = documentationTitle;
            return this;
        }

        public final String getDocumentationLink() {
            return documentationLink;
        }

        public final void setDocumentationLink(String documentationLink) {
            this.documentationLink = documentationLink;
        }

        @Override
        public final Builder documentationLink(String documentationLink) {
            this.documentationLink = documentationLink;
            return this;
        }

        @Override
        public RegistrationDeniedReasonInformation build() {
            return new RegistrationDeniedReasonInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
