/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.PinpointSmsVoiceV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccessDeniedException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConflictException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAssociationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationAttachmentResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateVerifiedDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteAccountDefaultProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteAccountDefaultProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteMediaMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteMediaMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationAttachmentResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationFieldValueResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteRegistrationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVerifiedDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationAttachmentsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationFieldValuesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationSectionDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DiscardRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetProtectConfigurationCountryRuleSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetProtectConfigurationCountryRuleSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.InternalServerException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListRegistrationAssociationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutRegistrationFieldValueResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleaseSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendDestinationNumberVerificationCodeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendMediaMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendMediaMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetAccountDefaultProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetAccountDefaultProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetMediaMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetMediaMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SubmitRegistrationVersionResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ThrottlingException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationCountryRuleSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationCountryRuleSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateProtectConfigurationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ValidationException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifyDestinationNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.AssociateOriginationIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.AssociateProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateOptOutListRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreatePoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateRegistrationAssociationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateRegistrationAttachmentRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateRegistrationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateRegistrationVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateVerifiedDestinationNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteAccountDefaultProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteDefaultMessageTypeRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteDefaultSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteKeywordRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteMediaMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteOptOutListRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteOptedOutNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeletePoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteRegistrationAttachmentRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteRegistrationFieldValueRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteRegistrationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteTextMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteVerifiedDestinationNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteVoiceMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeKeywordsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeOptOutListsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeOptedOutNumbersRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribePhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribePoolsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeProtectConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationFieldDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationFieldValuesRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationSectionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationTypeDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeSenderIdsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeSpendLimitsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeVerifiedDestinationNumbersRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DisassociateOriginationIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DisassociateProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DiscardRegistrationVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.GetProtectConfigurationCountryRuleSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ListPoolOriginationIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ListRegistrationAssociationsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.PutKeywordRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.PutOptedOutNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.PutRegistrationFieldValueRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ReleasePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ReleaseSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.RequestPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.RequestSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SendDestinationNumberVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SendMediaMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SendTextMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SendVoiceMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetAccountDefaultProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetDefaultMessageTypeRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetDefaultSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetMediaMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetTextMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetVoiceMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SubmitRegistrationVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdateEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdatePoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdateProtectConfigurationCountryRuleSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdateProtectConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdateSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.VerifyDestinationNumberRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link PinpointSmsVoiceV2AsyncClient}.
 *
 * @see PinpointSmsVoiceV2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPinpointSmsVoiceV2AsyncClient implements PinpointSmsVoiceV2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPinpointSmsVoiceV2AsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointSmsVoiceV2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates the specified origination identity with a pool.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <p>
     * If the origination identity configuration doesn't match the pool's configuration, an error is returned.
     * </p>
     *
     * @param associateOriginationIdentityRequest
     * @return A Java Future containing the result of the AssociateOriginationIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.AssociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateOriginationIdentityResponse> associateOriginationIdentity(
            AssociateOriginationIdentityRequest associateOriginationIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateOriginationIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOriginationIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOriginationIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateOriginationIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateOriginationIdentityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateOriginationIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateOriginationIdentityRequest, AssociateOriginationIdentityResponse>()
                            .withOperationName("AssociateOriginationIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateOriginationIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateOriginationIdentityRequest));
            CompletableFuture<AssociateOriginationIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate a protect configuration with a configuration set. This replaces the configuration sets current protect
     * configuration. A configuration set can only be associated with one protect configuration at a time. A protect
     * configuration can be associated with multiple configuration sets.
     * </p>
     *
     * @param associateProtectConfigurationRequest
     * @return A Java Future containing the result of the AssociateProtectConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.AssociateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateProtectConfigurationResponse> associateProtectConfiguration(
            AssociateProtectConfigurationRequest associateProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateProtectConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateProtectConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateProtectConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateProtectConfigurationRequest, AssociateProtectConfigurationResponse>()
                            .withOperationName("AssociateProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateProtectConfigurationRequest));
            CompletableFuture<AssociateProtectConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     * </p>
     * <p>
     * When you send a message, you can optionally specify a single configuration set.
     * </p>
     *
     * @param createConfigurationSetRequest
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            CreateConfigurationSetRequest createConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConfigurationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConfigurationSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConfigurationSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConfigurationSetRequest, CreateConfigurationSetResponse>()
                            .withOperationName("CreateConfigurationSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConfigurationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConfigurationSetRequest));
            CompletableFuture<CreateConfigurationSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new event destination in a configuration set.
     * </p>
     * <p>
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon
     * Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send information
     * about that event to an event destination, or send notifications to endpoints that are subscribed to an Amazon SNS
     * topic.
     * </p>
     * <p>
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a
     * reference to a single destination, such as a CloudWatch or Firehose destination.
     * </p>
     *
     * @param createEventDestinationRequest
     * @return A Java Future containing the result of the CreateEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventDestinationResponse> createEventDestination(
            CreateEventDestinationRequest createEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEventDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEventDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventDestinationRequest, CreateEventDestinationResponse>()
                            .withOperationName("CreateEventDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEventDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEventDestinationRequest));
            CompletableFuture<CreateEventDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new opt-out list.
     * </p>
     * <p>
     * If the opt-out list name already exists, an error is returned.
     * </p>
     * <p>
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to
     * them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In
     * addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of
     * supported opt-out keywords, see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS
     * opt out </a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param createOptOutListRequest
     * @return A Java Future containing the result of the CreateOptOutList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOptOutListResponse> createOptOutList(CreateOptOutListRequest createOptOutListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOptOutListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOptOutListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOptOutList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOptOutListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOptOutListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOptOutListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOptOutListRequest, CreateOptOutListResponse>()
                            .withOperationName("CreateOptOutList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOptOutListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOptOutListRequest));
            CompletableFuture<CreateOptOutListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more
     * phone numbers and SenderIds that are associated with your Amazon Web Services account.
     * </p>
     * <p>
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message
     * type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't
     * inherited from the origination identity and defaults to false.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     *
     * @param createPoolRequest
     * @return A Java Future containing the result of the CreatePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePoolResponse> createPool(CreatePoolRequest createPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePoolRequest, CreatePoolResponse>().withOperationName("CreatePool")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPoolRequest));
            CompletableFuture<CreatePoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new protect configuration. By default all country rule sets for each capability are set to
     * <code>ALLOW</code>. Update the country rule sets using <code>UpdateProtectConfigurationCountryRuleSet</code>. A
     * protect configurations name is stored as a Tag with the key set to <code>Name</code> and value as the name of the
     * protect configuration.
     * </p>
     *
     * @param createProtectConfigurationRequest
     * @return A Java Future containing the result of the CreateProtectConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProtectConfigurationResponse> createProtectConfiguration(
            CreateProtectConfigurationRequest createProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProtectConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProtectConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProtectConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProtectConfigurationRequest, CreateProtectConfigurationResponse>()
                            .withOperationName("CreateProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProtectConfigurationRequest));
            CompletableFuture<CreateProtectConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new registration based on the <b>RegistrationType</b> field.
     * </p>
     *
     * @param createRegistrationRequest
     * @return A Java Future containing the result of the CreateRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRegistrationResponse> createRegistration(CreateRegistrationRequest createRegistrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRegistrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRegistration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRegistrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRegistrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRegistrationRequest, CreateRegistrationResponse>()
                            .withOperationName("CreateRegistration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRegistrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRegistrationRequest));
            CompletableFuture<CreateRegistrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate the registration with an origination identity such as a phone number or sender ID.
     * </p>
     *
     * @param createRegistrationAssociationRequest
     * @return A Java Future containing the result of the CreateRegistrationAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRegistrationAssociationResponse> createRegistrationAssociation(
            CreateRegistrationAssociationRequest createRegistrationAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRegistrationAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRegistrationAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRegistrationAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRegistrationAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRegistrationAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRegistrationAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRegistrationAssociationRequest, CreateRegistrationAssociationResponse>()
                            .withOperationName("CreateRegistrationAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRegistrationAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRegistrationAssociationRequest));
            CompletableFuture<CreateRegistrationAssociationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is
     * 500KB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed
     * “letter of authorization” (LOA) to be submitted.
     * </p>
     * <p>
     * Use either <code>AttachmentUrl</code> or <code>AttachmentBody</code> to upload your attachment. If both are
     * specified then an exception is returned.
     * </p>
     *
     * @param createRegistrationAttachmentRequest
     * @return A Java Future containing the result of the CreateRegistrationAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRegistrationAttachmentResponse> createRegistrationAttachment(
            CreateRegistrationAttachmentRequest createRegistrationAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRegistrationAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRegistrationAttachmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRegistrationAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRegistrationAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRegistrationAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRegistrationAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRegistrationAttachmentRequest, CreateRegistrationAttachmentResponse>()
                            .withOperationName("CreateRegistrationAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRegistrationAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRegistrationAttachmentRequest));
            CompletableFuture<CreateRegistrationAttachmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new version of the registration and increase the <b>VersionNumber</b>. The previous version of the
     * registration becomes read-only.
     * </p>
     *
     * @param createRegistrationVersionRequest
     * @return A Java Future containing the result of the CreateRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRegistrationVersionResponse> createRegistrationVersion(
            CreateRegistrationVersionRequest createRegistrationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRegistrationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRegistrationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRegistrationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRegistrationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRegistrationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRegistrationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRegistrationVersionRequest, CreateRegistrationVersionResponse>()
                            .withOperationName("CreateRegistrationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRegistrationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRegistrationVersionRequest));
            CompletableFuture<CreateRegistrationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * You can only send messages to verified destination numbers when your account is in the sandbox. You can add up to
     * 10 verified destination numbers.
     * </p>
     *
     * @param createVerifiedDestinationNumberRequest
     * @return A Java Future containing the result of the CreateVerifiedDestinationNumber operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.CreateVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVerifiedDestinationNumberResponse> createVerifiedDestinationNumber(
            CreateVerifiedDestinationNumberRequest createVerifiedDestinationNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedDestinationNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVerifiedDestinationNumberRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedDestinationNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVerifiedDestinationNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVerifiedDestinationNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVerifiedDestinationNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedDestinationNumberRequest, CreateVerifiedDestinationNumberResponse>()
                            .withOperationName("CreateVerifiedDestinationNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVerifiedDestinationNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVerifiedDestinationNumberRequest));
            CompletableFuture<CreateVerifiedDestinationNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the current account default protect configuration.
     * </p>
     *
     * @param deleteAccountDefaultProtectConfigurationRequest
     * @return A Java Future containing the result of the DeleteAccountDefaultProtectConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteAccountDefaultProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteAccountDefaultProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountDefaultProtectConfigurationResponse> deleteAccountDefaultProtectConfiguration(
            DeleteAccountDefaultProtectConfigurationRequest deleteAccountDefaultProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteAccountDefaultProtectConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccountDefaultProtectConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountDefaultProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountDefaultProtectConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteAccountDefaultProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccountDefaultProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountDefaultProtectConfigurationRequest, DeleteAccountDefaultProtectConfigurationResponse>()
                            .withOperationName("DeleteAccountDefaultProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccountDefaultProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccountDefaultProtectConfigurationRequest));
            CompletableFuture<DeleteAccountDefaultProtectConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing configuration set.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration
     * set, you can specify a destination for specific types of events related to voice and SMS messages.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfigurationSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigurationSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfigurationSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationSetRequest, DeleteConfigurationSetResponse>()
                            .withOperationName("DeleteConfigurationSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfigurationSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfigurationSetRequest));
            CompletableFuture<DeleteConfigurationSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing default message type on a configuration set.
     * </p>
     * <p>
     * A message type is a type of messages that you plan to send. If you send account-related messages or
     * time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param deleteDefaultMessageTypeRequest
     * @return A Java Future containing the result of the DeleteDefaultMessageType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDefaultMessageTypeResponse> deleteDefaultMessageType(
            DeleteDefaultMessageTypeRequest deleteDefaultMessageTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDefaultMessageTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDefaultMessageTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDefaultMessageType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDefaultMessageTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDefaultMessageTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDefaultMessageTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDefaultMessageTypeRequest, DeleteDefaultMessageTypeResponse>()
                            .withOperationName("DeleteDefaultMessageType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDefaultMessageTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDefaultMessageTypeRequest));
            CompletableFuture<DeleteDefaultMessageTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing default sender ID on a configuration set.
     * </p>
     * <p>
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support
     * for sender ID capabilities varies by country or region.
     * </p>
     *
     * @param deleteDefaultSenderIdRequest
     * @return A Java Future containing the result of the DeleteDefaultSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDefaultSenderIdResponse> deleteDefaultSenderId(
            DeleteDefaultSenderIdRequest deleteDefaultSenderIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDefaultSenderIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDefaultSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDefaultSenderId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDefaultSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDefaultSenderIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDefaultSenderIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDefaultSenderIdRequest, DeleteDefaultSenderIdResponse>()
                            .withOperationName("DeleteDefaultSenderId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDefaultSenderIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDefaultSenderIdRequest));
            CompletableFuture<DeleteDefaultSenderIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing event destination.
     * </p>
     * <p>
     * An event destination is a location where you send response information about the messages that you send. For
     * example, when a message is delivered successfully, you can send information about that event to an Amazon
     * CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     * </p>
     *
     * @param deleteEventDestinationRequest
     * @return A Java Future containing the result of the DeleteEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventDestinationResponse> deleteEventDestination(
            DeleteEventDestinationRequest deleteEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventDestinationRequest, DeleteEventDestinationResponse>()
                            .withOperationName("DeleteEventDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventDestinationRequest));
            CompletableFuture<DeleteEventDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing keyword from an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     * </p>
     *
     * @param deleteKeywordRequest
     * @return A Java Future containing the result of the DeleteKeyword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeywordResponse> deleteKeyword(DeleteKeywordRequest deleteKeywordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKeywordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeywordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteKeywordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteKeywordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteKeywordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKeywordRequest, DeleteKeywordResponse>()
                            .withOperationName("DeleteKeyword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteKeywordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteKeywordRequest));
            CompletableFuture<DeleteKeywordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending multimedia messages (MMS). Deleting a spend
     * limit override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas for Server Migration Service</a>
     * in the <i>Server Migration Service User Guide</i>.
     * </p>
     *
     * @param deleteMediaMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the DeleteMediaMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteMediaMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteMediaMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMediaMessageSpendLimitOverrideResponse> deleteMediaMessageSpendLimitOverride(
            DeleteMediaMessageSpendLimitOverrideRequest deleteMediaMessageSpendLimitOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMediaMessageSpendLimitOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMediaMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaMessageSpendLimitOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMediaMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteMediaMessageSpendLimitOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMediaMessageSpendLimitOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaMessageSpendLimitOverrideRequest, DeleteMediaMessageSpendLimitOverrideResponse>()
                            .withOperationName("DeleteMediaMessageSpendLimitOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMediaMessageSpendLimitOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMediaMessageSpendLimitOverrideRequest));
            CompletableFuture<DeleteMediaMessageSpendLimitOverrideResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     * </p>
     * <p>
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an error is
     * returned.
     * </p>
     *
     * @param deleteOptOutListRequest
     * @return A Java Future containing the result of the DeleteOptOutList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOptOutListResponse> deleteOptOutList(DeleteOptOutListRequest deleteOptOutListRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOptOutListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptOutListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptOutList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOptOutListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOptOutListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOptOutListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOptOutListRequest, DeleteOptOutListResponse>()
                            .withOperationName("DeleteOptOutList").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOptOutListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOptOutListRequest));
            CompletableFuture<DeleteOptOutListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     * </p>
     * <p>
     * Each destination phone number can only be deleted once every 30 days.
     * </p>
     * <p>
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an error is
     * returned.
     * </p>
     *
     * @param deleteOptedOutNumberRequest
     * @return A Java Future containing the result of the DeleteOptedOutNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOptedOutNumberResponse> deleteOptedOutNumber(
            DeleteOptedOutNumberRequest deleteOptedOutNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOptedOutNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptedOutNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptedOutNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOptedOutNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOptedOutNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOptedOutNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOptedOutNumberRequest, DeleteOptedOutNumberResponse>()
                            .withOperationName("DeleteOptedOutNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOptedOutNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOptedOutNumberRequest));
            CompletableFuture<DeleteOptedOutNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     * </p>
     * <p>
     * If the pool status isn't active or if deletion protection is enabled, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param deletePoolRequest
     * @return A Java Future containing the result of the DeletePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeletePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePoolResponse> deletePool(DeletePoolRequest deletePoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePoolRequest, DeletePoolResponse>().withOperationName("DeletePool")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePoolRequest));
            CompletableFuture<DeletePoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently delete the protect configuration. The protect configuration must have deletion protection disabled
     * and must not be associated as the account default protect configuration or associated with a configuration set.
     * </p>
     *
     * @param deleteProtectConfigurationRequest
     * @return A Java Future containing the result of the DeleteProtectConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProtectConfigurationResponse> deleteProtectConfiguration(
            DeleteProtectConfigurationRequest deleteProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProtectConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProtectConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProtectConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProtectConfigurationRequest, DeleteProtectConfigurationResponse>()
                            .withOperationName("DeleteProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProtectConfigurationRequest));
            CompletableFuture<DeleteProtectConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently delete an existing registration from your account.
     * </p>
     *
     * @param deleteRegistrationRequest
     * @return A Java Future containing the result of the DeleteRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRegistrationResponse> deleteRegistration(DeleteRegistrationRequest deleteRegistrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRegistrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRegistration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRegistrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRegistrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRegistrationRequest, DeleteRegistrationResponse>()
                            .withOperationName("DeleteRegistration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRegistrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRegistrationRequest));
            CompletableFuture<DeleteRegistrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently delete the specified registration attachment.
     * </p>
     *
     * @param deleteRegistrationAttachmentRequest
     * @return A Java Future containing the result of the DeleteRegistrationAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistrationAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRegistrationAttachmentResponse> deleteRegistrationAttachment(
            DeleteRegistrationAttachmentRequest deleteRegistrationAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRegistrationAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRegistrationAttachmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRegistrationAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRegistrationAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRegistrationAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRegistrationAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRegistrationAttachmentRequest, DeleteRegistrationAttachmentResponse>()
                            .withOperationName("DeleteRegistrationAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRegistrationAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRegistrationAttachmentRequest));
            CompletableFuture<DeleteRegistrationAttachmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the value in a registration form field.
     * </p>
     *
     * @param deleteRegistrationFieldValueRequest
     * @return A Java Future containing the result of the DeleteRegistrationFieldValue operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteRegistrationFieldValue
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRegistrationFieldValueResponse> deleteRegistrationFieldValue(
            DeleteRegistrationFieldValueRequest deleteRegistrationFieldValueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRegistrationFieldValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRegistrationFieldValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRegistrationFieldValue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRegistrationFieldValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRegistrationFieldValueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRegistrationFieldValueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRegistrationFieldValueRequest, DeleteRegistrationFieldValueResponse>()
                            .withOperationName("DeleteRegistrationFieldValue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRegistrationFieldValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRegistrationFieldValueRequest));
            CompletableFuture<DeleteRegistrationFieldValueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the resource-based policy document attached to the AWS End User Messaging SMS and Voice resource. A
     * shared resource can be a Pool, Opt-out list, Sender Id, or Phone number.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit
     * override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the <i>AWS End User
     * Messaging SMS User Guide</i>.
     * </p>
     *
     * @param deleteTextMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the DeleteTextMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTextMessageSpendLimitOverrideResponse> deleteTextMessageSpendLimitOverride(
            DeleteTextMessageSpendLimitOverrideRequest deleteTextMessageSpendLimitOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTextMessageSpendLimitOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTextMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTextMessageSpendLimitOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTextMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteTextMessageSpendLimitOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTextMessageSpendLimitOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTextMessageSpendLimitOverrideRequest, DeleteTextMessageSpendLimitOverrideResponse>()
                            .withOperationName("DeleteTextMessageSpendLimitOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTextMessageSpendLimitOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTextMessageSpendLimitOverrideRequest));
            CompletableFuture<DeleteTextMessageSpendLimitOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a verified destination phone number.
     * </p>
     *
     * @param deleteVerifiedDestinationNumberRequest
     * @return A Java Future containing the result of the DeleteVerifiedDestinationNumber operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteVerifiedDestinationNumber
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVerifiedDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVerifiedDestinationNumberResponse> deleteVerifiedDestinationNumber(
            DeleteVerifiedDestinationNumberRequest deleteVerifiedDestinationNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVerifiedDestinationNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVerifiedDestinationNumberRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVerifiedDestinationNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVerifiedDestinationNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVerifiedDestinationNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVerifiedDestinationNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVerifiedDestinationNumberRequest, DeleteVerifiedDestinationNumberResponse>()
                            .withOperationName("DeleteVerifiedDestinationNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVerifiedDestinationNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVerifiedDestinationNumberRequest));
            CompletableFuture<DeleteVerifiedDestinationNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override
     * sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web
     * Services. For more information on spending limits (quotas) see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the <i>AWS End User
     * Messaging SMS User Guide</i>.
     * </p>
     *
     * @param deleteVoiceMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the DeleteVoiceMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DeleteVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceMessageSpendLimitOverrideResponse> deleteVoiceMessageSpendLimitOverride(
            DeleteVoiceMessageSpendLimitOverrideRequest deleteVoiceMessageSpendLimitOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVoiceMessageSpendLimitOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceMessageSpendLimitOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteVoiceMessageSpendLimitOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceMessageSpendLimitOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceMessageSpendLimitOverrideRequest, DeleteVoiceMessageSpendLimitOverrideResponse>()
                            .withOperationName("DeleteVoiceMessageSpendLimitOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVoiceMessageSpendLimitOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVoiceMessageSpendLimitOverrideRequest));
            CompletableFuture<DeleteVoiceMessageSpendLimitOverrideResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web Services end
     * recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountAttributesRequest));
            CompletableFuture<DescribeAccountAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current AWS End User Messaging SMS and Voice SMS Voice V2 resource quotas for your account. The
     * description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/quotas.html">Quotas </a> in the
     * <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                            .withOperationName("DescribeAccountLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountLimitsRequest));
            CompletableFuture<DescribeAccountLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return A Java Future containing the result of the DescribeConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationSetsResponse> describeConfigurationSets(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigurationSetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConfigurationSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConfigurationSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigurationSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationSetsRequest, DescribeConfigurationSetsResponse>()
                            .withOperationName("DescribeConfigurationSets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigurationSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigurationSetsRequest));
            CompletableFuture<DescribeConfigurationSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     *
     * @param describeKeywordsRequest
     * @return A Java Future containing the result of the DescribeKeywords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeKeywordsResponse> describeKeywords(DescribeKeywordsRequest describeKeywordsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeKeywordsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeKeywordsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeKeywords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeKeywordsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeKeywordsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeKeywordsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeKeywordsRequest, DescribeKeywordsResponse>()
                            .withOperationName("DescribeKeywords").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeKeywordsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeKeywordsRequest));
            CompletableFuture<DescribeKeywordsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return A Java Future containing the result of the DescribeOptOutLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOptOutListsResponse> describeOptOutLists(
            DescribeOptOutListsRequest describeOptOutListsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOptOutListsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptOutListsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptOutLists");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOptOutListsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOptOutListsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOptOutListsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOptOutListsRequest, DescribeOptOutListsResponse>()
                            .withOperationName("DescribeOptOutLists").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOptOutListsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOptOutListsRequest));
            CompletableFuture<DescribeOptOutListsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an exception is returned.
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return A Java Future containing the result of the DescribeOptedOutNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOptedOutNumbersResponse> describeOptedOutNumbers(
            DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOptedOutNumbersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptedOutNumbersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptedOutNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOptedOutNumbersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOptedOutNumbersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOptedOutNumbersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOptedOutNumbersRequest, DescribeOptedOutNumbersResponse>()
                            .withOperationName("DescribeOptedOutNumbers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOptedOutNumbersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOptedOutNumbersRequest));
            CompletableFuture<DescribeOptedOutNumbersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an error is returned.
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return A Java Future containing the result of the DescribePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePhoneNumbersResponse> describePhoneNumbers(
            DescribePhoneNumbersRequest describePhoneNumbersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePhoneNumbersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePhoneNumbersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePhoneNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePhoneNumbersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePhoneNumbersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePhoneNumbersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePhoneNumbersRequest, DescribePhoneNumbersResponse>()
                            .withOperationName("DescribePhoneNumbers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePhoneNumbersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePhoneNumbersRequest));
            CompletableFuture<DescribePhoneNumbersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param describePoolsRequest
     * @return A Java Future containing the result of the DescribePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePoolsResponse> describePools(DescribePoolsRequest describePoolsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePoolsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribePoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePoolsRequest, DescribePoolsResponse>()
                            .withOperationName("DescribePools").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePoolsRequest));
            CompletableFuture<DescribePoolsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the protect configurations that match any of filters. If a filter isn’t provided then all protect
     * configurations are returned.
     * </p>
     *
     * @param describeProtectConfigurationsRequest
     * @return A Java Future containing the result of the DescribeProtectConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeProtectConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeProtectConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProtectConfigurationsResponse> describeProtectConfigurations(
            DescribeProtectConfigurationsRequest describeProtectConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProtectConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeProtectConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProtectConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProtectConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProtectConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProtectConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProtectConfigurationsRequest, DescribeProtectConfigurationsResponse>()
                            .withOperationName("DescribeProtectConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProtectConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProtectConfigurationsRequest));
            CompletableFuture<DescribeProtectConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web
     * Services account.
     * </p>
     *
     * @param describeRegistrationAttachmentsRequest
     * @return A Java Future containing the result of the DescribeRegistrationAttachments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationAttachmentsResponse> describeRegistrationAttachments(
            DescribeRegistrationAttachmentsRequest describeRegistrationAttachmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationAttachmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRegistrationAttachmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrationAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationAttachmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegistrationAttachmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationAttachmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationAttachmentsRequest, DescribeRegistrationAttachmentsResponse>()
                            .withOperationName("DescribeRegistrationAttachments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationAttachmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationAttachmentsRequest));
            CompletableFuture<DescribeRegistrationAttachmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registration type field definitions. You can use DescribeRegistrationFieldDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationFieldDefinitionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationFieldDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationFieldDefinitionsResponse> describeRegistrationFieldDefinitions(
            DescribeRegistrationFieldDefinitionsRequest describeRegistrationFieldDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationFieldDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRegistrationFieldDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrationFieldDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationFieldDefinitionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeRegistrationFieldDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationFieldDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationFieldDefinitionsRequest, DescribeRegistrationFieldDefinitionsResponse>()
                            .withOperationName("DescribeRegistrationFieldDefinitions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationFieldDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationFieldDefinitionsRequest));
            CompletableFuture<DescribeRegistrationFieldDefinitionsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registration field values.
     * </p>
     *
     * @param describeRegistrationFieldValuesRequest
     * @return A Java Future containing the result of the DescribeRegistrationFieldValues operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationFieldValues
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationFieldValues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationFieldValuesResponse> describeRegistrationFieldValues(
            DescribeRegistrationFieldValuesRequest describeRegistrationFieldValuesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationFieldValuesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRegistrationFieldValuesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrationFieldValues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationFieldValuesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegistrationFieldValuesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationFieldValuesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationFieldValuesRequest, DescribeRegistrationFieldValuesResponse>()
                            .withOperationName("DescribeRegistrationFieldValues").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationFieldValuesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationFieldValuesRequest));
            CompletableFuture<DescribeRegistrationFieldValuesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registration section definitions. You can use DescribeRegistrationSectionDefinitions to
     * view the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationSectionDefinitionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationSectionDefinitions operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationSectionDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationSectionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationSectionDefinitionsResponse> describeRegistrationSectionDefinitions(
            DescribeRegistrationSectionDefinitionsRequest describeRegistrationSectionDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationSectionDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRegistrationSectionDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrationSectionDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationSectionDefinitionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeRegistrationSectionDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationSectionDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationSectionDefinitionsRequest, DescribeRegistrationSectionDefinitionsResponse>()
                            .withOperationName("DescribeRegistrationSectionDefinitions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationSectionDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationSectionDefinitionsRequest));
            CompletableFuture<DescribeRegistrationSectionDefinitionsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registration type definitions. You can use DescribeRegistrationTypeDefinitions to view
     * the requirements for creating, filling out, and submitting each registration type.
     * </p>
     *
     * @param describeRegistrationTypeDefinitionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationTypeDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationTypeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationTypeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationTypeDefinitionsResponse> describeRegistrationTypeDefinitions(
            DescribeRegistrationTypeDefinitionsRequest describeRegistrationTypeDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationTypeDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRegistrationTypeDefinitionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrationTypeDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationTypeDefinitionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeRegistrationTypeDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationTypeDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationTypeDefinitionsRequest, DescribeRegistrationTypeDefinitionsResponse>()
                            .withOperationName("DescribeRegistrationTypeDefinitions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationTypeDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationTypeDefinitionsRequest));
            CompletableFuture<DescribeRegistrationTypeDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registration version.
     * </p>
     *
     * @param describeRegistrationVersionsRequest
     * @return A Java Future containing the result of the DescribeRegistrationVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrationVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationVersionsResponse> describeRegistrationVersions(
            DescribeRegistrationVersionsRequest describeRegistrationVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegistrationVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrationVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegistrationVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationVersionsRequest, DescribeRegistrationVersionsResponse>()
                            .withOperationName("DescribeRegistrationVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationVersionsRequest));
            CompletableFuture<DescribeRegistrationVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified registrations.
     * </p>
     *
     * @param describeRegistrationsRequest
     * @return A Java Future containing the result of the DescribeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegistrationsResponse> describeRegistrations(
            DescribeRegistrationsRequest describeRegistrationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegistrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegistrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegistrations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegistrationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegistrationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegistrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegistrationsRequest, DescribeRegistrationsResponse>()
                            .withOperationName("DescribeRegistrations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegistrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegistrationsRequest));
            CompletableFuture<DescribeRegistrationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an error is returned.
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return A Java Future containing the result of the DescribeSenderIds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSenderIdsResponse> describeSenderIds(DescribeSenderIdsRequest describeSenderIdsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSenderIdsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSenderIdsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSenderIds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSenderIdsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSenderIdsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSenderIdsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSenderIdsRequest, DescribeSenderIdsResponse>()
                            .withOperationName("DescribeSenderIds").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSenderIdsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSenderIdsRequest));
            CompletableFuture<DescribeSenderIdsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/awssupport-spend-threshold.html"> Requesting
     * increases to your monthly SMS, MMS, or Voice spending quota </a> in the <i>AWS End User Messaging SMS User
     * Guide</i>.
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return A Java Future containing the result of the DescribeSpendLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpendLimitsResponse> describeSpendLimits(
            DescribeSpendLimitsRequest describeSpendLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSpendLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSpendLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSpendLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSpendLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSpendLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSpendLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpendLimitsRequest, DescribeSpendLimitsResponse>()
                            .withOperationName("DescribeSpendLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSpendLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSpendLimitsRequest));
            CompletableFuture<DescribeSpendLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the specified verified destiona numbers.
     * </p>
     *
     * @param describeVerifiedDestinationNumbersRequest
     * @return A Java Future containing the result of the DescribeVerifiedDestinationNumbers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DescribeVerifiedDestinationNumbers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeVerifiedDestinationNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVerifiedDestinationNumbersResponse> describeVerifiedDestinationNumbers(
            DescribeVerifiedDestinationNumbersRequest describeVerifiedDestinationNumbersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVerifiedDestinationNumbersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeVerifiedDestinationNumbersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVerifiedDestinationNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVerifiedDestinationNumbersResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeVerifiedDestinationNumbersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeVerifiedDestinationNumbersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVerifiedDestinationNumbersRequest, DescribeVerifiedDestinationNumbersResponse>()
                            .withOperationName("DescribeVerifiedDestinationNumbers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeVerifiedDestinationNumbersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVerifiedDestinationNumbersRequest));
            CompletableFuture<DescribeVerifiedDestinationNumbersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified origination identity from an existing pool.
     * </p>
     * <p>
     * If the origination identity isn't associated with the specified pool, an error is returned.
     * </p>
     *
     * @param disassociateOriginationIdentityRequest
     * @return A Java Future containing the result of the DisassociateOriginationIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DisassociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateOriginationIdentityResponse> disassociateOriginationIdentity(
            DisassociateOriginationIdentityRequest disassociateOriginationIdentityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateOriginationIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateOriginationIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateOriginationIdentity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateOriginationIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateOriginationIdentityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateOriginationIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateOriginationIdentityRequest, DisassociateOriginationIdentityResponse>()
                            .withOperationName("DisassociateOriginationIdentity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateOriginationIdentityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateOriginationIdentityRequest));
            CompletableFuture<DisassociateOriginationIdentityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociate a protect configuration from a configuration set.
     * </p>
     *
     * @param disassociateProtectConfigurationRequest
     * @return A Java Future containing the result of the DisassociateProtectConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DisassociateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateProtectConfigurationResponse> disassociateProtectConfiguration(
            DisassociateProtectConfigurationRequest disassociateProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateProtectConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateProtectConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateProtectConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateProtectConfigurationRequest, DisassociateProtectConfigurationResponse>()
                            .withOperationName("DisassociateProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateProtectConfigurationRequest));
            CompletableFuture<DisassociateProtectConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Discard the current version of the registration.
     * </p>
     *
     * @param discardRegistrationVersionRequest
     * @return A Java Future containing the result of the DiscardRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.DiscardRegistrationVersion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DiscardRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DiscardRegistrationVersionResponse> discardRegistrationVersion(
            DiscardRegistrationVersionRequest discardRegistrationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(discardRegistrationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, discardRegistrationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DiscardRegistrationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DiscardRegistrationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DiscardRegistrationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DiscardRegistrationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DiscardRegistrationVersionRequest, DiscardRegistrationVersionResponse>()
                            .withOperationName("DiscardRegistrationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DiscardRegistrationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(discardRegistrationVersionRequest));
            CompletableFuture<DiscardRegistrationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration.
     * </p>
     *
     * @param getProtectConfigurationCountryRuleSetRequest
     * @return A Java Future containing the result of the GetProtectConfigurationCountryRuleSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.GetProtectConfigurationCountryRuleSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/GetProtectConfigurationCountryRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetProtectConfigurationCountryRuleSetResponse> getProtectConfigurationCountryRuleSet(
            GetProtectConfigurationCountryRuleSetRequest getProtectConfigurationCountryRuleSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getProtectConfigurationCountryRuleSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getProtectConfigurationCountryRuleSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProtectConfigurationCountryRuleSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetProtectConfigurationCountryRuleSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetProtectConfigurationCountryRuleSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetProtectConfigurationCountryRuleSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetProtectConfigurationCountryRuleSetRequest, GetProtectConfigurationCountryRuleSetResponse>()
                            .withOperationName("GetProtectConfigurationCountryRuleSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetProtectConfigurationCountryRuleSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getProtectConfigurationCountryRuleSetRequest));
            CompletableFuture<GetProtectConfigurationCountryRuleSetResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the AWS End User Messaging SMS and
     * Voice resource. A shared resource can be a Pool, Opt-out list, Sender Id, or Phone number.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                            .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePolicyRequest));
            CompletableFuture<GetResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return A Java Future containing the result of the ListPoolOriginationIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPoolOriginationIdentitiesResponse> listPoolOriginationIdentities(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPoolOriginationIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPoolOriginationIdentitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPoolOriginationIdentities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPoolOriginationIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPoolOriginationIdentitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPoolOriginationIdentitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPoolOriginationIdentitiesRequest, ListPoolOriginationIdentitiesResponse>()
                            .withOperationName("ListPoolOriginationIdentities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPoolOriginationIdentitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPoolOriginationIdentitiesRequest));
            CompletableFuture<ListPoolOriginationIdentitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retreive all of the origination identies that are associated with a registration.
     * </p>
     *
     * @param listRegistrationAssociationsRequest
     * @return A Java Future containing the result of the ListRegistrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListRegistrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListRegistrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRegistrationAssociationsResponse> listRegistrationAssociations(
            ListRegistrationAssociationsRequest listRegistrationAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRegistrationAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRegistrationAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRegistrationAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRegistrationAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRegistrationAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRegistrationAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRegistrationAssociationsRequest, ListRegistrationAssociationsResponse>()
                            .withOperationName("ListRegistrationAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRegistrationAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRegistrationAssociationsRequest));
            CompletableFuture<ListRegistrationAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a keyword configuration on an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, AWS End User Messaging SMS and
     * Voice responds with a customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an error is returned.
     * </p>
     *
     * @param putKeywordRequest
     * @return A Java Future containing the result of the PutKeyword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutKeywordResponse> putKeyword(PutKeywordRequest putKeywordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putKeywordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putKeywordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutKeyword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutKeywordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutKeywordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutKeywordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutKeywordRequest, PutKeywordResponse>().withOperationName("PutKeyword")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutKeywordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putKeywordRequest));
            CompletableFuture<PutKeywordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an opted out destination phone number in the opt-out list.
     * </p>
     * <p>
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an error is returned.
     * </p>
     *
     * @param putOptedOutNumberRequest
     * @return A Java Future containing the result of the PutOptedOutNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutOptedOutNumberResponse> putOptedOutNumber(PutOptedOutNumberRequest putOptedOutNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putOptedOutNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOptedOutNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOptedOutNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutOptedOutNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutOptedOutNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutOptedOutNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutOptedOutNumberRequest, PutOptedOutNumberResponse>()
                            .withOperationName("PutOptedOutNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutOptedOutNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putOptedOutNumberRequest));
            CompletableFuture<PutOptedOutNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a field value for a registration.
     * </p>
     *
     * @param putRegistrationFieldValueRequest
     * @return A Java Future containing the result of the PutRegistrationFieldValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutRegistrationFieldValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutRegistrationFieldValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRegistrationFieldValueResponse> putRegistrationFieldValue(
            PutRegistrationFieldValueRequest putRegistrationFieldValueRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRegistrationFieldValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRegistrationFieldValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRegistrationFieldValue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRegistrationFieldValueResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRegistrationFieldValueResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRegistrationFieldValueResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRegistrationFieldValueRequest, PutRegistrationFieldValueResponse>()
                            .withOperationName("PutRegistrationFieldValue").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutRegistrationFieldValueRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putRegistrationFieldValueRequest));
            CompletableFuture<PutRegistrationFieldValueResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a resource-based policy to a AWS End User Messaging SMS and Voice resource(phone number, sender Id,
     * phone poll, or opt-out list) that is used for sharing the resource. A shared resource can be a Pool, Opt-out
     * list, Sender Id, or Phone number. For more information about resource-based policies, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/shared-resources.html">Working with shared
     * resources</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer
     * available for sending messages.
     * </p>
     * <p>
     * If the origination phone number has deletion protection enabled or is associated with a pool, an error is
     * returned.
     * </p>
     *
     * @param releasePhoneNumberRequest
     * @return A Java Future containing the result of the ReleasePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ReleasePhoneNumberResponse> releasePhoneNumber(ReleasePhoneNumberRequest releasePhoneNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(releasePhoneNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, releasePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReleasePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ReleasePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ReleasePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ReleasePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ReleasePhoneNumberRequest, ReleasePhoneNumberResponse>()
                            .withOperationName("ReleasePhoneNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ReleasePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(releasePhoneNumberRequest));
            CompletableFuture<ReleasePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Releases an existing sender ID in your account.
     * </p>
     *
     * @param releaseSenderIdRequest
     * @return A Java Future containing the result of the ReleaseSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.ReleaseSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleaseSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseSenderIdResponse> releaseSenderId(ReleaseSenderIdRequest releaseSenderIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(releaseSenderIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, releaseSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReleaseSenderId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ReleaseSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ReleaseSenderIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ReleaseSenderIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ReleaseSenderIdRequest, ReleaseSenderIdResponse>()
                            .withOperationName("ReleaseSenderId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ReleaseSenderIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(releaseSenderIdRequest));
            CompletableFuture<ReleaseSenderIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Request an origination phone number for use in your account. For more information on phone number request see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-request.html">Request a phone
     * number</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param requestPhoneNumberRequest
     * @return A Java Future containing the result of the RequestPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.RequestPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RequestPhoneNumberResponse> requestPhoneNumber(RequestPhoneNumberRequest requestPhoneNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(requestPhoneNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestPhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RequestPhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RequestPhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RequestPhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RequestPhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RequestPhoneNumberRequest, RequestPhoneNumberResponse>()
                            .withOperationName("RequestPhoneNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RequestPhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(requestPhoneNumberRequest));
            CompletableFuture<RequestPhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Request a new sender ID that doesn't require registration.
     * </p>
     *
     * @param requestSenderIdRequest
     * @return A Java Future containing the result of the RequestSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.RequestSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RequestSenderIdResponse> requestSenderId(RequestSenderIdRequest requestSenderIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(requestSenderIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RequestSenderId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RequestSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RequestSenderIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RequestSenderIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RequestSenderIdRequest, RequestSenderIdResponse>()
                            .withOperationName("RequestSenderId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RequestSenderIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(requestSenderIdRequest));
            CompletableFuture<RequestSenderIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Before you can send test messages to a verified destination phone number you need to opt-in the verified
     * destination phone number. Creates a new text message with a verification code and send it to a verified
     * destination phone number. Once you have the verification code use <a>VerifyDestinationNumber</a> to opt-in the
     * verified destination phone number to receive messages.
     * </p>
     *
     * @param sendDestinationNumberVerificationCodeRequest
     * @return A Java Future containing the result of the SendDestinationNumberVerificationCode operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendDestinationNumberVerificationCode
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendDestinationNumberVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendDestinationNumberVerificationCodeResponse> sendDestinationNumberVerificationCode(
            SendDestinationNumberVerificationCodeRequest sendDestinationNumberVerificationCodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendDestinationNumberVerificationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                sendDestinationNumberVerificationCodeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendDestinationNumberVerificationCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendDestinationNumberVerificationCodeResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, SendDestinationNumberVerificationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendDestinationNumberVerificationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendDestinationNumberVerificationCodeRequest, SendDestinationNumberVerificationCodeResponse>()
                            .withOperationName("SendDestinationNumberVerificationCode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendDestinationNumberVerificationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendDestinationNumberVerificationCodeRequest));
            CompletableFuture<SendDestinationNumberVerificationCodeResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new multimedia message (MMS) and sends it to a recipient's phone number.
     * </p>
     *
     * @param sendMediaMessageRequest
     * @return A Java Future containing the result of the SendMediaMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendMediaMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendMediaMessage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendMediaMessageResponse> sendMediaMessage(SendMediaMessageRequest sendMediaMessageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendMediaMessageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendMediaMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendMediaMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendMediaMessageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendMediaMessageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendMediaMessageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendMediaMessageRequest, SendMediaMessageResponse>()
                            .withOperationName("SendMediaMessage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendMediaMessageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendMediaMessageRequest));
            CompletableFuture<SendMediaMessageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new text message and sends it to a recipient's phone number. SendTextMessage only sends an SMS message
     * to one recipient each time it is invoked.
     * </p>
     * <p>
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination
     * country of your messages, as well as the type of phone number (origination number) that you use to send the
     * message. For more information about MPS, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message Parts per Second
     * (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param sendTextMessageRequest
     * @return A Java Future containing the result of the SendTextMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendTextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendTextMessageResponse> sendTextMessage(SendTextMessageRequest sendTextMessageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendTextMessageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendTextMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendTextMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendTextMessageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendTextMessageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendTextMessageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendTextMessageRequest, SendTextMessageResponse>()
                            .withOperationName("SendTextMessage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendTextMessageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendTextMessageRequest));
            CompletableFuture<SendTextMessageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to send a request that sends a voice message. This operation uses <a
     * href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.
     * </p>
     *
     * @param sendVoiceMessageRequest
     * @return A Java Future containing the result of the SendVoiceMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SendVoiceMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendVoiceMessageResponse> sendVoiceMessage(SendVoiceMessageRequest sendVoiceMessageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendVoiceMessageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendVoiceMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendVoiceMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendVoiceMessageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendVoiceMessageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendVoiceMessageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendVoiceMessageRequest, SendVoiceMessageResponse>()
                            .withOperationName("SendVoiceMessage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendVoiceMessageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendVoiceMessageRequest));
            CompletableFuture<SendVoiceMessageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set a protect configuration as your account default. You can only have one account default protect configuration
     * at a time. The current account default protect configuration is replaced with the provided protect configuration.
     * </p>
     *
     * @param setAccountDefaultProtectConfigurationRequest
     * @return A Java Future containing the result of the SetAccountDefaultProtectConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetAccountDefaultProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetAccountDefaultProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetAccountDefaultProtectConfigurationResponse> setAccountDefaultProtectConfiguration(
            SetAccountDefaultProtectConfigurationRequest setAccountDefaultProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setAccountDefaultProtectConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setAccountDefaultProtectConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetAccountDefaultProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetAccountDefaultProtectConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, SetAccountDefaultProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetAccountDefaultProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetAccountDefaultProtectConfigurationRequest, SetAccountDefaultProtectConfigurationResponse>()
                            .withOperationName("SetAccountDefaultProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetAccountDefaultProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setAccountDefaultProtectConfigurationRequest));
            CompletableFuture<SetAccountDefaultProtectConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the default message type on a configuration set.
     * </p>
     * <p>
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages
     * or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param setDefaultMessageTypeRequest
     * @return A Java Future containing the result of the SetDefaultMessageType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetDefaultMessageTypeResponse> setDefaultMessageType(
            SetDefaultMessageTypeRequest setDefaultMessageTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setDefaultMessageTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultMessageTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultMessageType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetDefaultMessageTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetDefaultMessageTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetDefaultMessageTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetDefaultMessageTypeRequest, SetDefaultMessageTypeResponse>()
                            .withOperationName("SetDefaultMessageType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetDefaultMessageTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setDefaultMessageTypeRequest));
            CompletableFuture<SetDefaultMessageTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets default sender ID on a configuration set.
     * </p>
     * <p>
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the
     * configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are
     * available in your account.
     * </p>
     *
     * @param setDefaultSenderIdRequest
     * @return A Java Future containing the result of the SetDefaultSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetDefaultSenderIdResponse> setDefaultSenderId(SetDefaultSenderIdRequest setDefaultSenderIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setDefaultSenderIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultSenderId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetDefaultSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetDefaultSenderIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetDefaultSenderIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetDefaultSenderIdRequest, SetDefaultSenderIdResponse>()
                            .withOperationName("SetDefaultSenderId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetDefaultSenderIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setDefaultSenderIdRequest));
            CompletableFuture<SetDefaultSenderIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending MMS messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setMediaMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the SetMediaMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetMediaMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetMediaMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetMediaMessageSpendLimitOverrideResponse> setMediaMessageSpendLimitOverride(
            SetMediaMessageSpendLimitOverrideRequest setMediaMessageSpendLimitOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setMediaMessageSpendLimitOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setMediaMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetMediaMessageSpendLimitOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetMediaMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, SetMediaMessageSpendLimitOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetMediaMessageSpendLimitOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetMediaMessageSpendLimitOverrideRequest, SetMediaMessageSpendLimitOverrideResponse>()
                            .withOperationName("SetMediaMessageSpendLimitOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetMediaMessageSpendLimitOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setMediaMessageSpendLimitOverrideRequest));
            CompletableFuture<SetMediaMessageSpendLimitOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setTextMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the SetTextMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetTextMessageSpendLimitOverrideResponse> setTextMessageSpendLimitOverride(
            SetTextMessageSpendLimitOverrideRequest setTextMessageSpendLimitOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setTextMessageSpendLimitOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setTextMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTextMessageSpendLimitOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetTextMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, SetTextMessageSpendLimitOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetTextMessageSpendLimitOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetTextMessageSpendLimitOverrideRequest, SetTextMessageSpendLimitOverrideResponse>()
                            .withOperationName("SetTextMessageSpendLimitOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetTextMessageSpendLimitOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setTextMessageSpendLimitOverrideRequest));
            CompletableFuture<SetTextMessageSpendLimitOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setVoiceMessageSpendLimitOverrideRequest
     * @return A Java Future containing the result of the SetVoiceMessageSpendLimitOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SetVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetVoiceMessageSpendLimitOverrideResponse> setVoiceMessageSpendLimitOverride(
            SetVoiceMessageSpendLimitOverrideRequest setVoiceMessageSpendLimitOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setVoiceMessageSpendLimitOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setVoiceMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetVoiceMessageSpendLimitOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetVoiceMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, SetVoiceMessageSpendLimitOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetVoiceMessageSpendLimitOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetVoiceMessageSpendLimitOverrideRequest, SetVoiceMessageSpendLimitOverrideResponse>()
                            .withOperationName("SetVoiceMessageSpendLimitOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetVoiceMessageSpendLimitOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setVoiceMessageSpendLimitOverrideRequest));
            CompletableFuture<SetVoiceMessageSpendLimitOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Submit the specified registration for review and approval.
     * </p>
     *
     * @param submitRegistrationVersionRequest
     * @return A Java Future containing the result of the SubmitRegistrationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.SubmitRegistrationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SubmitRegistrationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SubmitRegistrationVersionResponse> submitRegistrationVersion(
            SubmitRegistrationVersionRequest submitRegistrationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(submitRegistrationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, submitRegistrationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubmitRegistrationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SubmitRegistrationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SubmitRegistrationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SubmitRegistrationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SubmitRegistrationVersionRequest, SubmitRegistrationVersionResponse>()
                            .withOperationName("SubmitRegistrationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SubmitRegistrationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(submitRegistrationVersionRequest));
            CompletableFuture<SubmitRegistrationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the
     * value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key
     * and an optional value. Tag keys must be unique per resource. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html">Tags </a> in the <i>AWS End
     * User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the association of the specified tags from a resource. For more information on tags see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-tags.html">Tags </a> in the <i>AWS End
     * User Messaging SMS User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs
     * and Firehose. You can also enable or disable the event destination.
     * </p>
     * <p>
     * You may want to update an event destination to change its matching event types or updating the destination
     * resource ARN. You can't change an event destination's type between CloudWatch Logs, Firehose, and Amazon SNS.
     * </p>
     *
     * @param updateEventDestinationRequest
     * @return A Java Future containing the result of the UpdateEventDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventDestinationResponse> updateEventDestination(
            UpdateEventDestinationRequest updateEventDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEventDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventDestinationRequest, UpdateEventDestinationResponse>()
                            .withOperationName("UpdateEventDestination").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEventDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEventDestinationRequest));
            CompletableFuture<UpdateEventDestinationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or
     * disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
     * disable deletion protection.
     * </p>
     * <p>
     * If the origination phone number is associated with a pool, an error is returned.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePhoneNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse>()
                            .withOperationName("UpdatePhoneNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePhoneNumberRequest));
            CompletableFuture<UpdatePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way
     * messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable
     * deletion protection, and enable or disable shared routes.
     * </p>
     *
     * @param updatePoolRequest
     * @return A Java Future containing the result of the UpdatePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePoolResponse> updatePool(UpdatePoolRequest updatePoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdatePoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePoolRequest, UpdatePoolResponse>().withOperationName("UpdatePool")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePoolRequest));
            CompletableFuture<UpdatePoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the setting for an existing protect configuration.
     * </p>
     *
     * @param updateProtectConfigurationRequest
     * @return A Java Future containing the result of the UpdateProtectConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateProtectConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateProtectConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProtectConfigurationResponse> updateProtectConfiguration(
            UpdateProtectConfigurationRequest updateProtectConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProtectConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProtectConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProtectConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProtectConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProtectConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProtectConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProtectConfigurationRequest, UpdateProtectConfigurationResponse>()
                            .withOperationName("UpdateProtectConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProtectConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProtectConfigurationRequest));
            CompletableFuture<UpdateProtectConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a country rule set to <code>ALLOW</code> or <code>BLOCK</code> messages to be sent to the specified
     * destination counties. You can update one or multiple countries at a time. The updates are only applied to the
     * specified NumberCapability type.
     * </p>
     *
     * @param updateProtectConfigurationCountryRuleSetRequest
     * @return A Java Future containing the result of the UpdateProtectConfigurationCountryRuleSet operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateProtectConfigurationCountryRuleSet
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateProtectConfigurationCountryRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProtectConfigurationCountryRuleSetResponse> updateProtectConfigurationCountryRuleSet(
            UpdateProtectConfigurationCountryRuleSetRequest updateProtectConfigurationCountryRuleSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateProtectConfigurationCountryRuleSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateProtectConfigurationCountryRuleSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProtectConfigurationCountryRuleSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProtectConfigurationCountryRuleSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateProtectConfigurationCountryRuleSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProtectConfigurationCountryRuleSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProtectConfigurationCountryRuleSetRequest, UpdateProtectConfigurationCountryRuleSetResponse>()
                            .withOperationName("UpdateProtectConfigurationCountryRuleSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProtectConfigurationCountryRuleSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProtectConfigurationCountryRuleSetRequest));
            CompletableFuture<UpdateProtectConfigurationCountryRuleSetResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing sender ID.
     * </p>
     *
     * @param updateSenderIdRequest
     * @return A Java Future containing the result of the UpdateSenderId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.UpdateSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSenderIdResponse> updateSenderId(UpdateSenderIdRequest updateSenderIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSenderIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSenderId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSenderIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSenderIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSenderIdRequest, UpdateSenderIdResponse>()
                            .withOperationName("UpdateSenderId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSenderIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSenderIdRequest));
            CompletableFuture<UpdateSenderIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the verification code that was received by the verified destination phone number to opt-in the verified
     * destination phone number to receive more messages.
     * </p>
     *
     * @param verifyDestinationNumberRequest
     * @return A Java Future containing the result of the VerifyDestinationNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException An error that occurred because too many requests were sent during a certain
     *         amount of time.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient permissions to access
     *         the resource.</li>
     *         <li>ResourceNotFoundException A requested resource couldn't be found.</li>
     *         <li>ValidationException A validation exception for a field.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time or it could be that the requested action
     *         isn't valid for the current state or configuration of the resource.</li>
     *         <li>InternalServerException The API encountered an unexpected error and couldn't complete the request.
     *         You might be able to successfully issue the request again in the future.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointSmsVoiceV2Exception Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PinpointSmsVoiceV2AsyncClient.VerifyDestinationNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/VerifyDestinationNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<VerifyDestinationNumberResponse> verifyDestinationNumber(
            VerifyDestinationNumberRequest verifyDestinationNumberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifyDestinationNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifyDestinationNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifyDestinationNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifyDestinationNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, VerifyDestinationNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifyDestinationNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifyDestinationNumberRequest, VerifyDestinationNumberResponse>()
                            .withOperationName("VerifyDestinationNumber").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifyDestinationNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifyDestinationNumberRequest));
            CompletableFuture<VerifyDestinationNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final PinpointSmsVoiceV2ServiceClientConfiguration serviceClientConfiguration() {
        return new PinpointSmsVoiceV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PinpointSmsVoiceV2Exception::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PinpointSmsVoiceV2ServiceClientConfigurationBuilder serviceConfigBuilder = new PinpointSmsVoiceV2ServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
