/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventDestinationRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<CreateEventDestinationRequest.Builder, CreateEventDestinationRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(CreateEventDestinationRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> EVENT_DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDestinationName").getter(getter(CreateEventDestinationRequest::eventDestinationName))
            .setter(setter(Builder::eventDestinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinationName").build())
            .build();

    private static final SdkField<List<String>> MATCHING_EVENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchingEventTypes")
            .getter(getter(CreateEventDestinationRequest::matchingEventTypesAsStrings))
            .setter(setter(Builder::matchingEventTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingEventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CloudWatchLogsDestination> CLOUD_WATCH_LOGS_DESTINATION_FIELD = SdkField
            .<CloudWatchLogsDestination> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogsDestination")
            .getter(getter(CreateEventDestinationRequest::cloudWatchLogsDestination))
            .setter(setter(Builder::cloudWatchLogsDestination)).constructor(CloudWatchLogsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsDestination").build())
            .build();

    private static final SdkField<KinesisFirehoseDestination> KINESIS_FIREHOSE_DESTINATION_FIELD = SdkField
            .<KinesisFirehoseDestination> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisFirehoseDestination")
            .getter(getter(CreateEventDestinationRequest::kinesisFirehoseDestination))
            .setter(setter(Builder::kinesisFirehoseDestination))
            .constructor(KinesisFirehoseDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDestination").build())
            .build();

    private static final SdkField<SnsDestination> SNS_DESTINATION_FIELD = SdkField
            .<SnsDestination> builder(MarshallingType.SDK_POJO).memberName("SnsDestination")
            .getter(getter(CreateEventDestinationRequest::snsDestination)).setter(setter(Builder::snsDestination))
            .constructor(SnsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDestination").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateEventDestinationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            EVENT_DESTINATION_NAME_FIELD, MATCHING_EVENT_TYPES_FIELD, CLOUD_WATCH_LOGS_DESTINATION_FIELD,
            KINESIS_FIREHOSE_DESTINATION_FIELD, SNS_DESTINATION_FIELD, CLIENT_TOKEN_FIELD));

    private final String configurationSetName;

    private final String eventDestinationName;

    private final List<String> matchingEventTypes;

    private final CloudWatchLogsDestination cloudWatchLogsDestination;

    private final KinesisFirehoseDestination kinesisFirehoseDestination;

    private final SnsDestination snsDestination;

    private final String clientToken;

    private CreateEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.cloudWatchLogsDestination = builder.cloudWatchLogsDestination;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.snsDestination = builder.snsDestination;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Either the name of the configuration set or the configuration set ARN to apply event logging to. The
     * ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.
     * </p>
     * 
     * @return Either the name of the configuration set or the configuration set ARN to apply event logging to. The
     *         ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a>
     *         action.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The name that identifies the event destination.
     * </p>
     * 
     * @return The name that identifies the event destination.
     */
    public final String eventDestinationName() {
        return eventDestinationName;
    }

    /**
     * <p>
     * An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging SMS and
     * Voice logs every event type.
     * </p>
     * <note>
     * <p>
     * The <code>TEXT_SENT</code> event type is not supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchingEventTypes} method.
     * </p>
     * 
     * @return An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging
     *         SMS and Voice logs every event type.</p> <note>
     *         <p>
     *         The <code>TEXT_SENT</code> event type is not supported.
     *         </p>
     */
    public final List<EventType> matchingEventTypes() {
        return EventTypeListCopier.copyStringToEnum(matchingEventTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchingEventTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchingEventTypes() {
        return matchingEventTypes != null && !(matchingEventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging SMS and
     * Voice logs every event type.
     * </p>
     * <note>
     * <p>
     * The <code>TEXT_SENT</code> event type is not supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchingEventTypes} method.
     * </p>
     * 
     * @return An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging
     *         SMS and Voice logs every event type.</p> <note>
     *         <p>
     *         The <code>TEXT_SENT</code> event type is not supported.
     *         </p>
     */
    public final List<String> matchingEventTypesAsStrings() {
        return matchingEventTypes;
    }

    /**
     * <p>
     * An object that contains information about an event destination for logging to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return An object that contains information about an event destination for logging to Amazon CloudWatch Logs.
     */
    public final CloudWatchLogsDestination cloudWatchLogsDestination() {
        return cloudWatchLogsDestination;
    }

    /**
     * <p>
     * An object that contains information about an event destination for logging to Amazon Data Firehose.
     * </p>
     * 
     * @return An object that contains information about an event destination for logging to Amazon Data Firehose.
     */
    public final KinesisFirehoseDestination kinesisFirehoseDestination() {
        return kinesisFirehoseDestination;
    }

    /**
     * <p>
     * An object that contains information about an event destination for logging to Amazon SNS.
     * </p>
     * 
     * @return An object that contains information about an event destination for logging to Amazon SNS.
     */
    public final SnsDestination snsDestination() {
        return snsDestination;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify
     * a client token, a randomly generated token is used for the request to ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     *         specify a client token, a randomly generated token is used for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestinationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchingEventTypes() ? matchingEventTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(snsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventDestinationRequest)) {
            return false;
        }
        CreateEventDestinationRequest other = (CreateEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestinationName(), other.eventDestinationName())
                && hasMatchingEventTypes() == other.hasMatchingEventTypes()
                && Objects.equals(matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings())
                && Objects.equals(cloudWatchLogsDestination(), other.cloudWatchLogsDestination())
                && Objects.equals(kinesisFirehoseDestination(), other.kinesisFirehoseDestination())
                && Objects.equals(snsDestination(), other.snsDestination()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventDestinationRequest").add("ConfigurationSetName", configurationSetName())
                .add("EventDestinationName", eventDestinationName())
                .add("MatchingEventTypes", hasMatchingEventTypes() ? matchingEventTypesAsStrings() : null)
                .add("CloudWatchLogsDestination", cloudWatchLogsDestination())
                .add("KinesisFirehoseDestination", kinesisFirehoseDestination()).add("SnsDestination", snsDestination())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestinationName":
            return Optional.ofNullable(clazz.cast(eventDestinationName()));
        case "MatchingEventTypes":
            return Optional.ofNullable(clazz.cast(matchingEventTypesAsStrings()));
        case "CloudWatchLogsDestination":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsDestination()));
        case "KinesisFirehoseDestination":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseDestination()));
        case "SnsDestination":
            return Optional.ofNullable(clazz.cast(snsDestination()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventDestinationRequest, T> g) {
        return obj -> g.apply((CreateEventDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEventDestinationRequest> {
        /**
         * <p>
         * Either the name of the configuration set or the configuration set ARN to apply event logging to. The
         * ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a> action.
         * </p>
         * 
         * @param configurationSetName
         *        Either the name of the configuration set or the configuration set ARN to apply event logging to. The
         *        ConfigurateSetName and ConfigurationSetArn can be found using the <a>DescribeConfigurationSets</a>
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The name that identifies the event destination.
         * </p>
         * 
         * @param eventDestinationName
         *        The name that identifies the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinationName(String eventDestinationName);

        /**
         * <p>
         * An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging SMS
         * and Voice logs every event type.
         * </p>
         * <note>
         * <p>
         * The <code>TEXT_SENT</code> event type is not supported.
         * </p>
         * </note>
         * 
         * @param matchingEventTypes
         *        An array of event types that determine which events to log. If "ALL" is used, then AWS End User
         *        Messaging SMS and Voice logs every event type.</p> <note>
         *        <p>
         *        The <code>TEXT_SENT</code> event type is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes);

        /**
         * <p>
         * An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging SMS
         * and Voice logs every event type.
         * </p>
         * <note>
         * <p>
         * The <code>TEXT_SENT</code> event type is not supported.
         * </p>
         * </note>
         * 
         * @param matchingEventTypes
         *        An array of event types that determine which events to log. If "ALL" is used, then AWS End User
         *        Messaging SMS and Voice logs every event type.</p> <note>
         *        <p>
         *        The <code>TEXT_SENT</code> event type is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypesWithStrings(String... matchingEventTypes);

        /**
         * <p>
         * An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging SMS
         * and Voice logs every event type.
         * </p>
         * <note>
         * <p>
         * The <code>TEXT_SENT</code> event type is not supported.
         * </p>
         * </note>
         * 
         * @param matchingEventTypes
         *        An array of event types that determine which events to log. If "ALL" is used, then AWS End User
         *        Messaging SMS and Voice logs every event type.</p> <note>
         *        <p>
         *        The <code>TEXT_SENT</code> event type is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypes(Collection<EventType> matchingEventTypes);

        /**
         * <p>
         * An array of event types that determine which events to log. If "ALL" is used, then AWS End User Messaging SMS
         * and Voice logs every event type.
         * </p>
         * <note>
         * <p>
         * The <code>TEXT_SENT</code> event type is not supported.
         * </p>
         * </note>
         * 
         * @param matchingEventTypes
         *        An array of event types that determine which events to log. If "ALL" is used, then AWS End User
         *        Messaging SMS and Voice logs every event type.</p> <note>
         *        <p>
         *        The <code>TEXT_SENT</code> event type is not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypes(EventType... matchingEventTypes);

        /**
         * <p>
         * An object that contains information about an event destination for logging to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchLogsDestination
         *        An object that contains information about an event destination for logging to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination);

        /**
         * <p>
         * An object that contains information about an event destination for logging to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsDestination.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogsDestination(CloudWatchLogsDestination)}.
         * 
         * @param cloudWatchLogsDestination
         *        a consumer that will call methods on {@link CloudWatchLogsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsDestination(CloudWatchLogsDestination)
         */
        default Builder cloudWatchLogsDestination(Consumer<CloudWatchLogsDestination.Builder> cloudWatchLogsDestination) {
            return cloudWatchLogsDestination(CloudWatchLogsDestination.builder().applyMutation(cloudWatchLogsDestination).build());
        }

        /**
         * <p>
         * An object that contains information about an event destination for logging to Amazon Data Firehose.
         * </p>
         * 
         * @param kinesisFirehoseDestination
         *        An object that contains information about an event destination for logging to Amazon Data Firehose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination);

        /**
         * <p>
         * An object that contains information about an event destination for logging to Amazon Data Firehose.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisFirehoseDestination.Builder}
         * avoiding the need to create one manually via {@link KinesisFirehoseDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisFirehoseDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisFirehoseDestination(KinesisFirehoseDestination)}.
         * 
         * @param kinesisFirehoseDestination
         *        a consumer that will call methods on {@link KinesisFirehoseDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseDestination(KinesisFirehoseDestination)
         */
        default Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return kinesisFirehoseDestination(KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)
                    .build());
        }

        /**
         * <p>
         * An object that contains information about an event destination for logging to Amazon SNS.
         * </p>
         * 
         * @param snsDestination
         *        An object that contains information about an event destination for logging to Amazon SNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsDestination(SnsDestination snsDestination);

        /**
         * <p>
         * An object that contains information about an event destination for logging to Amazon SNS.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnsDestination.Builder} avoiding the need
         * to create one manually via {@link SnsDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnsDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #snsDestination(SnsDestination)}.
         * 
         * @param snsDestination
         *        a consumer that will call methods on {@link SnsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsDestination(SnsDestination)
         */
        default Builder snsDestination(Consumer<SnsDestination.Builder> snsDestination) {
            return snsDestination(SnsDestination.builder().applyMutation(snsDestination).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, a randomly generated token is used for the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, a randomly generated token is used for the request to ensure
         *        idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String configurationSetName;

        private String eventDestinationName;

        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();

        private CloudWatchLogsDestination cloudWatchLogsDestination;

        private KinesisFirehoseDestination kinesisFirehoseDestination;

        private SnsDestination snsDestination;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventDestinationRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            eventDestinationName(model.eventDestinationName);
            matchingEventTypesWithStrings(model.matchingEventTypes);
            cloudWatchLogsDestination(model.cloudWatchLogsDestination);
            kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            snsDestination(model.snsDestination);
            clientToken(model.clientToken);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getEventDestinationName() {
            return eventDestinationName;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final Collection<String> getMatchingEventTypes() {
            if (matchingEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return matchingEventTypes;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypeListCopier.copy(matchingEventTypes);
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypeListCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String... matchingEventTypes) {
            matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypeListCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType... matchingEventTypes) {
            matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final CloudWatchLogsDestination.Builder getCloudWatchLogsDestination() {
            return cloudWatchLogsDestination != null ? cloudWatchLogsDestination.toBuilder() : null;
        }

        public final void setCloudWatchLogsDestination(CloudWatchLogsDestination.BuilderImpl cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination != null ? cloudWatchLogsDestination.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination;
            return this;
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return kinesisFirehoseDestination != null ? kinesisFirehoseDestination.toBuilder() : null;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final SnsDestination.Builder getSnsDestination() {
            return snsDestination != null ? snsDestination.toBuilder() : null;
        }

        public final void setSnsDestination(SnsDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        @Override
        public final Builder snsDestination(SnsDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventDestinationRequest build() {
            return new CreateEventDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
