/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAccountDefaultProtectConfigurationResponse extends PinpointSmsVoiceV2Response
        implements
        ToCopyableBuilder<DeleteAccountDefaultProtectConfigurationResponse.Builder, DeleteAccountDefaultProtectConfigurationResponse> {
    private static final SdkField<String> DEFAULT_PROTECT_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultProtectConfigurationArn")
            .getter(getter(DeleteAccountDefaultProtectConfigurationResponse::defaultProtectConfigurationArn))
            .setter(setter(Builder::defaultProtectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultProtectConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DEFAULT_PROTECT_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultProtectConfigurationId")
            .getter(getter(DeleteAccountDefaultProtectConfigurationResponse::defaultProtectConfigurationId))
            .setter(setter(Builder::defaultProtectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultProtectConfigurationId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_PROTECT_CONFIGURATION_ARN_FIELD, DEFAULT_PROTECT_CONFIGURATION_ID_FIELD));

    private final String defaultProtectConfigurationArn;

    private final String defaultProtectConfigurationId;

    private DeleteAccountDefaultProtectConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.defaultProtectConfigurationArn = builder.defaultProtectConfigurationArn;
        this.defaultProtectConfigurationId = builder.defaultProtectConfigurationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the account default protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the account default protect configuration.
     */
    public final String defaultProtectConfigurationArn() {
        return defaultProtectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier of the account default protect configuration.
     * </p>
     * 
     * @return The unique identifier of the account default protect configuration.
     */
    public final String defaultProtectConfigurationId() {
        return defaultProtectConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(defaultProtectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultProtectConfigurationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccountDefaultProtectConfigurationResponse)) {
            return false;
        }
        DeleteAccountDefaultProtectConfigurationResponse other = (DeleteAccountDefaultProtectConfigurationResponse) obj;
        return Objects.equals(defaultProtectConfigurationArn(), other.defaultProtectConfigurationArn())
                && Objects.equals(defaultProtectConfigurationId(), other.defaultProtectConfigurationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAccountDefaultProtectConfigurationResponse")
                .add("DefaultProtectConfigurationArn", defaultProtectConfigurationArn())
                .add("DefaultProtectConfigurationId", defaultProtectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(defaultProtectConfigurationArn()));
        case "DefaultProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(defaultProtectConfigurationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccountDefaultProtectConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteAccountDefaultProtectConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAccountDefaultProtectConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the account default protect configuration.
         * </p>
         * 
         * @param defaultProtectConfigurationArn
         *        The Amazon Resource Name (ARN) of the account default protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultProtectConfigurationArn(String defaultProtectConfigurationArn);

        /**
         * <p>
         * The unique identifier of the account default protect configuration.
         * </p>
         * 
         * @param defaultProtectConfigurationId
         *        The unique identifier of the account default protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultProtectConfigurationId(String defaultProtectConfigurationId);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String defaultProtectConfigurationArn;

        private String defaultProtectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccountDefaultProtectConfigurationResponse model) {
            super(model);
            defaultProtectConfigurationArn(model.defaultProtectConfigurationArn);
            defaultProtectConfigurationId(model.defaultProtectConfigurationId);
        }

        public final String getDefaultProtectConfigurationArn() {
            return defaultProtectConfigurationArn;
        }

        public final void setDefaultProtectConfigurationArn(String defaultProtectConfigurationArn) {
            this.defaultProtectConfigurationArn = defaultProtectConfigurationArn;
        }

        @Override
        public final Builder defaultProtectConfigurationArn(String defaultProtectConfigurationArn) {
            this.defaultProtectConfigurationArn = defaultProtectConfigurationArn;
            return this;
        }

        public final String getDefaultProtectConfigurationId() {
            return defaultProtectConfigurationId;
        }

        public final void setDefaultProtectConfigurationId(String defaultProtectConfigurationId) {
            this.defaultProtectConfigurationId = defaultProtectConfigurationId;
        }

        @Override
        public final Builder defaultProtectConfigurationId(String defaultProtectConfigurationId) {
            this.defaultProtectConfigurationId = defaultProtectConfigurationId;
            return this;
        }

        @Override
        public DeleteAccountDefaultProtectConfigurationResponse build() {
            return new DeleteAccountDefaultProtectConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
