/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProtectConfigurationCountryRuleSetRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<GetProtectConfigurationCountryRuleSetRequest.Builder, GetProtectConfigurationCountryRuleSetRequest> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(GetProtectConfigurationCountryRuleSetRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<String> NUMBER_CAPABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberCapability")
            .getter(getter(GetProtectConfigurationCountryRuleSetRequest::numberCapabilityAsString))
            .setter(setter(Builder::numberCapability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ID_FIELD, NUMBER_CAPABILITY_FIELD));

    private final String protectConfigurationId;

    private final String numberCapability;

    private GetProtectConfigurationCountryRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationId = builder.protectConfigurationId;
        this.numberCapability = builder.numberCapability;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>, <code>VOICE</code>, or
     * <code>MMS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberCapability}
     * will return {@link NumberCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberCapabilityAsString}.
     * </p>
     * 
     * @return The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>,
     *         <code>VOICE</code>, or <code>MMS</code>.
     * @see NumberCapability
     */
    public final NumberCapability numberCapability() {
        return NumberCapability.fromValue(numberCapability);
    }

    /**
     * <p>
     * The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>, <code>VOICE</code>, or
     * <code>MMS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberCapability}
     * will return {@link NumberCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberCapabilityAsString}.
     * </p>
     * 
     * @return The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>,
     *         <code>VOICE</code>, or <code>MMS</code>.
     * @see NumberCapability
     */
    public final String numberCapabilityAsString() {
        return numberCapability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(numberCapabilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtectConfigurationCountryRuleSetRequest)) {
            return false;
        }
        GetProtectConfigurationCountryRuleSetRequest other = (GetProtectConfigurationCountryRuleSetRequest) obj;
        return Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(numberCapabilityAsString(), other.numberCapabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProtectConfigurationCountryRuleSetRequest")
                .add("ProtectConfigurationId", protectConfigurationId()).add("NumberCapability", numberCapabilityAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "NumberCapability":
            return Optional.ofNullable(clazz.cast(numberCapabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtectConfigurationCountryRuleSetRequest, T> g) {
        return obj -> g.apply((GetProtectConfigurationCountryRuleSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProtectConfigurationCountryRuleSetRequest> {
        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>, <code>VOICE</code>,
         * or <code>MMS</code>.
         * </p>
         * 
         * @param numberCapability
         *        The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>,
         *        <code>VOICE</code>, or <code>MMS</code>.
         * @see NumberCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberCapability
         */
        Builder numberCapability(String numberCapability);

        /**
         * <p>
         * The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>, <code>VOICE</code>,
         * or <code>MMS</code>.
         * </p>
         * 
         * @param numberCapability
         *        The capability type to return the CountryRuleSet for. Valid values are <code>SMS</code>,
         *        <code>VOICE</code>, or <code>MMS</code>.
         * @see NumberCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberCapability
         */
        Builder numberCapability(NumberCapability numberCapability);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String protectConfigurationId;

        private String numberCapability;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtectConfigurationCountryRuleSetRequest model) {
            super(model);
            protectConfigurationId(model.protectConfigurationId);
            numberCapability(model.numberCapability);
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getNumberCapability() {
            return numberCapability;
        }

        public final void setNumberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
        }

        @Override
        public final Builder numberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
            return this;
        }

        @Override
        public final Builder numberCapability(NumberCapability numberCapability) {
            this.numberCapability(numberCapability == null ? null : numberCapability.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProtectConfigurationCountryRuleSetRequest build() {
            return new GetProtectConfigurationCountryRuleSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
