/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProtectConfigurationCountryRuleSetResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<GetProtectConfigurationCountryRuleSetResponse.Builder, GetProtectConfigurationCountryRuleSetResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationArn")
            .getter(getter(GetProtectConfigurationCountryRuleSetResponse::protectConfigurationArn))
            .setter(setter(Builder::protectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(GetProtectConfigurationCountryRuleSetResponse::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<String> NUMBER_CAPABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberCapability")
            .getter(getter(GetProtectConfigurationCountryRuleSetResponse::numberCapabilityAsString))
            .setter(setter(Builder::numberCapability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapability").build()).build();

    private static final SdkField<Map<String, ProtectConfigurationCountryRuleSetInformation>> COUNTRY_RULE_SET_FIELD = SdkField
            .<Map<String, ProtectConfigurationCountryRuleSetInformation>> builder(MarshallingType.MAP)
            .memberName("CountryRuleSet")
            .getter(getter(GetProtectConfigurationCountryRuleSetResponse::countryRuleSet))
            .setter(setter(Builder::countryRuleSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryRuleSet").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ProtectConfigurationCountryRuleSetInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectConfigurationCountryRuleSetInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, NUMBER_CAPABILITY_FIELD, COUNTRY_RULE_SET_FIELD));

    private final String protectConfigurationArn;

    private final String protectConfigurationId;

    private final String numberCapability;

    private final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet;

    private GetProtectConfigurationCountryRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.numberCapability = builder.numberCapability;
        this.countryRuleSet = builder.countryRuleSet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protect configuration.
     */
    public final String protectConfigurationArn() {
        return protectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberCapability}
     * will return {@link NumberCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberCapabilityAsString}.
     * </p>
     * 
     * @return The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.
     * @see NumberCapability
     */
    public final NumberCapability numberCapability() {
        return NumberCapability.fromValue(numberCapability);
    }

    /**
     * <p>
     * The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberCapability}
     * will return {@link NumberCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberCapabilityAsString}.
     * </p>
     * 
     * @return The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.
     * @see NumberCapability
     */
    public final String numberCapabilityAsString() {
        return numberCapability;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountryRuleSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCountryRuleSet() {
        return countryRuleSet != null && !(countryRuleSet instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested
     * NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">Supported
     * countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountryRuleSet} method.
     * </p>
     * 
     * @return A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested
     *         NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes,
     *         see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">
     *         Supported countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
     */
    public final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet() {
        return countryRuleSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(numberCapabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCountryRuleSet() ? countryRuleSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtectConfigurationCountryRuleSetResponse)) {
            return false;
        }
        GetProtectConfigurationCountryRuleSetResponse other = (GetProtectConfigurationCountryRuleSetResponse) obj;
        return Objects.equals(protectConfigurationArn(), other.protectConfigurationArn())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(numberCapabilityAsString(), other.numberCapabilityAsString())
                && hasCountryRuleSet() == other.hasCountryRuleSet() && Objects.equals(countryRuleSet(), other.countryRuleSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProtectConfigurationCountryRuleSetResponse")
                .add("ProtectConfigurationArn", protectConfigurationArn())
                .add("ProtectConfigurationId", protectConfigurationId()).add("NumberCapability", numberCapabilityAsString())
                .add("CountryRuleSet", hasCountryRuleSet() ? countryRuleSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(protectConfigurationArn()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "NumberCapability":
            return Optional.ofNullable(clazz.cast(numberCapabilityAsString()));
        case "CountryRuleSet":
            return Optional.ofNullable(clazz.cast(countryRuleSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtectConfigurationCountryRuleSetResponse, T> g) {
        return obj -> g.apply((GetProtectConfigurationCountryRuleSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProtectConfigurationCountryRuleSetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protect configuration.
         * </p>
         * 
         * @param protectConfigurationArn
         *        The Amazon Resource Name (ARN) of the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationArn(String protectConfigurationArn);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.
         * </p>
         * 
         * @param numberCapability
         *        The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation
         *        objects.
         * @see NumberCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberCapability
         */
        Builder numberCapability(String numberCapability);

        /**
         * <p>
         * The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation objects.
         * </p>
         * 
         * @param numberCapability
         *        The capability type associated with the returned ProtectConfigurationCountryRuleSetInformation
         *        objects.
         * @see NumberCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberCapability
         */
        Builder numberCapability(NumberCapability numberCapability);

        /**
         * <p>
         * A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested
         * NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes, see
         * <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">Supported
         * countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
         * </p>
         * 
         * @param countryRuleSet
         *        A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the
         *        requested NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO
         *        country codes, see <a
         *        href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html"
         *        >Supported countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryRuleSet(Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String protectConfigurationArn;

        private String protectConfigurationId;

        private String numberCapability;

        private Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtectConfigurationCountryRuleSetResponse model) {
            super(model);
            protectConfigurationArn(model.protectConfigurationArn);
            protectConfigurationId(model.protectConfigurationId);
            numberCapability(model.numberCapability);
            countryRuleSet(model.countryRuleSet);
        }

        public final String getProtectConfigurationArn() {
            return protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getNumberCapability() {
            return numberCapability;
        }

        public final void setNumberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
        }

        @Override
        public final Builder numberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
            return this;
        }

        @Override
        public final Builder numberCapability(NumberCapability numberCapability) {
            this.numberCapability(numberCapability == null ? null : numberCapability.toString());
            return this;
        }

        public final Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> getCountryRuleSet() {
            Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> result = ProtectConfigurationCountryRuleSetCopier
                    .copyToBuilder(this.countryRuleSet);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCountryRuleSet(Map<String, ProtectConfigurationCountryRuleSetInformation.BuilderImpl> countryRuleSet) {
            this.countryRuleSet = ProtectConfigurationCountryRuleSetCopier.copyFromBuilder(countryRuleSet);
        }

        @Override
        public final Builder countryRuleSet(Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet) {
            this.countryRuleSet = ProtectConfigurationCountryRuleSetCopier.copy(countryRuleSet);
            return this;
        }

        @Override
        public GetProtectConfigurationCountryRuleSetResponse build() {
            return new GetProtectConfigurationCountryRuleSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
