/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendVoiceMessageRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<SendVoiceMessageRequest.Builder, SendVoiceMessageRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(SendVoiceMessageRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(SendVoiceMessageRequest::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageBody").getter(getter(SendVoiceMessageRequest::messageBody)).setter(setter(Builder::messageBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()).build();

    private static final SdkField<String> MESSAGE_BODY_TEXT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageBodyTextType").getter(getter(SendVoiceMessageRequest::messageBodyTextTypeAsString))
            .setter(setter(Builder::messageBodyTextType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBodyTextType").build())
            .build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceId").getter(getter(SendVoiceMessageRequest::voiceIdAsString)).setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()).build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(SendVoiceMessageRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> MAX_PRICE_PER_MINUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxPricePerMinute").getter(getter(SendVoiceMessageRequest::maxPricePerMinute))
            .setter(setter(Builder::maxPricePerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPricePerMinute").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeToLive").getter(getter(SendVoiceMessageRequest::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Context")
            .getter(getter(SendVoiceMessageRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(SendVoiceMessageRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(SendVoiceMessageRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_IDENTITY_FIELD, MESSAGE_BODY_FIELD, MESSAGE_BODY_TEXT_TYPE_FIELD,
            VOICE_ID_FIELD, CONFIGURATION_SET_NAME_FIELD, MAX_PRICE_PER_MINUTE_FIELD, TIME_TO_LIVE_FIELD, CONTEXT_FIELD,
            DRY_RUN_FIELD, PROTECT_CONFIGURATION_ID_FIELD));

    private final String destinationPhoneNumber;

    private final String originationIdentity;

    private final String messageBody;

    private final String messageBodyTextType;

    private final String voiceId;

    private final String configurationSetName;

    private final String maxPricePerMinute;

    private final Integer timeToLive;

    private final Map<String, String> context;

    private final Boolean dryRun;

    private final String protectConfigurationId;

    private SendVoiceMessageRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationIdentity = builder.originationIdentity;
        this.messageBody = builder.messageBody;
        this.messageBodyTextType = builder.messageBodyTextType;
        this.voiceId = builder.voiceId;
        this.configurationSetName = builder.configurationSetName;
        this.maxPricePerMinute = builder.maxPricePerMinute;
        this.timeToLive = builder.timeToLive;
        this.context = builder.context;
        this.dryRun = builder.dryRun;
        this.protectConfigurationId = builder.protectConfigurationId;
    }

    /**
     * <p>
     * The destination phone number in E.164 format.
     * </p>
     * 
     * @return The destination phone number in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId, PhoneNumberArn,
     * PoolId, or PoolArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId,
     *         PhoneNumberArn, PoolId, or PoolArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The text to convert to a voice message.
     * </p>
     * 
     * @return The text to convert to a voice message.
     */
    public final String messageBody() {
        return messageBody;
    }

    /**
     * <p>
     * Specifies if the MessageBody field contains text or <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * TEXT: This is the default value. When used the maximum character limit is 3000.
     * </p>
     * </li>
     * <li>
     * <p>
     * SSML: When used the maximum character limit is 6000 including SSML tagging.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #messageBodyTextType} will return {@link VoiceMessageBodyTextType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #messageBodyTextTypeAsString}.
     * </p>
     * 
     * @return Specifies if the MessageBody field contains text or <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language
     *         (SSML)</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TEXT: This is the default value. When used the maximum character limit is 3000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSML: When used the maximum character limit is 6000 including SSML tagging.
     *         </p>
     *         </li>
     * @see VoiceMessageBodyTextType
     */
    public final VoiceMessageBodyTextType messageBodyTextType() {
        return VoiceMessageBodyTextType.fromValue(messageBodyTextType);
    }

    /**
     * <p>
     * Specifies if the MessageBody field contains text or <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * TEXT: This is the default value. When used the maximum character limit is 3000.
     * </p>
     * </li>
     * <li>
     * <p>
     * SSML: When used the maximum character limit is 6000 including SSML tagging.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #messageBodyTextType} will return {@link VoiceMessageBodyTextType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #messageBodyTextTypeAsString}.
     * </p>
     * 
     * @return Specifies if the MessageBody field contains text or <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language
     *         (SSML)</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TEXT: This is the default value. When used the maximum character limit is 3000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSML: When used the maximum character limit is 6000 including SSML tagging.
     *         </p>
     *         </li>
     * @see VoiceMessageBodyTextType
     */
    public final String messageBodyTextTypeAsString() {
        return messageBodyTextType;
    }

    /**
     * <p>
     * The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to
     * use. By default this is set to "MATTHEW".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #voiceId} will
     * return {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voiceIdAsString}.
     * </p>
     * 
     * @return The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a>
     *         service to use. By default this is set to "MATTHEW".
     * @see VoiceId
     */
    public final VoiceId voiceId() {
        return VoiceId.fromValue(voiceId);
    }

    /**
     * <p>
     * The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service to
     * use. By default this is set to "MATTHEW".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #voiceId} will
     * return {@link VoiceId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voiceIdAsString}.
     * </p>
     * 
     * @return The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a>
     *         service to use. By default this is set to "MATTHEW".
     * @see VoiceId
     */
    public final String voiceIdAsString() {
        return voiceId;
    }

    /**
     * <p>
     * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
     * </p>
     * 
     * @return The name of the configuration set to use. This can be either the ConfigurationSetName or
     *         ConfigurationSetArn.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The maximum amount to spend per voice message, in US dollars.
     * </p>
     * 
     * @return The maximum amount to spend per voice message, in US dollars.
     */
    public final String maxPricePerMinute() {
        return maxPricePerMinute;
    }

    /**
     * <p>
     * How long the voice message is valid for. By default this is 72 hours.
     * </p>
     * 
     * @return How long the voice message is valid for. By default this is 72 hours.
     */
    public final Integer timeToLive() {
        return timeToLive;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can specify custom data in this field. If you do, that data is logged to the event destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return You can specify custom data in this field. If you do, that data is logged to the event destination.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * When set to true, the message is checked and validated, but isn't sent to the end recipient.
     * </p>
     * 
     * @return When set to true, the message is checked and validated, but isn't sent to the end recipient.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(messageBodyTextTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(voiceIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(maxPricePerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendVoiceMessageRequest)) {
            return false;
        }
        SendVoiceMessageRequest other = (SendVoiceMessageRequest) obj;
        return Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(messageBody(), other.messageBody())
                && Objects.equals(messageBodyTextTypeAsString(), other.messageBodyTextTypeAsString())
                && Objects.equals(voiceIdAsString(), other.voiceIdAsString())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(maxPricePerMinute(), other.maxPricePerMinute())
                && Objects.equals(timeToLive(), other.timeToLive()) && hasContext() == other.hasContext()
                && Objects.equals(context(), other.context()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendVoiceMessageRequest").add("DestinationPhoneNumber", destinationPhoneNumber())
                .add("OriginationIdentity", originationIdentity()).add("MessageBody", messageBody())
                .add("MessageBodyTextType", messageBodyTextTypeAsString()).add("VoiceId", voiceIdAsString())
                .add("ConfigurationSetName", configurationSetName()).add("MaxPricePerMinute", maxPricePerMinute())
                .add("TimeToLive", timeToLive()).add("Context", hasContext() ? context() : null).add("DryRun", dryRun())
                .add("ProtectConfigurationId", protectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "MessageBody":
            return Optional.ofNullable(clazz.cast(messageBody()));
        case "MessageBodyTextType":
            return Optional.ofNullable(clazz.cast(messageBodyTextTypeAsString()));
        case "VoiceId":
            return Optional.ofNullable(clazz.cast(voiceIdAsString()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "MaxPricePerMinute":
            return Optional.ofNullable(clazz.cast(maxPricePerMinute()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendVoiceMessageRequest, T> g) {
        return obj -> g.apply((SendVoiceMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SendVoiceMessageRequest> {
        /**
         * <p>
         * The destination phone number in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The destination phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId,
         * PhoneNumberArn, PoolId, or PoolArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param originationIdentity
         *        The origination identity to use for the voice call. This can be the PhoneNumber, PhoneNumberId,
         *        PhoneNumberArn, PoolId, or PoolArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The text to convert to a voice message.
         * </p>
         * 
         * @param messageBody
         *        The text to convert to a voice message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageBody(String messageBody);

        /**
         * <p>
         * Specifies if the MessageBody field contains text or <a
         * href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TEXT: This is the default value. When used the maximum character limit is 3000.
         * </p>
         * </li>
         * <li>
         * <p>
         * SSML: When used the maximum character limit is 6000 including SSML tagging.
         * </p>
         * </li>
         * </ul>
         * 
         * @param messageBodyTextType
         *        Specifies if the MessageBody field contains text or <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language
         *        (SSML)</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TEXT: This is the default value. When used the maximum character limit is 3000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SSML: When used the maximum character limit is 6000 including SSML tagging.
         *        </p>
         *        </li>
         * @see VoiceMessageBodyTextType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceMessageBodyTextType
         */
        Builder messageBodyTextType(String messageBodyTextType);

        /**
         * <p>
         * Specifies if the MessageBody field contains text or <a
         * href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language (SSML)</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * TEXT: This is the default value. When used the maximum character limit is 3000.
         * </p>
         * </li>
         * <li>
         * <p>
         * SSML: When used the maximum character limit is 6000 including SSML tagging.
         * </p>
         * </li>
         * </ul>
         * 
         * @param messageBodyTextType
         *        Specifies if the MessageBody field contains text or <a
         *        href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">speech synthesis markup language
         *        (SSML)</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TEXT: This is the default value. When used the maximum character limit is 3000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SSML: When used the maximum character limit is 6000 including SSML tagging.
         *        </p>
         *        </li>
         * @see VoiceMessageBodyTextType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceMessageBodyTextType
         */
        Builder messageBodyTextType(VoiceMessageBodyTextType messageBodyTextType);

        /**
         * <p>
         * The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service
         * to use. By default this is set to "MATTHEW".
         * </p>
         * 
         * @param voiceId
         *        The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a>
         *        service to use. By default this is set to "MATTHEW".
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder voiceId(String voiceId);

        /**
         * <p>
         * The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a> service
         * to use. By default this is set to "MATTHEW".
         * </p>
         * 
         * @param voiceId
         *        The voice for the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly</a>
         *        service to use. By default this is set to "MATTHEW".
         * @see VoiceId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceId
         */
        Builder voiceId(VoiceId voiceId);

        /**
         * <p>
         * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to use. This can be either the ConfigurationSetName or
         *        ConfigurationSetArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The maximum amount to spend per voice message, in US dollars.
         * </p>
         * 
         * @param maxPricePerMinute
         *        The maximum amount to spend per voice message, in US dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPricePerMinute(String maxPricePerMinute);

        /**
         * <p>
         * How long the voice message is valid for. By default this is 72 hours.
         * </p>
         * 
         * @param timeToLive
         *        How long the voice message is valid for. By default this is 72 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * <p>
         * You can specify custom data in this field. If you do, that data is logged to the event destination.
         * </p>
         * 
         * @param context
         *        You can specify custom data in this field. If you do, that data is logged to the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * When set to true, the message is checked and validated, but isn't sent to the end recipient.
         * </p>
         * 
         * @param dryRun
         *        When set to true, the message is checked and validated, but isn't sent to the end recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String destinationPhoneNumber;

        private String originationIdentity;

        private String messageBody;

        private String messageBodyTextType;

        private String voiceId;

        private String configurationSetName;

        private String maxPricePerMinute;

        private Integer timeToLive;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private Boolean dryRun;

        private String protectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendVoiceMessageRequest model) {
            super(model);
            destinationPhoneNumber(model.destinationPhoneNumber);
            originationIdentity(model.originationIdentity);
            messageBody(model.messageBody);
            messageBodyTextType(model.messageBodyTextType);
            voiceId(model.voiceId);
            configurationSetName(model.configurationSetName);
            maxPricePerMinute(model.maxPricePerMinute);
            timeToLive(model.timeToLive);
            context(model.context);
            dryRun(model.dryRun);
            protectConfigurationId(model.protectConfigurationId);
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getMessageBody() {
            return messageBody;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final String getMessageBodyTextType() {
            return messageBodyTextType;
        }

        public final void setMessageBodyTextType(String messageBodyTextType) {
            this.messageBodyTextType = messageBodyTextType;
        }

        @Override
        public final Builder messageBodyTextType(String messageBodyTextType) {
            this.messageBodyTextType = messageBodyTextType;
            return this;
        }

        @Override
        public final Builder messageBodyTextType(VoiceMessageBodyTextType messageBodyTextType) {
            this.messageBodyTextType(messageBodyTextType == null ? null : messageBodyTextType.toString());
            return this;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId == null ? null : voiceId.toString());
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMaxPricePerMinute() {
            return maxPricePerMinute;
        }

        public final void setMaxPricePerMinute(String maxPricePerMinute) {
            this.maxPricePerMinute = maxPricePerMinute;
        }

        @Override
        public final Builder maxPricePerMinute(String maxPricePerMinute) {
            this.maxPricePerMinute = maxPricePerMinute;
            return this;
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendVoiceMessageRequest build() {
            return new SendVoiceMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
