/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSetsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeConfigurationSetsResponse> {
    private static final SdkField<List<ConfigurationSetInformation>> CONFIGURATION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationSets").getter(DescribeConfigurationSetsResponse.getter(DescribeConfigurationSetsResponse::configurationSets)).setter(DescribeConfigurationSetsResponse.setter(Builder::configurationSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationSetInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConfigurationSetsResponse.getter(DescribeConfigurationSetsResponse::nextToken)).setter(DescribeConfigurationSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationSets", CONFIGURATION_SETS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfigurationSetInformation> configurationSets;
    private final String nextToken;

    private DescribeConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationSets() {
        return this.configurationSets != null && !(this.configurationSets instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationSetInformation> configurationSets() {
        return this.configurationSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationSets() ? this.configurationSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetsResponse)) {
            return false;
        }
        DescribeConfigurationSetsResponse other = (DescribeConfigurationSetsResponse)((Object)obj);
        return this.hasConfigurationSets() == other.hasConfigurationSets() && Objects.equals(this.configurationSets(), other.configurationSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationSetsResponse").add("ConfigurationSets", this.hasConfigurationSets() ? this.configurationSets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSets": {
                return Optional.ofNullable(clazz.cast(this.configurationSets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSetsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<ConfigurationSetInformation> configurationSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetsResponse model) {
            super(model);
            this.configurationSets(model.configurationSets);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationSetInformation.Builder> getConfigurationSets() {
            List<ConfigurationSetInformation.Builder> result = ConfigurationSetInformationListCopier.copyToBuilder(this.configurationSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationSets(Collection<ConfigurationSetInformation.BuilderImpl> configurationSets) {
            this.configurationSets = ConfigurationSetInformationListCopier.copyFromBuilder(configurationSets);
        }

        @Override
        public final Builder configurationSets(Collection<ConfigurationSetInformation> configurationSets) {
            this.configurationSets = ConfigurationSetInformationListCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(ConfigurationSetInformation ... configurationSets) {
            this.configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(Consumer<ConfigurationSetInformation.Builder> ... configurationSets) {
            this.configurationSets(Stream.of(configurationSets).map(c -> (ConfigurationSetInformation)((ConfigurationSetInformation.Builder)ConfigurationSetInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigurationSetsResponse build() {
            return new DescribeConfigurationSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationSetsResponse> {
        public Builder configurationSets(Collection<ConfigurationSetInformation> var1);

        public Builder configurationSets(ConfigurationSetInformation ... var1);

        public Builder configurationSets(Consumer<ConfigurationSetInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

