/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PhoneNumberInformation;

public class DescribePhoneNumbersPublisher
implements SdkPublisher<DescribePhoneNumbersResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribePhoneNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePhoneNumbersPublisher(PinpointSmsVoiceV2AsyncClient client, DescribePhoneNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePhoneNumbersPublisher(PinpointSmsVoiceV2AsyncClient client, DescribePhoneNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePhoneNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePhoneNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PhoneNumberInformation> phoneNumbers() {
        Function<DescribePhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumbers() != null) {
                return response.phoneNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePhoneNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePhoneNumbersResponseFetcher
    implements AsyncPageFetcher<DescribePhoneNumbersResponse> {
        private DescribePhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(DescribePhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePhoneNumbersResponse> nextPage(DescribePhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return DescribePhoneNumbersPublisher.this.client.describePhoneNumbers(DescribePhoneNumbersPublisher.this.firstRequest);
            }
            return DescribePhoneNumbersPublisher.this.client.describePhoneNumbers((DescribePhoneNumbersRequest)((Object)DescribePhoneNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

