/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProtectConfigurationResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<CreateProtectConfigurationResponse.Builder, CreateProtectConfigurationResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationArn").getter(getter(CreateProtectConfigurationResponse::protectConfigurationArn))
            .setter(setter(Builder::protectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(CreateProtectConfigurationResponse::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(CreateProtectConfigurationResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Boolean> ACCOUNT_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccountDefault").getter(getter(CreateProtectConfigurationResponse::accountDefault))
            .setter(setter(Builder::accountDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountDefault").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(CreateProtectConfigurationResponse::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateProtectConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, CREATED_TIMESTAMP_FIELD, ACCOUNT_DEFAULT_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationArn;

    private final String protectConfigurationId;

    private final Instant createdTimestamp;

    private final Boolean accountDefault;

    private final Boolean deletionProtectionEnabled;

    private final List<Tag> tags;

    private CreateProtectConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.createdTimestamp = builder.createdTimestamp;
        this.accountDefault = builder.accountDefault;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protect configuration.
     */
    public final String protectConfigurationArn() {
        return protectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * This is true if the protect configuration is set as your account default protect configuration.
     * </p>
     * 
     * @return This is true if the protect configuration is set as your account default protect configuration.
     */
    public final Boolean accountDefault() {
        return accountDefault;
    }

    /**
     * <p>
     * When set to true deletion protection is enabled. By default this is set to false.
     * </p>
     * 
     * @return When set to true deletion protection is enabled. By default this is set to false.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key and value pair tags that are associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key and value pair tags that are associated with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(accountDefault());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProtectConfigurationResponse)) {
            return false;
        }
        CreateProtectConfigurationResponse other = (CreateProtectConfigurationResponse) obj;
        return Objects.equals(protectConfigurationArn(), other.protectConfigurationArn())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(accountDefault(), other.accountDefault())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProtectConfigurationResponse").add("ProtectConfigurationArn", protectConfigurationArn())
                .add("ProtectConfigurationId", protectConfigurationId()).add("CreatedTimestamp", createdTimestamp())
                .add("AccountDefault", accountDefault()).add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(protectConfigurationArn()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "AccountDefault":
            return Optional.ofNullable(clazz.cast(accountDefault()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("AccountDefault", ACCOUNT_DEFAULT_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProtectConfigurationResponse, T> g) {
        return obj -> g.apply((CreateProtectConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProtectConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protect configuration.
         * </p>
         * 
         * @param protectConfigurationArn
         *        The Amazon Resource Name (ARN) of the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationArn(String protectConfigurationArn);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         * time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the protect configuration was created, in <a href="https://www.epochconverter.com/">UNIX
         *        epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * This is true if the protect configuration is set as your account default protect configuration.
         * </p>
         * 
         * @param accountDefault
         *        This is true if the protect configuration is set as your account default protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefault(Boolean accountDefault);

        /**
         * <p>
         * When set to true deletion protection is enabled. By default this is set to false.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        When set to true deletion protection is enabled. By default this is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * An array of key and value pair tags that are associated with the resource.
         * </p>
         * 
         * @param tags
         *        An array of key and value pair tags that are associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key and value pair tags that are associated with the resource.
         * </p>
         * 
         * @param tags
         *        An array of key and value pair tags that are associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key and value pair tags that are associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String protectConfigurationArn;

        private String protectConfigurationId;

        private Instant createdTimestamp;

        private Boolean accountDefault;

        private Boolean deletionProtectionEnabled;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProtectConfigurationResponse model) {
            super(model);
            protectConfigurationArn(model.protectConfigurationArn);
            protectConfigurationId(model.protectConfigurationId);
            createdTimestamp(model.createdTimestamp);
            accountDefault(model.accountDefault);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            tags(model.tags);
        }

        public final String getProtectConfigurationArn() {
            return protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Boolean getAccountDefault() {
            return accountDefault;
        }

        public final void setAccountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
        }

        @Override
        public final Builder accountDefault(Boolean accountDefault) {
            this.accountDefault = accountDefault;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateProtectConfigurationResponse build() {
            return new CreateProtectConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
