/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVerifiedDestinationNumberResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<CreateVerifiedDestinationNumberResponse.Builder, CreateVerifiedDestinationNumberResponse> {
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberArn")
            .getter(getter(CreateVerifiedDestinationNumberResponse::verifiedDestinationNumberArn))
            .setter(setter(Builder::verifiedDestinationNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberArn")
                    .build()).build();

    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberId")
            .getter(getter(CreateVerifiedDestinationNumberResponse::verifiedDestinationNumberId))
            .setter(setter(Builder::verifiedDestinationNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberId")
                    .build()).build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(CreateVerifiedDestinationNumberResponse::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateVerifiedDestinationNumberResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateVerifiedDestinationNumberResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(CreateVerifiedDestinationNumberResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_DESTINATION_NUMBER_ARN_FIELD, VERIFIED_DESTINATION_NUMBER_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD,
            STATUS_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String verifiedDestinationNumberArn;

    private final String verifiedDestinationNumberId;

    private final String destinationPhoneNumber;

    private final String status;

    private final List<Tag> tags;

    private final Instant createdTimestamp;

    private CreateVerifiedDestinationNumberResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberArn = builder.verifiedDestinationNumberArn;
        this.verifiedDestinationNumberId = builder.verifiedDestinationNumberId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.status = builder.status;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the verified destination phone number.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the verified destination phone number.
     */
    public final String verifiedDestinationNumberArn() {
        return verifiedDestinationNumberArn;
    }

    /**
     * <p>
     * The unique identifier for the verified destination phone number.
     * </p>
     * 
     * @return The unique identifier for the verified destination phone number.
     */
    public final String verifiedDestinationNumberId() {
        return verifiedDestinationNumberId;
    }

    /**
     * <p>
     * The verified destination phone number, in E.164 format.
     * </p>
     * 
     * @return The verified destination phone number, in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The status of the verified destination phone number.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The phone number hasn't been verified yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED</code>: The phone number is verified and can receive messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the verified destination phone number.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The phone number hasn't been verified yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED</code>: The phone number is verified and can receive messages.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final VerificationStatus status() {
        return VerificationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the verified destination phone number.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The phone number hasn't been verified yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED</code>: The phone number is verified and can receive messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the verified destination phone number.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The phone number hasn't been verified yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED</code>: The phone number is verified and can receive messages.
     *         </p>
     *         </li>
     * @see VerificationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tags (key and value pairs) to associate with the destination number.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags (key and value pairs) to associate with the destination number.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The time when the verified phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     * time</a> format.
     * </p>
     * 
     * @return The time when the verified phone number was created, in <a href="https://www.epochconverter.com/">UNIX
     *         epoch time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedDestinationNumberResponse)) {
            return false;
        }
        CreateVerifiedDestinationNumberResponse other = (CreateVerifiedDestinationNumberResponse) obj;
        return Objects.equals(verifiedDestinationNumberArn(), other.verifiedDestinationNumberArn())
                && Objects.equals(verifiedDestinationNumberId(), other.verifiedDestinationNumberId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVerifiedDestinationNumberResponse")
                .add("VerifiedDestinationNumberArn", verifiedDestinationNumberArn())
                .add("VerifiedDestinationNumberId", verifiedDestinationNumberId())
                .add("DestinationPhoneNumber", destinationPhoneNumber()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedDestinationNumberArn":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberArn()));
        case "VerifiedDestinationNumberId":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedDestinationNumberArn", VERIFIED_DESTINATION_NUMBER_ARN_FIELD);
        map.put("VerifiedDestinationNumberId", VERIFIED_DESTINATION_NUMBER_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedDestinationNumberResponse, T> g) {
        return obj -> g.apply((CreateVerifiedDestinationNumberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVerifiedDestinationNumberResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberArn
         *        The Amazon Resource Name (ARN) for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn);

        /**
         * <p>
         * The unique identifier for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberId
         *        The unique identifier for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberId(String verifiedDestinationNumberId);

        /**
         * <p>
         * The verified destination phone number, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The verified destination phone number, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The status of the verified destination phone number.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The phone number hasn't been verified yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED</code>: The phone number is verified and can receive messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the verified destination phone number.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The phone number hasn't been verified yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED</code>: The phone number is verified and can receive messages.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the verified destination phone number.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The phone number hasn't been verified yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED</code>: The phone number is verified and can receive messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the verified destination phone number.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The phone number hasn't been verified yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED</code>: The phone number is verified and can receive messages.
         *        </p>
         *        </li>
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(VerificationStatus status);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the destination number.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the destination number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the destination number.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the destination number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the destination number.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The time when the verified phone number was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         * time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the verified phone number was created, in <a href="https://www.epochconverter.com/">UNIX
         *        epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String verifiedDestinationNumberArn;

        private String verifiedDestinationNumberId;

        private String destinationPhoneNumber;

        private String status;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedDestinationNumberResponse model) {
            super(model);
            verifiedDestinationNumberArn(model.verifiedDestinationNumberArn);
            verifiedDestinationNumberId(model.verifiedDestinationNumberId);
            destinationPhoneNumber(model.destinationPhoneNumber);
            status(model.status);
            tags(model.tags);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getVerifiedDestinationNumberArn() {
            return verifiedDestinationNumberArn;
        }

        public final void setVerifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
        }

        @Override
        public final Builder verifiedDestinationNumberArn(String verifiedDestinationNumberArn) {
            this.verifiedDestinationNumberArn = verifiedDestinationNumberArn;
            return this;
        }

        public final String getVerifiedDestinationNumberId() {
            return verifiedDestinationNumberId;
        }

        public final void setVerifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
        }

        @Override
        public final Builder verifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateVerifiedDestinationNumberResponse build() {
            return new CreateVerifiedDestinationNumberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
