/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOptOutListRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<DeleteOptOutListRequest.Builder, DeleteOptOutListRequest> {
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(DeleteOptOutListRequest::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String optOutListName;

    private DeleteOptOutListRequest(BuilderImpl builder) {
        super(builder);
        this.optOutListName = builder.optOutListName;
    }

    /**
     * <p>
     * The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <a>DescribeOptOutLists</a> to find
     * the values for OptOutListName and OptOutListArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <a>DescribeOptOutLists</a>
     *         to find the values for OptOutListName and OptOutListArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String optOutListName() {
        return optOutListName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOptOutListRequest)) {
            return false;
        }
        DeleteOptOutListRequest other = (DeleteOptOutListRequest) obj;
        return Objects.equals(optOutListName(), other.optOutListName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOptOutListRequest").add("OptOutListName", optOutListName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteOptOutListRequest, T> g) {
        return obj -> g.apply((DeleteOptOutListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteOptOutListRequest> {
        /**
         * <p>
         * The OptOutListName or OptOutListArn of the OptOutList to delete. You can use <a>DescribeOptOutLists</a> to
         * find the values for OptOutListName and OptOutListArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param optOutListName
         *        The OptOutListName or OptOutListArn of the OptOutList to delete. You can use
         *        <a>DescribeOptOutLists</a> to find the values for OptOutListName and OptOutListArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String optOutListName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOptOutListRequest model) {
            super(model);
            optOutListName(model.optOutListName);
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOptOutListRequest build() {
            return new DeleteOptOutListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
