/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOptOutListResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DeleteOptOutListResponse.Builder, DeleteOptOutListResponse> {
    private static final SdkField<String> OPT_OUT_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListArn").getter(getter(DeleteOptOutListResponse::optOutListArn))
            .setter(setter(Builder::optOutListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListArn").build()).build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(DeleteOptOutListResponse::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DeleteOptOutListResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_ARN_FIELD,
            OPT_OUT_LIST_NAME_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String optOutListArn;

    private final String optOutListName;

    private final Instant createdTimestamp;

    private DeleteOptOutListResponse(BuilderImpl builder) {
        super(builder);
        this.optOutListArn = builder.optOutListArn;
        this.optOutListName = builder.optOutListName;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OptOutList that was removed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OptOutList that was removed.
     */
    public final String optOutListArn() {
        return optOutListArn;
    }

    /**
     * <p>
     * The name of the OptOutList that was removed.
     * </p>
     * 
     * @return The name of the OptOutList that was removed.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     * format.
     * </p>
     * 
     * @return The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     *         time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optOutListArn());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOptOutListResponse)) {
            return false;
        }
        DeleteOptOutListResponse other = (DeleteOptOutListResponse) obj;
        return Objects.equals(optOutListArn(), other.optOutListArn()) && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOptOutListResponse").add("OptOutListArn", optOutListArn())
                .add("OptOutListName", optOutListName()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptOutListArn":
            return Optional.ofNullable(clazz.cast(optOutListArn()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptOutListArn", OPT_OUT_LIST_ARN_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteOptOutListResponse, T> g) {
        return obj -> g.apply((DeleteOptOutListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteOptOutListResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OptOutList that was removed.
         * </p>
         * 
         * @param optOutListArn
         *        The Amazon Resource Name (ARN) of the OptOutList that was removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListArn(String optOutListArn);

        /**
         * <p>
         * The name of the OptOutList that was removed.
         * </p>
         * 
         * @param optOutListName
         *        The name of the OptOutList that was removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         * format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the OptOutList was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         *        time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String optOutListArn;

        private String optOutListName;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOptOutListResponse model) {
            super(model);
            optOutListArn(model.optOutListArn);
            optOutListName(model.optOutListName);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getOptOutListArn() {
            return optOutListArn;
        }

        public final void setOptOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
        }

        @Override
        public final Builder optOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public DeleteOptOutListResponse build() {
            return new DeleteOptOutListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
