/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePoolsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribePoolsResponse.Builder, DescribePoolsResponse> {
    private static final SdkField<List<PoolInformation>> POOLS_FIELD = SdkField
            .<List<PoolInformation>> builder(MarshallingType.LIST)
            .memberName("Pools")
            .getter(getter(DescribePoolsResponse::pools))
            .setter(setter(Builder::pools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PoolInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PoolInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePoolsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(POOLS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PoolInformation> pools;

    private final String nextToken;

    private DescribePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.pools = builder.pools;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pools property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPools() {
        return pools != null && !(pools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of PoolInformation objects that contain the details for the requested pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPools} method.
     * </p>
     * 
     * @return An array of PoolInformation objects that contain the details for the requested pools.
     */
    public final List<PoolInformation> pools() {
        return pools;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. If this field is empty then there are no more
     * results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. If this field is empty then there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPools() ? pools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoolsResponse)) {
            return false;
        }
        DescribePoolsResponse other = (DescribePoolsResponse) obj;
        return hasPools() == other.hasPools() && Objects.equals(pools(), other.pools())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePoolsResponse").add("Pools", hasPools() ? pools() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pools":
            return Optional.ofNullable(clazz.cast(pools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Pools", POOLS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePoolsResponse, T> g) {
        return obj -> g.apply((DescribePoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribePoolsResponse> {
        /**
         * <p>
         * An array of PoolInformation objects that contain the details for the requested pools.
         * </p>
         * 
         * @param pools
         *        An array of PoolInformation objects that contain the details for the requested pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pools(Collection<PoolInformation> pools);

        /**
         * <p>
         * An array of PoolInformation objects that contain the details for the requested pools.
         * </p>
         * 
         * @param pools
         *        An array of PoolInformation objects that contain the details for the requested pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pools(PoolInformation... pools);

        /**
         * <p>
         * An array of PoolInformation objects that contain the details for the requested pools.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #pools(List<PoolInformation>)}.
         * 
         * @param pools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pools(java.util.Collection<PoolInformation>)
         */
        Builder pools(Consumer<PoolInformation.Builder>... pools);

        /**
         * <p>
         * The token to be used for the next set of paginated results. If this field is empty then there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. If this field is empty then there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<PoolInformation> pools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoolsResponse model) {
            super(model);
            pools(model.pools);
            nextToken(model.nextToken);
        }

        public final List<PoolInformation.Builder> getPools() {
            List<PoolInformation.Builder> result = PoolInformationListCopier.copyToBuilder(this.pools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPools(Collection<PoolInformation.BuilderImpl> pools) {
            this.pools = PoolInformationListCopier.copyFromBuilder(pools);
        }

        @Override
        public final Builder pools(Collection<PoolInformation> pools) {
            this.pools = PoolInformationListCopier.copy(pools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pools(PoolInformation... pools) {
            pools(Arrays.asList(pools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pools(Consumer<PoolInformation.Builder>... pools) {
            pools(Stream.of(pools).map(c -> PoolInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePoolsResponse build() {
            return new DescribePoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
