/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistrationFieldValuesRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<DescribeRegistrationFieldValuesRequest.Builder, DescribeRegistrationFieldValuesRequest> {
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(DescribeRegistrationFieldValuesRequest::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(DescribeRegistrationFieldValuesRequest::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<String> SECTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SectionPath").getter(getter(DescribeRegistrationFieldValuesRequest::sectionPath))
            .setter(setter(Builder::sectionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionPath").build()).build();

    private static final SdkField<List<String>> FIELD_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FieldPaths")
            .getter(getter(DescribeRegistrationFieldValuesRequest::fieldPaths))
            .setter(setter(Builder::fieldPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRegistrationFieldValuesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeRegistrationFieldValuesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ID_FIELD,
            VERSION_NUMBER_FIELD, SECTION_PATH_FIELD, FIELD_PATHS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationId;

    private final Long versionNumber;

    private final String sectionPath;

    private final List<String> fieldPaths;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeRegistrationFieldValuesRequest(BuilderImpl builder) {
        super(builder);
        this.registrationId = builder.registrationId;
        this.versionNumber = builder.versionNumber;
        this.sectionPath = builder.sectionPath;
        this.fieldPaths = builder.fieldPaths;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The version number of the registration.
     * </p>
     * 
     * @return The version number of the registration.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The path to the section of the registration.
     * </p>
     * 
     * @return The path to the section of the registration.
     */
    public final String sectionPath() {
        return sectionPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldPaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldPaths() {
        return fieldPaths != null && !(fieldPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of paths to the registration form field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldPaths} method.
     * </p>
     * 
     * @return An array of paths to the registration form field.
     */
    public final List<String> fieldPaths() {
        return fieldPaths;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per each request.
     * </p>
     * 
     * @return The maximum number of results to return per each request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sectionPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldPaths() ? fieldPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationFieldValuesRequest)) {
            return false;
        }
        DescribeRegistrationFieldValuesRequest other = (DescribeRegistrationFieldValuesRequest) obj;
        return Objects.equals(registrationId(), other.registrationId()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(sectionPath(), other.sectionPath()) && hasFieldPaths() == other.hasFieldPaths()
                && Objects.equals(fieldPaths(), other.fieldPaths()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRegistrationFieldValuesRequest").add("RegistrationId", registrationId())
                .add("VersionNumber", versionNumber()).add("SectionPath", sectionPath())
                .add("FieldPaths", hasFieldPaths() ? fieldPaths() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "SectionPath":
            return Optional.ofNullable(clazz.cast(sectionPath()));
        case "FieldPaths":
            return Optional.ofNullable(clazz.cast(fieldPaths()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("SectionPath", SECTION_PATH_FIELD);
        map.put("FieldPaths", FIELD_PATHS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationFieldValuesRequest, T> g) {
        return obj -> g.apply((DescribeRegistrationFieldValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRegistrationFieldValuesRequest> {
        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The version number of the registration.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The path to the section of the registration.
         * </p>
         * 
         * @param sectionPath
         *        The path to the section of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionPath(String sectionPath);

        /**
         * <p>
         * An array of paths to the registration form field.
         * </p>
         * 
         * @param fieldPaths
         *        An array of paths to the registration form field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPaths(Collection<String> fieldPaths);

        /**
         * <p>
         * An array of paths to the registration form field.
         * </p>
         * 
         * @param fieldPaths
         *        An array of paths to the registration form field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPaths(String... fieldPaths);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per each request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String registrationId;

        private Long versionNumber;

        private String sectionPath;

        private List<String> fieldPaths = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationFieldValuesRequest model) {
            super(model);
            registrationId(model.registrationId);
            versionNumber(model.versionNumber);
            sectionPath(model.sectionPath);
            fieldPaths(model.fieldPaths);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getSectionPath() {
            return sectionPath;
        }

        public final void setSectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
        }

        @Override
        public final Builder sectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
            return this;
        }

        public final Collection<String> getFieldPaths() {
            if (fieldPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldPaths;
        }

        public final void setFieldPaths(Collection<String> fieldPaths) {
            this.fieldPaths = FieldPathListCopier.copy(fieldPaths);
        }

        @Override
        public final Builder fieldPaths(Collection<String> fieldPaths) {
            this.fieldPaths = FieldPathListCopier.copy(fieldPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldPaths(String... fieldPaths) {
            fieldPaths(Arrays.asList(fieldPaths));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegistrationFieldValuesRequest build() {
            return new DescribeRegistrationFieldValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
