/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistrationFieldValuesResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeRegistrationFieldValuesResponse.Builder, DescribeRegistrationFieldValuesResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationArn").getter(getter(DescribeRegistrationFieldValuesResponse::registrationArn))
            .setter(setter(Builder::registrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(DescribeRegistrationFieldValuesResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(DescribeRegistrationFieldValuesResponse::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final SdkField<List<RegistrationFieldValueInformation>> REGISTRATION_FIELD_VALUES_FIELD = SdkField
            .<List<RegistrationFieldValueInformation>> builder(MarshallingType.LIST)
            .memberName("RegistrationFieldValues")
            .getter(getter(DescribeRegistrationFieldValuesResponse::registrationFieldValues))
            .setter(setter(Builder::registrationFieldValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationFieldValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationFieldValueInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationFieldValueInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRegistrationFieldValuesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD,
            REGISTRATION_ID_FIELD, VERSION_NUMBER_FIELD, REGISTRATION_FIELD_VALUES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationArn;

    private final String registrationId;

    private final Long versionNumber;

    private final List<RegistrationFieldValueInformation> registrationFieldValues;

    private final String nextToken;

    private DescribeRegistrationFieldValuesResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.versionNumber = builder.versionNumber;
        this.registrationFieldValues = builder.registrationFieldValues;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration.
     */
    public final String registrationArn() {
        return registrationArn;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The current version of the registration.
     * </p>
     * 
     * @return The current version of the registration.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistrationFieldValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegistrationFieldValues() {
        return registrationFieldValues != null && !(registrationFieldValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RegistrationFieldValues objects that contain the values for the requested registration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrationFieldValues} method.
     * </p>
     * 
     * @return An array of RegistrationFieldValues objects that contain the values for the requested registration.
     */
    public final List<RegistrationFieldValueInformation> registrationFieldValues() {
        return registrationFieldValues;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistrationFieldValues() ? registrationFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationFieldValuesResponse)) {
            return false;
        }
        DescribeRegistrationFieldValuesResponse other = (DescribeRegistrationFieldValuesResponse) obj;
        return Objects.equals(registrationArn(), other.registrationArn())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(versionNumber(), other.versionNumber())
                && hasRegistrationFieldValues() == other.hasRegistrationFieldValues()
                && Objects.equals(registrationFieldValues(), other.registrationFieldValues())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRegistrationFieldValuesResponse").add("RegistrationArn", registrationArn())
                .add("RegistrationId", registrationId()).add("VersionNumber", versionNumber())
                .add("RegistrationFieldValues", hasRegistrationFieldValues() ? registrationFieldValues() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationArn":
            return Optional.ofNullable(clazz.cast(registrationArn()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "RegistrationFieldValues":
            return Optional.ofNullable(clazz.cast(registrationFieldValues()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("RegistrationFieldValues", REGISTRATION_FIELD_VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationFieldValuesResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationFieldValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRegistrationFieldValuesResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration.
         * </p>
         * 
         * @param registrationArn
         *        The Amazon Resource Name (ARN) for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationArn(String registrationArn);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The current version of the registration.
         * </p>
         * 
         * @param versionNumber
         *        The current version of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * An array of RegistrationFieldValues objects that contain the values for the requested registration.
         * </p>
         * 
         * @param registrationFieldValues
         *        An array of RegistrationFieldValues objects that contain the values for the requested registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationFieldValues(Collection<RegistrationFieldValueInformation> registrationFieldValues);

        /**
         * <p>
         * An array of RegistrationFieldValues objects that contain the values for the requested registration.
         * </p>
         * 
         * @param registrationFieldValues
         *        An array of RegistrationFieldValues objects that contain the values for the requested registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationFieldValues(RegistrationFieldValueInformation... registrationFieldValues);

        /**
         * <p>
         * An array of RegistrationFieldValues objects that contain the values for the requested registration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #registrationFieldValues(List<RegistrationFieldValueInformation>)}.
         * 
         * @param registrationFieldValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationFieldValueInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationFieldValues(java.util.Collection<RegistrationFieldValueInformation>)
         */
        Builder registrationFieldValues(Consumer<RegistrationFieldValueInformation.Builder>... registrationFieldValues);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationArn;

        private String registrationId;

        private Long versionNumber;

        private List<RegistrationFieldValueInformation> registrationFieldValues = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationFieldValuesResponse model) {
            super(model);
            registrationArn(model.registrationArn);
            registrationId(model.registrationId);
            versionNumber(model.versionNumber);
            registrationFieldValues(model.registrationFieldValues);
            nextToken(model.nextToken);
        }

        public final String getRegistrationArn() {
            return registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final List<RegistrationFieldValueInformation.Builder> getRegistrationFieldValues() {
            List<RegistrationFieldValueInformation.Builder> result = RegistrationFieldValueInformationListCopier
                    .copyToBuilder(this.registrationFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationFieldValues(
                Collection<RegistrationFieldValueInformation.BuilderImpl> registrationFieldValues) {
            this.registrationFieldValues = RegistrationFieldValueInformationListCopier.copyFromBuilder(registrationFieldValues);
        }

        @Override
        public final Builder registrationFieldValues(Collection<RegistrationFieldValueInformation> registrationFieldValues) {
            this.registrationFieldValues = RegistrationFieldValueInformationListCopier.copy(registrationFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationFieldValues(RegistrationFieldValueInformation... registrationFieldValues) {
            registrationFieldValues(Arrays.asList(registrationFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationFieldValues(
                Consumer<RegistrationFieldValueInformation.Builder>... registrationFieldValues) {
            registrationFieldValues(Stream.of(registrationFieldValues)
                    .map(c -> RegistrationFieldValueInformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationFieldValuesResponse build() {
            return new DescribeRegistrationFieldValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
