/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistrationSectionDefinitionsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeRegistrationSectionDefinitionsResponse.Builder, DescribeRegistrationSectionDefinitionsResponse> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationType").getter(getter(DescribeRegistrationSectionDefinitionsResponse::registrationType))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()).build();

    private static final SdkField<List<RegistrationSectionDefinition>> REGISTRATION_SECTION_DEFINITIONS_FIELD = SdkField
            .<List<RegistrationSectionDefinition>> builder(MarshallingType.LIST)
            .memberName("RegistrationSectionDefinitions")
            .getter(getter(DescribeRegistrationSectionDefinitionsResponse::registrationSectionDefinitions))
            .setter(setter(Builder::registrationSectionDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationSectionDefinitions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationSectionDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationSectionDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRegistrationSectionDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD,
            REGISTRATION_SECTION_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationType;

    private final List<RegistrationSectionDefinition> registrationSectionDefinitions;

    private final String nextToken;

    private DescribeRegistrationSectionDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationType = builder.registrationType;
        this.registrationSectionDefinitions = builder.registrationSectionDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     * <a>DescribeRegistrationTypeDefinitions</a> action.
     * </p>
     * 
     * @return The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     *         <a>DescribeRegistrationTypeDefinitions</a> action.
     */
    public final String registrationType() {
        return registrationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistrationSectionDefinitions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegistrationSectionDefinitions() {
        return registrationSectionDefinitions != null && !(registrationSectionDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RegistrationSectionDefinition objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrationSectionDefinitions} method.
     * </p>
     * 
     * @return An array of RegistrationSectionDefinition objects.
     */
    public final List<RegistrationSectionDefinition> registrationSectionDefinitions() {
        return registrationSectionDefinitions;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationType());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRegistrationSectionDefinitions() ? registrationSectionDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationSectionDefinitionsResponse)) {
            return false;
        }
        DescribeRegistrationSectionDefinitionsResponse other = (DescribeRegistrationSectionDefinitionsResponse) obj;
        return Objects.equals(registrationType(), other.registrationType())
                && hasRegistrationSectionDefinitions() == other.hasRegistrationSectionDefinitions()
                && Objects.equals(registrationSectionDefinitions(), other.registrationSectionDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeRegistrationSectionDefinitionsResponse")
                .add("RegistrationType", registrationType())
                .add("RegistrationSectionDefinitions",
                        hasRegistrationSectionDefinitions() ? registrationSectionDefinitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationType":
            return Optional.ofNullable(clazz.cast(registrationType()));
        case "RegistrationSectionDefinitions":
            return Optional.ofNullable(clazz.cast(registrationSectionDefinitions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("RegistrationSectionDefinitions", REGISTRATION_SECTION_DEFINITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationSectionDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationSectionDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRegistrationSectionDefinitionsResponse> {
        /**
         * <p>
         * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         * <a>DescribeRegistrationTypeDefinitions</a> action.
         * </p>
         * 
         * @param registrationType
         *        The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         *        <a>DescribeRegistrationTypeDefinitions</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * An array of RegistrationSectionDefinition objects.
         * </p>
         * 
         * @param registrationSectionDefinitions
         *        An array of RegistrationSectionDefinition objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationSectionDefinitions(Collection<RegistrationSectionDefinition> registrationSectionDefinitions);

        /**
         * <p>
         * An array of RegistrationSectionDefinition objects.
         * </p>
         * 
         * @param registrationSectionDefinitions
         *        An array of RegistrationSectionDefinition objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationSectionDefinitions(RegistrationSectionDefinition... registrationSectionDefinitions);

        /**
         * <p>
         * An array of RegistrationSectionDefinition objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #registrationSectionDefinitions(List<RegistrationSectionDefinition>)}.
         * 
         * @param registrationSectionDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationSectionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationSectionDefinitions(java.util.Collection<RegistrationSectionDefinition>)
         */
        Builder registrationSectionDefinitions(Consumer<RegistrationSectionDefinition.Builder>... registrationSectionDefinitions);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationType;

        private List<RegistrationSectionDefinition> registrationSectionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationSectionDefinitionsResponse model) {
            super(model);
            registrationType(model.registrationType);
            registrationSectionDefinitions(model.registrationSectionDefinitions);
            nextToken(model.nextToken);
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<RegistrationSectionDefinition.Builder> getRegistrationSectionDefinitions() {
            List<RegistrationSectionDefinition.Builder> result = RegistrationSectionDefinitionListCopier
                    .copyToBuilder(this.registrationSectionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationSectionDefinitions(
                Collection<RegistrationSectionDefinition.BuilderImpl> registrationSectionDefinitions) {
            this.registrationSectionDefinitions = RegistrationSectionDefinitionListCopier
                    .copyFromBuilder(registrationSectionDefinitions);
        }

        @Override
        public final Builder registrationSectionDefinitions(
                Collection<RegistrationSectionDefinition> registrationSectionDefinitions) {
            this.registrationSectionDefinitions = RegistrationSectionDefinitionListCopier.copy(registrationSectionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationSectionDefinitions(RegistrationSectionDefinition... registrationSectionDefinitions) {
            registrationSectionDefinitions(Arrays.asList(registrationSectionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationSectionDefinitions(
                Consumer<RegistrationSectionDefinition.Builder>... registrationSectionDefinitions) {
            registrationSectionDefinitions(Stream.of(registrationSectionDefinitions)
                    .map(c -> RegistrationSectionDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationSectionDefinitionsResponse build() {
            return new DescribeRegistrationSectionDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
