/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistrationsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeRegistrationsResponse.Builder, DescribeRegistrationsResponse> {
    private static final SdkField<List<RegistrationInformation>> REGISTRATIONS_FIELD = SdkField
            .<List<RegistrationInformation>> builder(MarshallingType.LIST)
            .memberName("Registrations")
            .getter(getter(DescribeRegistrationsResponse::registrations))
            .setter(setter(Builder::registrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRegistrationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RegistrationInformation> registrations;

    private final String nextToken;

    private DescribeRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.registrations = builder.registrations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Registrations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegistrations() {
        return registrations != null && !(registrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RegistrationInformation objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrations} method.
     * </p>
     * 
     * @return An array of RegistrationInformation objects.
     */
    public final List<RegistrationInformation> registrations() {
        return registrations;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistrations() ? registrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistrationsResponse)) {
            return false;
        }
        DescribeRegistrationsResponse other = (DescribeRegistrationsResponse) obj;
        return hasRegistrations() == other.hasRegistrations() && Objects.equals(registrations(), other.registrations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRegistrationsResponse")
                .add("Registrations", hasRegistrations() ? registrations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Registrations":
            return Optional.ofNullable(clazz.cast(registrations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Registrations", REGISTRATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistrationsResponse, T> g) {
        return obj -> g.apply((DescribeRegistrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRegistrationsResponse> {
        /**
         * <p>
         * An array of RegistrationInformation objects.
         * </p>
         * 
         * @param registrations
         *        An array of RegistrationInformation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrations(Collection<RegistrationInformation> registrations);

        /**
         * <p>
         * An array of RegistrationInformation objects.
         * </p>
         * 
         * @param registrations
         *        An array of RegistrationInformation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrations(RegistrationInformation... registrations);

        /**
         * <p>
         * An array of RegistrationInformation objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation.Builder#build()} is
         * called immediately and its result is passed to {@link #registrations(List<RegistrationInformation>)}.
         * 
         * @param registrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrations(java.util.Collection<RegistrationInformation>)
         */
        Builder registrations(Consumer<RegistrationInformation.Builder>... registrations);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private List<RegistrationInformation> registrations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistrationsResponse model) {
            super(model);
            registrations(model.registrations);
            nextToken(model.nextToken);
        }

        public final List<RegistrationInformation.Builder> getRegistrations() {
            List<RegistrationInformation.Builder> result = RegistrationInformationListCopier.copyToBuilder(this.registrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrations(Collection<RegistrationInformation.BuilderImpl> registrations) {
            this.registrations = RegistrationInformationListCopier.copyFromBuilder(registrations);
        }

        @Override
        public final Builder registrations(Collection<RegistrationInformation> registrations) {
            this.registrations = RegistrationInformationListCopier.copy(registrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrations(RegistrationInformation... registrations) {
            registrations(Arrays.asList(registrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrations(Consumer<RegistrationInformation.Builder>... registrations) {
            registrations(Stream.of(registrations).map(c -> RegistrationInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegistrationsResponse build() {
            return new DescribeRegistrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
