/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProtectConfigurationRuleSetNumberOverridesResponse extends PinpointSmsVoiceV2Response
        implements
        ToCopyableBuilder<ListProtectConfigurationRuleSetNumberOverridesResponse.Builder, ListProtectConfigurationRuleSetNumberOverridesResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationArn")
            .getter(getter(ListProtectConfigurationRuleSetNumberOverridesResponse::protectConfigurationArn))
            .setter(setter(Builder::protectConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build())
            .build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(ListProtectConfigurationRuleSetNumberOverridesResponse::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<List<ProtectConfigurationRuleSetNumberOverride>> RULE_SET_NUMBER_OVERRIDES_FIELD = SdkField
            .<List<ProtectConfigurationRuleSetNumberOverride>> builder(MarshallingType.LIST)
            .memberName("RuleSetNumberOverrides")
            .getter(getter(ListProtectConfigurationRuleSetNumberOverridesResponse::ruleSetNumberOverrides))
            .setter(setter(Builder::ruleSetNumberOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetNumberOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectConfigurationRuleSetNumberOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectConfigurationRuleSetNumberOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProtectConfigurationRuleSetNumberOverridesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, RULE_SET_NUMBER_OVERRIDES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationArn;

    private final String protectConfigurationId;

    private final List<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides;

    private final String nextToken;

    private ListProtectConfigurationRuleSetNumberOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.ruleSetNumberOverrides = builder.ruleSetNumberOverrides;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protect configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protect configuration.
     */
    public final String protectConfigurationArn() {
        return protectConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleSetNumberOverrides property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRuleSetNumberOverrides() {
        return ruleSetNumberOverrides != null && !(ruleSetNumberOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RuleSetNumberOverrides objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetNumberOverrides} method.
     * </p>
     * 
     * @return An array of RuleSetNumberOverrides objects.
     */
    public final List<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides() {
        return ruleSetNumberOverrides;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleSetNumberOverrides() ? ruleSetNumberOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectConfigurationRuleSetNumberOverridesResponse)) {
            return false;
        }
        ListProtectConfigurationRuleSetNumberOverridesResponse other = (ListProtectConfigurationRuleSetNumberOverridesResponse) obj;
        return Objects.equals(protectConfigurationArn(), other.protectConfigurationArn())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && hasRuleSetNumberOverrides() == other.hasRuleSetNumberOverrides()
                && Objects.equals(ruleSetNumberOverrides(), other.ruleSetNumberOverrides())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProtectConfigurationRuleSetNumberOverridesResponse")
                .add("ProtectConfigurationArn", protectConfigurationArn())
                .add("ProtectConfigurationId", protectConfigurationId())
                .add("RuleSetNumberOverrides", hasRuleSetNumberOverrides() ? ruleSetNumberOverrides() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationArn":
            return Optional.ofNullable(clazz.cast(protectConfigurationArn()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "RuleSetNumberOverrides":
            return Optional.ofNullable(clazz.cast(ruleSetNumberOverrides()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationArn", PROTECT_CONFIGURATION_ARN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("RuleSetNumberOverrides", RULE_SET_NUMBER_OVERRIDES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectConfigurationRuleSetNumberOverridesResponse, T> g) {
        return obj -> g.apply((ListProtectConfigurationRuleSetNumberOverridesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProtectConfigurationRuleSetNumberOverridesResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the protect configuration.
         * </p>
         * 
         * @param protectConfigurationArn
         *        The Amazon Resource Name (ARN) of the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationArn(String protectConfigurationArn);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * An array of RuleSetNumberOverrides objects.
         * </p>
         * 
         * @param ruleSetNumberOverrides
         *        An array of RuleSetNumberOverrides objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetNumberOverrides(Collection<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides);

        /**
         * <p>
         * An array of RuleSetNumberOverrides objects.
         * </p>
         * 
         * @param ruleSetNumberOverrides
         *        An array of RuleSetNumberOverrides objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetNumberOverrides(ProtectConfigurationRuleSetNumberOverride... ruleSetNumberOverrides);

        /**
         * <p>
         * An array of RuleSetNumberOverrides objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationRuleSetNumberOverride.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationRuleSetNumberOverride#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationRuleSetNumberOverride.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #ruleSetNumberOverrides(List<ProtectConfigurationRuleSetNumberOverride>)}.
         * 
         * @param ruleSetNumberOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationRuleSetNumberOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleSetNumberOverrides(java.util.Collection<ProtectConfigurationRuleSetNumberOverride>)
         */
        Builder ruleSetNumberOverrides(Consumer<ProtectConfigurationRuleSetNumberOverride.Builder>... ruleSetNumberOverrides);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String protectConfigurationArn;

        private String protectConfigurationId;

        private List<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectConfigurationRuleSetNumberOverridesResponse model) {
            super(model);
            protectConfigurationArn(model.protectConfigurationArn);
            protectConfigurationId(model.protectConfigurationId);
            ruleSetNumberOverrides(model.ruleSetNumberOverrides);
            nextToken(model.nextToken);
        }

        public final String getProtectConfigurationArn() {
            return protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final List<ProtectConfigurationRuleSetNumberOverride.Builder> getRuleSetNumberOverrides() {
            List<ProtectConfigurationRuleSetNumberOverride.Builder> result = ProtectConfigurationRuleSetNumberOverrideListCopier
                    .copyToBuilder(this.ruleSetNumberOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSetNumberOverrides(
                Collection<ProtectConfigurationRuleSetNumberOverride.BuilderImpl> ruleSetNumberOverrides) {
            this.ruleSetNumberOverrides = ProtectConfigurationRuleSetNumberOverrideListCopier
                    .copyFromBuilder(ruleSetNumberOverrides);
        }

        @Override
        public final Builder ruleSetNumberOverrides(Collection<ProtectConfigurationRuleSetNumberOverride> ruleSetNumberOverrides) {
            this.ruleSetNumberOverrides = ProtectConfigurationRuleSetNumberOverrideListCopier.copy(ruleSetNumberOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetNumberOverrides(ProtectConfigurationRuleSetNumberOverride... ruleSetNumberOverrides) {
            ruleSetNumberOverrides(Arrays.asList(ruleSetNumberOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetNumberOverrides(
                Consumer<ProtectConfigurationRuleSetNumberOverride.Builder>... ruleSetNumberOverrides) {
            ruleSetNumberOverrides(Stream.of(ruleSetNumberOverrides)
                    .map(c -> ProtectConfigurationRuleSetNumberOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProtectConfigurationRuleSetNumberOverridesResponse build() {
            return new ListProtectConfigurationRuleSetNumberOverridesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
