/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegistrationAssociationsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<ListRegistrationAssociationsResponse.Builder, ListRegistrationAssociationsResponse> {
    private static final SdkField<String> REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationArn").getter(getter(ListRegistrationAssociationsResponse::registrationArn))
            .setter(setter(Builder::registrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationArn").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(ListRegistrationAssociationsResponse::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationType").getter(getter(ListRegistrationAssociationsResponse::registrationType))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()).build();

    private static final SdkField<List<RegistrationAssociationMetadata>> REGISTRATION_ASSOCIATIONS_FIELD = SdkField
            .<List<RegistrationAssociationMetadata>> builder(MarshallingType.LIST)
            .memberName("RegistrationAssociations")
            .getter(getter(ListRegistrationAssociationsResponse::registrationAssociations))
            .setter(setter(Builder::registrationAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationAssociationMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationAssociationMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegistrationAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ARN_FIELD,
            REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, REGISTRATION_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registrationArn;

    private final String registrationId;

    private final String registrationType;

    private final List<RegistrationAssociationMetadata> registrationAssociations;

    private final String nextToken;

    private ListRegistrationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationArn = builder.registrationArn;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.registrationAssociations = builder.registrationAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registration.
     */
    public final String registrationArn() {
        return registrationArn;
    }

    /**
     * <p>
     * The unique identifier for the registration.
     * </p>
     * 
     * @return The unique identifier for the registration.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     * <a>DescribeRegistrationTypeDefinitions</a> action.
     * </p>
     * 
     * @return The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     *         <a>DescribeRegistrationTypeDefinitions</a> action.
     */
    public final String registrationType() {
        return registrationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistrationAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegistrationAssociations() {
        return registrationAssociations != null && !(registrationAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of RegistrationAssociationMetadata objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrationAssociations} method.
     * </p>
     * 
     * @return An array of RegistrationAssociationMetadata objects.
     */
    public final List<RegistrationAssociationMetadata> registrationAssociations() {
        return registrationAssociations;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. You don't need to supply a value for this field in
     * the initial request.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. You don't need to supply a value for this
     *         field in the initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistrationAssociations() ? registrationAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistrationAssociationsResponse)) {
            return false;
        }
        ListRegistrationAssociationsResponse other = (ListRegistrationAssociationsResponse) obj;
        return Objects.equals(registrationArn(), other.registrationArn())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(registrationType(), other.registrationType())
                && hasRegistrationAssociations() == other.hasRegistrationAssociations()
                && Objects.equals(registrationAssociations(), other.registrationAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRegistrationAssociationsResponse").add("RegistrationArn", registrationArn())
                .add("RegistrationId", registrationId()).add("RegistrationType", registrationType())
                .add("RegistrationAssociations", hasRegistrationAssociations() ? registrationAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationArn":
            return Optional.ofNullable(clazz.cast(registrationArn()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "RegistrationType":
            return Optional.ofNullable(clazz.cast(registrationType()));
        case "RegistrationAssociations":
            return Optional.ofNullable(clazz.cast(registrationAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationArn", REGISTRATION_ARN_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("RegistrationAssociations", REGISTRATION_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegistrationAssociationsResponse, T> g) {
        return obj -> g.apply((ListRegistrationAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRegistrationAssociationsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registration.
         * </p>
         * 
         * @param registrationArn
         *        The Amazon Resource Name (ARN) for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationArn(String registrationArn);

        /**
         * <p>
         * The unique identifier for the registration.
         * </p>
         * 
         * @param registrationId
         *        The unique identifier for the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         * <a>DescribeRegistrationTypeDefinitions</a> action.
         * </p>
         * 
         * @param registrationType
         *        The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         *        <a>DescribeRegistrationTypeDefinitions</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * An array of RegistrationAssociationMetadata objects.
         * </p>
         * 
         * @param registrationAssociations
         *        An array of RegistrationAssociationMetadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAssociations(Collection<RegistrationAssociationMetadata> registrationAssociations);

        /**
         * <p>
         * An array of RegistrationAssociationMetadata objects.
         * </p>
         * 
         * @param registrationAssociations
         *        An array of RegistrationAssociationMetadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationAssociations(RegistrationAssociationMetadata... registrationAssociations);

        /**
         * <p>
         * An array of RegistrationAssociationMetadata objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadata.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadata.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #registrationAssociations(List<RegistrationAssociationMetadata>)}.
         * 
         * @param registrationAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationAssociations(java.util.Collection<RegistrationAssociationMetadata>)
         */
        Builder registrationAssociations(Consumer<RegistrationAssociationMetadata.Builder>... registrationAssociations);

        /**
         * <p>
         * The token to be used for the next set of paginated results. You don't need to supply a value for this field
         * in the initial request.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. You don't need to supply a value for this
         *        field in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String registrationArn;

        private String registrationId;

        private String registrationType;

        private List<RegistrationAssociationMetadata> registrationAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistrationAssociationsResponse model) {
            super(model);
            registrationArn(model.registrationArn);
            registrationId(model.registrationId);
            registrationType(model.registrationType);
            registrationAssociations(model.registrationAssociations);
            nextToken(model.nextToken);
        }

        public final String getRegistrationArn() {
            return registrationArn;
        }

        public final void setRegistrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
        }

        @Override
        public final Builder registrationArn(String registrationArn) {
            this.registrationArn = registrationArn;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<RegistrationAssociationMetadata.Builder> getRegistrationAssociations() {
            List<RegistrationAssociationMetadata.Builder> result = RegistrationAssociationMetadataListCopier
                    .copyToBuilder(this.registrationAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationAssociations(
                Collection<RegistrationAssociationMetadata.BuilderImpl> registrationAssociations) {
            this.registrationAssociations = RegistrationAssociationMetadataListCopier.copyFromBuilder(registrationAssociations);
        }

        @Override
        public final Builder registrationAssociations(Collection<RegistrationAssociationMetadata> registrationAssociations) {
            this.registrationAssociations = RegistrationAssociationMetadataListCopier.copy(registrationAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAssociations(RegistrationAssociationMetadata... registrationAssociations) {
            registrationAssociations(Arrays.asList(registrationAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationAssociations(
                Consumer<RegistrationAssociationMetadata.Builder>... registrationAssociations) {
            registrationAssociations(Stream.of(registrationAssociations)
                    .map(c -> RegistrationAssociationMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRegistrationAssociationsResponse build() {
            return new ListRegistrationAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
