/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for a pool in an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PoolInformation implements SdkPojo, Serializable, ToCopyableBuilder<PoolInformation.Builder, PoolInformation> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(PoolInformation::poolArn)).setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(PoolInformation::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PoolInformation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(PoolInformation::messageTypeAsString)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TwoWayEnabled").getter(getter(PoolInformation::twoWayEnabled)).setter(setter(Builder::twoWayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelArn").getter(getter(PoolInformation::twoWayChannelArn))
            .setter(setter(Builder::twoWayChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()).build();

    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TwoWayChannelRole").getter(getter(PoolInformation::twoWayChannelRole))
            .setter(setter(Builder::twoWayChannelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()).build();

    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled")
            .getter(getter(PoolInformation::selfManagedOptOutsEnabled)).setter(setter(Builder::selfManagedOptOutsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build())
            .build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(PoolInformation::optOutListName)).setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<Boolean> SHARED_ROUTES_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SharedRoutesEnabled").getter(getter(PoolInformation::sharedRoutesEnabled))
            .setter(setter(Builder::sharedRoutesEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedRoutesEnabled").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(PoolInformation::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(PoolInformation::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD,
            STATUS_FIELD, MESSAGE_TYPE_FIELD, TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD,
            SELF_MANAGED_OPT_OUTS_ENABLED_FIELD, OPT_OUT_LIST_NAME_FIELD, SHARED_ROUTES_ENABLED_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String poolArn;

    private final String poolId;

    private final String status;

    private final String messageType;

    private final Boolean twoWayEnabled;

    private final String twoWayChannelArn;

    private final String twoWayChannelRole;

    private final Boolean selfManagedOptOutsEnabled;

    private final String optOutListName;

    private final Boolean sharedRoutesEnabled;

    private final Boolean deletionProtectionEnabled;

    private final Instant createdTimestamp;

    private PoolInformation(BuilderImpl builder) {
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.status = builder.status;
        this.messageType = builder.messageType;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.sharedRoutesEnabled = builder.sharedRoutesEnabled;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the pool.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the pool.
     */
    public final String poolArn() {
        return poolArn;
    }

    /**
     * <p>
     * The unique identifier for the pool.
     * </p>
     * 
     * @return The unique identifier for the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The current status of the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pool.
     * @see PoolStatus
     */
    public final PoolStatus status() {
        return PoolStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the pool.
     * @see PoolStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
     * </p>
     * 
     * @return When set to true you can receive incoming text messages from your end recipients using the
     *         TwoWayChannelArn.
     */
    public final Boolean twoWayEnabled() {
        return twoWayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the two way channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the two way channel.
     */
    public final String twoWayChannelArn() {
        return twoWayChannelArn;
    }

    /**
     * <p>
     * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     * </p>
     * 
     * @return An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
     */
    public final String twoWayChannelRole() {
        return twoWayChannelRole;
    }

    /**
     * <p>
     * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated
     * numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end
     * recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP requests. You're
     * also responsible for tracking and honoring opt-out requests. For more information see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out"
     * >Self-managed opt-outs</a>
     * </p>
     * 
     * @return When set to false, an end recipient sends a message that begins with HELP or STOP to one of your
     *         dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message
     *         and adds the end recipient to the OptOutList. When set to true you're responsible for responding to HELP
     *         and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more
     *         information see <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out"
     *         >Self-managed opt-outs</a>
     */
    public final Boolean selfManagedOptOutsEnabled() {
        return selfManagedOptOutsEnabled;
    }

    /**
     * <p>
     * The name of the OptOutList associated with the pool.
     * </p>
     * 
     * @return The name of the OptOutList associated with the pool.
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * Allows you to enable shared routes on your pool.
     * </p>
     * <p>
     * By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are sent
     * using phone numbers or sender IDs (depending on the country) that are shared with other users. In some countries,
     * such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or
     * short code.
     * </p>
     * 
     * @return Allows you to enable shared routes on your pool.</p>
     *         <p>
     *         By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages
     *         are sent using phone numbers or sender IDs (depending on the country) that are shared with other users.
     *         In some countries, such as the United States, senders aren't allowed to use shared routes and must use a
     *         dedicated phone number or short code.
     */
    public final Boolean sharedRoutesEnabled() {
        return sharedRoutesEnabled;
    }

    /**
     * <p>
     * When set to true the pool can't be deleted.
     * </p>
     * 
     * @return When set to true the pool can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     *         format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(sharedRoutesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolInformation)) {
            return false;
        }
        PoolInformation other = (PoolInformation) obj;
        return Objects.equals(poolArn(), other.poolArn()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(twoWayEnabled(), other.twoWayEnabled())
                && Objects.equals(twoWayChannelArn(), other.twoWayChannelArn())
                && Objects.equals(twoWayChannelRole(), other.twoWayChannelRole())
                && Objects.equals(selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled())
                && Objects.equals(optOutListName(), other.optOutListName())
                && Objects.equals(sharedRoutesEnabled(), other.sharedRoutesEnabled())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PoolInformation").add("PoolArn", poolArn()).add("PoolId", poolId())
                .add("Status", statusAsString()).add("MessageType", messageTypeAsString()).add("TwoWayEnabled", twoWayEnabled())
                .add("TwoWayChannelArn", twoWayChannelArn()).add("TwoWayChannelRole", twoWayChannelRole())
                .add("SelfManagedOptOutsEnabled", selfManagedOptOutsEnabled()).add("OptOutListName", optOutListName())
                .add("SharedRoutesEnabled", sharedRoutesEnabled()).add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "TwoWayEnabled":
            return Optional.ofNullable(clazz.cast(twoWayEnabled()));
        case "TwoWayChannelArn":
            return Optional.ofNullable(clazz.cast(twoWayChannelArn()));
        case "TwoWayChannelRole":
            return Optional.ofNullable(clazz.cast(twoWayChannelRole()));
        case "SelfManagedOptOutsEnabled":
            return Optional.ofNullable(clazz.cast(selfManagedOptOutsEnabled()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "SharedRoutesEnabled":
            return Optional.ofNullable(clazz.cast(sharedRoutesEnabled()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("TwoWayEnabled", TWO_WAY_ENABLED_FIELD);
        map.put("TwoWayChannelArn", TWO_WAY_CHANNEL_ARN_FIELD);
        map.put("TwoWayChannelRole", TWO_WAY_CHANNEL_ROLE_FIELD);
        map.put("SelfManagedOptOutsEnabled", SELF_MANAGED_OPT_OUTS_ENABLED_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("SharedRoutesEnabled", SHARED_ROUTES_ENABLED_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PoolInformation, T> g) {
        return obj -> g.apply((PoolInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PoolInformation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the pool.
         * </p>
         * 
         * @param poolArn
         *        The Amazon Resource Name (ARN) for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);

        /**
         * <p>
         * The unique identifier for the pool.
         * </p>
         * 
         * @param poolId
         *        The unique identifier for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The current status of the pool.
         * </p>
         * 
         * @param status
         *        The current status of the pool.
         * @see PoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the pool.
         * </p>
         * 
         * @param status
         *        The current status of the pool.
         * @see PoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PoolStatus
         */
        Builder status(PoolStatus status);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
         * </p>
         * 
         * @param twoWayEnabled
         *        When set to true you can receive incoming text messages from your end recipients using the
         *        TwoWayChannelArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayEnabled(Boolean twoWayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the two way channel.
         * </p>
         * 
         * @param twoWayChannelArn
         *        The Amazon Resource Name (ARN) of the two way channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelArn(String twoWayChannelArn);

        /**
         * <p>
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * </p>
         * 
         * @param twoWayChannelRole
         *        An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twoWayChannelRole(String twoWayChannelRole);

        /**
         * <p>
         * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated
         * numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the
         * end recipient to the OptOutList. When set to true you're responsible for responding to HELP and STOP
         * requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out"
         * >Self-managed opt-outs</a>
         * </p>
         * 
         * @param selfManagedOptOutsEnabled
         *        When set to false, an end recipient sends a message that begins with HELP or STOP to one of your
         *        dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable
         *        message and adds the end recipient to the OptOutList. When set to true you're responsible for
         *        responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out
         *        requests. For more information see <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out"
         *        >Self-managed opt-outs</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled);

        /**
         * <p>
         * The name of the OptOutList associated with the pool.
         * </p>
         * 
         * @param optOutListName
         *        The name of the OptOutList associated with the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * Allows you to enable shared routes on your pool.
         * </p>
         * <p>
         * By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your messages are
         * sent using phone numbers or sender IDs (depending on the country) that are shared with other users. In some
         * countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated
         * phone number or short code.
         * </p>
         * 
         * @param sharedRoutesEnabled
         *        Allows you to enable shared routes on your pool.</p>
         *        <p>
         *        By default, this is set to <code>False</code>. If you set this value to <code>True</code>, your
         *        messages are sent using phone numbers or sender IDs (depending on the country) that are shared with
         *        other users. In some countries, such as the United States, senders aren't allowed to use shared routes
         *        and must use a dedicated phone number or short code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled);

        /**
         * <p>
         * When set to true the pool can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        When set to true the pool can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the pool was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String poolArn;

        private String poolId;

        private String status;

        private String messageType;

        private Boolean twoWayEnabled;

        private String twoWayChannelArn;

        private String twoWayChannelRole;

        private Boolean selfManagedOptOutsEnabled;

        private String optOutListName;

        private Boolean sharedRoutesEnabled;

        private Boolean deletionProtectionEnabled;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PoolInformation model) {
            poolArn(model.poolArn);
            poolId(model.poolId);
            status(model.status);
            messageType(model.messageType);
            twoWayEnabled(model.twoWayEnabled);
            twoWayChannelArn(model.twoWayChannelArn);
            twoWayChannelRole(model.twoWayChannelRole);
            selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            optOutListName(model.optOutListName);
            sharedRoutesEnabled(model.sharedRoutesEnabled);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PoolStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getSharedRoutesEnabled() {
            return sharedRoutesEnabled;
        }

        public final void setSharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
        }

        @Override
        public final Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public PoolInformation build() {
            return new PoolInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
