/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for the origination identity that is associated with the registration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationAssociationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationAssociationMetadata.Builder, RegistrationAssociationMetadata> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(RegistrationAssociationMetadata::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(RegistrationAssociationMetadata::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(RegistrationAssociationMetadata::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(RegistrationAssociationMetadata::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(RegistrationAssociationMetadata::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, ISO_COUNTRY_CODE_FIELD, PHONE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String resourceId;

    private final String resourceType;

    private final String isoCountryCode;

    private final String phoneNumber;

    private RegistrationAssociationMetadata(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.isoCountryCode = builder.isoCountryCode;
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or
     * <b>SenderId</b>.
     * </p>
     * 
     * @return The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or
     *         <b>SenderId</b>.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The origination identity type.
     * </p>
     * 
     * @return The origination identity type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The phone number associated with the registration in E.164 format.
     * </p>
     * 
     * @return The phone number associated with the registration in E.164 format.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationAssociationMetadata)) {
            return false;
        }
        RegistrationAssociationMetadata other = (RegistrationAssociationMetadata) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(isoCountryCode(), other.isoCountryCode()) && Objects.equals(phoneNumber(), other.phoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationAssociationMetadata").add("ResourceArn", resourceArn())
                .add("ResourceId", resourceId()).add("ResourceType", resourceType()).add("IsoCountryCode", isoCountryCode())
                .add("PhoneNumber", phoneNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationAssociationMetadata, T> g) {
        return obj -> g.apply((RegistrationAssociationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationAssociationMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the origination identity that is associated with the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b> or
         * <b>SenderId</b>.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the origination identity. For example this could be a <b>PhoneNumberId</b>
         *        or <b>SenderId</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The origination identity type.
         * </p>
         * 
         * @param resourceType
         *        The origination identity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The phone number associated with the registration in E.164 format.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number associated with the registration in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceId;

        private String resourceType;

        private String isoCountryCode;

        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationAssociationMetadata model) {
            resourceArn(model.resourceArn);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            isoCountryCode(model.isoCountryCode);
            phoneNumber(model.phoneNumber);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public RegistrationAssociationMetadata build() {
            return new RegistrationAssociationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
