/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on the specified section definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationSectionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationSectionDefinition.Builder, RegistrationSectionDefinition> {
    private static final SdkField<String> SECTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SectionPath").getter(getter(RegistrationSectionDefinition::sectionPath))
            .setter(setter(Builder::sectionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionPath").build()).build();

    private static final SdkField<RegistrationSectionDisplayHints> DISPLAY_HINTS_FIELD = SdkField
            .<RegistrationSectionDisplayHints> builder(MarshallingType.SDK_POJO).memberName("DisplayHints")
            .getter(getter(RegistrationSectionDefinition::displayHints)).setter(setter(Builder::displayHints))
            .constructor(RegistrationSectionDisplayHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayHints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_PATH_FIELD,
            DISPLAY_HINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sectionPath;

    private final RegistrationSectionDisplayHints displayHints;

    private RegistrationSectionDefinition(BuilderImpl builder) {
        this.sectionPath = builder.sectionPath;
        this.displayHints = builder.displayHints;
    }

    /**
     * <p>
     * The path to the section of the registration.
     * </p>
     * 
     * @return The path to the section of the registration.
     */
    public final String sectionPath() {
        return sectionPath;
    }

    /**
     * <p>
     * The path to the section of the registration.
     * </p>
     * 
     * @return The path to the section of the registration.
     */
    public final RegistrationSectionDisplayHints displayHints() {
        return displayHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sectionPath());
        hashCode = 31 * hashCode + Objects.hashCode(displayHints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationSectionDefinition)) {
            return false;
        }
        RegistrationSectionDefinition other = (RegistrationSectionDefinition) obj;
        return Objects.equals(sectionPath(), other.sectionPath()) && Objects.equals(displayHints(), other.displayHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationSectionDefinition").add("SectionPath", sectionPath())
                .add("DisplayHints", displayHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SectionPath":
            return Optional.ofNullable(clazz.cast(sectionPath()));
        case "DisplayHints":
            return Optional.ofNullable(clazz.cast(displayHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SectionPath", SECTION_PATH_FIELD);
        map.put("DisplayHints", DISPLAY_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationSectionDefinition, T> g) {
        return obj -> g.apply((RegistrationSectionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationSectionDefinition> {
        /**
         * <p>
         * The path to the section of the registration.
         * </p>
         * 
         * @param sectionPath
         *        The path to the section of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionPath(String sectionPath);

        /**
         * <p>
         * The path to the section of the registration.
         * </p>
         * 
         * @param displayHints
         *        The path to the section of the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayHints(RegistrationSectionDisplayHints displayHints);

        /**
         * <p>
         * The path to the section of the registration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationSectionDisplayHints.Builder}
         * avoiding the need to create one manually via {@link RegistrationSectionDisplayHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationSectionDisplayHints.Builder#build()} is called
         * immediately and its result is passed to {@link #displayHints(RegistrationSectionDisplayHints)}.
         * 
         * @param displayHints
         *        a consumer that will call methods on {@link RegistrationSectionDisplayHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayHints(RegistrationSectionDisplayHints)
         */
        default Builder displayHints(Consumer<RegistrationSectionDisplayHints.Builder> displayHints) {
            return displayHints(RegistrationSectionDisplayHints.builder().applyMutation(displayHints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sectionPath;

        private RegistrationSectionDisplayHints displayHints;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationSectionDefinition model) {
            sectionPath(model.sectionPath);
            displayHints(model.displayHints);
        }

        public final String getSectionPath() {
            return sectionPath;
        }

        public final void setSectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
        }

        @Override
        public final Builder sectionPath(String sectionPath) {
            this.sectionPath = sectionPath;
            return this;
        }

        public final RegistrationSectionDisplayHints.Builder getDisplayHints() {
            return displayHints != null ? displayHints.toBuilder() : null;
        }

        public final void setDisplayHints(RegistrationSectionDisplayHints.BuilderImpl displayHints) {
            this.displayHints = displayHints != null ? displayHints.build() : null;
        }

        @Override
        public final Builder displayHints(RegistrationSectionDisplayHints displayHints) {
            this.displayHints = displayHints;
            return this;
        }

        @Override
        public RegistrationSectionDefinition build() {
            return new RegistrationSectionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
