/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information on the supported registration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistrationTypeDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistrationTypeDefinition.Builder, RegistrationTypeDefinition> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationType").getter(getter(RegistrationTypeDefinition::registrationType))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationType").build()).build();

    private static final SdkField<List<SupportedAssociation>> SUPPORTED_ASSOCIATIONS_FIELD = SdkField
            .<List<SupportedAssociation>> builder(MarshallingType.LIST)
            .memberName("SupportedAssociations")
            .getter(getter(RegistrationTypeDefinition::supportedAssociations))
            .setter(setter(Builder::supportedAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RegistrationTypeDisplayHints> DISPLAY_HINTS_FIELD = SdkField
            .<RegistrationTypeDisplayHints> builder(MarshallingType.SDK_POJO).memberName("DisplayHints")
            .getter(getter(RegistrationTypeDefinition::displayHints)).setter(setter(Builder::displayHints))
            .constructor(RegistrationTypeDisplayHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayHints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD,
            SUPPORTED_ASSOCIATIONS_FIELD, DISPLAY_HINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String registrationType;

    private final List<SupportedAssociation> supportedAssociations;

    private final RegistrationTypeDisplayHints displayHints;

    private RegistrationTypeDefinition(BuilderImpl builder) {
        this.registrationType = builder.registrationType;
        this.supportedAssociations = builder.supportedAssociations;
        this.displayHints = builder.displayHints;
    }

    /**
     * <p>
     * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     * <a>DescribeRegistrationTypeDefinitions</a> action.
     * </p>
     * 
     * @return The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
     *         <a>DescribeRegistrationTypeDefinitions</a> action.
     */
    public final String registrationType() {
        return registrationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedAssociations() {
        return supportedAssociations != null && !(supportedAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported association behavior for the registration type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedAssociations} method.
     * </p>
     * 
     * @return The supported association behavior for the registration type.
     */
    public final List<SupportedAssociation> supportedAssociations() {
        return supportedAssociations;
    }

    /**
     * <p>
     * Provides help information on the registration.
     * </p>
     * 
     * @return Provides help information on the registration.
     */
    public final RegistrationTypeDisplayHints displayHints() {
        return displayHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registrationType());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedAssociations() ? supportedAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayHints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationTypeDefinition)) {
            return false;
        }
        RegistrationTypeDefinition other = (RegistrationTypeDefinition) obj;
        return Objects.equals(registrationType(), other.registrationType())
                && hasSupportedAssociations() == other.hasSupportedAssociations()
                && Objects.equals(supportedAssociations(), other.supportedAssociations())
                && Objects.equals(displayHints(), other.displayHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistrationTypeDefinition").add("RegistrationType", registrationType())
                .add("SupportedAssociations", hasSupportedAssociations() ? supportedAssociations() : null)
                .add("DisplayHints", displayHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationType":
            return Optional.ofNullable(clazz.cast(registrationType()));
        case "SupportedAssociations":
            return Optional.ofNullable(clazz.cast(supportedAssociations()));
        case "DisplayHints":
            return Optional.ofNullable(clazz.cast(displayHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegistrationType", REGISTRATION_TYPE_FIELD);
        map.put("SupportedAssociations", SUPPORTED_ASSOCIATIONS_FIELD);
        map.put("DisplayHints", DISPLAY_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistrationTypeDefinition, T> g) {
        return obj -> g.apply((RegistrationTypeDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistrationTypeDefinition> {
        /**
         * <p>
         * The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         * <a>DescribeRegistrationTypeDefinitions</a> action.
         * </p>
         * 
         * @param registrationType
         *        The type of registration form. The list of <b>RegistrationTypes</b> can be found using the
         *        <a>DescribeRegistrationTypeDefinitions</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * The supported association behavior for the registration type.
         * </p>
         * 
         * @param supportedAssociations
         *        The supported association behavior for the registration type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAssociations(Collection<SupportedAssociation> supportedAssociations);

        /**
         * <p>
         * The supported association behavior for the registration type.
         * </p>
         * 
         * @param supportedAssociations
         *        The supported association behavior for the registration type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAssociations(SupportedAssociation... supportedAssociations);

        /**
         * <p>
         * The supported association behavior for the registration type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SupportedAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SupportedAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SupportedAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link #supportedAssociations(List<SupportedAssociation>)}.
         * 
         * @param supportedAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.SupportedAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedAssociations(java.util.Collection<SupportedAssociation>)
         */
        Builder supportedAssociations(Consumer<SupportedAssociation.Builder>... supportedAssociations);

        /**
         * <p>
         * Provides help information on the registration.
         * </p>
         * 
         * @param displayHints
         *        Provides help information on the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayHints(RegistrationTypeDisplayHints displayHints);

        /**
         * <p>
         * Provides help information on the registration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistrationTypeDisplayHints.Builder}
         * avoiding the need to create one manually via {@link RegistrationTypeDisplayHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegistrationTypeDisplayHints.Builder#build()} is called
         * immediately and its result is passed to {@link #displayHints(RegistrationTypeDisplayHints)}.
         * 
         * @param displayHints
         *        a consumer that will call methods on {@link RegistrationTypeDisplayHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayHints(RegistrationTypeDisplayHints)
         */
        default Builder displayHints(Consumer<RegistrationTypeDisplayHints.Builder> displayHints) {
            return displayHints(RegistrationTypeDisplayHints.builder().applyMutation(displayHints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String registrationType;

        private List<SupportedAssociation> supportedAssociations = DefaultSdkAutoConstructList.getInstance();

        private RegistrationTypeDisplayHints displayHints;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationTypeDefinition model) {
            registrationType(model.registrationType);
            supportedAssociations(model.supportedAssociations);
            displayHints(model.displayHints);
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public final List<SupportedAssociation.Builder> getSupportedAssociations() {
            List<SupportedAssociation.Builder> result = SupportedAssociationListCopier.copyToBuilder(this.supportedAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedAssociations(Collection<SupportedAssociation.BuilderImpl> supportedAssociations) {
            this.supportedAssociations = SupportedAssociationListCopier.copyFromBuilder(supportedAssociations);
        }

        @Override
        public final Builder supportedAssociations(Collection<SupportedAssociation> supportedAssociations) {
            this.supportedAssociations = SupportedAssociationListCopier.copy(supportedAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAssociations(SupportedAssociation... supportedAssociations) {
            supportedAssociations(Arrays.asList(supportedAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAssociations(Consumer<SupportedAssociation.Builder>... supportedAssociations) {
            supportedAssociations(Stream.of(supportedAssociations)
                    .map(c -> SupportedAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RegistrationTypeDisplayHints.Builder getDisplayHints() {
            return displayHints != null ? displayHints.toBuilder() : null;
        }

        public final void setDisplayHints(RegistrationTypeDisplayHints.BuilderImpl displayHints) {
            this.displayHints = displayHints != null ? displayHints.build() : null;
        }

        @Override
        public final Builder displayHints(RegistrationTypeDisplayHints displayHints) {
            this.displayHints = displayHints;
            return this;
        }

        @Override
        public RegistrationTypeDefinition build() {
            return new RegistrationTypeDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
