/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestPhoneNumberRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<RequestPhoneNumberRequest.Builder, RequestPhoneNumberRequest> {
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(RequestPhoneNumberRequest::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(RequestPhoneNumberRequest::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NumberCapabilities")
            .getter(getter(RequestPhoneNumberRequest::numberCapabilitiesAsStrings))
            .setter(setter(Builder::numberCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberType").getter(getter(RequestPhoneNumberRequest::numberTypeAsString))
            .setter(setter(Builder::numberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberType").build()).build();

    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptOutListName").getter(getter(RequestPhoneNumberRequest::optOutListName))
            .setter(setter(Builder::optOutListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(RequestPhoneNumberRequest::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationId").getter(getter(RequestPhoneNumberRequest::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationId").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(RequestPhoneNumberRequest::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RequestPhoneNumberRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(RequestPhoneNumberRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISO_COUNTRY_CODE_FIELD,
            MESSAGE_TYPE_FIELD, NUMBER_CAPABILITIES_FIELD, NUMBER_TYPE_FIELD, OPT_OUT_LIST_NAME_FIELD, POOL_ID_FIELD,
            REGISTRATION_ID_FIELD, DELETION_PROTECTION_ENABLED_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String isoCountryCode;

    private final String messageType;

    private final List<String> numberCapabilities;

    private final String numberType;

    private final String optOutListName;

    private final String poolId;

    private final String registrationId;

    private final Boolean deletionProtectionEnabled;

    private final List<Tag> tags;

    private final String clientToken;

    private RequestPhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.isoCountryCode = builder.isoCountryCode;
        this.messageType = builder.messageType;
        this.numberCapabilities = builder.numberCapabilities;
        this.numberType = builder.numberType;
        this.optOutListName = builder.optOutListName;
        this.poolId = builder.poolId;
        this.registrationId = builder.registrationId;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * Indicates if the phone number will be used for text messages, voice messages, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return Indicates if the phone number will be used for text messages, voice messages, or both.
     */
    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(numberCapabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the NumberCapabilities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNumberCapabilities() {
        return numberCapabilities != null && !(numberCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates if the phone number will be used for text messages, voice messages, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumberCapabilities} method.
     * </p>
     * 
     * @return Indicates if the phone number will be used for text messages, voice messages, or both.
     */
    public final List<String> numberCapabilitiesAsStrings() {
        return numberCapabilities;
    }

    /**
     * <p>
     * The type of phone number to request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberType} will
     * return {@link RequestableNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number to request.
     * @see RequestableNumberType
     */
    public final RequestableNumberType numberType() {
        return RequestableNumberType.fromValue(numberType);
    }

    /**
     * <p>
     * The type of phone number to request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberType} will
     * return {@link RequestableNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number to request.
     * @see RequestableNumberType
     */
    public final String numberTypeAsString() {
        return numberType;
    }

    /**
     * <p>
     * The name of the OptOutList to associate with the phone number. You can use the OptOutListName or OptOutListArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The name of the OptOutList to associate with the phone number. You can use the OptOutListName or
     *         OptOutListArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String optOutListName() {
        return optOutListName;
    }

    /**
     * <p>
     * The pool to associated with the phone number. You can use the PoolId or PoolArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The pool to associated with the phone number. You can use the PoolId or PoolArn. </p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * Use this field to attach your phone number for an external registration process.
     * </p>
     * 
     * @return Use this field to attach your phone number for an external registration process.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * By default this is set to false. When set to true the phone number can't be deleted.
     * </p>
     * 
     * @return By default this is set to false. When set to true the phone number can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tags (key and value pairs) associate with the requested phone number.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags (key and value pairs) associate with the requested phone number.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify
     * a client token, a randomly generated token is used for the request to ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     *         specify a client token, a randomly generated token is used for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestPhoneNumberRequest)) {
            return false;
        }
        RequestPhoneNumberRequest other = (RequestPhoneNumberRequest) obj;
        return Objects.equals(isoCountryCode(), other.isoCountryCode())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && hasNumberCapabilities() == other.hasNumberCapabilities()
                && Objects.equals(numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings())
                && Objects.equals(numberTypeAsString(), other.numberTypeAsString())
                && Objects.equals(optOutListName(), other.optOutListName()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestPhoneNumberRequest").add("IsoCountryCode", isoCountryCode())
                .add("MessageType", messageTypeAsString())
                .add("NumberCapabilities", hasNumberCapabilities() ? numberCapabilitiesAsStrings() : null)
                .add("NumberType", numberTypeAsString()).add("OptOutListName", optOutListName()).add("PoolId", poolId())
                .add("RegistrationId", registrationId()).add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "NumberCapabilities":
            return Optional.ofNullable(clazz.cast(numberCapabilitiesAsStrings()));
        case "NumberType":
            return Optional.ofNullable(clazz.cast(numberTypeAsString()));
        case "OptOutListName":
            return Optional.ofNullable(clazz.cast(optOutListName()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "RegistrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("NumberCapabilities", NUMBER_CAPABILITIES_FIELD);
        map.put("NumberType", NUMBER_TYPE_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("RegistrationId", REGISTRATION_ID_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestPhoneNumberRequest, T> g) {
        return obj -> g.apply((RequestPhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, RequestPhoneNumberRequest> {
        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * Indicates if the phone number will be used for text messages, voice messages, or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Indicates if the phone number will be used for text messages, voice messages, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities);

        /**
         * <p>
         * Indicates if the phone number will be used for text messages, voice messages, or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Indicates if the phone number will be used for text messages, voice messages, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilitiesWithStrings(String... numberCapabilities);

        /**
         * <p>
         * Indicates if the phone number will be used for text messages, voice messages, or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Indicates if the phone number will be used for text messages, voice messages, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(Collection<NumberCapability> numberCapabilities);

        /**
         * <p>
         * Indicates if the phone number will be used for text messages, voice messages, or both.
         * </p>
         * 
         * @param numberCapabilities
         *        Indicates if the phone number will be used for text messages, voice messages, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCapabilities(NumberCapability... numberCapabilities);

        /**
         * <p>
         * The type of phone number to request.
         * </p>
         * 
         * @param numberType
         *        The type of phone number to request.
         * @see RequestableNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestableNumberType
         */
        Builder numberType(String numberType);

        /**
         * <p>
         * The type of phone number to request.
         * </p>
         * 
         * @param numberType
         *        The type of phone number to request.
         * @see RequestableNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestableNumberType
         */
        Builder numberType(RequestableNumberType numberType);

        /**
         * <p>
         * The name of the OptOutList to associate with the phone number. You can use the OptOutListName or
         * OptOutListArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param optOutListName
         *        The name of the OptOutList to associate with the phone number. You can use the OptOutListName or
         *        OptOutListArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOutListName(String optOutListName);

        /**
         * <p>
         * The pool to associated with the phone number. You can use the PoolId or PoolArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param poolId
         *        The pool to associated with the phone number. You can use the PoolId or PoolArn. </p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * Use this field to attach your phone number for an external registration process.
         * </p>
         * 
         * @param registrationId
         *        Use this field to attach your phone number for an external registration process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * By default this is set to false. When set to true the phone number can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        By default this is set to false. When set to true the phone number can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * An array of tags (key and value pairs) associate with the requested phone number.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) associate with the requested phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tags (key and value pairs) associate with the requested phone number.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) associate with the requested phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tags (key and value pairs) associate with the requested phone number.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, a randomly generated token is used for the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, a randomly generated token is used for the request to ensure
         *        idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String isoCountryCode;

        private String messageType;

        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();

        private String numberType;

        private String optOutListName;

        private String poolId;

        private String registrationId;

        private Boolean deletionProtectionEnabled;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestPhoneNumberRequest model) {
            super(model);
            isoCountryCode(model.isoCountryCode);
            messageType(model.messageType);
            numberCapabilitiesWithStrings(model.numberCapabilities);
            numberType(model.numberType);
            optOutListName(model.optOutListName);
            poolId(model.poolId);
            registrationId(model.registrationId);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String... numberCapabilities) {
            numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability... numberCapabilities) {
            numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public final String getNumberType() {
            return numberType;
        }

        public final void setNumberType(String numberType) {
            this.numberType = numberType;
        }

        @Override
        public final Builder numberType(String numberType) {
            this.numberType = numberType;
            return this;
        }

        @Override
        public final Builder numberType(RequestableNumberType numberType) {
            this.numberType(numberType == null ? null : numberType.toString());
            return this;
        }

        public final String getOptOutListName() {
            return optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestPhoneNumberRequest build() {
            return new RequestPhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
