/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendDestinationNumberVerificationCodeRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<SendDestinationNumberVerificationCodeRequest.Builder, SendDestinationNumberVerificationCodeRequest> {
    private static final SdkField<String> VERIFIED_DESTINATION_NUMBER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedDestinationNumberId")
            .getter(getter(SendDestinationNumberVerificationCodeRequest::verifiedDestinationNumberId))
            .setter(setter(Builder::verifiedDestinationNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedDestinationNumberId")
                    .build()).build();

    private static final SdkField<String> VERIFICATION_CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationChannel")
            .getter(getter(SendDestinationNumberVerificationCodeRequest::verificationChannelAsString))
            .setter(setter(Builder::verificationChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationChannel").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(SendDestinationNumberVerificationCodeRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(SendDestinationNumberVerificationCodeRequest::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName")
            .getter(getter(SendDestinationNumberVerificationCodeRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Context")
            .getter(getter(SendDestinationNumberVerificationCodeRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> DESTINATION_COUNTRY_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DestinationCountryParameters")
            .getter(getter(SendDestinationNumberVerificationCodeRequest::destinationCountryParametersAsStrings))
            .setter(setter(Builder::destinationCountryParametersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCountryParameters")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_DESTINATION_NUMBER_ID_FIELD, VERIFICATION_CHANNEL_FIELD, LANGUAGE_CODE_FIELD, ORIGINATION_IDENTITY_FIELD,
            CONFIGURATION_SET_NAME_FIELD, CONTEXT_FIELD, DESTINATION_COUNTRY_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String verifiedDestinationNumberId;

    private final String verificationChannel;

    private final String languageCode;

    private final String originationIdentity;

    private final String configurationSetName;

    private final Map<String, String> context;

    private final Map<String, String> destinationCountryParameters;

    private SendDestinationNumberVerificationCodeRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedDestinationNumberId = builder.verifiedDestinationNumberId;
        this.verificationChannel = builder.verificationChannel;
        this.languageCode = builder.languageCode;
        this.originationIdentity = builder.originationIdentity;
        this.configurationSetName = builder.configurationSetName;
        this.context = builder.context;
        this.destinationCountryParameters = builder.destinationCountryParameters;
    }

    /**
     * <p>
     * The unique identifier for the verified destination phone number.
     * </p>
     * 
     * @return The unique identifier for the verified destination phone number.
     */
    public final String verifiedDestinationNumberId() {
        return verifiedDestinationNumberId;
    }

    /**
     * <p>
     * Choose to send the verification code as an SMS or voice message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationChannel} will return {@link VerificationChannel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #verificationChannelAsString}.
     * </p>
     * 
     * @return Choose to send the verification code as an SMS or voice message.
     * @see VerificationChannel
     */
    public final VerificationChannel verificationChannel() {
        return VerificationChannel.fromValue(verificationChannel);
    }

    /**
     * <p>
     * Choose to send the verification code as an SMS or voice message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationChannel} will return {@link VerificationChannel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #verificationChannelAsString}.
     * </p>
     * 
     * @return Choose to send the verification code as an SMS or voice message.
     * @see VerificationChannel
     */
    public final String verificationChannelAsString() {
        return verificationChannel;
    }

    /**
     * <p>
     * Choose the language to use for the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Choose the language to use for the message.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Choose the language to use for the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Choose the language to use for the message.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn,
     * SenderId, SenderIdArn, PoolId, or PoolArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId,
     *         PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
     * </p>
     * 
     * @return The name of the configuration set to use. This can be either the ConfigurationSetName or
     *         ConfigurationSetArn.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can specify custom data in this field. If you do, that data is logged to the event destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return You can specify custom data in this field. If you do, that data is logged to the event destination.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * This field is used for any country-specific registration requirements. Currently, this setting is only used when
     * you send messages to recipients in India using a sender ID. For more information see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     * requirements for sending SMS messages to recipients in India</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationCountryParameters} method.
     * </p>
     * 
     * @return This field is used for any country-specific registration requirements. Currently, this setting is only
     *         used when you send messages to recipients in India using a sender ID. For more information see <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     *         requirements for sending SMS messages to recipients in India</a>.
     */
    public final Map<DestinationCountryParameterKey, String> destinationCountryParameters() {
        return DestinationCountryParametersCopier.copyStringToEnum(destinationCountryParameters);
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationCountryParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationCountryParameters() {
        return destinationCountryParameters != null && !(destinationCountryParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This field is used for any country-specific registration requirements. Currently, this setting is only used when
     * you send messages to recipients in India using a sender ID. For more information see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     * requirements for sending SMS messages to recipients in India</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationCountryParameters} method.
     * </p>
     * 
     * @return This field is used for any country-specific registration requirements. Currently, this setting is only
     *         used when you send messages to recipients in India using a sender ID. For more information see <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     *         requirements for sending SMS messages to recipients in India</a>.
     */
    public final Map<String, String> destinationCountryParametersAsStrings() {
        return destinationCountryParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedDestinationNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(verificationChannelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDestinationCountryParameters() ? destinationCountryParametersAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDestinationNumberVerificationCodeRequest)) {
            return false;
        }
        SendDestinationNumberVerificationCodeRequest other = (SendDestinationNumberVerificationCodeRequest) obj;
        return Objects.equals(verifiedDestinationNumberId(), other.verifiedDestinationNumberId())
                && Objects.equals(verificationChannelAsString(), other.verificationChannelAsString())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(configurationSetName(), other.configurationSetName()) && hasContext() == other.hasContext()
                && Objects.equals(context(), other.context())
                && hasDestinationCountryParameters() == other.hasDestinationCountryParameters()
                && Objects.equals(destinationCountryParametersAsStrings(), other.destinationCountryParametersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SendDestinationNumberVerificationCodeRequest")
                .add("VerifiedDestinationNumberId", verifiedDestinationNumberId())
                .add("VerificationChannel", verificationChannelAsString())
                .add("LanguageCode", languageCodeAsString())
                .add("OriginationIdentity", originationIdentity())
                .add("ConfigurationSetName", configurationSetName())
                .add("Context", hasContext() ? context() : null)
                .add("DestinationCountryParameters",
                        hasDestinationCountryParameters() ? destinationCountryParametersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedDestinationNumberId":
            return Optional.ofNullable(clazz.cast(verifiedDestinationNumberId()));
        case "VerificationChannel":
            return Optional.ofNullable(clazz.cast(verificationChannelAsString()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DestinationCountryParameters":
            return Optional.ofNullable(clazz.cast(destinationCountryParametersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedDestinationNumberId", VERIFIED_DESTINATION_NUMBER_ID_FIELD);
        map.put("VerificationChannel", VERIFICATION_CHANNEL_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("DestinationCountryParameters", DESTINATION_COUNTRY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendDestinationNumberVerificationCodeRequest, T> g) {
        return obj -> g.apply((SendDestinationNumberVerificationCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SendDestinationNumberVerificationCodeRequest> {
        /**
         * <p>
         * The unique identifier for the verified destination phone number.
         * </p>
         * 
         * @param verifiedDestinationNumberId
         *        The unique identifier for the verified destination phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedDestinationNumberId(String verifiedDestinationNumberId);

        /**
         * <p>
         * Choose to send the verification code as an SMS or voice message.
         * </p>
         * 
         * @param verificationChannel
         *        Choose to send the verification code as an SMS or voice message.
         * @see VerificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationChannel
         */
        Builder verificationChannel(String verificationChannel);

        /**
         * <p>
         * Choose to send the verification code as an SMS or voice message.
         * </p>
         * 
         * @param verificationChannel
         *        Choose to send the verification code as an SMS or voice message.
         * @see VerificationChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationChannel
         */
        Builder verificationChannel(VerificationChannel verificationChannel);

        /**
         * <p>
         * Choose the language to use for the message.
         * </p>
         * 
         * @param languageCode
         *        Choose the language to use for the message.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Choose the language to use for the message.
         * </p>
         * 
         * @param languageCode
         *        Choose the language to use for the message.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn,
         * SenderId, SenderIdArn, PoolId, or PoolArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param originationIdentity
         *        The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId,
         *        PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to use. This can be either the ConfigurationSetName or
         *        ConfigurationSetArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * You can specify custom data in this field. If you do, that data is logged to the event destination.
         * </p>
         * 
         * @param context
         *        You can specify custom data in this field. If you do, that data is logged to the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * This field is used for any country-specific registration requirements. Currently, this setting is only used
         * when you send messages to recipients in India using a sender ID. For more information see <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         * requirements for sending SMS messages to recipients in India</a>.
         * </p>
         * 
         * @param destinationCountryParameters
         *        This field is used for any country-specific registration requirements. Currently, this setting is only
         *        used when you send messages to recipients in India using a sender ID. For more information see <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         *        requirements for sending SMS messages to recipients in India</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCountryParametersWithStrings(Map<String, String> destinationCountryParameters);

        /**
         * <p>
         * This field is used for any country-specific registration requirements. Currently, this setting is only used
         * when you send messages to recipients in India using a sender ID. For more information see <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         * requirements for sending SMS messages to recipients in India</a>.
         * </p>
         * 
         * @param destinationCountryParameters
         *        This field is used for any country-specific registration requirements. Currently, this setting is only
         *        used when you send messages to recipients in India using a sender ID. For more information see <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         *        requirements for sending SMS messages to recipients in India</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> destinationCountryParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String verifiedDestinationNumberId;

        private String verificationChannel;

        private String languageCode;

        private String originationIdentity;

        private String configurationSetName;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> destinationCountryParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendDestinationNumberVerificationCodeRequest model) {
            super(model);
            verifiedDestinationNumberId(model.verifiedDestinationNumberId);
            verificationChannel(model.verificationChannel);
            languageCode(model.languageCode);
            originationIdentity(model.originationIdentity);
            configurationSetName(model.configurationSetName);
            context(model.context);
            destinationCountryParametersWithStrings(model.destinationCountryParameters);
        }

        public final String getVerifiedDestinationNumberId() {
            return verifiedDestinationNumberId;
        }

        public final void setVerifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
        }

        @Override
        public final Builder verifiedDestinationNumberId(String verifiedDestinationNumberId) {
            this.verifiedDestinationNumberId = verifiedDestinationNumberId;
            return this;
        }

        public final String getVerificationChannel() {
            return verificationChannel;
        }

        public final void setVerificationChannel(String verificationChannel) {
            this.verificationChannel = verificationChannel;
        }

        @Override
        public final Builder verificationChannel(String verificationChannel) {
            this.verificationChannel = verificationChannel;
            return this;
        }

        @Override
        public final Builder verificationChannel(VerificationChannel verificationChannel) {
            this.verificationChannel(verificationChannel == null ? null : verificationChannel.toString());
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Map<String, String> getDestinationCountryParameters() {
            if (destinationCountryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return destinationCountryParameters;
        }

        public final void setDestinationCountryParameters(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
        }

        @Override
        public final Builder destinationCountryParametersWithStrings(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
            return this;
        }

        @Override
        public final Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copyEnumToString(destinationCountryParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDestinationNumberVerificationCodeRequest build() {
            return new SendDestinationNumberVerificationCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
