/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendTextMessageRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<SendTextMessageRequest.Builder, SendTextMessageRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(SendTextMessageRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(SendTextMessageRequest::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<String> MESSAGE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageBody").getter(getter(SendTextMessageRequest::messageBody)).setter(setter(Builder::messageBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageBody").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(SendTextMessageRequest::messageTypeAsString))
            .setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> KEYWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Keyword")
            .getter(getter(SendTextMessageRequest::keyword)).setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()).build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(SendTextMessageRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxPrice").getter(getter(SendTextMessageRequest::maxPrice)).setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeToLive").getter(getter(SendTextMessageRequest::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Context")
            .getter(getter(SendTextMessageRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> DESTINATION_COUNTRY_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DestinationCountryParameters")
            .getter(getter(SendTextMessageRequest::destinationCountryParametersAsStrings))
            .setter(setter(Builder::destinationCountryParametersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCountryParameters")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(SendTextMessageRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(SendTextMessageRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<Boolean> MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MessageFeedbackEnabled").getter(getter(SendTextMessageRequest::messageFeedbackEnabled))
            .setter(setter(Builder::messageFeedbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFeedbackEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_IDENTITY_FIELD, MESSAGE_BODY_FIELD, MESSAGE_TYPE_FIELD, KEYWORD_FIELD,
            CONFIGURATION_SET_NAME_FIELD, MAX_PRICE_FIELD, TIME_TO_LIVE_FIELD, CONTEXT_FIELD,
            DESTINATION_COUNTRY_PARAMETERS_FIELD, DRY_RUN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, MESSAGE_FEEDBACK_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationPhoneNumber;

    private final String originationIdentity;

    private final String messageBody;

    private final String messageType;

    private final String keyword;

    private final String configurationSetName;

    private final String maxPrice;

    private final Integer timeToLive;

    private final Map<String, String> context;

    private final Map<String, String> destinationCountryParameters;

    private final Boolean dryRun;

    private final String protectConfigurationId;

    private final Boolean messageFeedbackEnabled;

    private SendTextMessageRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationIdentity = builder.originationIdentity;
        this.messageBody = builder.messageBody;
        this.messageType = builder.messageType;
        this.keyword = builder.keyword;
        this.configurationSetName = builder.configurationSetName;
        this.maxPrice = builder.maxPrice;
        this.timeToLive = builder.timeToLive;
        this.context = builder.context;
        this.destinationCountryParameters = builder.destinationCountryParameters;
        this.dryRun = builder.dryRun;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.messageFeedbackEnabled = builder.messageFeedbackEnabled;
    }

    /**
     * <p>
     * The destination phone number in E.164 format.
     * </p>
     * 
     * @return The destination phone number in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn,
     * SenderId, SenderIdArn, PoolId, or PoolArn.
     * </p>
     * <important>
     * <p>
     * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     * Resource Name(ARN).
     * </p>
     * </important>
     * 
     * @return The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId,
     *         PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p> <important>
     *         <p>
     *         If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
     *         Resource Name(ARN).
     *         </p>
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * <p>
     * The body of the text message.
     * </p>
     * 
     * @return The body of the text message.
     */
    public final String messageBody() {
        return messageBody;
    }

    /**
     * <p>
     * The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL for
     * messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL
     *         for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL for
     * messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL
     *         for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * When you register a short code in the US, you must specify a program name. If you don’t have a US short code,
     * omit this attribute.
     * </p>
     * 
     * @return When you register a short code in the US, you must specify a program name. If you don’t have a US short
     *         code, omit this attribute.
     */
    public final String keyword() {
        return keyword;
    }

    /**
     * <p>
     * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
     * </p>
     * 
     * @return The name of the configuration set to use. This can be either the ConfigurationSetName or
     *         ConfigurationSetArn.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The maximum amount that you want to spend, in US dollars, per each text message. If the calculated amount to send
     * the text message is greater than <code>MaxPrice</code>, the message is not sent and an error is returned.
     * </p>
     * 
     * @return The maximum amount that you want to spend, in US dollars, per each text message. If the calculated amount
     *         to send the text message is greater than <code>MaxPrice</code>, the message is not sent and an error is
     *         returned.
     */
    public final String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * How long the text message is valid for, in seconds. By default this is 72 hours. If the messages isn't handed off
     * before the TTL expires we stop attempting to hand off the message and return <code>TTL_EXPIRED</code> event.
     * </p>
     * 
     * @return How long the text message is valid for, in seconds. By default this is 72 hours. If the messages isn't
     *         handed off before the TTL expires we stop attempting to hand off the message and return
     *         <code>TTL_EXPIRED</code> event.
     */
    public final Integer timeToLive() {
        return timeToLive;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can specify custom data in this field. If you do, that data is logged to the event destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return You can specify custom data in this field. If you do, that data is logged to the event destination.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * This field is used for any country-specific registration requirements. Currently, this setting is only used when
     * you send messages to recipients in India using a sender ID. For more information see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     * requirements for sending SMS messages to recipients in India</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing the sender
     * ID registration process.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID registration
     * process.
     * </p>
     * <important>
     * <p>
     * Make sure that the Template ID that you specify matches your message template exactly. If your message doesn't
     * match the template that you provided during the registration process, the mobile carriers might reject your
     * message.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationCountryParameters} method.
     * </p>
     * 
     * @return This field is used for any country-specific registration requirements. Currently, this setting is only
     *         used when you send messages to recipients in India using a sender ID. For more information see <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     *         requirements for sending SMS messages to recipients in India</a>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing
     *         the sender ID registration process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID registration
     *         process.
     *         </p>
     *         <important>
     *         <p>
     *         Make sure that the Template ID that you specify matches your message template exactly. If your message
     *         doesn't match the template that you provided during the registration process, the mobile carriers might
     *         reject your message.
     *         </p>
     *         </important></li>
     */
    public final Map<DestinationCountryParameterKey, String> destinationCountryParameters() {
        return DestinationCountryParametersCopier.copyStringToEnum(destinationCountryParameters);
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationCountryParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationCountryParameters() {
        return destinationCountryParameters != null && !(destinationCountryParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This field is used for any country-specific registration requirements. Currently, this setting is only used when
     * you send messages to recipients in India using a sender ID. For more information see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     * requirements for sending SMS messages to recipients in India</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing the sender
     * ID registration process.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID registration
     * process.
     * </p>
     * <important>
     * <p>
     * Make sure that the Template ID that you specify matches your message template exactly. If your message doesn't
     * match the template that you provided during the registration process, the mobile carriers might reject your
     * message.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationCountryParameters} method.
     * </p>
     * 
     * @return This field is used for any country-specific registration requirements. Currently, this setting is only
     *         used when you send messages to recipients in India using a sender ID. For more information see <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
     *         requirements for sending SMS messages to recipients in India</a>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing
     *         the sender ID registration process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID registration
     *         process.
     *         </p>
     *         <important>
     *         <p>
     *         Make sure that the Template ID that you specify matches your message template exactly. If your message
     *         doesn't match the template that you provided during the registration process, the mobile carriers might
     *         reject your message.
     *         </p>
     *         </important></li>
     */
    public final Map<String, String> destinationCountryParametersAsStrings() {
        return destinationCountryParameters;
    }

    /**
     * <p>
     * When set to true, the message is checked and validated, but isn't sent to the end recipient. You are not charged
     * for using <code>DryRun</code>.
     * </p>
     * <p>
     * The Message Parts per Second (MPS) limit when using <code>DryRun</code> is five. If your origination identity has
     * a lower MPS limit then the lower MPS limit is used. For more information about MPS limits, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message Parts per Second
     * (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>..
     * </p>
     * 
     * @return When set to true, the message is checked and validated, but isn't sent to the end recipient. You are not
     *         charged for using <code>DryRun</code>.</p>
     *         <p>
     *         The Message Parts per Second (MPS) limit when using <code>DryRun</code> is five. If your origination
     *         identity has a lower MPS limit then the lower MPS limit is used. For more information about MPS limits,
     *         see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message
     *         Parts per Second (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>..
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * Set to true to enable message feedback for the message. When a user receives the message you need to update the
     * message status using <a>PutMessageFeedback</a>.
     * </p>
     * 
     * @return Set to true to enable message feedback for the message. When a user receives the message you need to
     *         update the message status using <a>PutMessageFeedback</a>.
     */
    public final Boolean messageFeedbackEnabled() {
        return messageFeedbackEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(messageBody());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDestinationCountryParameters() ? destinationCountryParametersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(messageFeedbackEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendTextMessageRequest)) {
            return false;
        }
        SendTextMessageRequest other = (SendTextMessageRequest) obj;
        return Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(originationIdentity(), other.originationIdentity())
                && Objects.equals(messageBody(), other.messageBody())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(keyword(), other.keyword())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(maxPrice(), other.maxPrice()) && Objects.equals(timeToLive(), other.timeToLive())
                && hasContext() == other.hasContext() && Objects.equals(context(), other.context())
                && hasDestinationCountryParameters() == other.hasDestinationCountryParameters()
                && Objects.equals(destinationCountryParametersAsStrings(), other.destinationCountryParametersAsStrings())
                && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(messageFeedbackEnabled(), other.messageFeedbackEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SendTextMessageRequest")
                .add("DestinationPhoneNumber", destinationPhoneNumber())
                .add("OriginationIdentity", originationIdentity())
                .add("MessageBody", messageBody())
                .add("MessageType", messageTypeAsString())
                .add("Keyword", keyword())
                .add("ConfigurationSetName", configurationSetName())
                .add("MaxPrice", maxPrice())
                .add("TimeToLive", timeToLive())
                .add("Context", hasContext() ? context() : null)
                .add("DestinationCountryParameters",
                        hasDestinationCountryParameters() ? destinationCountryParametersAsStrings() : null)
                .add("DryRun", dryRun()).add("ProtectConfigurationId", protectConfigurationId())
                .add("MessageFeedbackEnabled", messageFeedbackEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "MessageBody":
            return Optional.ofNullable(clazz.cast(messageBody()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        case "DestinationCountryParameters":
            return Optional.ofNullable(clazz.cast(destinationCountryParametersAsStrings()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "MessageFeedbackEnabled":
            return Optional.ofNullable(clazz.cast(messageFeedbackEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
        map.put("MessageBody", MESSAGE_BODY_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("Keyword", KEYWORD_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("TimeToLive", TIME_TO_LIVE_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("DestinationCountryParameters", DESTINATION_COUNTRY_PARAMETERS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("MessageFeedbackEnabled", MESSAGE_FEEDBACK_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendTextMessageRequest, T> g) {
        return obj -> g.apply((SendTextMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo, CopyableBuilder<Builder, SendTextMessageRequest> {
        /**
         * <p>
         * The destination phone number in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The destination phone number in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId, PhoneNumberArn,
         * SenderId, SenderIdArn, PoolId, or PoolArn.
         * </p>
         * <important>
         * <p>
         * If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full Amazon
         * Resource Name(ARN).
         * </p>
         * </important>
         * 
         * @param originationIdentity
         *        The origination identity of the message. This can be either the PhoneNumber, PhoneNumberId,
         *        PhoneNumberArn, SenderId, SenderIdArn, PoolId, or PoolArn.</p> <important>
         *        <p>
         *        If you are using a shared AWS End User Messaging SMS and Voice resource then you must use the full
         *        Amazon Resource Name(ARN).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * The body of the text message.
         * </p>
         * 
         * @param messageBody
         *        The body of the text message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageBody(String messageBody);

        /**
         * <p>
         * The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL for
         * messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL
         *        for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL for
         * messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param messageType
         *        The type of message. Valid values are for messages that are critical or time-sensitive and PROMOTIONAL
         *        for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * When you register a short code in the US, you must specify a program name. If you don’t have a US short code,
         * omit this attribute.
         * </p>
         * 
         * @param keyword
         *        When you register a short code in the US, you must specify a program name. If you don’t have a US
         *        short code, omit this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);

        /**
         * <p>
         * The name of the configuration set to use. This can be either the ConfigurationSetName or ConfigurationSetArn.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set to use. This can be either the ConfigurationSetName or
         *        ConfigurationSetArn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The maximum amount that you want to spend, in US dollars, per each text message. If the calculated amount to
         * send the text message is greater than <code>MaxPrice</code>, the message is not sent and an error is
         * returned.
         * </p>
         * 
         * @param maxPrice
         *        The maximum amount that you want to spend, in US dollars, per each text message. If the calculated
         *        amount to send the text message is greater than <code>MaxPrice</code>, the message is not sent and an
         *        error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * How long the text message is valid for, in seconds. By default this is 72 hours. If the messages isn't handed
         * off before the TTL expires we stop attempting to hand off the message and return <code>TTL_EXPIRED</code>
         * event.
         * </p>
         * 
         * @param timeToLive
         *        How long the text message is valid for, in seconds. By default this is 72 hours. If the messages isn't
         *        handed off before the TTL expires we stop attempting to hand off the message and return
         *        <code>TTL_EXPIRED</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * <p>
         * You can specify custom data in this field. If you do, that data is logged to the event destination.
         * </p>
         * 
         * @param context
         *        You can specify custom data in this field. If you do, that data is logged to the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * This field is used for any country-specific registration requirements. Currently, this setting is only used
         * when you send messages to recipients in India using a sender ID. For more information see <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         * requirements for sending SMS messages to recipients in India</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing the
         * sender ID registration process.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID registration
         * process.
         * </p>
         * <important>
         * <p>
         * Make sure that the Template ID that you specify matches your message template exactly. If your message
         * doesn't match the template that you provided during the registration process, the mobile carriers might
         * reject your message.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param destinationCountryParameters
         *        This field is used for any country-specific registration requirements. Currently, this setting is only
         *        used when you send messages to recipients in India using a sender ID. For more information see <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         *        requirements for sending SMS messages to recipients in India</a>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing
         *        the sender ID registration process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID
         *        registration process.
         *        </p>
         *        <important>
         *        <p>
         *        Make sure that the Template ID that you specify matches your message template exactly. If your message
         *        doesn't match the template that you provided during the registration process, the mobile carriers
         *        might reject your message.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCountryParametersWithStrings(Map<String, String> destinationCountryParameters);

        /**
         * <p>
         * This field is used for any country-specific registration requirements. Currently, this setting is only used
         * when you send messages to recipients in India using a sender ID. For more information see <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         * requirements for sending SMS messages to recipients in India</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing the
         * sender ID registration process.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID registration
         * process.
         * </p>
         * <important>
         * <p>
         * Make sure that the Template ID that you specify matches your message template exactly. If your message
         * doesn't match the template that you provided during the registration process, the mobile carriers might
         * reject your message.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param destinationCountryParameters
         *        This field is used for any country-specific registration requirements. Currently, this setting is only
         *        used when you send messages to recipients in India using a sender ID. For more information see <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-senderid-india.html">Special
         *        requirements for sending SMS messages to recipients in India</a>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_ENTITY_ID</code> The entity ID or Principal Entity (PE) ID that you received after completing
         *        the sender ID registration process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_TEMPLATE_ID</code> The template ID that you received after completing the sender ID
         *        registration process.
         *        </p>
         *        <important>
         *        <p>
         *        Make sure that the Template ID that you specify matches your message template exactly. If your message
         *        doesn't match the template that you provided during the registration process, the mobile carriers
         *        might reject your message.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> destinationCountryParameters);

        /**
         * <p>
         * When set to true, the message is checked and validated, but isn't sent to the end recipient. You are not
         * charged for using <code>DryRun</code>.
         * </p>
         * <p>
         * The Message Parts per Second (MPS) limit when using <code>DryRun</code> is five. If your origination identity
         * has a lower MPS limit then the lower MPS limit is used. For more information about MPS limits, see <a
         * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message Parts per
         * Second (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>..
         * </p>
         * 
         * @param dryRun
         *        When set to true, the message is checked and validated, but isn't sent to the end recipient. You are
         *        not charged for using <code>DryRun</code>.</p>
         *        <p>
         *        The Message Parts per Second (MPS) limit when using <code>DryRun</code> is five. If your origination
         *        identity has a lower MPS limit then the lower MPS limit is used. For more information about MPS
         *        limits, see <a
         *        href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sms-limitations-mps.html">Message Parts
         *        per Second (MPS) limits</a> in the <i>AWS End User Messaging SMS User Guide</i>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * Set to true to enable message feedback for the message. When a user receives the message you need to update
         * the message status using <a>PutMessageFeedback</a>.
         * </p>
         * 
         * @param messageFeedbackEnabled
         *        Set to true to enable message feedback for the message. When a user receives the message you need to
         *        update the message status using <a>PutMessageFeedback</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String destinationPhoneNumber;

        private String originationIdentity;

        private String messageBody;

        private String messageType;

        private String keyword;

        private String configurationSetName;

        private String maxPrice;

        private Integer timeToLive;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> destinationCountryParameters = DefaultSdkAutoConstructMap.getInstance();

        private Boolean dryRun;

        private String protectConfigurationId;

        private Boolean messageFeedbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SendTextMessageRequest model) {
            super(model);
            destinationPhoneNumber(model.destinationPhoneNumber);
            originationIdentity(model.originationIdentity);
            messageBody(model.messageBody);
            messageType(model.messageType);
            keyword(model.keyword);
            configurationSetName(model.configurationSetName);
            maxPrice(model.maxPrice);
            timeToLive(model.timeToLive);
            context(model.context);
            destinationCountryParametersWithStrings(model.destinationCountryParameters);
            dryRun(model.dryRun);
            protectConfigurationId(model.protectConfigurationId);
            messageFeedbackEnabled(model.messageFeedbackEnabled);
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getMessageBody() {
            return messageBody;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final String getKeyword() {
            return keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextMapCopier.copy(context);
            return this;
        }

        public final Map<String, String> getDestinationCountryParameters() {
            if (destinationCountryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return destinationCountryParameters;
        }

        public final void setDestinationCountryParameters(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
        }

        @Override
        public final Builder destinationCountryParametersWithStrings(Map<String, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copy(destinationCountryParameters);
            return this;
        }

        @Override
        public final Builder destinationCountryParameters(Map<DestinationCountryParameterKey, String> destinationCountryParameters) {
            this.destinationCountryParameters = DestinationCountryParametersCopier.copyEnumToString(destinationCountryParameters);
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Boolean getMessageFeedbackEnabled() {
            return messageFeedbackEnabled;
        }

        public final void setMessageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
        }

        @Override
        public final Builder messageFeedbackEnabled(Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendTextMessageRequest build() {
            return new SendTextMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
