/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The alphanumeric sender ID in a specific country that you want to describe. For more information on sender IDs see <a
 * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/sender-id-request.html">Requesting sender IDs </a> in
 * the <i>AWS End User Messaging SMS User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SenderIdAndCountry implements SdkPojo, Serializable,
        ToCopyableBuilder<SenderIdAndCountry.Builder, SenderIdAndCountry> {
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(SenderIdAndCountry::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(SenderIdAndCountry::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_FIELD,
            ISO_COUNTRY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String senderId;

    private final String isoCountryCode;

    private SenderIdAndCountry(BuilderImpl builder) {
        this.senderId = builder.senderId;
        this.isoCountryCode = builder.isoCountryCode;
    }

    /**
     * <p>
     * The unique identifier of the sender.
     * </p>
     * 
     * @return The unique identifier of the sender.
     */
    public final String senderId() {
        return senderId;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SenderIdAndCountry)) {
            return false;
        }
        SenderIdAndCountry other = (SenderIdAndCountry) obj;
        return Objects.equals(senderId(), other.senderId()) && Objects.equals(isoCountryCode(), other.isoCountryCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SenderIdAndCountry").add("SenderId", senderId()).add("IsoCountryCode", isoCountryCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SenderId", SENDER_ID_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SenderIdAndCountry, T> g) {
        return obj -> g.apply((SenderIdAndCountry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SenderIdAndCountry> {
        /**
         * <p>
         * The unique identifier of the sender.
         * </p>
         * 
         * @param senderId
         *        The unique identifier of the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);
    }

    static final class BuilderImpl implements Builder {
        private String senderId;

        private String isoCountryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(SenderIdAndCountry model) {
            senderId(model.senderId);
            isoCountryCode(model.isoCountryCode);
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        @Override
        public SenderIdAndCountry build() {
            return new SenderIdAndCountry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
