/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The processing rules for when a registration can be associated with an origination identity and disassociated from an
 * origination identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedAssociation.Builder, SupportedAssociation> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(SupportedAssociation::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(SupportedAssociation::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<String> ASSOCIATION_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationBehavior").getter(getter(SupportedAssociation::associationBehaviorAsString))
            .setter(setter(Builder::associationBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationBehavior").build())
            .build();

    private static final SdkField<String> DISASSOCIATION_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisassociationBehavior").getter(getter(SupportedAssociation::disassociationBehaviorAsString))
            .setter(setter(Builder::disassociationBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociationBehavior").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            ISO_COUNTRY_CODE_FIELD, ASSOCIATION_BEHAVIOR_FIELD, DISASSOCIATION_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String isoCountryCode;

    private final String associationBehavior;

    private final String disassociationBehavior;

    private SupportedAssociation(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.isoCountryCode = builder.isoCountryCode;
        this.associationBehavior = builder.associationBehavior;
        this.disassociationBehavior = builder.disassociationBehavior;
    }

    /**
     * <p>
     * Defines the behavior of when an origination identity and registration can be associated with each other.
     * </p>
     * 
     * @return Defines the behavior of when an origination identity and registration can be associated with each other.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The association behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be
     * automatically provisioned once the registration is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a
     * registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long codes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #associationBehavior} will return {@link RegistrationAssociationBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #associationBehaviorAsString}.
     * </p>
     * 
     * @return The association behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a
     *         registration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be
     *         automatically provisioned once the registration is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a
     *         registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long
     *         codes.
     *         </p>
     *         </li>
     * @see RegistrationAssociationBehavior
     */
    public final RegistrationAssociationBehavior associationBehavior() {
        return RegistrationAssociationBehavior.fromValue(associationBehavior);
    }

    /**
     * <p>
     * The association behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be
     * automatically provisioned once the registration is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a
     * registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long codes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #associationBehavior} will return {@link RegistrationAssociationBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #associationBehaviorAsString}.
     * </p>
     * 
     * @return The association behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a
     *         registration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be
     *         automatically provisioned once the registration is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a
     *         registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long
     *         codes.
     *         </p>
     *         </li>
     * @see RegistrationAssociationBehavior
     */
    public final String associationBehaviorAsString() {
        return associationBehavior;
    }

    /**
     * <p>
     * The disassociation behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from the
     * registration before the registration can be closed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated from
     * the registration before the registration can be deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination identities
     * will be disasscoiated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #disassociationBehavior} will return {@link RegistrationDisassociationBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #disassociationBehaviorAsString}.
     * </p>
     * 
     * @return The disassociation behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from
     *         the registration before the registration can be closed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated
     *         from the registration before the registration can be deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination
     *         identities will be disasscoiated.
     *         </p>
     *         </li>
     * @see RegistrationDisassociationBehavior
     */
    public final RegistrationDisassociationBehavior disassociationBehavior() {
        return RegistrationDisassociationBehavior.fromValue(disassociationBehavior);
    }

    /**
     * <p>
     * The disassociation behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from the
     * registration before the registration can be closed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated from
     * the registration before the registration can be deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination identities
     * will be disasscoiated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #disassociationBehavior} will return {@link RegistrationDisassociationBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #disassociationBehaviorAsString}.
     * </p>
     * 
     * @return The disassociation behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from
     *         the registration before the registration can be closed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated
     *         from the registration before the registration can be deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination
     *         identities will be disasscoiated.
     *         </p>
     *         </li>
     * @see RegistrationDisassociationBehavior
     */
    public final String disassociationBehaviorAsString() {
        return disassociationBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(associationBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disassociationBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedAssociation)) {
            return false;
        }
        SupportedAssociation other = (SupportedAssociation) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(isoCountryCode(), other.isoCountryCode())
                && Objects.equals(associationBehaviorAsString(), other.associationBehaviorAsString())
                && Objects.equals(disassociationBehaviorAsString(), other.disassociationBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedAssociation").add("ResourceType", resourceType())
                .add("IsoCountryCode", isoCountryCode()).add("AssociationBehavior", associationBehaviorAsString())
                .add("DisassociationBehavior", disassociationBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "AssociationBehavior":
            return Optional.ofNullable(clazz.cast(associationBehaviorAsString()));
        case "DisassociationBehavior":
            return Optional.ofNullable(clazz.cast(disassociationBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("AssociationBehavior", ASSOCIATION_BEHAVIOR_FIELD);
        map.put("DisassociationBehavior", DISASSOCIATION_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedAssociation, T> g) {
        return obj -> g.apply((SupportedAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedAssociation> {
        /**
         * <p>
         * Defines the behavior of when an origination identity and registration can be associated with each other.
         * </p>
         * 
         * @param resourceType
         *        Defines the behavior of when an origination identity and registration can be associated with each
         *        other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The association behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a
         * registration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be
         * automatically provisioned once the registration is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a
         * registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long
         * codes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationBehavior
         *        The association behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a
         *        registration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will
         *        be automatically provisioned once the registration is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must
         *        complete a registration first, then associate one or more phone numbers later. For example 10DLC
         *        campaigns and long codes.
         *        </p>
         *        </li>
         * @see RegistrationAssociationBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationAssociationBehavior
         */
        Builder associationBehavior(String associationBehavior);

        /**
         * <p>
         * The association behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a
         * registration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will be
         * automatically provisioned once the registration is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must complete a
         * registration first, then associate one or more phone numbers later. For example 10DLC campaigns and long
         * codes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationBehavior
         *        The association behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASSOCIATE_BEFORE_SUBMIT</code> The origination identity has to be supplied when creating a
         *        registration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSOCIATE_ON_APPROVAL</code> This applies to all short code registrations. The short code will
         *        be automatically provisioned once the registration is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSOCIATE_AFTER_COMPLETE</code> This applies to phone number registrations when you must
         *        complete a registration first, then associate one or more phone numbers later. For example 10DLC
         *        campaigns and long codes.
         *        </p>
         *        </li>
         * @see RegistrationAssociationBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationAssociationBehavior
         */
        Builder associationBehavior(RegistrationAssociationBehavior associationBehavior);

        /**
         * <p>
         * The disassociation behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from the
         * registration before the registration can be closed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated
         * from the registration before the registration can be deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination identities
         * will be disasscoiated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param disassociationBehavior
         *        The disassociation behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated
         *        from the registration before the registration can be closed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be
         *        disassociated from the registration before the registration can be deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination
         *        identities will be disasscoiated.
         *        </p>
         *        </li>
         * @see RegistrationDisassociationBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationDisassociationBehavior
         */
        Builder disassociationBehavior(String disassociationBehavior);

        /**
         * <p>
         * The disassociation behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated from the
         * registration before the registration can be closed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be disassociated
         * from the registration before the registration can be deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination identities
         * will be disasscoiated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param disassociationBehavior
         *        The disassociation behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DISASSOCIATE_ALL_CLOSES_REGISTRATION</code> All origination identities must be disassociated
         *        from the registration before the registration can be closed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION</code> All origination identities must be
         *        disassociated from the registration before the registration can be deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_REGISTRATION_DISASSOCIATES</code> The registration can be deleted and all origination
         *        identities will be disasscoiated.
         *        </p>
         *        </li>
         * @see RegistrationDisassociationBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationDisassociationBehavior
         */
        Builder disassociationBehavior(RegistrationDisassociationBehavior disassociationBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String isoCountryCode;

        private String associationBehavior;

        private String disassociationBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedAssociation model) {
            resourceType(model.resourceType);
            isoCountryCode(model.isoCountryCode);
            associationBehavior(model.associationBehavior);
            disassociationBehavior(model.disassociationBehavior);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getAssociationBehavior() {
            return associationBehavior;
        }

        public final void setAssociationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
        }

        @Override
        public final Builder associationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
            return this;
        }

        @Override
        public final Builder associationBehavior(RegistrationAssociationBehavior associationBehavior) {
            this.associationBehavior(associationBehavior == null ? null : associationBehavior.toString());
            return this;
        }

        public final String getDisassociationBehavior() {
            return disassociationBehavior;
        }

        public final void setDisassociationBehavior(String disassociationBehavior) {
            this.disassociationBehavior = disassociationBehavior;
        }

        @Override
        public final Builder disassociationBehavior(String disassociationBehavior) {
            this.disassociationBehavior = disassociationBehavior;
            return this;
        }

        @Override
        public final Builder disassociationBehavior(RegistrationDisassociationBehavior disassociationBehavior) {
            this.disassociationBehavior(disassociationBehavior == null ? null : disassociationBehavior.toString());
            return this;
        }

        @Override
        public SupportedAssociation build() {
            return new SupportedAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
