/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Validation rules for a text field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextValidation implements SdkPojo, Serializable, ToCopyableBuilder<TextValidation.Builder, TextValidation> {
    private static final SdkField<Integer> MIN_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLength").getter(getter(TextValidation::minLength)).setter(setter(Builder::minLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinLength").build()).build();

    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLength").getter(getter(TextValidation::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Pattern")
            .getter(getter(TextValidation::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_LENGTH_FIELD,
            MAX_LENGTH_FIELD, PATTERN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minLength;

    private final Integer maxLength;

    private final String pattern;

    private TextValidation(BuilderImpl builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.pattern = builder.pattern;
    }

    /**
     * <p>
     * The minimum number of characters for the text field.
     * </p>
     * 
     * @return The minimum number of characters for the text field.
     */
    public final Integer minLength() {
        return minLength;
    }

    /**
     * <p>
     * The maximum number of characters for the text field.
     * </p>
     * 
     * @return The maximum number of characters for the text field.
     */
    public final Integer maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * The regular expression used to validate the text field.
     * </p>
     * 
     * @return The regular expression used to validate the text field.
     */
    public final String pattern() {
        return pattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextValidation)) {
            return false;
        }
        TextValidation other = (TextValidation) obj;
        return Objects.equals(minLength(), other.minLength()) && Objects.equals(maxLength(), other.maxLength())
                && Objects.equals(pattern(), other.pattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextValidation").add("MinLength", minLength()).add("MaxLength", maxLength())
                .add("Pattern", pattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "Pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinLength", MIN_LENGTH_FIELD);
        map.put("MaxLength", MAX_LENGTH_FIELD);
        map.put("Pattern", PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextValidation, T> g) {
        return obj -> g.apply((TextValidation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextValidation> {
        /**
         * <p>
         * The minimum number of characters for the text field.
         * </p>
         * 
         * @param minLength
         *        The minimum number of characters for the text field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(Integer minLength);

        /**
         * <p>
         * The maximum number of characters for the text field.
         * </p>
         * 
         * @param maxLength
         *        The maximum number of characters for the text field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(Integer maxLength);

        /**
         * <p>
         * The regular expression used to validate the text field.
         * </p>
         * 
         * @param pattern
         *        The regular expression used to validate the text field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);
    }

    static final class BuilderImpl implements Builder {
        private Integer minLength;

        private Integer maxLength;

        private String pattern;

        private BuilderImpl() {
        }

        private BuilderImpl(TextValidation model) {
            minLength(model.minLength);
            maxLength(model.maxLength);
            pattern(model.pattern);
        }

        public final Integer getMinLength() {
            return minLength;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final Integer getMaxLength() {
            return maxLength;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        public TextValidation build() {
            return new TextValidation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
