/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventDestinationResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<UpdateEventDestinationResponse.Builder, UpdateEventDestinationResponse> {
    private static final SdkField<String> CONFIGURATION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetArn").getter(getter(UpdateEventDestinationResponse::configurationSetArn))
            .setter(setter(Builder::configurationSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetArn").build())
            .build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(UpdateEventDestinationResponse::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<EventDestination> EVENT_DESTINATION_FIELD = SdkField
            .<EventDestination> builder(MarshallingType.SDK_POJO).memberName("EventDestination")
            .getter(getter(UpdateEventDestinationResponse::eventDestination)).setter(setter(Builder::eventDestination))
            .constructor(EventDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_ARN_FIELD,
            CONFIGURATION_SET_NAME_FIELD, EVENT_DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationSetArn;

    private final String configurationSetName;

    private final EventDestination eventDestination;

    private UpdateEventDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSetArn = builder.configurationSetArn;
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.
     */
    public final String configurationSetArn() {
        return configurationSetArn;
    }

    /**
     * <p>
     * The name of the configuration set.
     * </p>
     * 
     * @return The name of the configuration set.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * An EventDestination object containing the details of where events will be logged.
     * </p>
     * 
     * @return An EventDestination object containing the details of where events will be logged.
     */
    public final EventDestination eventDestination() {
        return eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventDestinationResponse)) {
            return false;
        }
        UpdateEventDestinationResponse other = (UpdateEventDestinationResponse) obj;
        return Objects.equals(configurationSetArn(), other.configurationSetArn())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestination(), other.eventDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventDestinationResponse").add("ConfigurationSetArn", configurationSetArn())
                .add("ConfigurationSetName", configurationSetName()).add("EventDestination", eventDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetArn":
            return Optional.ofNullable(clazz.cast(configurationSetArn()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestination":
            return Optional.ofNullable(clazz.cast(eventDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetArn", CONFIGURATION_SET_ARN_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("EventDestination", EVENT_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventDestinationResponse, T> g) {
        return obj -> g.apply((UpdateEventDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEventDestinationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.
         * </p>
         * 
         * @param configurationSetArn
         *        The Amazon Resource Name (ARN) for the ConfigurationSet that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetArn(String configurationSetArn);

        /**
         * <p>
         * The name of the configuration set.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * An EventDestination object containing the details of where events will be logged.
         * </p>
         * 
         * @param eventDestination
         *        An EventDestination object containing the details of where events will be logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestination eventDestination);

        /**
         * <p>
         * An EventDestination object containing the details of where events will be logged.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventDestination.Builder} avoiding the
         * need to create one manually via {@link EventDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #eventDestination(EventDestination)}.
         * 
         * @param eventDestination
         *        a consumer that will call methods on {@link EventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestination(EventDestination)
         */
        default Builder eventDestination(Consumer<EventDestination.Builder> eventDestination) {
            return eventDestination(EventDestination.builder().applyMutation(eventDestination).build());
        }
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String configurationSetArn;

        private String configurationSetName;

        private EventDestination eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventDestinationResponse model) {
            super(model);
            configurationSetArn(model.configurationSetArn);
            configurationSetName(model.configurationSetName);
            eventDestination(model.eventDestination);
        }

        public final String getConfigurationSetArn() {
            return configurationSetArn;
        }

        public final void setConfigurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
        }

        @Override
        public final Builder configurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final EventDestination.Builder getEventDestination() {
            return eventDestination != null ? eventDestination.toBuilder() : null;
        }

        public final void setEventDestination(EventDestination.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        @Override
        public final Builder eventDestination(EventDestination eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        @Override
        public UpdateEventDestinationResponse build() {
            return new UpdateEventDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
