/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProtectConfigurationCountryRuleSetRequest extends PinpointSmsVoiceV2Request
        implements
        ToCopyableBuilder<UpdateProtectConfigurationCountryRuleSetRequest.Builder, UpdateProtectConfigurationCountryRuleSetRequest> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId")
            .getter(getter(UpdateProtectConfigurationCountryRuleSetRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<String> NUMBER_CAPABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberCapability")
            .getter(getter(UpdateProtectConfigurationCountryRuleSetRequest::numberCapabilityAsString))
            .setter(setter(Builder::numberCapability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapability").build()).build();

    private static final SdkField<Map<String, ProtectConfigurationCountryRuleSetInformation>> COUNTRY_RULE_SET_UPDATES_FIELD = SdkField
            .<Map<String, ProtectConfigurationCountryRuleSetInformation>> builder(MarshallingType.MAP)
            .memberName("CountryRuleSetUpdates")
            .getter(getter(UpdateProtectConfigurationCountryRuleSetRequest::countryRuleSetUpdates))
            .setter(setter(Builder::countryRuleSetUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryRuleSetUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ProtectConfigurationCountryRuleSetInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectConfigurationCountryRuleSetInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ID_FIELD, NUMBER_CAPABILITY_FIELD, COUNTRY_RULE_SET_UPDATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationId;

    private final String numberCapability;

    private final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates;

    private UpdateProtectConfigurationCountryRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationId = builder.protectConfigurationId;
        this.numberCapability = builder.numberCapability;
        this.countryRuleSetUpdates = builder.countryRuleSetUpdates;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * The number capability to apply the CountryRuleSetUpdates updates to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberCapability}
     * will return {@link NumberCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberCapabilityAsString}.
     * </p>
     * 
     * @return The number capability to apply the CountryRuleSetUpdates updates to.
     * @see NumberCapability
     */
    public final NumberCapability numberCapability() {
        return NumberCapability.fromValue(numberCapability);
    }

    /**
     * <p>
     * The number capability to apply the CountryRuleSetUpdates updates to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numberCapability}
     * will return {@link NumberCapability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numberCapabilityAsString}.
     * </p>
     * 
     * @return The number capability to apply the CountryRuleSetUpdates updates to.
     * @see NumberCapability
     */
    public final String numberCapabilityAsString() {
        return numberCapability;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountryRuleSetUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCountryRuleSetUpdates() {
        return countryRuleSetUpdates != null && !(countryRuleSetUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested
     * NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes, see <a
     * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">Supported
     * countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountryRuleSetUpdates} method.
     * </p>
     * 
     * @return A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested
     *         NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes,
     *         see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">
     *         Supported countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
     */
    public final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates() {
        return countryRuleSetUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(numberCapabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCountryRuleSetUpdates() ? countryRuleSetUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProtectConfigurationCountryRuleSetRequest)) {
            return false;
        }
        UpdateProtectConfigurationCountryRuleSetRequest other = (UpdateProtectConfigurationCountryRuleSetRequest) obj;
        return Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(numberCapabilityAsString(), other.numberCapabilityAsString())
                && hasCountryRuleSetUpdates() == other.hasCountryRuleSetUpdates()
                && Objects.equals(countryRuleSetUpdates(), other.countryRuleSetUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProtectConfigurationCountryRuleSetRequest")
                .add("ProtectConfigurationId", protectConfigurationId()).add("NumberCapability", numberCapabilityAsString())
                .add("CountryRuleSetUpdates", hasCountryRuleSetUpdates() ? countryRuleSetUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "NumberCapability":
            return Optional.ofNullable(clazz.cast(numberCapabilityAsString()));
        case "CountryRuleSetUpdates":
            return Optional.ofNullable(clazz.cast(countryRuleSetUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("NumberCapability", NUMBER_CAPABILITY_FIELD);
        map.put("CountryRuleSetUpdates", COUNTRY_RULE_SET_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProtectConfigurationCountryRuleSetRequest, T> g) {
        return obj -> g.apply((UpdateProtectConfigurationCountryRuleSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProtectConfigurationCountryRuleSetRequest> {
        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * The number capability to apply the CountryRuleSetUpdates updates to.
         * </p>
         * 
         * @param numberCapability
         *        The number capability to apply the CountryRuleSetUpdates updates to.
         * @see NumberCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberCapability
         */
        Builder numberCapability(String numberCapability);

        /**
         * <p>
         * The number capability to apply the CountryRuleSetUpdates updates to.
         * </p>
         * 
         * @param numberCapability
         *        The number capability to apply the CountryRuleSetUpdates updates to.
         * @see NumberCapability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberCapability
         */
        Builder numberCapability(NumberCapability numberCapability);

        /**
         * <p>
         * A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the requested
         * NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO country codes, see
         * <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html">Supported
         * countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
         * </p>
         * 
         * @param countryRuleSetUpdates
         *        A map of ProtectConfigurationCountryRuleSetInformation objects that contain the details for the
         *        requested NumberCapability. The Key is the two-letter ISO country code. For a list of supported ISO
         *        country codes, see <a
         *        href="https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html"
         *        >Supported countries and regions (SMS channel)</a> in the AWS End User Messaging SMS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryRuleSetUpdates(Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String protectConfigurationId;

        private String numberCapability;

        private Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProtectConfigurationCountryRuleSetRequest model) {
            super(model);
            protectConfigurationId(model.protectConfigurationId);
            numberCapability(model.numberCapability);
            countryRuleSetUpdates(model.countryRuleSetUpdates);
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getNumberCapability() {
            return numberCapability;
        }

        public final void setNumberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
        }

        @Override
        public final Builder numberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
            return this;
        }

        @Override
        public final Builder numberCapability(NumberCapability numberCapability) {
            this.numberCapability(numberCapability == null ? null : numberCapability.toString());
            return this;
        }

        public final Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> getCountryRuleSetUpdates() {
            Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> result = ProtectConfigurationCountryRuleSetCopier
                    .copyToBuilder(this.countryRuleSetUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCountryRuleSetUpdates(
                Map<String, ProtectConfigurationCountryRuleSetInformation.BuilderImpl> countryRuleSetUpdates) {
            this.countryRuleSetUpdates = ProtectConfigurationCountryRuleSetCopier.copyFromBuilder(countryRuleSetUpdates);
        }

        @Override
        public final Builder countryRuleSetUpdates(
                Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSetUpdates) {
            this.countryRuleSetUpdates = ProtectConfigurationCountryRuleSetCopier.copy(countryRuleSetUpdates);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProtectConfigurationCountryRuleSetRequest build() {
            return new UpdateProtectConfigurationCountryRuleSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
