/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProtectConfigurationRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<UpdateProtectConfigurationRequest.Builder, UpdateProtectConfigurationRequest> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(UpdateProtectConfigurationRequest::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdateProtectConfigurationRequest::deletionProtectionEnabled))
            .setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECT_CONFIGURATION_ID_FIELD, DELETION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String protectConfigurationId;

    private final Boolean deletionProtectionEnabled;

    private UpdateProtectConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationId = builder.protectConfigurationId;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    /**
     * <p>
     * When set to true deletion protection is enabled. By default this is set to false.
     * </p>
     * 
     * @return When set to true deletion protection is enabled. By default this is set to false.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProtectConfigurationRequest)) {
            return false;
        }
        UpdateProtectConfigurationRequest other = (UpdateProtectConfigurationRequest) obj;
        return Objects.equals(protectConfigurationId(), other.protectConfigurationId())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProtectConfigurationRequest").add("ProtectConfigurationId", protectConfigurationId())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProtectConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateProtectConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProtectConfigurationRequest> {
        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);

        /**
         * <p>
         * When set to true deletion protection is enabled. By default this is set to false.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        When set to true deletion protection is enabled. By default this is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String protectConfigurationId;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProtectConfigurationRequest model) {
            super(model);
            protectConfigurationId(model.protectConfigurationId);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProtectConfigurationRequest build() {
            return new UpdateProtectConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
