/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSenderIdRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<UpdateSenderIdRequest.Builder, UpdateSenderIdRequest> {
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(UpdateSenderIdRequest::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(UpdateSenderIdRequest::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdateSenderIdRequest::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_FIELD,
            ISO_COUNTRY_CODE_FIELD, DELETION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String senderId;

    private final String isoCountryCode;

    private final Boolean deletionProtectionEnabled;

    private UpdateSenderIdRequest(BuilderImpl builder) {
        super(builder);
        this.senderId = builder.senderId;
        this.isoCountryCode = builder.isoCountryCode;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The sender ID to update.
     * </p>
     * 
     * @return The sender ID to update.
     */
    public final String senderId() {
        return senderId;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * By default this is set to false. When set to true the sender ID can't be deleted.
     * </p>
     * 
     * @return By default this is set to false. When set to true the sender ID can't be deleted.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSenderIdRequest)) {
            return false;
        }
        UpdateSenderIdRequest other = (UpdateSenderIdRequest) obj;
        return Objects.equals(senderId(), other.senderId()) && Objects.equals(isoCountryCode(), other.isoCountryCode())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSenderIdRequest").add("SenderId", senderId()).add("IsoCountryCode", isoCountryCode())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SenderId", SENDER_ID_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSenderIdRequest, T> g) {
        return obj -> g.apply((UpdateSenderIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSenderIdRequest> {
        /**
         * <p>
         * The sender ID to update.
         * </p>
         * 
         * @param senderId
         *        The sender ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * By default this is set to false. When set to true the sender ID can't be deleted.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        By default this is set to false. When set to true the sender ID can't be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private String senderId;

        private String isoCountryCode;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSenderIdRequest model) {
            super(model);
            senderId(model.senderId);
            isoCountryCode(model.isoCountryCode);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSenderIdRequest build() {
            return new UpdateSenderIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
