/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationTypeDefinitionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationTypeDefinition;

public class DescribeRegistrationTypeDefinitionsPublisher
implements SdkPublisher<DescribeRegistrationTypeDefinitionsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationTypeDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationTypeDefinitionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationTypeDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationTypeDefinitionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationTypeDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationTypeDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationTypeDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationTypeDefinition> registrationTypeDefinitions() {
        Function<DescribeRegistrationTypeDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationTypeDefinitions() != null) {
                return response.registrationTypeDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationTypeDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationTypeDefinitionsResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationTypeDefinitionsResponse> {
        private DescribeRegistrationTypeDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationTypeDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationTypeDefinitionsResponse> nextPage(DescribeRegistrationTypeDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationTypeDefinitionsPublisher.this.client.describeRegistrationTypeDefinitions(DescribeRegistrationTypeDefinitionsPublisher.this.firstRequest);
            }
            return DescribeRegistrationTypeDefinitionsPublisher.this.client.describeRegistrationTypeDefinitions((DescribeRegistrationTypeDefinitionsRequest)((Object)DescribeRegistrationTypeDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

