/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CarrierLookupResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<CarrierLookupResponse.Builder, CarrierLookupResponse> {
    private static final SdkField<String> E164_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("E164PhoneNumber").getter(getter(CarrierLookupResponse::e164PhoneNumber))
            .setter(setter(Builder::e164PhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumber").build()).build();

    private static final SdkField<String> DIALING_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DialingCountryCode").getter(getter(CarrierLookupResponse::dialingCountryCode))
            .setter(setter(Builder::dialingCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialingCountryCode").build())
            .build();

    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsoCountryCode").getter(getter(CarrierLookupResponse::isoCountryCode))
            .setter(setter(Builder::isoCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(CarrierLookupResponse::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> MCC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("MCC")
            .getter(getter(CarrierLookupResponse::mcc)).setter(setter(Builder::mcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MCC").build()).build();

    private static final SdkField<String> MNC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("MNC")
            .getter(getter(CarrierLookupResponse::mnc)).setter(setter(Builder::mnc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MNC").build()).build();

    private static final SdkField<String> CARRIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Carrier")
            .getter(getter(CarrierLookupResponse::carrier)).setter(setter(Builder::carrier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Carrier").build()).build();

    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberType").getter(getter(CarrierLookupResponse::phoneNumberTypeAsString))
            .setter(setter(Builder::phoneNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBER_FIELD,
            DIALING_COUNTRY_CODE_FIELD, ISO_COUNTRY_CODE_FIELD, COUNTRY_FIELD, MCC_FIELD, MNC_FIELD, CARRIER_FIELD,
            PHONE_NUMBER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String e164PhoneNumber;

    private final String dialingCountryCode;

    private final String isoCountryCode;

    private final String country;

    private final String mcc;

    private final String mnc;

    private final String carrier;

    private final String phoneNumberType;

    private CarrierLookupResponse(BuilderImpl builder) {
        super(builder);
        this.e164PhoneNumber = builder.e164PhoneNumber;
        this.dialingCountryCode = builder.dialingCountryCode;
        this.isoCountryCode = builder.isoCountryCode;
        this.country = builder.country;
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.carrier = builder.carrier;
        this.phoneNumberType = builder.phoneNumberType;
    }

    /**
     * <p>
     * The phone number in E164 format, sanitized from the original input by removing any formatting characters.
     * </p>
     * 
     * @return The phone number in E164 format, sanitized from the original input by removing any formatting characters.
     */
    public final String e164PhoneNumber() {
        return e164PhoneNumber;
    }

    /**
     * <p>
     * The numeric dialing code for the country or region where the phone number was originally registered.
     * </p>
     * 
     * @return The numeric dialing code for the country or region where the phone number was originally registered.
     */
    public final String dialingCountryCode() {
        return dialingCountryCode;
    }

    /**
     * <p>
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number was
     * originally registered.
     * </p>
     * 
     * @return The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number
     *         was originally registered.
     */
    public final String isoCountryCode() {
        return isoCountryCode;
    }

    /**
     * <p>
     * The name of the country where the phone number was originally registered.
     * </p>
     * 
     * @return The name of the country where the phone number was originally registered.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The phone number's mobile country code, for mobile phone number types
     * </p>
     * 
     * @return The phone number's mobile country code, for mobile phone number types
     */
    public final String mcc() {
        return mcc;
    }

    /**
     * <p>
     * The phone number's mobile network code, for mobile phone number types.
     * </p>
     * 
     * @return The phone number's mobile network code, for mobile phone number types.
     */
    public final String mnc() {
        return mnc;
    }

    /**
     * <p>
     * The carrier or service provider that the phone number is currently registered with. In some countries and
     * regions, this value may be the carrier or service provider that the phone number was originally registered with.
     * </p>
     * 
     * @return The carrier or service provider that the phone number is currently registered with. In some countries and
     *         regions, this value may be the carrier or service provider that the phone number was originally
     *         registered with.
     */
    public final String carrier() {
        return carrier;
    }

    /**
     * <p>
     * Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid sending SMS or
     * voice messages to INVALID phone numbers, as these numbers are unlikely to belong to actual recipients.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid sending
     *         SMS or voice messages to INVALID phone numbers, as these numbers are unlikely to belong to actual
     *         recipients.
     * @see PhoneNumberType
     */
    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(phoneNumberType);
    }

    /**
     * <p>
     * Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid sending SMS or
     * voice messages to INVALID phone numbers, as these numbers are unlikely to belong to actual recipients.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid sending
     *         SMS or voice messages to INVALID phone numbers, as these numbers are unlikely to belong to actual
     *         recipients.
     * @see PhoneNumberType
     */
    public final String phoneNumberTypeAsString() {
        return phoneNumberType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(e164PhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(dialingCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(mcc());
        hashCode = 31 * hashCode + Objects.hashCode(mnc());
        hashCode = 31 * hashCode + Objects.hashCode(carrier());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CarrierLookupResponse)) {
            return false;
        }
        CarrierLookupResponse other = (CarrierLookupResponse) obj;
        return Objects.equals(e164PhoneNumber(), other.e164PhoneNumber())
                && Objects.equals(dialingCountryCode(), other.dialingCountryCode())
                && Objects.equals(isoCountryCode(), other.isoCountryCode()) && Objects.equals(country(), other.country())
                && Objects.equals(mcc(), other.mcc()) && Objects.equals(mnc(), other.mnc())
                && Objects.equals(carrier(), other.carrier())
                && Objects.equals(phoneNumberTypeAsString(), other.phoneNumberTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CarrierLookupResponse").add("E164PhoneNumber", e164PhoneNumber())
                .add("DialingCountryCode", dialingCountryCode()).add("IsoCountryCode", isoCountryCode())
                .add("Country", country()).add("MCC", mcc()).add("MNC", mnc()).add("Carrier", carrier())
                .add("PhoneNumberType", phoneNumberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "E164PhoneNumber":
            return Optional.ofNullable(clazz.cast(e164PhoneNumber()));
        case "DialingCountryCode":
            return Optional.ofNullable(clazz.cast(dialingCountryCode()));
        case "IsoCountryCode":
            return Optional.ofNullable(clazz.cast(isoCountryCode()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "MCC":
            return Optional.ofNullable(clazz.cast(mcc()));
        case "MNC":
            return Optional.ofNullable(clazz.cast(mnc()));
        case "Carrier":
            return Optional.ofNullable(clazz.cast(carrier()));
        case "PhoneNumberType":
            return Optional.ofNullable(clazz.cast(phoneNumberTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("E164PhoneNumber", E164_PHONE_NUMBER_FIELD);
        map.put("DialingCountryCode", DIALING_COUNTRY_CODE_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("MCC", MCC_FIELD);
        map.put("MNC", MNC_FIELD);
        map.put("Carrier", CARRIER_FIELD);
        map.put("PhoneNumberType", PHONE_NUMBER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CarrierLookupResponse, T> g) {
        return obj -> g.apply((CarrierLookupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CarrierLookupResponse> {
        /**
         * <p>
         * The phone number in E164 format, sanitized from the original input by removing any formatting characters.
         * </p>
         * 
         * @param e164PhoneNumber
         *        The phone number in E164 format, sanitized from the original input by removing any formatting
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumber(String e164PhoneNumber);

        /**
         * <p>
         * The numeric dialing code for the country or region where the phone number was originally registered.
         * </p>
         * 
         * @param dialingCountryCode
         *        The numeric dialing code for the country or region where the phone number was originally registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialingCountryCode(String dialingCountryCode);

        /**
         * <p>
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number was
         * originally registered.
         * </p>
         * 
         * @param isoCountryCode
         *        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number
         *        was originally registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isoCountryCode(String isoCountryCode);

        /**
         * <p>
         * The name of the country where the phone number was originally registered.
         * </p>
         * 
         * @param country
         *        The name of the country where the phone number was originally registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The phone number's mobile country code, for mobile phone number types
         * </p>
         * 
         * @param mcc
         *        The phone number's mobile country code, for mobile phone number types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcc(String mcc);

        /**
         * <p>
         * The phone number's mobile network code, for mobile phone number types.
         * </p>
         * 
         * @param mnc
         *        The phone number's mobile network code, for mobile phone number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mnc(String mnc);

        /**
         * <p>
         * The carrier or service provider that the phone number is currently registered with. In some countries and
         * regions, this value may be the carrier or service provider that the phone number was originally registered
         * with.
         * </p>
         * 
         * @param carrier
         *        The carrier or service provider that the phone number is currently registered with. In some countries
         *        and regions, this value may be the carrier or service provider that the phone number was originally
         *        registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrier(String carrier);

        /**
         * <p>
         * Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid sending SMS
         * or voice messages to INVALID phone numbers, as these numbers are unlikely to belong to actual recipients.
         * </p>
         * 
         * @param phoneNumberType
         *        Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid
         *        sending SMS or voice messages to INVALID phone numbers, as these numbers are unlikely to belong to
         *        actual recipients.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(String phoneNumberType);

        /**
         * <p>
         * Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid sending SMS
         * or voice messages to INVALID phone numbers, as these numbers are unlikely to belong to actual recipients.
         * </p>
         * 
         * @param phoneNumberType
         *        Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER, and INVALID. Avoid
         *        sending SMS or voice messages to INVALID phone numbers, as these numbers are unlikely to belong to
         *        actual recipients.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(PhoneNumberType phoneNumberType);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String e164PhoneNumber;

        private String dialingCountryCode;

        private String isoCountryCode;

        private String country;

        private String mcc;

        private String mnc;

        private String carrier;

        private String phoneNumberType;

        private BuilderImpl() {
        }

        private BuilderImpl(CarrierLookupResponse model) {
            super(model);
            e164PhoneNumber(model.e164PhoneNumber);
            dialingCountryCode(model.dialingCountryCode);
            isoCountryCode(model.isoCountryCode);
            country(model.country);
            mcc(model.mcc);
            mnc(model.mnc);
            carrier(model.carrier);
            phoneNumberType(model.phoneNumberType);
        }

        public final String getE164PhoneNumber() {
            return e164PhoneNumber;
        }

        public final void setE164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
        }

        @Override
        public final Builder e164PhoneNumber(String e164PhoneNumber) {
            this.e164PhoneNumber = e164PhoneNumber;
            return this;
        }

        public final String getDialingCountryCode() {
            return dialingCountryCode;
        }

        public final void setDialingCountryCode(String dialingCountryCode) {
            this.dialingCountryCode = dialingCountryCode;
        }

        @Override
        public final Builder dialingCountryCode(String dialingCountryCode) {
            this.dialingCountryCode = dialingCountryCode;
            return this;
        }

        public final String getIsoCountryCode() {
            return isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getMcc() {
            return mcc;
        }

        public final void setMcc(String mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(String mcc) {
            this.mcc = mcc;
            return this;
        }

        public final String getMnc() {
            return mnc;
        }

        public final void setMnc(String mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(String mnc) {
            this.mnc = mnc;
            return this;
        }

        public final String getCarrier() {
            return carrier;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final String getPhoneNumberType() {
            return phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        @Override
        public CarrierLookupResponse build() {
            return new CarrierLookupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
