/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information related to a given configuration set in your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationSetInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationSetInformation.Builder, ConfigurationSetInformation> {
    private static final SdkField<String> CONFIGURATION_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetArn").getter(getter(ConfigurationSetInformation::configurationSetArn))
            .setter(setter(Builder::configurationSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetArn").build())
            .build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(ConfigurationSetInformation::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<List<EventDestination>> EVENT_DESTINATIONS_FIELD = SdkField
            .<List<EventDestination>> builder(MarshallingType.LIST)
            .memberName("EventDestinations")
            .getter(getter(ConfigurationSetInformation::eventDestinations))
            .setter(setter(Builder::eventDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultMessageType").getter(getter(ConfigurationSetInformation::defaultMessageTypeAsString))
            .setter(setter(Builder::defaultMessageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessageType").build())
            .build();

    private static final SdkField<String> DEFAULT_SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSenderId").getter(getter(ConfigurationSetInformation::defaultSenderId))
            .setter(setter(Builder::defaultSenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSenderId").build()).build();

    private static final SdkField<Boolean> DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultMessageFeedbackEnabled")
            .getter(getter(ConfigurationSetInformation::defaultMessageFeedbackEnabled))
            .setter(setter(Builder::defaultMessageFeedbackEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessageFeedbackEnabled")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ConfigurationSetInformation::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectConfigurationId").getter(getter(ConfigurationSetInformation::protectConfigurationId))
            .setter(setter(Builder::protectConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_ARN_FIELD,
            CONFIGURATION_SET_NAME_FIELD, EVENT_DESTINATIONS_FIELD, DEFAULT_MESSAGE_TYPE_FIELD, DEFAULT_SENDER_ID_FIELD,
            DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD, PROTECT_CONFIGURATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationSetArn;

    private final String configurationSetName;

    private final List<EventDestination> eventDestinations;

    private final String defaultMessageType;

    private final String defaultSenderId;

    private final Boolean defaultMessageFeedbackEnabled;

    private final Instant createdTimestamp;

    private final String protectConfigurationId;

    private ConfigurationSetInformation(BuilderImpl builder) {
        this.configurationSetArn = builder.configurationSetArn;
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinations = builder.eventDestinations;
        this.defaultMessageType = builder.defaultMessageType;
        this.defaultSenderId = builder.defaultSenderId;
        this.defaultMessageFeedbackEnabled = builder.defaultMessageFeedbackEnabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.protectConfigurationId = builder.protectConfigurationId;
    }

    /**
     * <p>
     * The Resource Name (ARN) of the ConfigurationSet.
     * </p>
     * 
     * @return The Resource Name (ARN) of the ConfigurationSet.
     */
    public final String configurationSetArn() {
        return configurationSetArn;
    }

    /**
     * <p>
     * The name of the ConfigurationSet.
     * </p>
     * 
     * @return The name of the ConfigurationSet.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventDestinations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventDestinations() {
        return eventDestinations != null && !(eventDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of EventDestination objects that describe any events to log and where to log them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventDestinations} method.
     * </p>
     * 
     * @return An array of EventDestination objects that describe any events to log and where to log them.
     */
    public final List<EventDestination> eventDestinations() {
        return eventDestinations;
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultMessageType} will return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultMessageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final MessageType defaultMessageType() {
        return MessageType.fromValue(defaultMessageType);
    }

    /**
     * <p>
     * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     * PROMOTIONAL for messages that aren't critical or time-sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultMessageType} will return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultMessageTypeAsString}.
     * </p>
     * 
     * @return The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
     *         PROMOTIONAL for messages that aren't critical or time-sensitive.
     * @see MessageType
     */
    public final String defaultMessageTypeAsString() {
        return defaultMessageType;
    }

    /**
     * <p>
     * The default sender ID used by the ConfigurationSet.
     * </p>
     * 
     * @return The default sender ID used by the ConfigurationSet.
     */
    public final String defaultSenderId() {
        return defaultSenderId;
    }

    /**
     * <p>
     * True if message feedback is enabled.
     * </p>
     * 
     * @return True if message feedback is enabled.
     */
    public final Boolean defaultMessageFeedbackEnabled() {
        return defaultMessageFeedbackEnabled;
    }

    /**
     * <p>
     * The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch time</a>
     * format.
     * </p>
     * 
     * @return The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch
     *         time</a> format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The unique identifier for the protect configuration.
     * </p>
     * 
     * @return The unique identifier for the protect configuration.
     */
    public final String protectConfigurationId() {
        return protectConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventDestinations() ? eventDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSenderId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessageFeedbackEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(protectConfigurationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationSetInformation)) {
            return false;
        }
        ConfigurationSetInformation other = (ConfigurationSetInformation) obj;
        return Objects.equals(configurationSetArn(), other.configurationSetArn())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && hasEventDestinations() == other.hasEventDestinations()
                && Objects.equals(eventDestinations(), other.eventDestinations())
                && Objects.equals(defaultMessageTypeAsString(), other.defaultMessageTypeAsString())
                && Objects.equals(defaultSenderId(), other.defaultSenderId())
                && Objects.equals(defaultMessageFeedbackEnabled(), other.defaultMessageFeedbackEnabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(protectConfigurationId(), other.protectConfigurationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationSetInformation").add("ConfigurationSetArn", configurationSetArn())
                .add("ConfigurationSetName", configurationSetName())
                .add("EventDestinations", hasEventDestinations() ? eventDestinations() : null)
                .add("DefaultMessageType", defaultMessageTypeAsString()).add("DefaultSenderId", defaultSenderId())
                .add("DefaultMessageFeedbackEnabled", defaultMessageFeedbackEnabled())
                .add("CreatedTimestamp", createdTimestamp()).add("ProtectConfigurationId", protectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetArn":
            return Optional.ofNullable(clazz.cast(configurationSetArn()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestinations":
            return Optional.ofNullable(clazz.cast(eventDestinations()));
        case "DefaultMessageType":
            return Optional.ofNullable(clazz.cast(defaultMessageTypeAsString()));
        case "DefaultSenderId":
            return Optional.ofNullable(clazz.cast(defaultSenderId()));
        case "DefaultMessageFeedbackEnabled":
            return Optional.ofNullable(clazz.cast(defaultMessageFeedbackEnabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "ProtectConfigurationId":
            return Optional.ofNullable(clazz.cast(protectConfigurationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationSetArn", CONFIGURATION_SET_ARN_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("EventDestinations", EVENT_DESTINATIONS_FIELD);
        map.put("DefaultMessageType", DEFAULT_MESSAGE_TYPE_FIELD);
        map.put("DefaultSenderId", DEFAULT_SENDER_ID_FIELD);
        map.put("DefaultMessageFeedbackEnabled", DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationSetInformation, T> g) {
        return obj -> g.apply((ConfigurationSetInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationSetInformation> {
        /**
         * <p>
         * The Resource Name (ARN) of the ConfigurationSet.
         * </p>
         * 
         * @param configurationSetArn
         *        The Resource Name (ARN) of the ConfigurationSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetArn(String configurationSetArn);

        /**
         * <p>
         * The name of the ConfigurationSet.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the ConfigurationSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * An array of EventDestination objects that describe any events to log and where to log them.
         * </p>
         * 
         * @param eventDestinations
         *        An array of EventDestination objects that describe any events to log and where to log them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(Collection<EventDestination> eventDestinations);

        /**
         * <p>
         * An array of EventDestination objects that describe any events to log and where to log them.
         * </p>
         * 
         * @param eventDestinations
         *        An array of EventDestination objects that describe any events to log and where to log them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinations(EventDestination... eventDestinations);

        /**
         * <p>
         * An array of EventDestination objects that describe any events to log and where to log them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #eventDestinations(List<EventDestination>)}.
         * 
         * @param eventDestinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestinations(java.util.Collection<EventDestination>)
         */
        Builder eventDestinations(Consumer<EventDestination.Builder>... eventDestinations);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param defaultMessageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder defaultMessageType(String defaultMessageType);

        /**
         * <p>
         * The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive and
         * PROMOTIONAL for messages that aren't critical or time-sensitive.
         * </p>
         * 
         * @param defaultMessageType
         *        The type of message. Valid values are TRANSACTIONAL for messages that are critical or time-sensitive
         *        and PROMOTIONAL for messages that aren't critical or time-sensitive.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder defaultMessageType(MessageType defaultMessageType);

        /**
         * <p>
         * The default sender ID used by the ConfigurationSet.
         * </p>
         * 
         * @param defaultSenderId
         *        The default sender ID used by the ConfigurationSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSenderId(String defaultSenderId);

        /**
         * <p>
         * True if message feedback is enabled.
         * </p>
         * 
         * @param defaultMessageFeedbackEnabled
         *        True if message feedback is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled);

        /**
         * <p>
         * The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX epoch
         * time</a> format.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the ConfigurationSet was created, in <a href="https://www.epochconverter.com/">UNIX
         *        epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The unique identifier for the protect configuration.
         * </p>
         * 
         * @param protectConfigurationId
         *        The unique identifier for the protect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectConfigurationId(String protectConfigurationId);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSetArn;

        private String configurationSetName;

        private List<EventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();

        private String defaultMessageType;

        private String defaultSenderId;

        private Boolean defaultMessageFeedbackEnabled;

        private Instant createdTimestamp;

        private String protectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationSetInformation model) {
            configurationSetArn(model.configurationSetArn);
            configurationSetName(model.configurationSetName);
            eventDestinations(model.eventDestinations);
            defaultMessageType(model.defaultMessageType);
            defaultSenderId(model.defaultSenderId);
            defaultMessageFeedbackEnabled(model.defaultMessageFeedbackEnabled);
            createdTimestamp(model.createdTimestamp);
            protectConfigurationId(model.protectConfigurationId);
        }

        public final String getConfigurationSetArn() {
            return configurationSetArn;
        }

        public final void setConfigurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
        }

        @Override
        public final Builder configurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final List<EventDestination.Builder> getEventDestinations() {
            List<EventDestination.Builder> result = EventDestinationListCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationListCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationListCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination... eventDestinations) {
            eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<EventDestination.Builder>... eventDestinations) {
            eventDestinations(Stream.of(eventDestinations).map(c -> EventDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultMessageType() {
            return defaultMessageType;
        }

        public final void setDefaultMessageType(String defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
        }

        @Override
        public final Builder defaultMessageType(String defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
            return this;
        }

        @Override
        public final Builder defaultMessageType(MessageType defaultMessageType) {
            this.defaultMessageType(defaultMessageType == null ? null : defaultMessageType.toString());
            return this;
        }

        public final String getDefaultSenderId() {
            return defaultSenderId;
        }

        public final void setDefaultSenderId(String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
        }

        @Override
        public final Builder defaultSenderId(String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
            return this;
        }

        public final Boolean getDefaultMessageFeedbackEnabled() {
            return defaultMessageFeedbackEnabled;
        }

        public final void setDefaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled) {
            this.defaultMessageFeedbackEnabled = defaultMessageFeedbackEnabled;
        }

        @Override
        public final Builder defaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled) {
            this.defaultMessageFeedbackEnabled = defaultMessageFeedbackEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getProtectConfigurationId() {
            return protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        @Override
        public ConfigurationSetInformation build() {
            return new ConfigurationSetInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
