/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRegistrationAttachmentRequest extends PinpointSmsVoiceV2Request implements
        ToCopyableBuilder<CreateRegistrationAttachmentRequest.Builder, CreateRegistrationAttachmentRequest> {
    private static final SdkField<SdkBytes> ATTACHMENT_BODY_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("AttachmentBody").getter(getter(CreateRegistrationAttachmentRequest::attachmentBody))
            .setter(setter(Builder::attachmentBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentBody").build()).build();

    private static final SdkField<String> ATTACHMENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentUrl").getter(getter(CreateRegistrationAttachmentRequest::attachmentUrl))
            .setter(setter(Builder::attachmentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentUrl").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRegistrationAttachmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateRegistrationAttachmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_BODY_FIELD,
            ATTACHMENT_URL_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SdkBytes attachmentBody;

    private final String attachmentUrl;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateRegistrationAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentBody = builder.attachmentBody;
        this.attachmentUrl = builder.attachmentUrl;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The registration file to upload. The maximum file size is 500KB and valid file extensions are PDF, JPEG and PNG.
     * </p>
     * 
     * @return The registration file to upload. The maximum file size is 500KB and valid file extensions are PDF, JPEG
     *         and PNG.
     */
    public final SdkBytes attachmentBody() {
        return attachmentBody;
    }

    /**
     * <p>
     * Registration files have to be stored in an Amazon S3 bucket. The URI to use when sending is in the format
     * <code>s3://BucketName/FileName</code>.
     * </p>
     * 
     * @return Registration files have to be stored in an Amazon S3 bucket. The URI to use when sending is in the format
     *         <code>s3://BucketName/FileName</code>.
     */
    public final String attachmentUrl() {
        return attachmentUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tags (key and value pairs) to associate with the registration attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of tags (key and value pairs) to associate with the registration attachment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't specify
     * a client token, a randomly generated token is used for the request to ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     *         specify a client token, a randomly generated token is used for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentBody());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegistrationAttachmentRequest)) {
            return false;
        }
        CreateRegistrationAttachmentRequest other = (CreateRegistrationAttachmentRequest) obj;
        return Objects.equals(attachmentBody(), other.attachmentBody()) && Objects.equals(attachmentUrl(), other.attachmentUrl())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRegistrationAttachmentRequest").add("AttachmentBody", attachmentBody())
                .add("AttachmentUrl", attachmentUrl()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentBody":
            return Optional.ofNullable(clazz.cast(attachmentBody()));
        case "AttachmentUrl":
            return Optional.ofNullable(clazz.cast(attachmentUrl()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachmentBody", ATTACHMENT_BODY_FIELD);
        map.put("AttachmentUrl", ATTACHMENT_URL_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRegistrationAttachmentRequest, T> g) {
        return obj -> g.apply((CreateRegistrationAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointSmsVoiceV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRegistrationAttachmentRequest> {
        /**
         * <p>
         * The registration file to upload. The maximum file size is 500KB and valid file extensions are PDF, JPEG and
         * PNG.
         * </p>
         * 
         * @param attachmentBody
         *        The registration file to upload. The maximum file size is 500KB and valid file extensions are PDF,
         *        JPEG and PNG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentBody(SdkBytes attachmentBody);

        /**
         * <p>
         * Registration files have to be stored in an Amazon S3 bucket. The URI to use when sending is in the format
         * <code>s3://BucketName/FileName</code>.
         * </p>
         * 
         * @param attachmentUrl
         *        Registration files have to be stored in an Amazon S3 bucket. The URI to use when sending is in the
         *        format <code>s3://BucketName/FileName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentUrl(String attachmentUrl);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the registration attachment.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the registration attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the registration attachment.
         * </p>
         * 
         * @param tags
         *        An array of tags (key and value pairs) to associate with the registration attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of tags (key and value pairs) to associate with the registration attachment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, a randomly generated token is used for the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, a randomly generated token is used for the request to ensure
         *        idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Request.BuilderImpl implements Builder {
        private SdkBytes attachmentBody;

        private String attachmentUrl;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegistrationAttachmentRequest model) {
            super(model);
            attachmentBody(model.attachmentBody);
            attachmentUrl(model.attachmentUrl);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final ByteBuffer getAttachmentBody() {
            return attachmentBody == null ? null : attachmentBody.asByteBuffer();
        }

        public final void setAttachmentBody(ByteBuffer attachmentBody) {
            attachmentBody(attachmentBody == null ? null : SdkBytes.fromByteBuffer(attachmentBody));
        }

        @Override
        public final Builder attachmentBody(SdkBytes attachmentBody) {
            this.attachmentBody = attachmentBody;
            return this;
        }

        public final String getAttachmentUrl() {
            return attachmentUrl;
        }

        public final void setAttachmentUrl(String attachmentUrl) {
            this.attachmentUrl = attachmentUrl;
        }

        @Override
        public final Builder attachmentUrl(String attachmentUrl) {
            this.attachmentUrl = attachmentUrl;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRegistrationAttachmentRequest build() {
            return new CreateRegistrationAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
